/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.axis.consumption.ui.task;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.internal.axis.consumption.core.common.JavaWSDLParameter;
import org.eclipse.jst.ws.internal.axis.consumption.core.common.NameMappingUtils;
import org.eclipse.jst.ws.internal.axis.consumption.ui.AxisConsumptionUIMessages;
import org.eclipse.jst.ws.internal.axis.consumption.ui.task.Stub2BeanInfo;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.ws.internal.parser.wsil.WebServicesParser;

public class Stub2BeanCommand
extends AbstractDataModelOperation {
    private WebServicesParser webServicesParser;
    private JavaWSDLParameter javaWSDLParam_;
    private String discoveredWsdlPortElementName;
    private Vector portTypes_ = new Vector();
    private String proxyBean_;
    private String outputFolder_;
    private String proxyEndpoint_;
    private IProject clientProject_;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        ModuleCoreNature mn;
        File file;
        IEnvironment environment = this.getEnvironment();
        String inputWsdlLocation = this.javaWSDLParam_.getInputWsdlLocation();
        Definition def = this.webServicesParser.getWSDLDefinition(inputWsdlLocation);
        if (def == null && (file = new File(inputWsdlLocation)).exists()) {
            try {
                def = this.webServicesParser.getWSDLDefinition(file.toURL().toString());
            }
            catch (MalformedURLException malformedURLException) {}
        }
        if ((mn = ModuleCoreNature.getModuleCoreNature((IProject)this.clientProject_)) == null && !ResourceUtils.isJavaProject((IProject)this.clientProject_)) {
            IStatus status = StatusUtils.errorStatus((String)AxisConsumptionUIMessages.MSG_WARN_NO_JAVA_NATURE);
            environment.getStatusHandler().reportError(status);
            return status;
        }
        HashMap pkg2nsMapping = this.javaWSDLParam_.getMappings();
        Map services = def.getServices();
        for (Service service : services.values()) {
            String serviceClassName;
            String servicePkgName = NameMappingUtils.getPackageName((String)service.getQName().getNamespaceURI(), (Map)pkg2nsMapping);
            String jndiName = serviceClassName = this.computeClassName(service.getQName().getLocalPart());
            Map ports = service.getPorts();
            Iterator it2 = ports.values().iterator();
            while (it2.hasNext()) {
                if (!serviceClassName.equals(this.computeClassName(((Port)it2.next()).getBinding().getPortType().getQName().getLocalPart()))) continue;
                serviceClassName = String.valueOf(serviceClassName) + "_Service";
                break;
            }
            for (Port port : ports.values()) {
                if (this.discoveredWsdlPortElementName != null && !this.discoveredWsdlPortElementName.equals(port.getName())) continue;
                SOAPAddress soapAddress = null;
                List extensibilityElements = port.getExtensibilityElements();
                if (extensibilityElements != null) {
                    for (Object object : extensibilityElements) {
                        if (!(object instanceof SOAPAddress)) continue;
                        soapAddress = (SOAPAddress)object;
                        break;
                    }
                }
                if (soapAddress == null) continue;
                this.proxyEndpoint_ = soapAddress.getLocationURI();
                PortType portType = port.getBinding().getPortType();
                QName portTypeQName = portType.getQName();
                StringBuffer portTypeID = new StringBuffer();
                portTypeID.append(portTypeQName.getNamespaceURI());
                portTypeID.append("#");
                portTypeID.append(portTypeQName.getLocalPart());
                if (this.portTypes_.contains(portTypeID.toString())) continue;
                this.portTypes_.add(portTypeID.toString());
                Stub2BeanInfo stub2BeanInfo = new Stub2BeanInfo();
                stub2BeanInfo.setClientProject(this.clientProject_);
                stub2BeanInfo.setOutputFolder(this.outputFolder_);
                String portTypePkgName = NameMappingUtils.getPackageName((String)portType.getQName().getNamespaceURI(), (Map)pkg2nsMapping);
                List operations = portType.getOperations();
                Iterator operIter = operations.iterator();
                boolean addSuffix = false;
                while (operIter.hasNext()) {
                    Operation operation = (Operation)operIter.next();
                    if (!operation.getName().equals(portTypePkgName)) continue;
                    addSuffix = true;
                }
                if (addSuffix) {
                    portTypePkgName = String.valueOf(portTypePkgName) + "_pkg";
                    servicePkgName = String.valueOf(servicePkgName) + "_pkg";
                }
                String portTypeClassName = this.computeClassName(portTypeQName.getLocalPart());
                stub2BeanInfo.setPackage(portTypePkgName);
                stub2BeanInfo.setClass(String.valueOf(portTypeClassName) + "Proxy");
                this.proxyBean_ = String.valueOf(portTypePkgName) + "." + portTypeClassName + "Proxy";
                if (jndiName.equals(portTypeClassName)) {
                    portTypeClassName = String.valueOf(portTypeClassName) + "_PortType";
                }
                stub2BeanInfo.addSEI(portTypePkgName, portTypeClassName, servicePkgName, serviceClassName, jndiName, NameMappingUtils.getPortName((String)port.getName()));
                try {
                    stub2BeanInfo.write(environment, monitor);
                    if (this.discoveredWsdlPortElementName == null) continue;
                    return Status.OK_STATUS;
                }
                catch (CoreException coreException) {
                }
                catch (IOException iOException) {}
            }
        }
        return Status.OK_STATUS;
    }

    private String computeClassName(String className) {
        return NameMappingUtils.xmlNameToJavaClass((String)className);
    }

    public JavaWSDLParameter getJavaWSDLParam() {
        return this.javaWSDLParam_;
    }

    public void setJavaWSDLParam(JavaWSDLParameter javaWSDLParam) {
        this.javaWSDLParam_ = javaWSDLParam;
    }

    public WebServicesParser getWebServicesParser() {
        return this.webServicesParser;
    }

    public void setWebServicesParser(WebServicesParser webServicesParser) {
        this.webServicesParser = webServicesParser;
    }

    public void setDiscoveredWsdlPortElementName(String discoveredWsdlPortElementName) {
        this.discoveredWsdlPortElementName = discoveredWsdlPortElementName;
    }

    public void setClientProject(IProject clientProject) {
        this.clientProject_ = clientProject;
    }

    public String getProxyBean() {
        return this.proxyBean_;
    }

    public void setOutputFolder(String outputFolder) {
        this.outputFolder_ = outputFolder;
    }

    public String getProxyEndpoint() {
        return this.proxyEndpoint_;
    }
}

