/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.deploy;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.j2ee.internal.deploy.DeployerRegistry;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPluginResourceHandler;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.internal.emf.utilities.CommandContext;
import org.eclipse.wst.common.internal.emf.utilities.ICommand;
import org.eclipse.wst.common.internal.emf.utilities.ICommand2;
import org.eclipse.wst.common.internal.emf.utilities.ICommandContext;
import org.eclipse.wst.server.core.IRuntime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class J2EEDeployOperation
extends AbstractDataModelOperation {
    private Object[] selection;
    private IStatus multiStatus;
    private IProject currentProject;
    private boolean wasAutoBuilding;
    private Set<IProject> affectedProjects;
    private boolean isAllDeployersProvideAffectedProjects = false;

    public J2EEDeployOperation(Object[] deployableObjects) {
        this.selection = deployableObjects;
        this.affectedProjects = new HashSet<IProject>();
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return null;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return null;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        try {
            block9: {
                int i;
                List components;
                DeployerRegistry reg;
                block8: {
                    this.turnAutoBuildOff();
                    reg = DeployerRegistry.instance();
                    components = this.getSelectedModules(this.selection);
                    monitor.beginTask(J2EEPluginResourceHandler.J2EEDeployOperation_UI_0, components.size());
                    i = 0;
                    if (!true) break block8;
                    if (i >= components.size()) return this.getMultiStatus();
                    if (monitor.isCanceled()) break block9;
                }
                do {
                    IVirtualComponent component = null;
                    component = (IVirtualComponent)components.get(i);
                    IProject proj = component.getProject();
                    IRuntime runtime = null;
                    try {
                        runtime = J2EEProjectUtilities.getServerRuntime(proj);
                    }
                    catch (CoreException e) {
                        J2EEPlugin.getDefault().getLog().log(e.getStatus());
                    }
                    if (runtime != null) {
                        List visitors = reg.getDeployModuleExtensions(proj, runtime);
                        this.deploy(visitors, component, monitor);
                        monitor.worked(1);
                    }
                    ++i;
                    if (i >= components.size()) return this.getMultiStatus();
                } while (!monitor.isCanceled());
            }
            return this.getMultiStatus();
        }
        finally {
            this.restoreBuildSettings();
        }
    }

    private void turnAutoBuildOff() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceDescription description = workspace.getDescription();
        this.wasAutoBuilding = workspace.isAutoBuilding();
        description.setAutoBuilding(false);
        try {
            workspace.setDescription(description);
        }
        catch (CoreException e) {
            J2EEPlugin.logError(e);
        }
    }

    private void restoreBuildSettings() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceDescription description = workspace.getDescription();
        if (this.wasAutoBuilding) {
            description.setAutoBuilding(true);
            try {
                workspace.setDescription(description);
            }
            catch (CoreException e) {
                J2EEPlugin.logError(e);
            }
        }
    }

    private void deploy(List visitors, IVirtualComponent component, IProgressMonitor monitor) {
        IProject proj = component.getProject();
        boolean curIsAllDeployersProvideAffectedProjects = true;
        int i = 0;
        while (i < visitors.size()) {
            block11: {
                if (visitors.get(i) instanceof IConfigurationElement) {
                    ICommand dep = null;
                    try {
                        dep = (ICommand)((IConfigurationElement)visitors.get(i)).createExecutableExtension("deployer_class");
                    }
                    catch (Exception e) {
                        J2EEPlugin.logError(e);
                        break block11;
                    }
                    if (dep != null) {
                        dep.init(this.selection);
                        monitor.setTaskName(J2EEPluginResourceHandler.getString(J2EEPluginResourceHandler.J2EEDeployOperation_1_UI_, new Object[]{proj.getName(), dep.getClass().getName()}));
                        try {
                            IModelProvider modelProvider = ModelProviderManager.getModelProvider(proj);
                            EObject eObject = (EObject)modelProvider.getModelObject();
                            if (eObject != null) {
                                CommandContext ctx = new CommandContext(monitor, null, eObject.eResource().getResourceSet());
                                dep.execute((IResource)proj, null, (ICommandContext)ctx);
                                if (dep instanceof ICommand2) {
                                    List changedProjects = ((ICommand2)dep).getAffectedProjects();
                                    if (changedProjects != null) {
                                        this.affectedProjects.addAll(changedProjects);
                                    }
                                } else {
                                    curIsAllDeployersProvideAffectedProjects = false;
                                }
                                this.addOKStatus(dep.getClass().getName());
                            }
                        }
                        catch (CoreException ex) {
                            J2EEPlugin.logError(ex);
                            CoreException statusException = ex.getStatus().getException() != null ? ex.getStatus().getException() : ex;
                            this.addErrorStatus(ex.getStatus(), dep.getClass().getName(), statusException);
                        }
                    }
                }
            }
            ++i;
        }
        this.isAllDeployersProvideAffectedProjects = curIsAllDeployersProvideAffectedProjects;
    }

    private void addOKStatus(String DeployerName) {
        Status statusLocal = new Status(0, " ", 0, J2EEPluginResourceHandler.getString(J2EEPluginResourceHandler.J2EEDeployOperation_2_UI_, new Object[]{DeployerName}), null);
        this.getMultiStatus().add((IStatus)statusLocal);
    }

    private void addErrorStatus(IStatus exceptionStatus, String DeployerName, Throwable ex) {
        Throwable mainCause = null;
        int severity = exceptionStatus.getSeverity();
        if (exceptionStatus instanceof MultiStatus) {
            IStatus[] stati = ((MultiStatus)exceptionStatus).getChildren();
            int i = 0;
            while (i < stati.length) {
                this.addErrorStatus(stati[i], DeployerName, stati[i].getException());
                ++i;
            }
        }
        mainCause = ex != null && ex.getCause() != null ? ex.getCause() : ex;
        String message = J2EEPluginResourceHandler.bind((String)J2EEPluginResourceHandler.J2EEDeployOperation_3_UI_, (Object)DeployerName, (Object)"");
        Status statusLocal = new Status(severity, J2EEPlugin.getPlugin().getPluginID(), severity, message, mainCause);
        this.getMultiStatus().add((IStatus)statusLocal);
    }

    private IStatus getMainStatus(IProject proj) {
        MultiStatus aStatus = new MultiStatus(J2EEPlugin.getPlugin().getPluginID(), 0, J2EEPluginResourceHandler.getString(J2EEPluginResourceHandler.J2EEDeployOperation_4_UI_, new Object[]{proj.getName()}), null);
        return aStatus;
    }

    public MultiStatus getMultiStatus() {
        if (this.multiStatus == null) {
            this.multiStatus = this.getMainStatus(this.currentProject);
        }
        return (MultiStatus)this.multiStatus;
    }

    public void setMultiStatus(IStatus newStatus) {
        this.multiStatus = newStatus;
    }

    protected List getSelectedModules(Object[] mySelections) {
        ArrayList<IVirtualComponent> components = new ArrayList<IVirtualComponent>();
        int i = 0;
        while (i < mySelections.length) {
            Object object = mySelections[i];
            if (object instanceof EObject) {
                object = ProjectUtilities.getProject((Object)object);
                this.currentProject = (IProject)object;
            }
            if (object instanceof IProject) {
                this.currentProject = (IProject)object;
                IVirtualComponent component = ComponentCore.createComponent((IProject)((IProject)object));
                if (!components.contains(component)) {
                    if (JavaEEProjectUtilities.isEARProject(component.getProject())) {
                        components.add(0, component);
                    } else {
                        components.add(component);
                    }
                }
            }
            ++i;
        }
        return components;
    }

    public Set<IProject> getAffectedProjects() {
        return this.affectedProjects;
    }

    public boolean isAllDeployersProvideAffectedProjects() {
        return this.isAllDeployersProvideAffectedProjects;
    }
}

