/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.jface;

import java.util.Iterator;
import org.eclipse.jpt.ui.internal.jface.DelegatingTreeContentAndLabelProvider;
import org.eclipse.jpt.ui.jface.TreeItemContentProvider;
import org.eclipse.jpt.utility.internal.ArrayTools;
import org.eclipse.jpt.utility.internal.model.value.ListCollectionValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.NullCollectionValueModel;
import org.eclipse.jpt.utility.internal.model.value.PropertyListValueModelAdapter;
import org.eclipse.jpt.utility.model.Model;
import org.eclipse.jpt.utility.model.event.CollectionAddEvent;
import org.eclipse.jpt.utility.model.event.CollectionChangeEvent;
import org.eclipse.jpt.utility.model.event.CollectionClearEvent;
import org.eclipse.jpt.utility.model.event.CollectionRemoveEvent;
import org.eclipse.jpt.utility.model.listener.CollectionChangeListener;
import org.eclipse.jpt.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.utility.model.value.ListValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTreeItemContentProvider<E>
implements TreeItemContentProvider {
    private DelegatingTreeContentAndLabelProvider treeContentProvider;
    private Model model;
    private CollectionValueModel<E> childrenModel;
    private CollectionChangeListener childrenListener;

    protected AbstractTreeItemContentProvider(Model model, DelegatingTreeContentAndLabelProvider treeContentProvider) {
        this.model = model;
        this.treeContentProvider = treeContentProvider;
        this.childrenListener = this.buildChildrenListener();
    }

    protected CollectionChangeListener buildChildrenListener() {
        return new CollectionChangeListener(){

            public void itemsAdded(CollectionAddEvent event) {
                AbstractTreeItemContentProvider.this.getTreeContentProvider().updateContent(AbstractTreeItemContentProvider.this.getModel());
            }

            public void itemsRemoved(CollectionRemoveEvent event) {
                AbstractTreeItemContentProvider.this.getTreeContentProvider().updateContent(AbstractTreeItemContentProvider.this.getModel());
                for (Object item : event.getItems()) {
                    AbstractTreeItemContentProvider.this.getTreeContentProvider().dispose(item);
                }
            }

            public void collectionChanged(CollectionChangeEvent event) {
                AbstractTreeItemContentProvider.this.getTreeContentProvider().updateContent(AbstractTreeItemContentProvider.this.getModel());
            }

            public void collectionCleared(CollectionClearEvent event) {
                AbstractTreeItemContentProvider.this.getTreeContentProvider().updateContent(AbstractTreeItemContentProvider.this.getModel());
            }
        };
    }

    protected synchronized Iterator<E> childrenModel() {
        if (this.childrenModel == null) {
            this.childrenModel = this.buildChildrenModel();
            this.engageChildren();
        }
        return this.childrenModel.iterator();
    }

    protected CollectionValueModel<E> buildChildrenModel() {
        return new NullCollectionValueModel();
    }

    protected CollectionValueModel<E> buildChildrenModel(ListValueModel<E> lvm) {
        return new ListCollectionValueModelAdapter(lvm);
    }

    protected ListValueModel<E> buildChildrenModel(PropertyValueModel<E> lvm) {
        return new PropertyListValueModelAdapter(lvm);
    }

    public Model getModel() {
        return this.model;
    }

    public DelegatingTreeContentAndLabelProvider getTreeContentProvider() {
        return this.treeContentProvider;
    }

    @Override
    public Object getParent() {
        return null;
    }

    @Override
    public Object[] getElements() {
        return this.getChildren();
    }

    @Override
    public Object[] getChildren() {
        return ArrayTools.array(this.childrenModel());
    }

    @Override
    public boolean hasChildren() {
        return this.childrenModel().hasNext();
    }

    @Override
    public void dispose() {
        Object[] objectArray = this.getChildren();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            this.getTreeContentProvider().dispose(child);
            ++n2;
        }
        this.disposeChildrenModel();
    }

    protected void engageChildren() {
        this.childrenModel.addCollectionChangeListener("values", this.childrenListener);
    }

    protected synchronized void disposeChildrenModel() {
        if (this.childrenModel != null) {
            this.disengageChildrenModel();
            this.childrenModel = null;
        }
    }

    protected void disengageChildrenModel() {
        this.childrenModel.removeCollectionChangeListener("values", this.childrenListener);
    }
}

