/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.command.common;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.jst.ws.internal.consumption.ConsumptionMessages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class AssociateModuleWithEARCommand
extends AbstractDataModelOperation {
    private String project_;
    private String module_;
    private String earProject_;
    private String ear_;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IEnvironment env = this.getEnvironment();
        IStatus status = Status.OK_STATUS;
        IProject moduleProject = null;
        IProject earProject = null;
        if (this.project_ != null) {
            moduleProject = ProjectUtilities.getProject((String)this.project_);
        }
        if (this.earProject_ != null) {
            earProject = ProjectUtilities.getProject((String)this.earProject_);
        }
        if (moduleProject != null && earProject != null && !J2EEUtils.isComponentAssociated((IProject)earProject, (IProject)moduleProject)) {
            J2EEUtils.associateComponentToEAR((IProject)moduleProject, (IProject)earProject);
        }
        if (!J2EEUtils.isComponentAssociated((IProject)earProject, (IProject)moduleProject)) {
            status = StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionMessages.MSG_ERROR_UNABLE_TO_ASSOCIATE, (Object[])new String[]{this.module_, this.ear_}));
            if (env != null) {
                env.getStatusHandler().reportError(status);
            }
            return status;
        }
        return status;
    }

    public void setProject(String project) {
        this.project_ = project;
    }

    public void setModule(String module) {
        this.module_ = module;
    }

    public void setEARProject(String earProject) {
        this.earProject_ = earProject;
    }

    public void setEar(String ear) {
        this.ear_ = ear;
    }
}

