/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.java;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.JpaFile;
import org.eclipse.jpt.core.JpaStructureNode;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.context.AccessType;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.PersistentType;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.context.java.JavaPersistentType;
import org.eclipse.jpt.core.context.java.JavaTypeMapping;
import org.eclipse.jpt.core.context.java.JavaTypeMappingDefinition;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.core.internal.resource.java.source.SourceNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.HashBag;
import org.eclipse.jpt.utility.internal.iterables.LiveCloneIterable;
import org.eclipse.jpt.utility.internal.iterators.ChainIterator;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.utility.internal.iterators.CompositeIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;
import org.eclipse.jst.j2ee.model.internal.validation.ValidationCancelledException;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaPersistentType
extends AbstractJavaJpaContextNode
implements JavaPersistentType {
    protected JavaResourcePersistentType resourcePersistentType;
    protected String name;
    protected AccessType defaultAccess;
    protected AccessType specifiedAccess;
    protected JavaTypeMapping mapping;
    protected final Vector<JavaPersistentAttribute> attributes = new Vector();
    protected PersistentType superPersistentType;

    protected AbstractJavaPersistentType(PersistentType.Owner parent, JavaResourcePersistentType jrpt) {
        super(parent);
        this.initialize(jrpt);
    }

    protected void initialize(JavaResourcePersistentType jrpt) {
        this.resourcePersistentType = jrpt;
        this.superPersistentType = this.buildSuperPersistentType();
        this.name = this.buildName();
        this.defaultAccess = this.buildDefaultAccess();
        this.specifiedAccess = this.buildSpecifiedAccess();
        this.mapping = this.buildMapping();
        this.initializeAttributes();
    }

    @Override
    public void update(JavaResourcePersistentType jrpt) {
        this.resourcePersistentType = jrpt;
        this.update();
    }

    @Override
    public void update() {
        JpaFile jpaFile = this.getJpaFile();
        if (jpaFile != null) {
            jpaFile.addRootStructureNode(this.resourcePersistentType.getQualifiedName(), this);
        }
        this.setSuperPersistentType(this.buildSuperPersistentType());
        this.setName(this.buildName());
        this.updateAccess();
        this.updateMapping();
        this.updateAttributes();
    }

    @Override
    public void postUpdate() {
        super.postUpdate();
        this.mapping.postUpdate();
        for (PersistentAttribute persistentAttribute : this.getAttributes()) {
            persistentAttribute.postUpdate();
        }
    }

    @Override
    public PersistentType.Owner getParent() {
        return (PersistentType.Owner)super.getParent();
    }

    @Override
    public IResource getResource() {
        return this.resourcePersistentType.getFile();
    }

    @Override
    public String getId() {
        return "org.eclipse.jpt.core.java.persistentType";
    }

    @Override
    public JpaStructureNode getStructureNode(int offset) {
        CompilationUnit astRoot = this.buildASTRoot();
        if (this.contains(offset, astRoot)) {
            for (JavaPersistentAttribute persistentAttribute : this.getAttributes()) {
                if (!persistentAttribute.contains(offset, astRoot)) continue;
                return persistentAttribute;
            }
            return this;
        }
        return null;
    }

    protected boolean contains(int offset, CompilationUnit astRoot) {
        TextRange fullTextRange = this.getFullTextRange(astRoot);
        return fullTextRange == null ? false : fullTextRange.includes(offset);
    }

    protected TextRange getFullTextRange(CompilationUnit astRoot) {
        return this.resourcePersistentType.getTextRange(astRoot);
    }

    @Override
    public TextRange getSelectionTextRange() {
        return this.getSelectionTextRange(this.buildASTRoot());
    }

    protected TextRange getSelectionTextRange(CompilationUnit astRoot) {
        return this.resourcePersistentType.getNameTextRange(astRoot);
    }

    @Override
    public void dispose() {
        JpaFile jpaFile = this.getJpaFile();
        if (jpaFile != null) {
            jpaFile.removeRootStructureNode(this.resourcePersistentType.getQualifiedName());
        }
    }

    @Override
    public JavaResourcePersistentType getResourcePersistentType() {
        return this.resourcePersistentType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getShortName() {
        return this.name.substring(this.name.lastIndexOf(46) + 1);
    }

    protected void setName(String name) {
        String old = this.name;
        this.name = name;
        this.firePropertyChanged("name", old, name);
    }

    protected String buildName() {
        return this.resourcePersistentType.getQualifiedName();
    }

    @Override
    public AccessType getAccess() {
        return this.specifiedAccess != null ? this.specifiedAccess : this.defaultAccess;
    }

    @Override
    public AccessType getDefaultAccess() {
        return this.defaultAccess;
    }

    protected void setDefaultAccess(AccessType defaultAccess) {
        AccessType old = this.defaultAccess;
        this.defaultAccess = defaultAccess;
        this.firePropertyChanged("defaultAccess", (Object)old, (Object)defaultAccess);
    }

    @Override
    public AccessType getSpecifiedAccess() {
        return this.specifiedAccess;
    }

    protected AccessType buildDefaultAccess() {
        AccessType accessType = AccessType.fromJavaResourceModel(this.resourcePersistentType.getAccess());
        if (accessType != null) {
            return accessType;
        }
        accessType = this.getOwnerOverrideAccess();
        if (accessType != null) {
            return accessType;
        }
        if (this.superPersistentType != null && (accessType = this.superPersistentType.getAccess()) != null) {
            return accessType;
        }
        accessType = this.getOwnerDefaultAccess();
        if (accessType != null) {
            return accessType;
        }
        return AccessType.FIELD;
    }

    protected void updateAccess() {
        this.setDefaultAccess(this.buildDefaultAccess());
    }

    protected abstract AccessType buildSpecifiedAccess();

    @Override
    public JavaTypeMapping getMapping() {
        return this.mapping;
    }

    @Override
    public String getMappingKey() {
        return this.mapping.getKey();
    }

    @Override
    public void setMappingKey(String key) {
        JavaTypeMapping newMapping;
        if (this.valuesAreEqual(key, this.mapping.getKey())) {
            return;
        }
        JavaTypeMapping oldMapping = this.mapping;
        this.mapping = newMapping = this.buildMappingFromMappingKey(key);
        this.resourcePersistentType.setPrimaryAnnotation(newMapping.getAnnotationName(), newMapping.getSupportingAnnotationNames());
        this.firePropertyChanged("mapping", oldMapping, newMapping);
    }

    protected void setMapping(JavaTypeMapping mapping) {
        JavaTypeMapping old = this.mapping;
        this.mapping = mapping;
        this.firePropertyChanged("mapping", old, mapping);
    }

    protected JavaTypeMapping buildMapping() {
        JavaTypeMappingDefinition mappingDefinition = this.getJpaPlatform().getJavaTypeMappingDefinition(this);
        return this.buildMapping(mappingDefinition);
    }

    protected JavaTypeMapping buildMapping(JavaTypeMappingDefinition mappingDefinition) {
        JavaTypeMapping jtMapping = mappingDefinition.buildMapping(this, this.getJpaFactory());
        if (jtMapping != null) {
            jtMapping.initialize(this.resourcePersistentType);
        }
        return jtMapping;
    }

    protected JavaTypeMapping buildMappingFromMappingKey(String key) {
        JavaTypeMappingDefinition mappingDefinition = this.getJpaPlatform().getJavaTypeMappingDefinition(key);
        JavaTypeMapping jtMapping = mappingDefinition.buildMapping(this, this.getJpaFactory());
        return jtMapping;
    }

    protected void updateMapping() {
        JavaTypeMappingDefinition mappingDefinition = this.getJpaPlatform().getJavaTypeMappingDefinition(this);
        if (this.mapping != null && this.valuesAreEqual(this.mapping.getKey(), mappingDefinition.getKey())) {
            this.mapping.update(this.resourcePersistentType);
        } else {
            this.setMapping(this.buildMapping(mappingDefinition));
        }
    }

    @Override
    public ListIterator<JavaPersistentAttribute> attributes() {
        return new CloneListIterator(this.attributes);
    }

    protected Iterable<JavaPersistentAttribute> getAttributes() {
        return new LiveCloneIterable(this.attributes);
    }

    @Override
    public int attributesSize() {
        return this.attributes.size();
    }

    private void addAttribute(int index, JavaPersistentAttribute attribute) {
        this.addItemToList(index, attribute, this.attributes, "attributes");
    }

    private void removeAttribute(JavaPersistentAttribute attribute) {
        this.removeItemFromList(attribute, this.attributes, "attributes");
    }

    private void moveAttribute(int index, JavaPersistentAttribute attribute) {
        this.moveItemInList(index, this.attributes.indexOf(attribute), this.attributes, "attributes");
    }

    @Override
    public Iterator<String> attributeNames() {
        return this.attributeNames(this.attributes());
    }

    protected Iterator<String> attributeNames(Iterator<? extends PersistentAttribute> attrs) {
        return new TransformationIterator<PersistentAttribute, String>(attrs){

            protected String transform(PersistentAttribute attribute) {
                return attribute.getName();
            }
        };
    }

    @Override
    public JavaPersistentAttribute getAttributeNamed(String attributeName) {
        Iterator<JavaPersistentAttribute> stream = this.attributesNamed(attributeName);
        return stream.hasNext() ? stream.next() : null;
    }

    @Override
    public PersistentAttribute resolveAttribute(String attributeName) {
        Iterator<JavaPersistentAttribute> stream = this.attributesNamed(attributeName);
        if (stream.hasNext()) {
            JavaPersistentAttribute attribute = stream.next();
            return stream.hasNext() ? null : attribute;
        }
        return this.superPersistentType == null ? null : this.superPersistentType.resolveAttribute(attributeName);
    }

    protected Iterator<JavaPersistentAttribute> attributesNamed(final String attributeName) {
        return new FilteringIterator<JavaPersistentAttribute>(this.attributes()){

            protected boolean accept(JavaPersistentAttribute o) {
                return attributeName.equals(o.getName());
            }
        };
    }

    @Override
    public Iterator<PersistentAttribute> allAttributes() {
        return new CompositeIterator((Iterator)new TransformationIterator<PersistentType, Iterator<PersistentAttribute>>(this.inheritanceHierarchy()){

            protected Iterator<PersistentAttribute> transform(PersistentType pt) {
                return pt.attributes();
            }
        });
    }

    @Override
    public Iterator<String> allAttributeNames() {
        return this.attributeNames(this.allAttributes());
    }

    protected void initializeAttributes() {
        Iterator<JavaResourcePersistentAttribute> stream = this.resourceAttributes();
        while (stream.hasNext()) {
            this.attributes.add(this.createAttribute(stream.next()));
        }
    }

    protected Iterator<JavaResourcePersistentAttribute> resourceAttributes() {
        return this.getAccess() == AccessType.PROPERTY ? this.resourcePersistentType.persistableProperties() : this.resourcePersistentType.persistableFields();
    }

    protected void updateAttributes() {
        HashBag contextAttributesToRemove = CollectionTools.bag(this.attributes(), (int)this.attributesSize());
        ArrayList<JavaPersistentAttribute> contextAttributesToUpdate = new ArrayList<JavaPersistentAttribute>(this.attributesSize());
        int resourceIndex = 0;
        Iterator<JavaResourcePersistentAttribute> resourceAttributes = this.resourceAttributes();
        while (resourceAttributes.hasNext()) {
            JavaResourcePersistentAttribute resourceAttribute = resourceAttributes.next();
            boolean match = false;
            Iterator contextAttributes = contextAttributesToRemove.iterator();
            while (contextAttributes.hasNext()) {
                JavaPersistentAttribute contextAttribute = (JavaPersistentAttribute)contextAttributes.next();
                if (contextAttribute.getResourcePersistentAttribute() != resourceAttribute) continue;
                this.moveAttribute(resourceIndex, contextAttribute);
                contextAttributes.remove();
                contextAttributesToUpdate.add(contextAttribute);
                match = true;
                break;
            }
            if (!match) {
                this.addAttribute(resourceIndex, this.createAttribute(resourceAttribute));
            }
            ++resourceIndex;
        }
        for (JavaPersistentAttribute contextAttribute : contextAttributesToRemove) {
            this.removeAttribute(contextAttribute);
        }
        for (JavaPersistentAttribute contextAttribute : contextAttributesToUpdate) {
            contextAttribute.update();
        }
    }

    protected JavaPersistentAttribute createAttribute(JavaResourcePersistentAttribute jrpa) {
        return this.getJpaFactory().buildJavaPersistentAttribute(this, jrpa);
    }

    @Override
    public boolean hasAnyAnnotatedAttributes() {
        return this.resourcePersistentType.hasAnyAnnotatedAttributes();
    }

    @Override
    public PersistentType getSuperPersistentType() {
        return this.superPersistentType;
    }

    protected void setSuperPersistentType(PersistentType superPersistentType) {
        PersistentType old = this.superPersistentType;
        this.superPersistentType = superPersistentType;
        this.firePropertyChanged("superPersistentType", old, superPersistentType);
    }

    protected PersistentType buildSuperPersistentType() {
        HashSet<JavaResourcePersistentType> visited = new HashSet<JavaResourcePersistentType>();
        visited.add(this.resourcePersistentType);
        PersistentType spt = this.getSuperPersistentType(this.resourcePersistentType.getSuperclassQualifiedName(), visited);
        if (spt == null) {
            return null;
        }
        if (CollectionTools.contains(spt.inheritanceHierarchy(), (Object)this)) {
            return null;
        }
        return spt.isMapped() ? spt : spt.getSuperPersistentType();
    }

    protected PersistentType getSuperPersistentType(String typeName, Collection<JavaResourcePersistentType> visited) {
        if (typeName == null) {
            return null;
        }
        JavaResourcePersistentType resourceType = this.getJpaProject().getJavaResourcePersistentType(typeName);
        if (resourceType == null || visited.contains(resourceType)) {
            return null;
        }
        visited.add(resourceType);
        PersistentType spt = this.getPersistentType(typeName);
        return spt != null ? spt : this.getSuperPersistentType(resourceType.getSuperclassQualifiedName(), visited);
    }

    protected PersistentType getPersistentType(String typeName) {
        return this.getPersistenceUnit().getPersistentType(typeName);
    }

    @Override
    public Iterator<PersistentType> inheritanceHierarchy() {
        return this.inheritanceHierarchyOf(this);
    }

    @Override
    public Iterator<PersistentType> ancestors() {
        return this.inheritanceHierarchyOf(this.superPersistentType);
    }

    protected Iterator<PersistentType> inheritanceHierarchyOf(PersistentType start) {
        return new ChainIterator<PersistentType>(start){

            protected PersistentType nextLink(PersistentType persistentType) {
                return persistentType.getSuperPersistentType();
            }
        };
    }

    @Override
    public Iterator<String> javaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator<String> result = super.javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        Iterator values = this.mapping.javaCompletionProposals(pos, filter, astRoot);
        if (values != null) {
            return values;
        }
        for (JavaPersistentAttribute attribute : this.getAttributes()) {
            values = attribute.javaCompletionProposals(pos, filter, astRoot);
            if (values == null) continue;
            return values;
        }
        return EmptyIterator.instance();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        if (reporter.isCancelled()) {
            throw new ValidationCancelledException();
        }
        IFile file = this.resourcePersistentType.getFile();
        if (file != null && file.getProject().equals((Object)this.getJpaProject().getProject()) && this.resourcePersistentType instanceof SourceNode) {
            this.validate(messages, reporter, this.buildASTRoot());
        }
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        this.validateMapping(messages, reporter, astRoot);
        this.validateAttributes(messages, reporter, astRoot);
    }

    protected void validateMapping(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        try {
            this.mapping.validate(messages, reporter, astRoot);
        }
        catch (Throwable t) {
            JptCorePlugin.log(t);
        }
    }

    protected void validateAttributes(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        for (JavaPersistentAttribute attribute : this.getAttributes()) {
            this.validateAttribute(attribute, reporter, messages, astRoot);
        }
    }

    protected void validateAttribute(JavaPersistentAttribute attribute, IReporter reporter, List<IMessage> messages, CompilationUnit astRoot) {
        try {
            attribute.validate(messages, reporter, astRoot);
        }
        catch (Throwable t) {
            JptCorePlugin.log(t);
        }
    }

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        return this.getSelectionTextRange(astRoot);
    }

    @Override
    public boolean isMapped() {
        return this.mapping.isMapped();
    }

    @Override
    public AccessType getOwnerOverrideAccess() {
        return this.getParent().getOverridePersistentTypeAccess();
    }

    @Override
    public AccessType getOwnerDefaultAccess() {
        return this.getParent().getDefaultPersistentTypeAccess();
    }

    public void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(this.name);
    }

    protected CompilationUnit buildASTRoot() {
        return this.resourcePersistentType.getJavaResourceCompilationUnit().buildASTRoot();
    }

    protected JpaFile getJpaFile() {
        return this.getJpaFile(this.resourcePersistentType.getFile());
    }
}

