/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import java.util.List;
import org.eclipse.jpt.core.context.AttributeMapping;
import org.eclipse.jpt.core.context.RelationshipMapping;
import org.eclipse.jpt.core.context.orm.OrmJoinTable;
import org.eclipse.jpt.core.context.orm.OrmJoinTableEnabledRelationshipReference;
import org.eclipse.jpt.core.context.orm.OrmJoinTableJoiningStrategy;
import org.eclipse.jpt.core.context.orm.OrmJoiningStrategy;
import org.eclipse.jpt.core.context.orm.OrmManyToManyMapping;
import org.eclipse.jpt.core.context.orm.OrmManyToManyRelationshipReference;
import org.eclipse.jpt.core.context.orm.OrmMappedByJoiningStrategy;
import org.eclipse.jpt.core.context.orm.OrmOwnableRelationshipReference;
import org.eclipse.jpt.core.context.orm.OrmRelationshipReference;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmRelationshipReference;
import org.eclipse.jpt.core.internal.context.orm.GenericOrmJoinTableJoiningStrategy;
import org.eclipse.jpt.core.internal.context.orm.GenericOrmMappedByJoiningStrategy;
import org.eclipse.jpt.core.resource.orm.XmlManyToMany;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericOrmManyToManyRelationshipReference
extends AbstractOrmRelationshipReference
implements OrmManyToManyRelationshipReference {
    protected OrmMappedByJoiningStrategy mappedByJoiningStrategy;
    protected OrmJoinTableJoiningStrategy joinTableJoiningStrategy;

    public GenericOrmManyToManyRelationshipReference(OrmManyToManyMapping parent, XmlManyToMany resource) {
        super(parent, resource);
    }

    @Override
    protected void initializeJoiningStrategies() {
        this.mappedByJoiningStrategy = this.buildMappedByJoiningStrategy();
        this.joinTableJoiningStrategy = this.buildJoinTableJoiningStrategy();
    }

    protected OrmMappedByJoiningStrategy buildMappedByJoiningStrategy() {
        return new GenericOrmMappedByJoiningStrategy(this, this.getResourceMapping());
    }

    protected OrmJoinTableJoiningStrategy buildJoinTableJoiningStrategy() {
        return new GenericOrmJoinTableJoiningStrategy(this, this.getResourceMapping());
    }

    @Override
    public void initializeOn(OrmRelationshipReference newRelationshipReference) {
        newRelationshipReference.initializeFromOwnableRelationshipReference(this);
        newRelationshipReference.initializeFromJoinTableEnabledRelationshipReference(this);
    }

    @Override
    public void initializeFromOwnableRelationshipReference(OrmOwnableRelationshipReference oldRelationshipReference) {
        super.initializeFromOwnableRelationshipReference(oldRelationshipReference);
        this.mappedByJoiningStrategy.setMappedByAttribute(oldRelationshipReference.getMappedByJoiningStrategy().getMappedByAttribute());
    }

    @Override
    public void initializeFromJoinTableEnabledRelationshipReference(OrmJoinTableEnabledRelationshipReference oldRelationshipReference) {
        super.initializeFromJoinTableEnabledRelationshipReference(oldRelationshipReference);
        OrmJoinTable oldTable = oldRelationshipReference.getJoinTableJoiningStrategy().getJoinTable();
        if (oldTable != null) {
            this.joinTableJoiningStrategy.addJoinTable().initializeFrom(oldTable);
        }
    }

    @Override
    public OrmManyToManyMapping getRelationshipMapping() {
        return (OrmManyToManyMapping)super.getRelationshipMapping();
    }

    @Override
    public XmlManyToMany getResourceMapping() {
        return this.getRelationshipMapping().getResourceAttributeMapping();
    }

    @Override
    public boolean isRelationshipOwner() {
        return this.mappedByJoiningStrategy.getMappedByAttribute() == null;
    }

    @Override
    public boolean isOwnedBy(RelationshipMapping mapping) {
        return this.mappedByJoiningStrategy.relationshipIsOwnedBy(mapping);
    }

    @Override
    protected OrmJoiningStrategy calculatePredominantJoiningStrategy() {
        if (this.mappedByJoiningStrategy.getMappedByAttribute() != null) {
            return this.mappedByJoiningStrategy;
        }
        return this.joinTableJoiningStrategy;
    }

    @Override
    public OrmMappedByJoiningStrategy getMappedByJoiningStrategy() {
        return this.mappedByJoiningStrategy;
    }

    @Override
    public boolean usesMappedByJoiningStrategy() {
        return this.getPredominantJoiningStrategy() == this.mappedByJoiningStrategy;
    }

    @Override
    public void setMappedByJoiningStrategy() {
        this.mappedByJoiningStrategy.addStrategy();
        this.joinTableJoiningStrategy.removeStrategy();
        this.setPredominantJoiningStrategy();
    }

    @Override
    public void unsetMappedByJoiningStrategy() {
        this.mappedByJoiningStrategy.removeStrategy();
        this.setPredominantJoiningStrategy();
    }

    @Override
    public boolean mayBeMappedBy(AttributeMapping mappedByMapping) {
        return mappedByMapping.getKey() == "manyToMany";
    }

    @Override
    public OrmJoinTableJoiningStrategy getJoinTableJoiningStrategy() {
        return this.joinTableJoiningStrategy;
    }

    @Override
    public boolean usesJoinTableJoiningStrategy() {
        return this.getPredominantJoiningStrategy() == this.joinTableJoiningStrategy;
    }

    @Override
    public void setJoinTableJoiningStrategy() {
        this.mappedByJoiningStrategy.removeStrategy();
        this.setPredominantJoiningStrategy();
    }

    @Override
    public void unsetJoinTableJoiningStrategy() {
        this.joinTableJoiningStrategy.removeStrategy();
        this.setPredominantJoiningStrategy();
    }

    @Override
    public boolean mayHaveDefaultJoinTable() {
        return this.getMappedByJoiningStrategy().getMappedByAttribute() == null;
    }

    @Override
    protected void updateJoiningStrategies() {
        this.mappedByJoiningStrategy.update();
        this.joinTableJoiningStrategy.update();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.mappedByJoiningStrategy.validate(messages, reporter);
        this.joinTableJoiningStrategy.validate(messages, reporter);
    }
}

