/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.axis.creation.ui.command;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.ws.internal.axis.consumption.core.AxisConsumptionCoreMessages;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.command.internal.env.common.FileResourceUtils;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.command.internal.env.core.context.ResourceContext;
import org.eclipse.wst.command.internal.env.eclipse.BaseEclipseEnvironment;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.environment.IStatusHandler;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.internal.IModulePublishHelper;

public class CopyDeploymentFileCommand
extends AbstractDataModelOperation {
    private final String WEB_INF = "WEB-INF";
    private final String SERVER_CONFIG = "server-config.wsdd";
    private String projectName_;
    private String EARProjectName_;
    private String serverInstanceId_;

    public CopyDeploymentFileCommand(String projectName, String earProjectName) {
        this.projectName_ = projectName;
        this.EARProjectName_ = earProjectName;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IStatus status;
        block19: {
            status = Status.OK_STATUS;
            IEnvironment environment = this.getEnvironment();
            FileInputStream finStream = null;
            try {
                try {
                    IModulePublishHelper publishHelper;
                    IVirtualComponent component = J2EEUtils.getVirtualComponent((String)this.projectName_);
                    IServer server = ServerCore.findServer((String)this.serverInstanceId_);
                    IProject project = ProjectUtilities.getProject((String)this.projectName_);
                    IModule projectModule = ServerUtil.getModule((IProject)project);
                    if (server != null && component != null && projectModule != null && (publishHelper = (IModulePublishHelper)server.loadAdapter(IModulePublishHelper.class, monitor)) != null) {
                        IModule[] serverModules;
                        if (this.EARProjectName_ == null) {
                            serverModules = new IModule[]{projectModule};
                        } else {
                            IProject EARProject = ProjectUtilities.getProject((String)this.EARProjectName_);
                            IModule EARProjectModule = ServerUtil.getModule((IProject)EARProject);
                            serverModules = new IModule[]{EARProjectModule, projectModule};
                        }
                        IPath publishDirPath = publishHelper.getPublishDirectory(serverModules);
                        if (publishDirPath != null) {
                            IVirtualFile newLocation;
                            IPath targetPath;
                            IPath path;
                            IPath serverConfigPath;
                            File publishDirFile;
                            File rootFolderFile;
                            IVirtualFolder rootFolder = component.getRootFolder();
                            IPath rootFolderPath = ResourceUtils.getWorkspaceRoot().getFile(rootFolder.getWorkspaceRelativePath()).getLocation();
                            if (rootFolderPath != null && !(rootFolderFile = rootFolderPath.toFile()).equals(publishDirFile = publishDirPath.toFile()) && (serverConfigPath = publishDirPath.append(path = new Path("WEB-INF").append("server-config.wsdd"))) != null && (targetPath = (newLocation = rootFolder.getFile(path)).getWorkspaceRelativePath()) != null) {
                                finStream = new FileInputStream(serverConfigPath.toString());
                                IStatusHandler statusHandler = environment.getStatusHandler();
                                ResourceContext context = ((BaseEclipseEnvironment)environment).getResourceContext();
                                FileResourceUtils.createFile((ResourceContext)context, (IPath)targetPath, (InputStream)finStream, (IProgressMonitor)monitor, (IStatusHandler)statusHandler);
                                finStream.close();
                            }
                        }
                    }
                }
                catch (Throwable e) {
                    status = StatusUtils.errorStatus((String)NLS.bind((String)AxisConsumptionCoreMessages.MSG_ERROR_MOVE_RESOURCE, (Object[])new String[]{e.getLocalizedMessage()}), (Throwable)e);
                    environment.getStatusHandler().reportError(status);
                    if (finStream != null) {
                        try {
                            finStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block19;
                }
            }
            catch (Throwable throwable) {
                if (finStream != null) {
                    try {
                        finStream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (finStream != null) {
                try {
                    finStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return status;
    }

    public void setServerInstanceId(String serverInstanceId) {
        this.serverInstanceId_ = serverInstanceId;
    }
}

