/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.text;

import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;

public class DocumentRegionEdgeMatcher
implements ICharacterPairMatcher {
    public static final String ID = "characterpairmatcher";
    protected int fAnchor;
    protected ICharacterPairMatcher fNextMatcher;
    protected List fRegionTypes;

    public DocumentRegionEdgeMatcher(String[] validContexts, ICharacterPairMatcher nextMatcher) {
        this.fRegionTypes = Arrays.asList(validContexts);
        this.fNextMatcher = nextMatcher;
    }

    public void clear() {
        if (this.fNextMatcher != null) {
            this.fNextMatcher.clear();
        }
    }

    public void dispose() {
        if (this.fNextMatcher != null) {
            this.fNextMatcher.dispose();
        }
    }

    public int getAnchor() {
        if (this.fAnchor < 0 && this.fNextMatcher != null) {
            return this.fNextMatcher.getAnchor();
        }
        return this.fAnchor;
    }

    public IRegion match(IDocument document, int offset) {
        IStructuredDocumentRegion docRegion;
        if (offset < 0 || offset >= document.getLength()) {
            return null;
        }
        IRegion match = null;
        if (!this.fRegionTypes.isEmpty() && document instanceof IStructuredDocument && (docRegion = ((IStructuredDocument)document).getRegionAtCharacterOffset(offset)) != null) {
            ITextRegion currentTextRegion;
            if (docRegion.getPrevious() != null && docRegion.getPrevious().getEndOffset() == offset && this.fRegionTypes.contains(docRegion.getPrevious().getType())) {
                this.fAnchor = 0;
                match = new Region(docRegion.getPrevious().getStartOffset(), 1);
            } else if (this.fRegionTypes.contains(docRegion.getType()) && docRegion.getStartOffset(docRegion.getLastRegion()) <= offset && offset <= docRegion.getEndOffset(docRegion.getLastRegion())) {
                this.fAnchor = 0;
                match = new Region(docRegion.getStartOffset(), 1);
            } else if (this.fRegionTypes.contains(docRegion.getType()) && docRegion.getStartOffset(docRegion.getFirstRegion()) <= offset && offset <= docRegion.getEndOffset(docRegion.getFirstRegion())) {
                this.fAnchor = 1;
                match = new Region(docRegion.getEndOffset() - 1, 1);
            }
            if (match == null && (currentTextRegion = docRegion.getRegionAtCharacterOffset(offset)) != null && currentTextRegion.getTextLength() > 1) {
                int offsetAtNearEdge = offset;
                if (offset == docRegion.getTextEndOffset(currentTextRegion)) {
                    offsetAtNearEdge = offset - 1;
                } else if (offset == docRegion.getStartOffset(currentTextRegion) + 1) {
                    offsetAtNearEdge = offset - 1;
                }
                if (offsetAtNearEdge == docRegion.getStartOffset(currentTextRegion)) {
                    int end = docRegion.getTextEndOffset(currentTextRegion);
                    try {
                        if (document.getChar(offsetAtNearEdge) == document.getChar(end - 1)) {
                            this.fAnchor = 1;
                            match = new Region(end - 1, 1);
                        }
                    }
                    catch (BadLocationException badLocationException) {}
                } else if (offsetAtNearEdge == docRegion.getTextEndOffset(currentTextRegion) - 1) {
                    int start = docRegion.getStartOffset(currentTextRegion);
                    try {
                        if (document.getChar(offsetAtNearEdge) == document.getChar(start)) {
                            this.fAnchor = 0;
                            match = new Region(start, 1);
                        }
                    }
                    catch (BadLocationException badLocationException) {}
                }
            }
        }
        if (match == null && this.fNextMatcher != null) {
            this.fAnchor = -1;
            match = this.fNextMatcher.match(document, offset);
        }
        return match;
    }
}

