/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.metadata.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jst.jsf.common.metadata.internal.AbstractMetaDataLocator;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataLocator;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataSourceModelProvider;
import org.eclipse.jst.jsf.common.metadata.internal.IPathSensitiveMetaDataLocator;
import org.eclipse.jst.jsf.core.internal.tld.CMUtil;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.CMDocumentFactoryTLD;
import org.eclipse.jst.jsp.core.taglib.ITaglibRecord;
import org.eclipse.jst.jsp.core.taglib.TaglibIndex;
import org.eclipse.wst.html.core.internal.contentmodel.HTMLCMDocumentFactory;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;

public class TaglibMetaDataLocator
extends AbstractMetaDataLocator
implements IPathSensitiveMetaDataLocator {
    private IProject _project;
    private TaglibMetaDataSource _source;

    public List locateMetaDataModelProviders(String uri) {
        ArrayList<TaglibMetaDataSource> ret = new ArrayList<TaglibMetaDataSource>();
        CMDocument doc = null;
        if (uri == null) {
            return ret;
        }
        if (uri.equalsIgnoreCase("HTML")) {
            doc = HTMLCMDocumentFactory.getCMDocument((String)"HTML");
        } else if (uri.equalsIgnoreCase("JSP11")) {
            doc = HTMLCMDocumentFactory.getCMDocument((String)"JSP11");
        } else if (uri.equalsIgnoreCase("JSP12")) {
            doc = HTMLCMDocumentFactory.getCMDocument((String)"JSP12");
        } else if (uri.equalsIgnoreCase("JSP20")) {
            doc = HTMLCMDocumentFactory.getCMDocument((String)"JSP20");
        } else if (this._project != null) {
            CMDocumentFactoryTLD factory = new CMDocumentFactoryTLD();
            ITaglibRecord[] tldRecs = TaglibIndex.getAvailableTaglibRecords((IPath)this._project.getFullPath());
            ITaglibRecord tldRec = this.findTLD(tldRecs, uri);
            if (tldRec != null) {
                doc = factory.createCMDocument(tldRec);
            }
        }
        if (doc != null) {
            this._source = new TaglibMetaDataSource(doc);
            ret.add(this._source);
        }
        return ret;
    }

    private ITaglibRecord findTLD(ITaglibRecord[] tldRecs, String uri) {
        int i = 0;
        while (i < tldRecs.length) {
            ITaglibRecord tldRec = tldRecs[i];
            String tldRecURI = CMUtil.getURIFromTaglibRecord(tldRec, this._project);
            if (uri.equals(tldRecURI)) {
                return tldRec;
            }
            ++i;
        }
        return null;
    }

    public void startLocating() {
    }

    public void stopLocating() {
    }

    public void setProjectContext(IProject project) {
        this._project = project;
    }

    private class TaglibMetaDataSource
    implements IMetaDataSourceModelProvider {
        private CMDocument doc;
        private IMetaDataLocator locator;

        TaglibMetaDataSource(CMDocument doc) {
            this.doc = doc;
        }

        public Object getSourceModel() {
            return this.doc;
        }

        public IMetaDataLocator getLocator() {
            return this.locator;
        }

        public void setLocator(IMetaDataLocator locator) {
            this.locator = locator;
        }

        public Object getAdapter(Class klass) {
            return null;
        }
    }
}

