/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.jpa1;

import org.eclipse.jpt.core.JpaDataSource;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.internal.AbstractJpaNode;
import org.eclipse.jpt.core.jpa2.JpaFactory2_0;
import org.eclipse.jpt.db.ConnectionAdapter;
import org.eclipse.jpt.db.ConnectionListener;
import org.eclipse.jpt.db.ConnectionProfile;
import org.eclipse.jpt.db.ConnectionProfileFactory;
import org.eclipse.jpt.db.ConnectionProfileListener;
import org.eclipse.jpt.db.Database;
import org.eclipse.jpt.db.DatabaseIdentifierAdapter;
import org.eclipse.jpt.db.DatabaseObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJpaDataSource
extends AbstractJpaNode
implements JpaDataSource {
    protected String connectionProfileName;
    protected transient ConnectionProfile connectionProfile;
    protected final ConnectionProfileListener connectionProfileListener;
    protected final ConnectionListener connectionListener;
    private static final long serialVersionUID = 1L;

    public GenericJpaDataSource(JpaProject jpaProject, String connectionProfileName) {
        super(jpaProject);
        this.connectionProfileName = connectionProfileName;
        this.connectionProfile = this.buildConnectionProfile(connectionProfileName);
        this.connectionProfileListener = this.buildConnectionProfileListener();
        this.getConnectionProfileFactory().addConnectionProfileListener(this.connectionProfileListener);
        this.connectionListener = this.buildConnectionListener();
        if (this.connectionProfile != null) {
            this.connectionProfile.addConnectionListener(this.connectionListener);
        }
    }

    protected ConnectionProfileFactory getConnectionProfileFactory() {
        return this.getJpaPlatform().getConnectionProfileFactory();
    }

    protected ConnectionProfileListener buildConnectionProfileListener() {
        return new LocalConnectionProfileListener();
    }

    protected ConnectionListener buildConnectionListener() {
        return new LocalConnectionListener();
    }

    @Override
    public String getConnectionProfileName() {
        return this.connectionProfileName;
    }

    @Override
    public void setConnectionProfileName(String connectionProfileName) {
        String old = this.connectionProfileName;
        this.connectionProfileName = connectionProfileName;
        if (this.attributeValueHasChanged(old, connectionProfileName)) {
            this.firePropertyChanged("connectionProfileName", old, connectionProfileName);
            this.setConnectionProfile(this.buildConnectionProfile(connectionProfileName));
            JptCorePlugin.setConnectionProfileName(this.getJpaProject().getProject(), connectionProfileName);
        }
    }

    @Override
    public ConnectionProfile getConnectionProfile() {
        return this.connectionProfile;
    }

    @Override
    public boolean connectionProfileIsActive() {
        ConnectionProfile cp = this.connectionProfile;
        return cp != null && cp.isActive();
    }

    @Override
    public Database getDatabase() {
        ConnectionProfile cp = this.connectionProfile;
        return cp == null ? null : cp.getDatabase();
    }

    @Override
    public <T extends DatabaseObject> T selectDatabaseObjectForIdentifier(Iterable<T> databaseObjects, String identifier) {
        Database db = this.getDatabase();
        return (T)(db == null ? null : db.selectDatabaseObjectForIdentifier(databaseObjects, identifier));
    }

    @Override
    public void dispose() {
        if (this.connectionProfile != null) {
            this.connectionProfile.removeConnectionListener(this.connectionListener);
        }
        this.getConnectionProfileFactory().removeConnectionProfileListener(this.connectionProfileListener);
    }

    protected ConnectionProfile buildConnectionProfile(String name) {
        return this.getConnectionProfileFactory().buildConnectionProfile(name, this.buildDatabaseIdentifierAdapter());
    }

    protected DatabaseIdentifierAdapter buildDatabaseIdentifierAdapter() {
        return this.isJpa2_0Compatible() ? ((JpaFactory2_0)this.getJpaFactory()).buildDatabaseIdentifierAdapter(this) : DatabaseIdentifierAdapter.Default.instance();
    }

    protected void setConnectionProfile(ConnectionProfile connectionProfile) {
        ConnectionProfile old = this.connectionProfile;
        if (old != null) {
            old.removeConnectionListener(this.connectionListener);
        }
        this.connectionProfile = connectionProfile;
        if (connectionProfile != null) {
            connectionProfile.addConnectionListener(this.connectionListener);
        }
        this.firePropertyChanged("connectionProfile", old, connectionProfile);
    }

    public void toString(StringBuilder sb) {
        sb.append(this.connectionProfileName);
    }

    protected class LocalConnectionListener
    extends ConnectionAdapter {
        protected LocalConnectionListener() {
        }

        public void opened(ConnectionProfile profile) {
            GenericJpaDataSource.this.getJpaProject().update();
        }

        public void closed(ConnectionProfile profile) {
            GenericJpaDataSource.this.getJpaProject().update();
        }
    }

    protected class LocalConnectionProfileListener
    implements ConnectionProfileListener {
        protected LocalConnectionProfileListener() {
        }

        public void connectionProfileAdded(String name) {
            if (GenericJpaDataSource.this.connectionProfile == null && name.equals(GenericJpaDataSource.this.getConnectionProfileName())) {
                GenericJpaDataSource.this.setConnectionProfileName(name);
            }
        }

        public void connectionProfileRemoved(String name) {
            if (GenericJpaDataSource.this.connectionProfile == null) {
                return;
            }
            if (name.equals(GenericJpaDataSource.this.connectionProfile.getName())) {
                GenericJpaDataSource.this.setConnectionProfile(null);
            }
        }

        public void connectionProfileRenamed(String oldName, String newName) {
            if (GenericJpaDataSource.this.connectionProfile == null) {
                if (newName.equals(GenericJpaDataSource.this.connectionProfileName)) {
                    GenericJpaDataSource.this.setConnectionProfileName(newName);
                }
                return;
            }
            if (newName.equals(GenericJpaDataSource.this.connectionProfile.getName())) {
                GenericJpaDataSource.this.setConnectionProfileName(newName);
            }
        }
    }
}

