/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jpt.core.JpaAnnotationDefinitionProvider;
import org.eclipse.jpt.core.JpaAnnotationProvider;
import org.eclipse.jpt.core.resource.java.Annotation;
import org.eclipse.jpt.core.resource.java.AnnotationDefinition;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.utility.jdt.Attribute;
import org.eclipse.jpt.core.utility.jdt.Type;
import org.eclipse.jpt.utility.internal.iterators.ArrayListIterator;
import org.eclipse.jpt.utility.internal.iterators.CompositeIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJpaAnnotationProvider
implements JpaAnnotationProvider {
    private final JpaAnnotationDefinitionProvider[] annotationDefinitionProviders;

    public GenericJpaAnnotationProvider(JpaAnnotationDefinitionProvider ... annotationDefinitionProviders) {
        this.annotationDefinitionProviders = annotationDefinitionProviders;
    }

    protected Iterator<String> annotationNames(Iterator<AnnotationDefinition> annotationDefinitions) {
        return new TransformationIterator<AnnotationDefinition, String>(annotationDefinitions){

            protected String transform(AnnotationDefinition annotationDefinition) {
                return annotationDefinition.getAnnotationName();
            }
        };
    }

    protected AnnotationDefinition selectAnnotationDefinition(Iterator<AnnotationDefinition> annotationDefinitions, String annotationName) {
        while (annotationDefinitions.hasNext()) {
            AnnotationDefinition annotationDefinition = annotationDefinitions.next();
            if (!annotationDefinition.getAnnotationName().equals(annotationName)) continue;
            return annotationDefinition;
        }
        return null;
    }

    protected ListIterator<JpaAnnotationDefinitionProvider> annotationDefinitionProviders() {
        return new ArrayListIterator((Object[])this.annotationDefinitionProviders);
    }

    @Override
    public Iterator<String> typeAnnotationNames() {
        return this.annotationNames(this.typeAnnotationDefinitions());
    }

    protected Iterator<AnnotationDefinition> typeAnnotationDefinitions() {
        return new CompositeIterator((Iterator)new TransformationIterator<JpaAnnotationDefinitionProvider, Iterator<AnnotationDefinition>>(this.annotationDefinitionProviders()){

            protected Iterator<AnnotationDefinition> transform(JpaAnnotationDefinitionProvider annotationDefinitionProvider) {
                return annotationDefinitionProvider.typeAnnotationDefinitions();
            }
        });
    }

    @Override
    public Iterator<String> typeMappingAnnotationNames() {
        return this.annotationNames(this.typeMappingAnnotationDefinitions());
    }

    protected Iterator<AnnotationDefinition> typeMappingAnnotationDefinitions() {
        return new CompositeIterator((Iterator)new TransformationIterator<JpaAnnotationDefinitionProvider, Iterator<AnnotationDefinition>>(this.annotationDefinitionProviders()){

            protected Iterator<AnnotationDefinition> transform(JpaAnnotationDefinitionProvider annotationDefinitionProvider) {
                return annotationDefinitionProvider.typeMappingAnnotationDefinitions();
            }
        });
    }

    @Override
    public Annotation buildTypeAnnotation(JavaResourcePersistentType parent, Type type, String annotationName) {
        return this.getTypeAnnotationDefinition(annotationName).buildAnnotation((JavaResourcePersistentMember)parent, type);
    }

    @Override
    public Annotation buildTypeAnnotation(JavaResourcePersistentType parent, IAnnotation jdtAnnotation) {
        return this.getTypeAnnotationDefinition(jdtAnnotation.getElementName()).buildAnnotation((JavaResourcePersistentMember)parent, jdtAnnotation);
    }

    protected AnnotationDefinition getTypeAnnotationDefinition(String annotationName) {
        AnnotationDefinition annotationDefinition = this.selectAnnotationDefinition(this.typeAnnotationDefinitions(), annotationName);
        if (annotationDefinition == null) {
            throw new IllegalArgumentException("unsupported type annotation: " + annotationName);
        }
        return annotationDefinition;
    }

    @Override
    public Annotation buildNullTypeAnnotation(JavaResourcePersistentType parent, String annotationName) {
        return this.getTypeAnnotationDefinition(annotationName).buildNullAnnotation(parent);
    }

    @Override
    public Iterator<String> attributeAnnotationNames() {
        return this.annotationNames(this.attributeAnnotationDefinitions());
    }

    protected Iterator<AnnotationDefinition> attributeAnnotationDefinitions() {
        return new CompositeIterator((Iterator)new TransformationIterator<JpaAnnotationDefinitionProvider, Iterator<AnnotationDefinition>>(this.annotationDefinitionProviders()){

            protected Iterator<AnnotationDefinition> transform(JpaAnnotationDefinitionProvider annotationDefinitionProvider) {
                return annotationDefinitionProvider.attributeAnnotationDefinitions();
            }
        });
    }

    @Override
    public Annotation buildAttributeAnnotation(JavaResourcePersistentAttribute parent, Attribute attribute, String annotationName) {
        return this.getAttributeAnnotationDefinition(annotationName).buildAnnotation((JavaResourcePersistentMember)parent, attribute);
    }

    @Override
    public Annotation buildAttributeAnnotation(JavaResourcePersistentAttribute parent, IAnnotation jdtAnnotation) {
        return this.getAttributeAnnotationDefinition(jdtAnnotation.getElementName()).buildAnnotation((JavaResourcePersistentMember)parent, jdtAnnotation);
    }

    @Override
    public Annotation buildNullAttributeAnnotation(JavaResourcePersistentAttribute parent, String annotationName) {
        return this.getAttributeAnnotationDefinition(annotationName).buildNullAnnotation(parent);
    }

    protected AnnotationDefinition getAttributeAnnotationDefinition(String annotationName) {
        AnnotationDefinition annotationDefinition = this.selectAnnotationDefinition(this.attributeAnnotationDefinitions(), annotationName);
        if (annotationDefinition == null) {
            throw new IllegalArgumentException("unsupported attribute annotation: " + annotationName);
        }
        return annotationDefinition;
    }
}

