/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.web.project.facet;

import java.util.ArrayList;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jst.common.project.facet.JavaFacetUtils;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.j2ee.project.facet.IJ2EEFacetConstants;
import org.eclipse.jst.j2ee.project.facet.J2EEFacetProjectCreationDataModelProvider;
import org.eclipse.jst.j2ee.web.project.facet.IWebFragmentProjectCreationDataModelProperties;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.datamodel.properties.IFacetProjectCreationDataModelProperties;
import org.eclipse.wst.common.frameworks.datamodel.DataModelEvent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelListener;
import org.eclipse.wst.common.frameworks.internal.operations.ProjectCreationDataModelProviderNew;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class WebFragmentFacetProjectCreationDataModelProvider
extends J2EEFacetProjectCreationDataModelProvider
implements IWebFragmentProjectCreationDataModelProperties {
    public IProjectFacet WEBFRAGMENT_FACET = ProjectFacetsManager.getProjectFacet((String)"jst.webfragment");

    public void init() {
        super.init();
        ArrayList<IProjectFacet> requiredFacets = new ArrayList<IProjectFacet>();
        requiredFacets.add(JavaFacetUtils.JAVA_FACET);
        requiredFacets.add(ProjectFacetsManager.getProjectFacet((String)"jst.webfragment"));
        this.setProperty("FacetProjectCreationDataModelProvider.REQUIRED_FACETS_COLLECTION", requiredFacets);
        IFacetProjectCreationDataModelProperties.FacetDataModelMap map = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)this.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        IDataModel javaFacet = map.getFacetDataModel(JavaFacetUtils.JAVA_FACET.getId());
        javaFacet.setProperty("IJavaFacetInstallDataModelProperties.DEFAULT_OUTPUT_FOLDER_NAME", (Object)"bin");
        IDataModel webFragmentFacet = map.getFacetDataModel(this.WEBFRAGMENT_FACET.getId());
        webFragmentFacet.addListener(new IDataModelListener(){

            public void propertyChanged(DataModelEvent event) {
                if ("IWebFragmentFacetInstallDataModelProperties.WAR_PROJECT_NAME".equals(event.getPropertyName())) {
                    if (WebFragmentFacetProjectCreationDataModelProvider.this.isPropertySet("IWebFragmentProjectCreationDataModelProperties.WAR_PROJECT_NAME")) {
                        WebFragmentFacetProjectCreationDataModelProvider.this.setProperty("IWebFragmentProjectCreationDataModelProperties.WAR_PROJECT_NAME", event.getProperty());
                    } else {
                        WebFragmentFacetProjectCreationDataModelProvider.this.model.notifyPropertyChange("IWebFragmentProjectCreationDataModelProperties.WAR_PROJECT_NAME", 2);
                    }
                } else if ("IWebFragmentFacetInstallDataModelProperties.ADD_TO_WAR".equals(event.getPropertyName())) {
                    WebFragmentFacetProjectCreationDataModelProvider.this.setProperty("IWebFragmentProjectCreationDataModelProperties.ADD_TO_WAR", event.getProperty());
                }
            }
        });
    }

    public IStatus validate(String propertyName) {
        if ("IWebFragmentProjectCreationDataModelProperties.WAR_PROJECT_NAME".equals(propertyName) && this.model.getBooleanProperty("IWebFragmentProjectCreationDataModelProperties.ADD_TO_WAR")) {
            IStatus status = this.validateWebProjForWebFragment(this.model.getStringProperty("IWebFragmentProjectCreationDataModelProperties.WAR_PROJECT_NAME"));
            if (!status.isOK()) {
                return status;
            }
            if (this.getStringProperty("IFacetDataModelProperties.FACET_PROJECT_NAME").equals(this.getStringProperty("IWebFragmentProjectCreationDataModelProperties.WAR_PROJECT_NAME"))) {
                String errorMessage = WTPCommonPlugin.getResourceString((String)"4", (Object[])new Object[]{this.getStringProperty("IWebFragmentProjectCreationDataModelProperties.WAR_PROJECT_NAME")});
                return WTPCommonPlugin.createErrorStatus((String)errorMessage);
            }
        }
        return super.validate(propertyName);
    }

    protected IStatus validateWebProjForWebFragment(String webAppName) {
        if (webAppName.indexOf("#") != -1 || webAppName.indexOf("/") != -1) {
            String errorMessage = WTPCommonPlugin.getResourceString((String)"35");
            return WTPCommonPlugin.createErrorStatus((String)errorMessage);
        }
        if (webAppName.equals("")) {
            String errorMessage = WTPCommonPlugin.getResourceString((String)"34");
            return WTPCommonPlugin.createErrorStatus((String)errorMessage);
        }
        IStatus status = ProjectCreationDataModelProviderNew.validateProjectName((String)webAppName);
        if (status.isOK()) {
            IProject webProj = JavaEEProjectUtilities.getProject((String)this.getStringProperty("IWebFragmentProjectCreationDataModelProperties.WAR_PROJECT_NAME"));
            if (!webProj.exists()) {
                IPath path = ResourcesPlugin.getWorkspace().getRoot().getLocation();
                path = path.append(webAppName);
                status = ProjectCreationDataModelProviderNew.validateExisting((String)webAppName, (String)path.toOSString());
            } else {
                IProjectFacetVersion facetVersion = JavaEEProjectUtilities.getProjectFacetVersion((IProject)webProj, (String)"jst.web");
                if (facetVersion != null && (facetVersion == IJ2EEFacetConstants.DYNAMIC_WEB_22 || facetVersion == IJ2EEFacetConstants.DYNAMIC_WEB_23 || facetVersion == IJ2EEFacetConstants.DYNAMIC_WEB_24 || facetVersion == IJ2EEFacetConstants.DYNAMIC_WEB_25)) {
                    String errorMessage = Resources.WEB_FRAGMENT_WEB_INCOMPATIBILITY;
                    return WTPCommonPlugin.createErrorStatus((String)errorMessage);
                }
            }
        }
        return status;
    }

    public Object getDefaultProperty(String propertyName) {
        IDataModel nestedJ2EEFacetDataModel;
        if ("IWebFragmentProjectCreationDataModelProperties.ADD_TO_WAR".equals(propertyName)) {
            return true;
        }
        if ("IWebFragmentProjectCreationDataModelProperties.WAR_PROJECT_NAME".equals(propertyName) && (nestedJ2EEFacetDataModel = this.getJ2EEFacetModel()) != null) {
            return nestedJ2EEFacetDataModel.getProperty("IWebFragmentFacetInstallDataModelProperties.WAR_PROJECT_NAME");
        }
        return super.getDefaultProperty(propertyName);
    }

    public Set getPropertyNames() {
        Set names = super.getPropertyNames();
        names.add("IWebFragmentProjectCreationDataModelProperties.WAR_PROJECT_NAME");
        names.add("IWebFragmentProjectCreationDataModelProperties.ADD_TO_WAR");
        return names;
    }

    private static final class Resources
    extends NLS {
        public static String WEB_FRAGMENT_WEB_INCOMPATIBILITY;

        static {
            Resources.initializeMessages((String)WebFragmentFacetProjectCreationDataModelProvider.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

