/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facelet.core.internal.registry.taglib;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ContentHandler;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.URIHandler;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.resource.impl.URIHandlerImpl;
import org.eclipse.emf.ecore.util.BasicExtendedMetaData;
import org.eclipse.jst.jsf.facelet.core.internal.FaceletCorePlugin;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.faceletTaglib.DocumentRoot;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.faceletTaglib.FaceletTaglib;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.faceletTaglib.FaceletTaglibPackage;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.faceletTaglib.util.FaceletTaglibResourceFactoryImpl;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalog;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalogEntry;
import org.eclipse.wst.xml.core.internal.catalog.provisional.INextCatalog;

public class TagModelLoader {
    private final ResourceSetImpl _resSet;
    private final String _resourceUri;
    private DocumentRoot _docRoot;
    private FaceletTaglib _faceletTaglib;
    private static final List<URIHandler> DEFAULT_URI_HANDLERS;

    static {
        ArrayList<URIHandler> handlers = new ArrayList<URIHandler>();
        DefaultFaceletURIHandler handleFacelet = new DefaultFaceletURIHandler();
        handlers.add((URIHandler)handleFacelet);
        handlers.addAll(URIHandler.DEFAULT_HANDLERS);
        DEFAULT_URI_HANDLERS = handlers;
    }

    public TagModelLoader(String resourceUri) {
        this(resourceUri, (URIConverter)new ExtensibleURIConverterImpl(DEFAULT_URI_HANDLERS, (Collection)ContentHandler.Registry.INSTANCE.contentHandlers()));
    }

    public TagModelLoader(String resourceUri, URIConverter uriConverter) {
        this._resourceUri = resourceUri;
        this._resSet = new ResourceSetImpl();
        this._resSet.getPackageRegistry().put((Object)"http://java.sun.com/xml/ns/javaee", (Object)FaceletTaglibPackage.eINSTANCE);
        this._resSet.getPackageRegistry().put((Object)"http://java.sun.com/xml/ns/javaee/web-facelettaglibrary.xsd", (Object)FaceletTaglibPackage.eINSTANCE);
        this._resSet.setURIConverter(uriConverter);
        BasicExtendedMetaData extendedMetaData = new BasicExtendedMetaData(this._resSet.getPackageRegistry());
        this._resSet.getLoadOptions().put("EXTENDED_META_DATA", extendedMetaData);
        this._resSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("xml", new FaceletTaglibResourceFactoryImpl());
    }

    public void loadFromInputStream(InputStream is) throws Exception {
        Resource res = this._resSet.createResource(URI.createFileURI((String)this._resourceUri));
        if (res == null) {
            throw new IllegalArgumentException("Could not create Resource");
        }
        res.load(is, Collections.EMPTY_MAP);
        EObject eObject = (EObject)res.getContents().get(0);
        this._docRoot = (DocumentRoot)eObject;
        this._faceletTaglib = this._docRoot.getFaceletTaglib();
    }

    public void save(OutputStream os) throws Exception {
        Resource res = this._resSet.createResource(URI.createFileURI((String)this._resourceUri));
        if (res == null) {
            throw new IllegalArgumentException("Could not create Resource");
        }
        res.getContents().add((Object)this._docRoot);
        res.save(os, Collections.EMPTY_MAP);
    }

    public final void setTaglib(FaceletTaglib faceletTaglib) {
        this._faceletTaglib = faceletTaglib;
    }

    public final void setDocRoot(DocumentRoot docRoot) {
        this._docRoot = docRoot;
    }

    public FaceletTaglib getTaglib() {
        return this._faceletTaglib;
    }

    public DocumentRoot getDocRoot() {
        return this._docRoot;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DefaultFaceletURIHandler
    extends URIHandlerImpl {
        private DefaultFaceletURIHandler() {
        }

        public boolean canHandle(URI uri) {
            return "http://java.sun.com/dtd/facelet-taglib_1_0.dtd".equals(uri.toString());
        }

        public InputStream createInputStream(URI uri, Map<?, ?> options) throws IOException {
            try {
                return this.findFaceletDtdInCatalog();
            }
            catch (URISyntaxException e) {
                FaceletCorePlugin.log("While trying to load facelet dtd from catalog", e);
                return null;
            }
        }

        private InputStream findFaceletDtdInCatalog() throws URISyntaxException, IOException {
            ICatalog xmlCatalog = XMLCorePlugin.getDefault().getDefaultXMLCatalog();
            if (xmlCatalog != null) {
                INextCatalog[] nextCatalogs;
                ICatalog systemCatalog = null;
                INextCatalog[] iNextCatalogArray = nextCatalogs = xmlCatalog.getNextCatalogs();
                int n = nextCatalogs.length;
                int n2 = 0;
                while (n2 < n) {
                    INextCatalog catalog = iNextCatalogArray[n2];
                    ICatalog referencedCatalog = catalog.getReferencedCatalog();
                    if (referencedCatalog != null && "system_catalog".equals(referencedCatalog.getId())) {
                        systemCatalog = referencedCatalog;
                    }
                    ++n2;
                }
                if (systemCatalog != null) {
                    ICatalogEntry foundEntry = null;
                    ICatalogEntry[] iCatalogEntryArray = systemCatalog.getCatalogEntries();
                    int n3 = iCatalogEntryArray.length;
                    n = 0;
                    while (n < n3) {
                        ICatalogEntry entry = iCatalogEntryArray[n];
                        if ("-//Sun Microsystems, Inc.//DTD Facelet Taglib 1.0//EN".equals(entry.getKey())) {
                            foundEntry = entry;
                            break;
                        }
                        ++n;
                    }
                    if (foundEntry != null) {
                        java.net.URI uri = URIUtil.fromString((String)foundEntry.getURI());
                        URL url = URIUtil.toURL((java.net.URI)uri);
                        return url.openStream();
                    }
                }
            }
            return null;
        }
    }
}

