/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.provisional.extensions;

import java.util.ArrayList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.part.MultiPageEditorSite;

public class ConfigurationPointCalculator {
    public static final String DESIGN = ".design";
    public static final String SOURCE = ".source";
    protected String fContentType = null;
    protected IWorkbenchPart fPart = null;
    protected Class fRootClass = null;
    protected String fSubContext = null;

    public static String[] getConfigurationPoints(IEditorPart part, String contentType, String subContext, Class rootClass) {
        ConfigurationPointCalculator calculator = new ConfigurationPointCalculator();
        calculator.setContentType(contentType);
        calculator.setPart((IWorkbenchPart)part);
        calculator.setRootClass(rootClass);
        calculator.setSubContext(subContext);
        return calculator.getConfigurationPoints();
    }

    public String[] getConfigurationPoints() {
        ArrayList<String> points = new ArrayList<String>(2);
        IWorkbenchPartSite site = null;
        if (this.fPart != null) {
            String multipageClassName;
            site = this.fPart.getSite();
            String id = site.getId();
            if (id != null && id.length() > 0 && !id.equals(this.fRootClass.getName())) {
                points.add(id);
            }
            if (site instanceof MultiPageEditorSite) {
                String sourcePageID;
                String multipageID = ((MultiPageEditorSite)site).getMultiPageEditor().getSite().getId();
                if (!points.contains(multipageID)) {
                    points.add(multipageID);
                }
                if (!points.contains(sourcePageID = String.valueOf(((MultiPageEditorSite)site).getMultiPageEditor().getSite().getId()) + SOURCE)) {
                    points.add(sourcePageID);
                }
            }
            if (site instanceof MultiPageEditorSite && !points.contains(multipageClassName = ((MultiPageEditorSite)site).getMultiPageEditor().getClass().getName())) {
                points.add(multipageClassName);
            }
            Class<?> editorClass = this.fPart.getClass();
            while (editorClass != null && this.fRootClass != null && !editorClass.equals(this.fRootClass)) {
                if (!points.contains(editorClass.getName())) {
                    points.add(editorClass.getName());
                }
                editorClass = editorClass.getSuperclass();
            }
        }
        if (this.fContentType != null) {
            IContentType contentType = Platform.getContentTypeManager().getContentType(this.fContentType);
            while (contentType != null && !contentType.getId().equals("org.eclipse.core.runtime.text")) {
                if (!points.contains(contentType.getId())) {
                    points.add(contentType.getId());
                }
                contentType = contentType.getBaseType();
            }
        }
        if (this.fRootClass != null && !points.contains(this.fRootClass.getName())) {
            points.add(this.fRootClass.getName());
        }
        return points.toArray(new String[0]);
    }

    public String getContentType() {
        return this.fContentType;
    }

    public IWorkbenchPart getPart() {
        return this.fPart;
    }

    public Class getRootClass() {
        return this.fRootClass;
    }

    public String getSubContext() {
        return this.fSubContext;
    }

    public void setContentType(String contentType) {
        this.fContentType = contentType;
    }

    public void setPart(IWorkbenchPart part) {
        this.fPart = part;
    }

    public void setRootClass(Class rootClass) {
        this.fRootClass = rootClass;
    }

    public void setSubContext(String subContext) {
        this.fSubContext = subContext;
    }
}

