/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.utility.jdt;

import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jpt.core.internal.utility.jdt.AbstractExpressionConverter;
import org.eclipse.jpt.core.internal.utility.jdt.NameStringExpressionConverter;
import org.eclipse.jpt.core.internal.utility.jdt.StringArrayExpressionConverter;
import org.eclipse.jpt.core.internal.utility.jdt.StringExpressionConverter;
import org.eclipse.jpt.core.utility.jdt.ExpressionConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationStringArrayExpressionConverter
extends AbstractExpressionConverter<String[]> {
    private final ExpressionConverter<String> elementConverter;
    private final StringArrayExpressionConverter arrayConverter;

    public AnnotationStringArrayExpressionConverter(ExpressionConverter<String> elementConverter) {
        this(elementConverter, true);
    }

    public AnnotationStringArrayExpressionConverter(ExpressionConverter<String> elementConverter, boolean removeArrayInitializerWhenEmpty) {
        this.elementConverter = elementConverter;
        this.arrayConverter = new StringArrayExpressionConverter(elementConverter, removeArrayInitializerWhenEmpty);
    }

    @Override
    protected Expression convertObject(String[] strings, AST ast) {
        return strings.length == 1 ? this.elementConverter.convert(strings[0], ast) : this.arrayConverter.convertObject(strings, ast);
    }

    @Override
    protected String[] convertNull() {
        return this.arrayConverter.convertNull();
    }

    @Override
    protected String[] convertExpression(Expression expression) {
        String[] stringArray;
        if (expression.getNodeType() == 4) {
            stringArray = this.arrayConverter.convertArrayInitializer((ArrayInitializer)expression);
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = this.elementConverter.convert(expression);
        }
        return stringArray;
    }

    public static AnnotationStringArrayExpressionConverter forStrings() {
        return new AnnotationStringArrayExpressionConverter(StringExpressionConverter.instance());
    }

    public static AnnotationStringArrayExpressionConverter forNames() {
        return new AnnotationStringArrayExpressionConverter(NameStringExpressionConverter.instance());
    }
}

