/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.jpa1.context.java;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.JoinColumn;
import org.eclipse.jpt.core.context.java.JavaJoinColumn;
import org.eclipse.jpt.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.core.context.java.JavaReferenceTable;
import org.eclipse.jpt.core.internal.context.MappingTools;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaTable;
import org.eclipse.jpt.core.internal.resource.java.NullJoinColumnAnnotation;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.java.JoinColumnAnnotation;
import org.eclipse.jpt.core.resource.java.ReferenceTableAnnotation;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyListIterator;
import org.eclipse.jpt.utility.internal.iterators.SingleElementListIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenericJavaReferenceTable
extends AbstractJavaTable
implements JavaReferenceTable {
    protected JavaJoinColumn defaultJoinColumn;
    protected final Vector<JavaJoinColumn> specifiedJoinColumns = new Vector();
    protected final JavaJoinColumn.Owner joinColumnOwner = this.buildJoinColumnOwner();

    protected GenericJavaReferenceTable(JavaJpaContextNode parent) {
        super(parent);
    }

    protected abstract JavaJoinColumn.Owner buildJoinColumnOwner();

    public void initialize(ReferenceTableAnnotation referenceTableAnnotation) {
        super.initialize(referenceTableAnnotation);
        this.initializeSpecifiedJoinColumns(referenceTableAnnotation);
        this.initializeDefaultJoinColumn(referenceTableAnnotation);
    }

    public void update(ReferenceTableAnnotation referenceTableAnnotation) {
        super.update(referenceTableAnnotation);
        this.updateSpecifiedJoinColumns(referenceTableAnnotation);
        this.updateDefaultJoinColumn(referenceTableAnnotation);
    }

    @Override
    protected String buildDefaultSchema() {
        return this.getContextDefaultSchema();
    }

    @Override
    protected String buildDefaultCatalog() {
        return this.getContextDefaultCatalog();
    }

    @Override
    protected abstract ReferenceTableAnnotation getAnnotation();

    @Override
    public boolean isResourceSpecified() {
        return this.getAnnotation().isSpecified();
    }

    @Override
    public ListIterator<JavaJoinColumn> joinColumns() {
        return this.hasSpecifiedJoinColumns() ? this.specifiedJoinColumns() : this.defaultJoinColumns();
    }

    @Override
    public int joinColumnsSize() {
        return this.hasSpecifiedJoinColumns() ? this.specifiedJoinColumnsSize() : this.defaultJoinColumnsSize();
    }

    @Override
    public void convertDefaultToSpecifiedJoinColumn() {
        MappingTools.convertReferenceTableDefaultToSpecifiedJoinColumn(this);
    }

    protected JavaJoinColumn buildJoinColumn(JoinColumnAnnotation joinColumnAnnotation) {
        return this.buildJoinColumn(joinColumnAnnotation, this.joinColumnOwner);
    }

    @Override
    public JavaJoinColumn getDefaultJoinColumn() {
        return this.defaultJoinColumn;
    }

    protected void setDefaultJoinColumn(JavaJoinColumn defaultJoinColumn) {
        JavaJoinColumn old = this.defaultJoinColumn;
        this.defaultJoinColumn = defaultJoinColumn;
        this.firePropertyChanged("defaultJoinColumn", old, defaultJoinColumn);
    }

    protected ListIterator<JavaJoinColumn> defaultJoinColumns() {
        if (this.defaultJoinColumn != null) {
            return new SingleElementListIterator((Object)this.defaultJoinColumn);
        }
        return EmptyListIterator.instance();
    }

    protected int defaultJoinColumnsSize() {
        return this.defaultJoinColumn == null ? 0 : 1;
    }

    protected void initializeDefaultJoinColumn(ReferenceTableAnnotation referenceTableAnnotation) {
        if (this.shouldBuildDefaultJoinColumn()) {
            this.defaultJoinColumn = this.buildJoinColumn(new NullJoinColumnAnnotation(referenceTableAnnotation));
        }
    }

    protected void updateDefaultJoinColumn(ReferenceTableAnnotation referenceTableAnnotation) {
        if (this.shouldBuildDefaultJoinColumn()) {
            if (this.defaultJoinColumn == null) {
                this.setDefaultJoinColumn(this.buildJoinColumn(new NullJoinColumnAnnotation(referenceTableAnnotation)));
            } else {
                this.defaultJoinColumn.update(new NullJoinColumnAnnotation(referenceTableAnnotation));
            }
        } else {
            this.setDefaultJoinColumn(null);
        }
    }

    protected boolean shouldBuildDefaultJoinColumn() {
        return !this.hasSpecifiedJoinColumns();
    }

    @Override
    public ListIterator<JavaJoinColumn> specifiedJoinColumns() {
        return new CloneListIterator(this.specifiedJoinColumns);
    }

    @Override
    public int specifiedJoinColumnsSize() {
        return this.specifiedJoinColumns.size();
    }

    @Override
    public boolean hasSpecifiedJoinColumns() {
        return this.specifiedJoinColumns.size() != 0;
    }

    @Override
    public JavaJoinColumn addSpecifiedJoinColumn(int index) {
        JavaJoinColumn oldDefault = this.defaultJoinColumn;
        this.defaultJoinColumn = null;
        JavaJoinColumn joinColumn = this.getJpaFactory().buildJavaJoinColumn(this, this.joinColumnOwner);
        this.specifiedJoinColumns.add(index, joinColumn);
        ReferenceTableAnnotation referenceTableAnnotation = this.getAnnotation();
        JoinColumnAnnotation joinColumnAnnotation = referenceTableAnnotation.addJoinColumn(index);
        joinColumn.initialize(joinColumnAnnotation);
        this.fireItemAdded("specifiedJoinColumns", index, joinColumn);
        this.firePropertyChanged("defaultJoinColumn", oldDefault, null);
        return joinColumn;
    }

    protected void addSpecifiedJoinColumn(int index, JavaJoinColumn joinColumn) {
        this.addItemToList(index, joinColumn, this.specifiedJoinColumns, "specifiedJoinColumns");
    }

    protected void addSpecifiedJoinColumn(JavaJoinColumn joinColumn) {
        this.addSpecifiedJoinColumn(this.specifiedJoinColumns.size(), joinColumn);
    }

    @Override
    public void removeSpecifiedJoinColumn(JoinColumn joinColumn) {
        this.removeSpecifiedJoinColumn(this.specifiedJoinColumns.indexOf(joinColumn));
    }

    @Override
    public void removeSpecifiedJoinColumn(int index) {
        JavaJoinColumn removedJoinColumn = this.specifiedJoinColumns.remove(index);
        if (!this.hasSpecifiedJoinColumns()) {
            this.defaultJoinColumn = this.buildJoinColumn(new NullJoinColumnAnnotation(this.getAnnotation()));
        }
        this.getAnnotation().removeJoinColumn(index);
        this.fireItemRemoved("specifiedJoinColumns", index, removedJoinColumn);
        if (this.defaultJoinColumn != null) {
            this.firePropertyChanged("defaultJoinColumn", null, this.defaultJoinColumn);
        }
    }

    protected void removeSpecifiedJoinColumn_(JavaJoinColumn joinColumn) {
        this.removeItemFromList(joinColumn, this.specifiedJoinColumns, "specifiedJoinColumns");
    }

    @Override
    public void moveSpecifiedJoinColumn(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.specifiedJoinColumns, (int)targetIndex, (int)sourceIndex);
        this.getAnnotation().moveJoinColumn(targetIndex, sourceIndex);
        this.fireItemMoved("specifiedJoinColumns", targetIndex, sourceIndex);
    }

    @Override
    public void clearSpecifiedJoinColumns() {
        int i = this.specifiedJoinColumns.size();
        while (i-- > 0) {
            this.removeSpecifiedJoinColumn(i);
        }
    }

    protected void initializeSpecifiedJoinColumns(ReferenceTableAnnotation referenceTableAnnotation) {
        ListIterator<JoinColumnAnnotation> stream = referenceTableAnnotation.joinColumns();
        while (stream.hasNext()) {
            this.specifiedJoinColumns.add(this.buildJoinColumn(stream.next()));
        }
    }

    protected void updateSpecifiedJoinColumns(ReferenceTableAnnotation referenceTableAnnotation) {
        ListIterator<JavaJoinColumn> joinColumns = this.specifiedJoinColumns();
        ListIterator<JoinColumnAnnotation> joinColumnAnnotations = referenceTableAnnotation.joinColumns();
        while (joinColumns.hasNext()) {
            JavaJoinColumn joinColumn = joinColumns.next();
            if (joinColumnAnnotations.hasNext()) {
                joinColumn.update(joinColumnAnnotations.next());
                continue;
            }
            this.removeSpecifiedJoinColumn_(joinColumn);
        }
        while (joinColumnAnnotations.hasNext()) {
            this.addSpecifiedJoinColumn(this.buildJoinColumn(joinColumnAnnotations.next()));
        }
    }

    @Override
    public Iterator<String> javaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator result = super.javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        for (JavaJoinColumn column : CollectionTools.iterable(this.joinColumns())) {
            result = column.javaCompletionProposals(pos, filter, astRoot);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    protected JavaJoinColumn buildJoinColumn(JoinColumnAnnotation joinColumnAnnotation, JavaJoinColumn.Owner owner) {
        JavaJoinColumn joinColumn = this.getJpaFactory().buildJavaJoinColumn(this, owner);
        joinColumn.initialize(joinColumnAnnotation);
        return joinColumn;
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        boolean continueValidating = true;
        if (this.shouldValidateAgainstDatabase()) {
            continueValidating = this.validateAgainstDatabase(messages, reporter, astRoot);
        }
        if (continueValidating) {
            this.validateJoinColumns(messages, reporter, astRoot);
        }
    }

    protected abstract boolean shouldValidateAgainstDatabase();

    protected boolean validateAgainstDatabase(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        if (!this.hasResolvedCatalog()) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, this.getUnresolvedCatalogMessageId(), new String[]{this.getCatalog(), this.getName()}, this, this.getCatalogTextRange(astRoot)));
            return false;
        }
        if (!this.hasResolvedSchema()) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, this.getUnresolvedSchemaMessageId(), new String[]{this.getSchema(), this.getName()}, this, this.getSchemaTextRange(astRoot)));
            return false;
        }
        if (!this.isResolved()) {
            if (this.getName() != null) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, this.getUnresolvedNameMessageId(), new String[]{this.getName()}, this, this.getNameTextRange(astRoot)));
            }
            return false;
        }
        return true;
    }

    protected void validateJoinColumns(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        this.validateJoinColumns(this.joinColumns(), messages, reporter, astRoot);
    }

    protected void validateJoinColumns(Iterator<JavaJoinColumn> joinColumns, List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        while (joinColumns.hasNext()) {
            joinColumns.next().validate(messages, reporter, astRoot);
        }
    }

    protected abstract String getUnresolvedCatalogMessageId();

    protected abstract String getUnresolvedSchemaMessageId();

    protected abstract String getUnresolvedNameMessageId();
}

