/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal;

import java.util.ListIterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jpt.core.EntityGeneratorDatabaseAnnotationNameBuilder;
import org.eclipse.jpt.core.JpaAnnotationProvider;
import org.eclipse.jpt.core.JpaFactory;
import org.eclipse.jpt.core.JpaFile;
import org.eclipse.jpt.core.JpaPlatform;
import org.eclipse.jpt.core.JpaPlatformProvider;
import org.eclipse.jpt.core.JpaPlatformVariation;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.JpaResourceModel;
import org.eclipse.jpt.core.JpaResourceModelProvider;
import org.eclipse.jpt.core.JpaResourceType;
import org.eclipse.jpt.core.ResourceDefinition;
import org.eclipse.jpt.core.context.java.JavaAttributeMappingDefinition;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.context.java.JavaPersistentType;
import org.eclipse.jpt.core.context.java.JavaTypeMappingDefinition;
import org.eclipse.jpt.core.internal.GenericEntityGeneratorDatabaseAnnotationNameBuilder;
import org.eclipse.jpt.core.internal.utility.PlatformTools;
import org.eclipse.jpt.core.internal.utility.jdt.DefaultAnnotationEditFormatter;
import org.eclipse.jpt.core.utility.jdt.AnnotationEditFormatter;
import org.eclipse.jpt.db.ConnectionProfileFactory;
import org.eclipse.jpt.db.JptDbPlugin;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.Tools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJpaPlatform
implements JpaPlatform {
    private final String id;
    private final JpaPlatform.Version jpaVersion;
    private final JpaFactory jpaFactory;
    private final JpaAnnotationProvider annotationProvider;
    private final JpaPlatformProvider platformProvider;
    private final JpaPlatformVariation jpaVariation;

    public GenericJpaPlatform(String id, JpaPlatform.Version jpaVersion, JpaFactory jpaFactory, JpaAnnotationProvider jpaAnnotationProvider, JpaPlatformProvider platformProvider, JpaPlatformVariation jpaVariation) {
        this.id = id;
        this.jpaVersion = jpaVersion;
        this.jpaFactory = jpaFactory;
        this.annotationProvider = jpaAnnotationProvider;
        this.jpaVariation = jpaVariation;
        this.platformProvider = platformProvider;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public JpaPlatform.Version getJpaVersion() {
        return this.jpaVersion;
    }

    @Override
    public JpaFactory getJpaFactory() {
        return this.jpaFactory;
    }

    protected JpaPlatformProvider getPlatformProvider() {
        return this.platformProvider;
    }

    @Override
    public JpaFile buildJpaFile(JpaProject jpaProject, IFile file) {
        IContentType contentType = PlatformTools.getContentType(file);
        return contentType == null ? null : this.buildJpaFile(jpaProject, file, contentType);
    }

    protected JpaFile buildJpaFile(JpaProject jpaProject, IFile file, IContentType contentType) {
        JpaResourceModel resourceModel = this.buildResourceModel(jpaProject, file, contentType);
        return resourceModel == null ? null : this.jpaFactory.buildJpaFile(jpaProject, file, contentType, resourceModel);
    }

    protected JpaResourceModel buildResourceModel(JpaProject jpaProject, IFile file, IContentType contentType) {
        JpaResourceModelProvider provider = this.getResourceModelProvider(contentType);
        return provider == null ? null : provider.buildResourceModel(jpaProject, file);
    }

    protected JpaResourceModelProvider getResourceModelProvider(IContentType contentType) {
        for (JpaResourceModelProvider provider : CollectionTools.iterable(this.resourceModelProviders())) {
            if (!contentType.equals(provider.getContentType())) continue;
            return provider;
        }
        return null;
    }

    protected ListIterator<JpaResourceModelProvider> resourceModelProviders() {
        return this.platformProvider.resourceModelProviders();
    }

    @Override
    public JpaAnnotationProvider getAnnotationProvider() {
        return this.annotationProvider;
    }

    @Override
    public AnnotationEditFormatter getAnnotationEditFormatter() {
        return DefaultAnnotationEditFormatter.instance();
    }

    @Override
    public JavaTypeMappingDefinition getJavaTypeMappingDefinition(JavaPersistentType type) {
        for (JavaTypeMappingDefinition definition : CollectionTools.iterable(this.javaTypeMappingDefinitions())) {
            if (!definition.test(type)) continue;
            return definition;
        }
        throw new IllegalStateException("There must be a mapping definition for all types");
    }

    @Override
    public JavaTypeMappingDefinition getJavaTypeMappingDefinition(String mappingKey) {
        for (JavaTypeMappingDefinition definition : CollectionTools.iterable(this.javaTypeMappingDefinitions())) {
            if (!Tools.valuesAreEqual((Object)definition.getKey(), (Object)mappingKey)) continue;
            return definition;
        }
        throw new IllegalArgumentException("Illegal type mapping key: " + mappingKey);
    }

    protected ListIterator<JavaTypeMappingDefinition> javaTypeMappingDefinitions() {
        return this.platformProvider.javaTypeMappingDefinitions();
    }

    @Override
    public JavaAttributeMappingDefinition getDefaultJavaAttributeMappingDefinition(JavaPersistentAttribute attribute) {
        for (JavaAttributeMappingDefinition definition : CollectionTools.iterable(this.defaultJavaAttributeMappingDefinitions())) {
            if (!definition.testDefault(attribute)) continue;
            return definition;
        }
        throw new IllegalStateException("There must be a mapping definition for all attributes");
    }

    protected ListIterator<JavaAttributeMappingDefinition> defaultJavaAttributeMappingDefinitions() {
        return this.platformProvider.defaultJavaAttributeMappingDefinitions();
    }

    @Override
    public JavaAttributeMappingDefinition getSpecifiedJavaAttributeMappingDefinition(JavaPersistentAttribute attribute) {
        for (JavaAttributeMappingDefinition definition : CollectionTools.iterable(this.specifiedJavaAttributeMappingDefinitions())) {
            if (!definition.testSpecified(attribute)) continue;
            return definition;
        }
        throw new IllegalStateException("There must be a mapping definition for all attributes");
    }

    protected ListIterator<JavaAttributeMappingDefinition> specifiedJavaAttributeMappingDefinitions() {
        return this.platformProvider.specifiedJavaAttributeMappingDefinitions();
    }

    @Override
    public JavaAttributeMappingDefinition getSpecifiedJavaAttributeMappingDefinition(String mappingKey) {
        for (JavaAttributeMappingDefinition definition : CollectionTools.iterable(this.specifiedJavaAttributeMappingDefinitions())) {
            if (!Tools.valuesAreEqual((Object)definition.getKey(), (Object)mappingKey)) continue;
            return definition;
        }
        throw new IllegalArgumentException("Illegal attribute mapping key: " + mappingKey);
    }

    @Override
    public boolean supportsResourceType(JpaResourceType resourceType) {
        for (ResourceDefinition resourceDefinition : CollectionTools.iterable(this.resourceDefinitions())) {
            if (!resourceDefinition.getResourceType().equals(resourceType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ResourceDefinition getResourceDefinition(JpaResourceType resourceType) {
        for (ResourceDefinition resourceDefinition : CollectionTools.iterable(this.resourceDefinitions())) {
            if (!resourceDefinition.getResourceType().equals(resourceType)) continue;
            return resourceDefinition;
        }
        throw new IllegalArgumentException("Illegal resource type: " + resourceType);
    }

    protected ListIterator<ResourceDefinition> resourceDefinitions() {
        return this.platformProvider.resourceDefinitions();
    }

    @Override
    public JpaResourceType getMostRecentSupportedResourceType(IContentType contentType) {
        return this.platformProvider.getMostRecentSupportedResourceType(contentType);
    }

    @Override
    public ConnectionProfileFactory getConnectionProfileFactory() {
        return JptDbPlugin.instance().getConnectionProfileFactory();
    }

    @Override
    public EntityGeneratorDatabaseAnnotationNameBuilder getEntityGeneratorDatabaseAnnotationNameBuilder() {
        return GenericEntityGeneratorDatabaseAnnotationNameBuilder.instance();
    }

    @Override
    public JpaPlatformVariation getJpaVariation() {
        return this.jpaVariation;
    }
}

