/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.java;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.JoinColumn;
import org.eclipse.jpt.core.context.JoinColumnEnabledRelationshipReference;
import org.eclipse.jpt.core.context.JoinColumnJoiningStrategy;
import org.eclipse.jpt.core.context.RelationshipMapping;
import org.eclipse.jpt.core.context.TypeMapping;
import org.eclipse.jpt.core.context.java.JavaJoinColumn;
import org.eclipse.jpt.core.context.java.JavaJoinColumnJoiningStrategy;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.core.resource.java.JoinColumnAnnotation;
import org.eclipse.jpt.db.Table;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyListIterator;
import org.eclipse.jpt.utility.internal.iterators.SingleElementListIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaJoinColumnJoiningStrategy
extends AbstractJavaJpaContextNode
implements JavaJoinColumnJoiningStrategy {
    protected JavaJoinColumn defaultJoinColumn;
    protected final Vector<JavaJoinColumn> specifiedJoinColumns = new Vector();
    protected final JavaJoinColumn.Owner joinColumnOwner = this.buildJoinColumnOwner();

    protected AbstractJavaJoinColumnJoiningStrategy(JoinColumnEnabledRelationshipReference parent) {
        super(parent);
    }

    protected abstract JavaJoinColumn.Owner buildJoinColumnOwner();

    @Override
    public void initializeFrom(JoinColumnJoiningStrategy oldStrategy) {
        for (JoinColumn joinColumn : CollectionTools.iterable(oldStrategy.joinColumns())) {
            JavaJoinColumn newJoinColumn = this.addSpecifiedJoinColumn(this.specifiedJoinColumnsSize());
            newJoinColumn.setSpecifiedName(joinColumn.getName());
            newJoinColumn.setSpecifiedReferencedColumnName(joinColumn.getReferencedColumnName());
        }
    }

    @Override
    public JoinColumnEnabledRelationshipReference getParent() {
        return (JoinColumnEnabledRelationshipReference)super.getParent();
    }

    @Override
    public JoinColumnEnabledRelationshipReference getRelationshipReference() {
        return this.getParent();
    }

    public RelationshipMapping getRelationshipMapping() {
        return this.getRelationshipReference().getRelationshipMapping();
    }

    @Override
    public String getTableName() {
        TypeMapping typeMapping = this.getRelationshipSource();
        return typeMapping == null ? null : typeMapping.getPrimaryTableName();
    }

    @Override
    public Table getDbTable(String tableName) {
        TypeMapping typeMapping = this.getRelationshipSource();
        return typeMapping == null ? null : typeMapping.getDbTable(tableName);
    }

    @Override
    public boolean tableNameIsInvalid(String tableName) {
        TypeMapping typeMapping = this.getRelationshipSource();
        return typeMapping == null ? false : typeMapping.tableNameIsInvalid(tableName);
    }

    protected Iterator<String> candidateTableNames() {
        TypeMapping typeMapping = this.getRelationshipSource();
        return typeMapping == null ? EmptyIterator.instance() : typeMapping.associatedTableNamesIncludingInherited();
    }

    @Override
    public void addStrategy() {
        if (this.specifiedJoinColumnsSize() == 0) {
            this.addSpecifiedJoinColumn(0);
        }
    }

    @Override
    public void removeStrategy() {
        for (JoinColumn each : CollectionTools.iterable(this.specifiedJoinColumns())) {
            this.removeSpecifiedJoinColumn(each);
        }
    }

    public Table getReferencedColumnDbTable() {
        TypeMapping relationshipTarget = this.getRelationshipTarget();
        return relationshipTarget == null ? null : relationshipTarget.getPrimaryDbTable();
    }

    @Override
    public ListIterator<JavaJoinColumn> joinColumns() {
        return this.hasSpecifiedJoinColumns() ? this.specifiedJoinColumns() : this.defaultJoinColumns();
    }

    @Override
    public int joinColumnsSize() {
        return this.hasSpecifiedJoinColumns() ? this.specifiedJoinColumnsSize() : this.defaultJoinColumnsSize();
    }

    @Override
    public JavaJoinColumn getDefaultJoinColumn() {
        return this.defaultJoinColumn;
    }

    protected void setDefaultJoinColumn(JavaJoinColumn column) {
        JavaJoinColumn old = this.defaultJoinColumn;
        this.defaultJoinColumn = column;
        this.firePropertyChanged("defaultJoinColumn", old, column);
    }

    protected ListIterator<JavaJoinColumn> defaultJoinColumns() {
        if (this.defaultJoinColumn != null) {
            return new SingleElementListIterator((Object)this.defaultJoinColumn);
        }
        return EmptyListIterator.instance();
    }

    protected int defaultJoinColumnsSize() {
        return this.defaultJoinColumn == null ? 0 : 1;
    }

    @Override
    public ListIterator<JavaJoinColumn> specifiedJoinColumns() {
        return new CloneListIterator(this.specifiedJoinColumns);
    }

    @Override
    public int specifiedJoinColumnsSize() {
        return this.specifiedJoinColumns.size();
    }

    @Override
    public boolean hasSpecifiedJoinColumns() {
        return !this.specifiedJoinColumns.isEmpty();
    }

    @Override
    public JavaJoinColumn addSpecifiedJoinColumn(int index) {
        JavaJoinColumn oldDefault = this.defaultJoinColumn;
        this.defaultJoinColumn = null;
        JavaJoinColumn joinColumn = this.getJpaFactory().buildJavaJoinColumn(this, this.joinColumnOwner);
        this.specifiedJoinColumns.add(index, joinColumn);
        JoinColumnAnnotation joinColumnAnnotation = this.addAnnotation(index);
        joinColumn.initialize(joinColumnAnnotation);
        this.fireItemAdded("specifiedJoinColumns", index, joinColumn);
        this.firePropertyChanged("defaultJoinColumn", oldDefault, null);
        return joinColumn;
    }

    protected void addSpecifiedJoinColumn(int index, JavaJoinColumn joinColumn) {
        this.addItemToList(index, joinColumn, this.specifiedJoinColumns, "specifiedJoinColumns");
    }

    protected void addSpecifiedJoinColumn(JavaJoinColumn joinColumn) {
        this.addSpecifiedJoinColumn(this.specifiedJoinColumns.size(), joinColumn);
    }

    @Override
    public void removeSpecifiedJoinColumn(JoinColumn joinColumn) {
        this.removeSpecifiedJoinColumn(this.specifiedJoinColumns.indexOf(joinColumn));
    }

    @Override
    public void removeSpecifiedJoinColumn(int index) {
        JavaJoinColumn removedJoinColumn = this.specifiedJoinColumns.remove(index);
        if (this.specifiedJoinColumns.isEmpty()) {
            this.defaultJoinColumn = this.buildJoinColumn(this.buildNullJoinColumnAnnotation());
        }
        this.removeAnnotation(index);
        this.fireItemRemoved("specifiedJoinColumns", index, removedJoinColumn);
        if (this.defaultJoinColumn != null) {
            this.firePropertyChanged("defaultJoinColumn", null, this.defaultJoinColumn);
        }
    }

    protected void removeSpecifiedJoinColumn_(JavaJoinColumn joinColumn) {
        this.removeItemFromList(joinColumn, this.specifiedJoinColumns, "specifiedJoinColumns");
    }

    @Override
    public void moveSpecifiedJoinColumn(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.specifiedJoinColumns, (int)targetIndex, (int)sourceIndex);
        this.moveAnnotation(targetIndex, sourceIndex);
        this.fireItemMoved("specifiedJoinColumns", targetIndex, sourceIndex);
    }

    protected abstract JoinColumnAnnotation addAnnotation(int var1);

    protected abstract void removeAnnotation(int var1);

    protected abstract void moveAnnotation(int var1, int var2);

    protected abstract Iterator<JoinColumnAnnotation> joinColumnAnnotations();

    protected abstract JoinColumnAnnotation buildNullJoinColumnAnnotation();

    @Override
    public void initialize() {
        this.initializeSpecifiedJoinColumns();
        this.initializeDefaultJoinColumn();
    }

    protected void initializeSpecifiedJoinColumns() {
        Iterator<JoinColumnAnnotation> annotations = this.joinColumnAnnotations();
        while (annotations.hasNext()) {
            this.specifiedJoinColumns.add(this.buildJoinColumn(annotations.next()));
        }
    }

    public void initializeDefaultJoinColumn() {
        if (this.mayHaveDefaultJoinColumn()) {
            this.defaultJoinColumn = this.buildJoinColumn(this.buildNullJoinColumnAnnotation());
        }
    }

    @Override
    public void update() {
        this.updateSpecifiedJoinColumns();
        this.updateDefaultJoinColumn();
    }

    protected void updateSpecifiedJoinColumns() {
        ListIterator<JavaJoinColumn> joinColumns = this.specifiedJoinColumns();
        Iterator<JoinColumnAnnotation> resourceJoinColumns = this.joinColumnAnnotations();
        while (joinColumns.hasNext()) {
            JavaJoinColumn joinColumn = joinColumns.next();
            if (resourceJoinColumns.hasNext()) {
                joinColumn.update(resourceJoinColumns.next());
                continue;
            }
            this.removeSpecifiedJoinColumn_(joinColumn);
        }
        while (resourceJoinColumns.hasNext()) {
            this.addSpecifiedJoinColumn(this.buildJoinColumn(resourceJoinColumns.next()));
        }
    }

    protected void updateDefaultJoinColumn() {
        if (this.mayHaveDefaultJoinColumn()) {
            JoinColumnAnnotation nullAnnotation = this.buildNullJoinColumnAnnotation();
            if (this.defaultJoinColumn == null) {
                this.setDefaultJoinColumn(this.buildJoinColumn(nullAnnotation));
            }
            this.defaultJoinColumn.update(nullAnnotation);
        } else if (this.defaultJoinColumn != null) {
            this.setDefaultJoinColumn(null);
        }
    }

    protected boolean mayHaveDefaultJoinColumn() {
        return this.getRelationshipReference().mayHaveDefaultJoinColumn() && !this.hasSpecifiedJoinColumns();
    }

    protected JavaJoinColumn buildJoinColumn(JoinColumnAnnotation joinColumnResource) {
        JavaJoinColumn joinColumn = this.getJpaFactory().buildJavaJoinColumn(this, this.joinColumnOwner);
        joinColumn.initialize(joinColumnResource);
        return joinColumn;
    }

    @Override
    public Iterator<String> javaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator result = super.javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        for (JavaJoinColumn column : CollectionTools.iterable(this.joinColumns())) {
            result = column.javaCompletionProposals(pos, filter, astRoot);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        ListIterator<JavaJoinColumn> stream = this.joinColumns();
        while (stream.hasNext()) {
            ((JavaJoinColumn)stream.next()).validate(messages, reporter, astRoot);
        }
    }
}

