/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jpt.core.context.BaseColumn;
import org.eclipse.jpt.core.context.BasicMapping;
import org.eclipse.jpt.core.context.FetchType;
import org.eclipse.jpt.core.context.NamedColumn;
import org.eclipse.jpt.core.context.orm.OrmAttributeMapping;
import org.eclipse.jpt.core.context.orm.OrmBasicMapping;
import org.eclipse.jpt.core.context.orm.OrmColumn;
import org.eclipse.jpt.core.context.orm.OrmColumnMapping;
import org.eclipse.jpt.core.context.orm.OrmConverter;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmAttributeMapping;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.internal.validation.JpaValidationDescriptionMessages;
import org.eclipse.jpt.core.resource.orm.Attributes;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlBasic;
import org.eclipse.jpt.core.resource.orm.XmlColumn;
import org.eclipse.jpt.core.resource.orm.XmlConvertibleMapping;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.db.Table;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmBasicMapping<T extends XmlBasic>
extends AbstractOrmAttributeMapping<T>
implements OrmBasicMapping {
    protected final OrmColumn column = this.getXmlContextNodeFactory().buildOrmColumn(this, this);
    protected FetchType specifiedFetch;
    protected Boolean specifiedOptional;
    protected OrmConverter converter;
    protected final OrmConverter nullConverter;

    protected AbstractOrmBasicMapping(OrmPersistentAttribute parent, T resourceMapping) {
        super(parent, resourceMapping);
        this.column.initialize(this.getResourceColumn());
        this.specifiedFetch = this.getResourceFetch();
        this.specifiedOptional = this.getResourceOptional();
        this.nullConverter = this.getXmlContextNodeFactory().buildOrmNullConverter(this);
        this.converter = this.buildConverter(this.getResourceConverterType());
    }

    @Override
    public FetchType getFetch() {
        return this.getSpecifiedFetch() == null ? this.getDefaultFetch() : this.getSpecifiedFetch();
    }

    @Override
    public FetchType getDefaultFetch() {
        return BasicMapping.DEFAULT_FETCH_TYPE;
    }

    @Override
    public FetchType getSpecifiedFetch() {
        return this.specifiedFetch;
    }

    @Override
    public void setSpecifiedFetch(FetchType newSpecifiedFetch) {
        FetchType oldFetch = this.specifiedFetch;
        this.specifiedFetch = newSpecifiedFetch;
        ((XmlBasic)this.resourceAttributeMapping).setFetch(FetchType.toOrmResourceModel(newSpecifiedFetch));
        this.firePropertyChanged("specifiedFetch", (Object)oldFetch, (Object)newSpecifiedFetch);
    }

    protected void setSpecifiedFetch_(FetchType newSpecifiedFetch) {
        FetchType oldFetch = this.specifiedFetch;
        this.specifiedFetch = newSpecifiedFetch;
        this.firePropertyChanged("specifiedFetch", (Object)oldFetch, (Object)newSpecifiedFetch);
    }

    @Override
    public boolean isOptional() {
        return this.getSpecifiedOptional() == null ? this.isDefaultOptional() : this.getSpecifiedOptional().booleanValue();
    }

    @Override
    public boolean isDefaultOptional() {
        return true;
    }

    @Override
    public Boolean getSpecifiedOptional() {
        return this.specifiedOptional;
    }

    @Override
    public void setSpecifiedOptional(Boolean newSpecifiedOptional) {
        Boolean oldOptional = this.specifiedOptional;
        this.specifiedOptional = newSpecifiedOptional;
        ((XmlBasic)this.resourceAttributeMapping).setOptional(newSpecifiedOptional);
        this.firePropertyChanged("specifiedOptional", oldOptional, newSpecifiedOptional);
    }

    protected void setSpecifiedOptional_(Boolean newSpecifiedOptional) {
        Boolean oldOptional = this.specifiedOptional;
        this.specifiedOptional = newSpecifiedOptional;
        this.firePropertyChanged("specifiedOptional", oldOptional, newSpecifiedOptional);
    }

    @Override
    public OrmConverter getConverter() {
        return this.converter;
    }

    protected String getConverterType() {
        return this.converter.getType();
    }

    @Override
    public void setConverter(String converterType) {
        if (this.valuesAreEqual(this.getConverterType(), converterType)) {
            return;
        }
        OrmConverter oldConverter = this.converter;
        OrmConverter newConverter = this.buildConverter(converterType);
        this.converter = this.nullConverter;
        if (oldConverter != null) {
            oldConverter.removeFromResourceModel();
        }
        this.converter = newConverter;
        if (newConverter != null) {
            newConverter.addToResourceModel();
        }
        this.firePropertyChanged("converter", oldConverter, newConverter);
    }

    protected void setConverter(OrmConverter newConverter) {
        OrmConverter oldConverter = this.converter;
        this.converter = newConverter;
        this.firePropertyChanged("converter", oldConverter, newConverter);
    }

    @Override
    public String getKey() {
        return "basic";
    }

    @Override
    public void initializeOn(OrmAttributeMapping newMapping) {
        newMapping.initializeFromOrmBasicMapping(this);
    }

    @Override
    public void initializeFromOrmColumnMapping(OrmColumnMapping oldMapping) {
        super.initializeFromOrmColumnMapping(oldMapping);
        this.getColumn().initializeFrom(oldMapping.getColumn());
    }

    @Override
    public int getXmlSequence() {
        return 20;
    }

    @Override
    public boolean isOverridableAttributeMapping() {
        return true;
    }

    @Override
    public OrmColumn getColumn() {
        return this.column;
    }

    @Override
    public String getDefaultColumnName() {
        return this.getName();
    }

    @Override
    public String getDefaultTableName() {
        return this.getTypeMapping().getPrimaryTableName();
    }

    @Override
    public Table getDbTable(String tableName) {
        return this.getTypeMapping().getDbTable(tableName);
    }

    @Override
    public boolean tableNameIsInvalid(String tableName) {
        return this.getTypeMapping().tableNameIsInvalid(tableName);
    }

    @Override
    public Iterator<String> candidateTableNames() {
        return this.getTypeMapping().associatedTableNamesIncludingInherited();
    }

    @Override
    public void update() {
        super.update();
        this.setSpecifiedFetch_(this.getResourceFetch());
        this.setSpecifiedOptional_(this.getResourceOptional());
        this.column.update(this.getResourceColumn());
        if (this.valuesAreEqual(this.getResourceConverterType(), this.getConverterType())) {
            this.getConverter().update();
        } else {
            this.setConverter(this.buildConverter(this.getResourceConverterType()));
        }
    }

    protected Boolean getResourceOptional() {
        return ((XmlBasic)this.resourceAttributeMapping).getOptional();
    }

    protected FetchType getResourceFetch() {
        return FetchType.fromOrmResourceModel(((XmlBasic)this.resourceAttributeMapping).getFetch());
    }

    protected OrmConverter buildConverter(String converterType) {
        if (this.valuesAreEqual(converterType, "noConverter")) {
            return this.nullConverter;
        }
        if (this.valuesAreEqual(converterType, "enumeratedConverter")) {
            return this.getXmlContextNodeFactory().buildOrmEnumeratedConverter(this, (XmlConvertibleMapping)((Object)this.resourceAttributeMapping));
        }
        if (this.valuesAreEqual(converterType, "temporalConverter")) {
            return this.getXmlContextNodeFactory().buildOrmTemporalConverter(this, (XmlConvertibleMapping)((Object)this.resourceAttributeMapping));
        }
        if (this.valuesAreEqual(converterType, "lobConverter")) {
            return this.getXmlContextNodeFactory().buildOrmLobConverter(this, (XmlConvertibleMapping)((Object)this.resourceAttributeMapping));
        }
        return null;
    }

    protected String getResourceConverterType() {
        if (((XmlBasic)this.resourceAttributeMapping).getEnumerated() != null) {
            return "enumeratedConverter";
        }
        if (((XmlBasic)this.resourceAttributeMapping).getTemporal() != null) {
            return "temporalConverter";
        }
        if (((XmlBasic)this.resourceAttributeMapping).isLob()) {
            return "lobConverter";
        }
        return "noConverter";
    }

    @Override
    public void addToResourceModel(Attributes resourceAttributes) {
        resourceAttributes.getBasics().add((Object)((XmlBasic)this.resourceAttributeMapping));
    }

    @Override
    public void removeFromResourceModel(Attributes resourceAttributes) {
        resourceAttributes.getBasics().remove((Object)this.resourceAttributeMapping);
    }

    @Override
    public XmlColumn getResourceColumn() {
        return ((XmlBasic)this.resourceAttributeMapping).getColumn();
    }

    @Override
    public void addResourceColumn() {
        ((XmlBasic)this.resourceAttributeMapping).setColumn(OrmFactory.eINSTANCE.createXmlColumn());
    }

    @Override
    public void removeResourceColumn() {
        ((XmlBasic)this.resourceAttributeMapping).setColumn(null);
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.getColumn().validate(messages, reporter);
    }

    @Override
    public IMessage buildUnresolvedNameMessage(NamedColumn column, TextRange textRange) {
        if (this.isVirtual()) {
            return this.buildVirtualUnresolvedNameMessage(column, textRange);
        }
        return DefaultJpaValidationMessages.buildMessage(1, "COLUMN_UNRESOLVED_NAME", new String[]{column.getName(), column.getDbTable().getName()}, column, textRange);
    }

    protected IMessage buildVirtualUnresolvedNameMessage(NamedColumn column, TextRange textRange) {
        return DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_COLUMN_UNRESOLVED_NAME", new String[]{this.getName(), column.getName(), column.getDbTable().getName()}, column, textRange);
    }

    @Override
    public IMessage buildTableNotValidMessage(BaseColumn column, TextRange textRange) {
        if (this.isVirtual()) {
            return this.buildVirtualTableNotValidMessage(column, textRange);
        }
        return DefaultJpaValidationMessages.buildMessage(1, "COLUMN_TABLE_NOT_VALID", new String[]{column.getTable(), column.getName(), JpaValidationDescriptionMessages.NOT_VALID_FOR_THIS_ENTITY}, column, textRange);
    }

    public IMessage buildVirtualTableNotValidMessage(BaseColumn column, TextRange textRange) {
        return DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_COLUMN_TABLE_NOT_VALID", new String[]{this.getName(), column.getTable(), column.getName(), JpaValidationDescriptionMessages.NOT_VALID_FOR_THIS_ENTITY}, column, textRange);
    }
}

