/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.ui.internal.contentassist;

import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.html.core.internal.HTMLCorePlugin;
import org.eclipse.wst.html.core.internal.contentmodel.HTMLElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.ui.internal.contentassist.XMLContentModelGenerator;
import org.w3c.dom.Node;

public class HTMLMinimalContentModelGenerator
extends XMLContentModelGenerator {
    private static HTMLMinimalContentModelGenerator instance = null;
    protected int fTagCase;
    protected int fAttrCase;

    private HTMLMinimalContentModelGenerator() {
    }

    private void init() {
        String qualifier = HTMLCorePlugin.getDefault().getBundle().getSymbolicName();
        this.fTagCase = Platform.getPreferencesService().getInt(qualifier, "tagNameCase", 0, null);
        this.fAttrCase = Platform.getPreferencesService().getInt(qualifier, "attrNameCase", 0, null);
    }

    protected void generateEndTag(String tagName, Node parentNode, CMElementDeclaration elementDecl, StringBuffer buffer) {
        String ommission;
        if (elementDecl == null) {
            return;
        }
        if (elementDecl instanceof HTMLElementDeclaration && ((Boolean)elementDecl.getProperty("isJSP") != false ? elementDecl.getContentType() == 1 : (ommission = (String)elementDecl.getProperty("omitType")).equals("omitEnd") || ommission.equals("omitEndDefault") || ommission.equals("omitEndMust"))) {
            return;
        }
        if (elementDecl.getContentType() == 1) {
            return;
        }
        buffer.append("</" + tagName + ">");
    }

    private boolean shouldIgnoreCase(CMNode cmnode) {
        if (!cmnode.supports("shouldIgnoreCase")) {
            return false;
        }
        return (Boolean)cmnode.getProperty("shouldIgnoreCase");
    }

    public String getRequiredName(Node ownerNode, CMNode cmnode) {
        String name = super.getRequiredName(ownerNode, cmnode);
        if (this.shouldIgnoreCase(cmnode)) {
            int caseVal = -1;
            if (cmnode.getNodeType() == 5) {
                caseVal = this.fTagCase;
            } else if (cmnode.getNodeType() == 2) {
                caseVal = this.fAttrCase;
            }
            switch (caseVal) {
                case 1: {
                    name = name.toLowerCase();
                    break;
                }
                case 2: {
                    name = name.toUpperCase();
                }
            }
        }
        return name;
    }

    public String getStartTagClose(Node parentNode, CMElementDeclaration elementDecl) {
        String other = this.getOtherClose(parentNode);
        if (other != null) {
            return other;
        }
        if (elementDecl == null) {
            return ">";
        }
        if (elementDecl instanceof HTMLElementDeclaration) {
            if (((Boolean)elementDecl.getProperty("isJSP")).booleanValue()) {
                if (elementDecl.getContentType() == 1) {
                    return "/>";
                }
            } else {
                String ommission = (String)elementDecl.getProperty("omitType");
                if (ommission.equals("omitEnd") || ommission.equals("omitEndDefault") || ommission.equals("omitEndMust")) {
                    return ">";
                }
            }
        } else if (elementDecl.getContentType() == 1) {
            return "/>";
        }
        return ">";
    }

    public static synchronized HTMLMinimalContentModelGenerator getInstance() {
        if (instance == null) {
            instance = new HTMLMinimalContentModelGenerator();
        }
        instance.init();
        return instance;
    }
}

