/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.internal;

import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.internal.IPublishTask;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.core.internal.Trace;
import org.eclipse.wst.server.core.model.PublishOperation;
import org.eclipse.wst.server.core.model.PublishTaskDelegate;

public class PublishTask
implements IPublishTask {
    private IConfigurationElement element;
    private PublishTaskDelegate delegate;

    public PublishTask(IConfigurationElement element) {
        this.element = element;
    }

    public String getId() {
        return this.element.getAttribute("id");
    }

    protected String[] getTypeIds() {
        try {
            return ServerPlugin.tokenize(this.element.getAttribute("typeIds"), ",");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean supportsType(String id) {
        return ServerPlugin.contains(this.getTypeIds(), id);
    }

    public PublishTaskDelegate getDelegate() {
        block4: {
            if (this.delegate == null) {
                try {
                    long time = System.currentTimeMillis();
                    this.delegate = (PublishTaskDelegate)this.element.createExecutableExtension("class");
                    if (Trace.PERFORMANCE) {
                        Trace.trace("/performance", "PublishTask.getDelegate(): <" + (System.currentTimeMillis() - time) + "> " + this.getId());
                    }
                }
                catch (Throwable t) {
                    if (!Trace.SEVERE) break block4;
                    Trace.trace("/severe", "Could not create delegate" + this.toString(), t);
                }
            }
        }
        return this.delegate;
    }

    public PublishOperation[] getTasks(IServer server, List modules) {
        block4: {
            try {
                PublishOperation[] po;
                if (Trace.FINEST) {
                    Trace.trace("/finest", "Task.init " + this);
                }
                if ((po = this.getDelegate().getTasks(server, modules)) != null) {
                    return po;
                }
            }
            catch (Exception e) {
                if (!Trace.SEVERE) break block4;
                Trace.trace("/severe", "Error calling delegate " + this.toString(), e);
            }
        }
        return new PublishOperation[0];
    }

    public PublishOperation[] getTasks(IServer server, int kind, List modules, List kindList) {
        block4: {
            try {
                PublishOperation[] po;
                if (Trace.FINEST) {
                    Trace.trace("/finest", "Task.init " + this);
                }
                if ((po = this.getDelegate().getTasks(server, kind, modules, kindList)) != null) {
                    return po;
                }
            }
            catch (Exception e) {
                if (!Trace.SEVERE) break block4;
                Trace.trace("/severe", "Error calling delegate " + this.toString(), e);
            }
        }
        return new PublishOperation[0];
    }

    public String toString() {
        return "PublishTask[" + this.getId() + "]";
    }
}

