/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.search;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.IEditorMatchAdapter;
import org.eclipse.search.ui.text.IFileMatchAdapter;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.wst.sse.ui.internal.editor.EditorPluginImageHelper;
import org.eclipse.wst.sse.ui.internal.search.BasicSearchMatchElement;

public class OccurrencesSearchResult
extends AbstractTextSearchResult
implements IEditorMatchAdapter,
IFileMatchAdapter {
    private ISearchQuery fQuery = null;
    private final Match[] NO_MATCHES = new Match[0];

    public OccurrencesSearchResult(ISearchQuery query) {
        this.fQuery = query;
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult result, IEditorPart editor) {
        IEditorInput editorInput = editor.getEditorInput();
        if (editorInput instanceof IFileEditorInput) {
            IFileEditorInput fileEditorInput = (IFileEditorInput)editorInput;
            return this.computeContainedMatches(result, fileEditorInput.getFile());
        }
        return this.NO_MATCHES;
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult result, IFile file) {
        Match[] matches = this.getMatches();
        Match[] containedMatches = new Match[]{};
        if (matches.length > 0 && matches[0].getElement() instanceof BasicSearchMatchElement && ((BasicSearchMatchElement)matches[0].getElement()).getFile().equals((Object)file)) {
            containedMatches = matches;
        }
        return containedMatches;
    }

    public IEditorMatchAdapter getEditorMatchAdapter() {
        return this;
    }

    public IFile getFile(Object element) {
        IResource r;
        IFile file = null;
        if (element instanceof IMarker && (r = ((IMarker)element).getResource()) instanceof IFile) {
            file = (IFile)r;
        }
        return file;
    }

    public IFileMatchAdapter getFileMatchAdapter() {
        return this;
    }

    public ImageDescriptor getImageDescriptor() {
        return EditorPluginImageHelper.getInstance().getImageDescriptor("icons/full/obj16/occ_match.gif");
    }

    public String getLabel() {
        return this.getQuery().getLabel();
    }

    public Match[] getMatches() {
        return this.collectMatches(this.getElements());
    }

    public ISearchQuery getQuery() {
        return this.fQuery;
    }

    public String getTooltip() {
        return this.getLabel();
    }

    public boolean isShownInEditor(Match match, IEditorPart editor) {
        return true;
    }

    private Match[] collectMatches(Object[] elements) {
        Match[] matches = new Match[this.getMatchCount()];
        int writeIndex = 0;
        int i = 0;
        while (i < elements.length) {
            Match[] perElement = this.getMatches(elements[i]);
            int j = 0;
            while (j < perElement.length) {
                matches[writeIndex++] = perElement[j];
                ++j;
            }
            ++i;
        }
        return matches;
    }
}

