/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.contenttype;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.ITextContentDescriber;
import org.eclipse.jst.jsp.core.internal.contenttype.JSPResourceEncodingDetector;
import org.eclipse.jst.jsp.core.internal.provisional.contenttype.IContentDescriptionForJSP;
import org.eclipse.wst.html.core.internal.provisional.contenttype.ContentTypeFamilyForHTML;
import org.eclipse.wst.sse.core.internal.encoding.EncodingMemento;
import org.eclipse.wst.sse.core.internal.encoding.IContentDescriptionExtended;
import org.eclipse.wst.sse.core.internal.encoding.IResourceCharsetDetector;

public final class ContentDescriberForJSP
implements ITextContentDescriber {
    private static final QualifiedName[] SUPPORTED_OPTIONS = new QualifiedName[]{IContentDescription.CHARSET, IContentDescription.BYTE_ORDER_MARK, IContentDescriptionExtended.DETECTED_CHARSET, IContentDescriptionExtended.UNSUPPORTED_CHARSET, IContentDescriptionExtended.APPROPRIATE_DEFAULT, IContentDescriptionForJSP.CONTENT_TYPE_ATTRIBUTE, IContentDescriptionForJSP.LANGUAGE_ATTRIBUTE, IContentDescriptionForJSP.CONTENT_FAMILY_ATTRIBUTE};

    public int describe(InputStream contents, IContentDescription description) throws IOException {
        int result = 0;
        result = description != null ? this.calculateSupportedOptions(contents, description) : this.determineValidity(contents);
        return result;
    }

    private int determineValidity(InputStream contents) {
        return 1;
    }

    public int describe(Reader contents, IContentDescription description) throws IOException {
        int result = 0;
        result = description != null ? this.calculateSupportedOptions(contents, description) : this.determineValidity(contents);
        return result;
    }

    private int determineValidity(Reader contents) {
        return 1;
    }

    public QualifiedName[] getSupportedOptions() {
        return SUPPORTED_OPTIONS;
    }

    private int calculateSupportedOptions(InputStream contents, IContentDescription description) throws IOException {
        int result = 1;
        if (this.isRelevent(description)) {
            IResourceCharsetDetector detector = this.getDetector();
            detector.set(contents);
            this.handleCalculations(description, detector);
            result = 2;
        }
        return result;
    }

    private int calculateSupportedOptions(Reader contents, IContentDescription description) throws IOException {
        int result = 1;
        if (this.isRelevent(description)) {
            IResourceCharsetDetector detector = this.getDetector();
            detector.set(contents);
            this.handleCalculations(description, detector);
            result = 2;
        }
        return result;
    }

    private IResourceCharsetDetector getDetector() {
        return new JSPResourceEncodingDetector();
    }

    private void handleCalculations(IContentDescription description, IResourceCharsetDetector detector) throws IOException {
        this.handleStandardCalculations(description, detector);
        if (detector instanceof JSPResourceEncodingDetector) {
            String contentTypeAttribute;
            JSPResourceEncodingDetector jspDetector = (JSPResourceEncodingDetector)detector;
            String language = jspDetector.getLanguage();
            if (language != null && language.length() > 0) {
                description.setProperty(IContentDescriptionForJSP.LANGUAGE_ATTRIBUTE, (Object)language);
            }
            if ((contentTypeAttribute = jspDetector.getContentType()) != null && contentTypeAttribute.length() > 0) {
                description.setProperty(IContentDescriptionForJSP.CONTENT_TYPE_ATTRIBUTE, (Object)contentTypeAttribute);
            }
            if (jspDetector.isXHTML() || jspDetector.isWML()) {
                description.setProperty(IContentDescriptionForJSP.CONTENT_FAMILY_ATTRIBUTE, (Object)ContentTypeFamilyForHTML.HTML_FAMILY);
            }
        }
    }

    private void handleDetectedSpecialCase(IContentDescription description, Object detectedCharset, Object javaCharset) {
        if (detectedCharset != null) {
            description.setProperty(IContentDescriptionExtended.DETECTED_CHARSET, detectedCharset);
        }
    }

    private void handleStandardCalculations(IContentDescription description, IResourceCharsetDetector detector) throws IOException {
        Object existingByteOrderMark;
        EncodingMemento encodingMemento = ((JSPResourceEncodingDetector)detector).getEncodingMemento();
        byte[] detectedByteOrderMark = encodingMemento.getUnicodeBOM();
        if (detectedByteOrderMark != null && !detectedByteOrderMark.equals(existingByteOrderMark = description.getProperty(IContentDescription.BYTE_ORDER_MARK))) {
            description.setProperty(IContentDescription.BYTE_ORDER_MARK, (Object)detectedByteOrderMark);
        }
        if (!encodingMemento.isValid()) {
            description.setProperty(IContentDescriptionExtended.UNSUPPORTED_CHARSET, (Object)encodingMemento.getInvalidEncoding());
            description.setProperty(IContentDescriptionExtended.APPROPRIATE_DEFAULT, (Object)encodingMemento.getAppropriateDefault());
        }
        String detectedCharset = encodingMemento.getDetectedCharsetName();
        String javaCharset = encodingMemento.getJavaCharsetName();
        this.handleDetectedSpecialCase(description, detectedCharset, javaCharset);
        if (javaCharset != null) {
            Object existingCharset = description.getProperty(IContentDescription.CHARSET);
            if (javaCharset.equals(existingCharset)) {
                this.handleDetectedSpecialCase(description, detectedCharset, javaCharset);
            } else {
                String defaultCharset = detector.getSpecDefaultEncoding();
                if (defaultCharset != null) {
                    if (!defaultCharset.equals(javaCharset)) {
                        description.setProperty(IContentDescription.CHARSET, (Object)javaCharset);
                    }
                } else {
                    description.setProperty(IContentDescription.CHARSET, (Object)javaCharset);
                }
            }
        }
    }

    private boolean isRelevent(IContentDescription description) {
        boolean result = false;
        if (description == null) {
            result = false;
        } else if (description.isRequested(IContentDescription.BYTE_ORDER_MARK)) {
            result = true;
        } else if (description.isRequested(IContentDescription.CHARSET)) {
            result = true;
        } else if (description.isRequested(IContentDescriptionExtended.APPROPRIATE_DEFAULT)) {
            result = true;
        } else if (description.isRequested(IContentDescriptionExtended.DETECTED_CHARSET)) {
            result = true;
        } else if (description.isRequested(IContentDescriptionExtended.UNSUPPORTED_CHARSET)) {
            result = true;
        } else if (description.isRequested(IContentDescriptionForJSP.CONTENT_TYPE_ATTRIBUTE)) {
            result = true;
        } else if (description.isRequested(IContentDescriptionForJSP.LANGUAGE_ATTRIBUTE)) {
            result = true;
        }
        return result;
    }
}

