/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.MoveProcessor;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.RangeMarker;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.text.edits.TextEditProcessor;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeHierarchy;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionInvocation;
import org.eclipse.wst.jsdt.core.dom.FunctionRef;
import org.eclipse.wst.jsdt.core.dom.FunctionRefParameter;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IFunctionBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.JSdoc;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.NullLiteral;
import org.eclipse.wst.jsdt.core.dom.PostfixExpression;
import org.eclipse.wst.jsdt.core.dom.PrefixExpression;
import org.eclipse.wst.jsdt.core.dom.PrimitiveType;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.SuperFieldAccess;
import org.eclipse.wst.jsdt.core.dom.SuperMethodInvocation;
import org.eclipse.wst.jsdt.core.dom.TagElement;
import org.eclipse.wst.jsdt.core.dom.ThisExpression;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.VariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ListRewrite;
import org.eclipse.wst.jsdt.core.search.SearchMatch;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.internal.corext.SourceRange;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.GetterSetterUtil;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.wst.jsdt.internal.corext.refactoring.Checks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringSearchEngine2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.ScriptableRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.delegates.DelegateMethodCreator;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ImportRewriteUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.MemberVisibilityAdjustor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.ICommentProvider;
import org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.IDelegateUpdating;
import org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.IScriptableRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.JavadocUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.JdtFlags;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.corext.util.Strings;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.BindingLabelProvider;
import org.eclipse.wst.jsdt.ui.JavaScriptElementLabels;

public final class MoveInstanceMethodProcessor
extends MoveProcessor
implements IScriptableRefactoring,
IDelegateUpdating,
ICommentProvider {
    private static final String ATTRIBUTE_DEPRECATE = "deprecate";
    private static final String ATTRIBUTE_INLINE = "inline";
    private static final String ATTRIBUTE_REMOVE = "remove";
    private static final String ATTRIBUTE_TARGET_INDEX = "targetIndex";
    private static final String ATTRIBUTE_TARGET_NAME = "targetName";
    private static final String ATTRIBUTE_USE_GETTER = "getter";
    private static final String ATTRIBUTE_USE_SETTER = "setter";
    public static final String IDENTIFIER = "org.eclipse.wst.jsdt.ui.moveInstanceMethodProcessor";
    private IVariableBinding[] fCandidateTargets = new IVariableBinding[0];
    private TextChangeManager fChangeManager = null;
    private String fComment;
    private boolean fDelegateDeprecation = true;
    private boolean fDelegatingUpdating;
    private boolean fInline = false;
    private IFunction fMethod;
    private String fMethodName;
    private IVariableBinding[] fPossibleTargets = new IVariableBinding[0];
    private boolean fRemove = false;
    private CodeGenerationSettings fSettings;
    private CompilationUnitRewrite fSourceRewrite;
    private IVariableBinding fTarget = null;
    private String fTargetName;
    private boolean fTargetNode = true;
    private IType fTargetType = null;
    private boolean fUseGetters = true;
    private boolean fUseSetters = true;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected static IVariableBinding[] getArgumentBindings(FunctionDeclaration declaration) {
        Assert.isNotNull((Object)declaration);
        ArrayList<IVariableBinding> parameters = new ArrayList<IVariableBinding>(declaration.parameters().size());
        VariableDeclaration variable = null;
        IVariableBinding binding = null;
        Iterator iterator = declaration.parameters().iterator();
        while (iterator.hasNext()) {
            variable = (VariableDeclaration)iterator.next();
            binding = variable.resolveBinding();
            if (binding == null) {
                return new IVariableBinding[0];
            }
            parameters.add(binding);
        }
        IVariableBinding[] result = new IVariableBinding[parameters.size()];
        parameters.toArray(result);
        return result;
    }

    protected static ITypeBinding[] getArgumentTypes(FunctionDeclaration declaration) {
        Assert.isNotNull((Object)declaration);
        IVariableBinding[] parameters = MoveInstanceMethodProcessor.getArgumentBindings(declaration);
        ArrayList<ITypeBinding> types = new ArrayList<ITypeBinding>(parameters.length);
        IVariableBinding binding = null;
        ITypeBinding type = null;
        int index = 0;
        while (index < parameters.length) {
            binding = parameters[index];
            type = binding.getType();
            if (type != null) {
                types.add(type);
            }
            ++index;
        }
        ITypeBinding[] result = new ITypeBinding[types.size()];
        types.toArray(result);
        return result;
    }

    protected static boolean isFieldAccess(SimpleName name) {
        QualifiedName qualified;
        ITypeBinding type;
        ASTNode parent;
        Assert.isNotNull((Object)name);
        IBinding binding = name.resolveBinding();
        if (!(binding instanceof IVariableBinding)) {
            return false;
        }
        IVariableBinding variable = (IVariableBinding)binding;
        if (!variable.isField()) {
            return false;
        }
        if ("length".equals(name.getIdentifier()) && (parent = name.getParent()) instanceof QualifiedName && (type = (qualified = (QualifiedName)parent).getQualifier().resolveTypeBinding()) != null && type.isArray()) {
            return false;
        }
        return !Modifier.isStatic((int)variable.getModifiers());
    }

    public MoveInstanceMethodProcessor(IFunction method, CodeGenerationSettings settings) {
        this.fSettings = settings;
        this.fMethod = method;
        if (method != null) {
            this.initialize(method);
        }
    }

    public boolean canEnableComment() {
        return true;
    }

    public final boolean canEnableDelegateUpdating() {
        return true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void checkConflictingMethod(IProgressMonitor monitor, RefactoringStatus status) throws JavaScriptModelException {
        Assert.isNotNull((Object)monitor);
        Assert.isNotNull((Object)status);
        IFunction[] methods = this.fTargetType.getFunctions();
        try {
            monitor.beginTask("", methods.length);
            monitor.setTaskName(RefactoringCoreMessages.MoveInstanceMethodProcessor_checking);
            IFunction method = null;
            int index = 0;
            while (true) {
                block6: {
                    if (index < methods.length) break block6;
                    if (this.fMethodName.equals(this.fTargetType.getElementName())) {
                        status.merge(RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.MoveInstanceMethodProcessor_method_type_clash, this.fMethodName), (RefactoringStatusContext)JavaStatusContext.create((IMember)this.fTargetType)));
                    }
                    break;
                }
                method = methods[index];
                if (method.getElementName().equals(this.fMethodName) && method.getParameterTypes().length == this.fMethod.getParameterTypes().length - 1) {
                    status.merge(RefactoringStatus.createErrorStatus((String)Messages.format(RefactoringCoreMessages.MoveInstanceMethodProcessor_method_already_exists, new String[]{this.fMethodName, this.fTargetType.getElementName()}), (RefactoringStatusContext)JavaStatusContext.create((IMember)method)));
                }
                monitor.worked(1);
                ++index;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        monitor.done();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void checkConflictingTarget(IProgressMonitor monitor, RefactoringStatus status) throws JavaScriptModelException {
        Assert.isNotNull((Object)monitor);
        Assert.isNotNull((Object)status);
        FunctionDeclaration declaration = ASTNodeSearchUtil.getMethodDeclarationNode(this.fMethod, this.fSourceRewrite.getRoot());
        VariableDeclaration variable = null;
        List parameters = declaration.parameters();
        try {
            monitor.beginTask("", parameters.size());
            monitor.setTaskName(RefactoringCoreMessages.MoveInstanceMethodProcessor_checking);
            Iterator iterator = parameters.iterator();
            while (iterator.hasNext()) {
                block4: {
                    variable = (VariableDeclaration)iterator.next();
                    if (!this.fTargetName.equals(variable.getName().getIdentifier())) break block4;
                    status.merge(RefactoringStatus.createErrorStatus((String)RefactoringCoreMessages.MoveInstanceMethodProcessor_target_name_already_used, (RefactoringStatusContext)JavaStatusContext.create((IMember)this.fMethod)));
                    break;
                }
                monitor.worked(1);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        monitor.done();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final RefactoringStatus checkFinalConditions(IProgressMonitor monitor, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        Assert.isNotNull((Object)monitor);
        Assert.isNotNull((Object)context);
        Assert.isNotNull((Object)this.fTarget);
        RefactoringStatus status = new RefactoringStatus();
        this.fChangeManager = new TextChangeManager();
        try {
            block6: {
                block7: {
                    IType type;
                    block8: {
                        monitor.beginTask("", 4);
                        monitor.setTaskName(RefactoringCoreMessages.MoveInstanceMethodProcessor_checking);
                        status.merge(Checks.checkIfCuBroken((IMember)this.fMethod));
                        if (status.hasError()) break block6;
                        this.checkGenericTarget((IProgressMonitor)new SubProgressMonitor(monitor, 1), status);
                        if (!status.isOK()) break block6;
                        type = this.getTargetType();
                        if (type == null) break block7;
                        if (!type.isBinary() && !type.isReadOnly() && this.fMethod.exists() && !this.fMethod.isBinary() && !this.fMethod.isReadOnly()) break block8;
                        status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.MoveInstanceMethodProcessor_no_binary, (RefactoringStatusContext)JavaStatusContext.create((IMember)this.fMethod)));
                        break block6;
                    }
                    status.merge(Checks.checkIfCuBroken((IMember)type));
                    if (!status.hasError()) {
                        if (!type.exists() || type.isBinary() || type.isReadOnly()) {
                            status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.MoveInstanceMethodProcessor_no_binary, (RefactoringStatusContext)JavaStatusContext.create((IMember)this.fMethod)));
                        }
                        this.checkConflictingTarget((IProgressMonitor)new SubProgressMonitor(monitor, 1), status);
                        this.checkConflictingMethod((IProgressMonitor)new SubProgressMonitor(monitor, 1), status);
                        status.merge(Checks.validateModifiesFiles(this.computeModifiedFiles(this.fMethod.getJavaScriptUnit(), type.getJavaScriptUnit()), null));
                        monitor.worked(1);
                        if (!status.hasFatalError()) {
                            this.fChangeManager = this.createChangeManager(status, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        }
                    }
                    break block6;
                }
                status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.MoveInstanceMethodProcessor_no_resolved_target, (RefactoringStatusContext)JavaStatusContext.create((IMember)this.fMethod)));
            }
            Object var5_7 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
        return status;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void checkGenericTarget(IProgressMonitor monitor, RefactoringStatus status) {
        Assert.isNotNull((Object)monitor);
        Assert.isNotNull((Object)status);
        try {
            monitor.beginTask("", 1);
            monitor.setTaskName(RefactoringCoreMessages.MoveInstanceMethodProcessor_checking);
            ITypeBinding binding = this.fTarget.getType();
            if (binding == null) {
                status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.MoveInstanceMethodProcessor_no_generic_targets, (RefactoringStatusContext)JavaStatusContext.create((IMember)this.fMethod)));
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        monitor.done();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void checkGenericTypes(IProgressMonitor monitor, FunctionDeclaration declaration, RefactoringStatus status) {
        Assert.isNotNull((Object)monitor);
        Assert.isNotNull((Object)declaration);
        Assert.isNotNull((Object)status);
        try {
            monitor.beginTask("", 1);
            monitor.setTaskName(RefactoringCoreMessages.MoveInstanceMethodProcessor_checking);
            GenericReferenceFinder finder = new GenericReferenceFinder(declaration);
            declaration.accept((ASTVisitor)finder);
            if (!finder.getStatus().isOK()) {
                status.merge(finder.getStatus());
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        monitor.done();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final RefactoringStatus checkInitialConditions(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        Assert.isNotNull((Object)monitor);
        RefactoringStatus status = new RefactoringStatus();
        try {
            monitor.beginTask("", 4);
            monitor.setTaskName(RefactoringCoreMessages.MoveInstanceMethodProcessor_checking);
            status.merge(Checks.checkIfCuBroken((IMember)this.fMethod));
            if (!status.hasError()) {
                this.checkMethodDeclaration((IProgressMonitor)new SubProgressMonitor(monitor, 1), status);
                if (status.isOK()) {
                    FunctionDeclaration declaration = ASTNodeSearchUtil.getMethodDeclarationNode(this.fMethod, this.fSourceRewrite.getRoot());
                    this.checkGenericTypes((IProgressMonitor)new SubProgressMonitor(monitor, 1), declaration, status);
                    this.checkMethodBody((IProgressMonitor)new SubProgressMonitor(monitor, 1), declaration, status);
                    this.checkPossibleTargets((IProgressMonitor)new SubProgressMonitor(monitor, 1), declaration, status);
                }
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        monitor.done();
        return status;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void checkMethodBody(IProgressMonitor monitor, FunctionDeclaration declaration, RefactoringStatus status) {
        Assert.isNotNull((Object)monitor);
        Assert.isNotNull((Object)declaration);
        Assert.isNotNull((Object)status);
        try {
            ITypeBinding declaring;
            monitor.beginTask("", 3);
            monitor.setTaskName(RefactoringCoreMessages.MoveInstanceMethodProcessor_checking);
            AstNodeFinder finder = new SuperReferenceFinder();
            declaration.accept((ASTVisitor)finder);
            if (!finder.getStatus().isOK()) {
                status.merge(finder.getStatus());
            }
            monitor.worked(1);
            finder = null;
            IFunctionBinding binding = declaration.resolveBinding();
            if (binding != null && (declaring = binding.getDeclaringClass()) != null) {
                finder = new EnclosingInstanceReferenceFinder(declaring);
            }
            if (finder != null) {
                declaration.accept((ASTVisitor)finder);
                if (!finder.getStatus().isOK()) {
                    status.merge(finder.getStatus());
                }
                monitor.worked(1);
                finder = new RecursiveCallFinder(declaration);
                declaration.accept((ASTVisitor)finder);
                if (!finder.getStatus().isOK()) {
                    status.merge(finder.getStatus());
                }
                monitor.worked(1);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        monitor.done();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void checkMethodDeclaration(IProgressMonitor monitor, RefactoringStatus status) throws JavaScriptModelException {
        Assert.isNotNull((Object)monitor);
        Assert.isNotNull((Object)status);
        try {
            monitor.beginTask("", 2);
            monitor.setTaskName(RefactoringCoreMessages.MoveInstanceMethodProcessor_checking);
            int flags = this.fMethod.getFlags();
            if (Flags.isStatic((int)flags)) {
                status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.MoveInstanceMethodProcessor_no_static_methods, (RefactoringStatusContext)JavaStatusContext.create((IMember)this.fMethod)));
            } else if (Flags.isAbstract((int)flags)) {
                status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.MoveInstanceMethodProcessor_single_implementation, (RefactoringStatusContext)JavaStatusContext.create((IMember)this.fMethod)));
            }
            monitor.worked(1);
            if (this.fMethod.isConstructor()) {
                status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.MoveInstanceMethodProcessor_no_constructors, (RefactoringStatusContext)JavaStatusContext.create((IMember)this.fMethod)));
            }
            monitor.worked(1);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        monitor.done();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void checkPossibleTargets(IProgressMonitor monitor, FunctionDeclaration declaration, RefactoringStatus status) {
        Assert.isNotNull((Object)monitor);
        Assert.isNotNull((Object)declaration);
        Assert.isNotNull((Object)status);
        try {
            monitor.beginTask("", 1);
            monitor.setTaskName(RefactoringCoreMessages.MoveInstanceMethodProcessor_checking);
            if (this.computeTargetCategories(declaration).length < 1) {
                status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.MoveInstanceMethodProcessor_cannot_be_moved, (RefactoringStatusContext)JavaStatusContext.create((IMember)this.fMethod)));
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        monitor.done();
    }

    protected SearchResultGroup[] computeMethodReferences(IProgressMonitor monitor, RefactoringStatus status) throws CoreException {
        SearchResultGroup[] searchResultGroupArray;
        Assert.isNotNull((Object)monitor);
        Assert.isNotNull((Object)status);
        try {
            monitor.beginTask("", 1);
            monitor.setTaskName(RefactoringCoreMessages.MoveInstanceMethodProcessor_checking);
            RefactoringSearchEngine2 engine = new RefactoringSearchEngine2(SearchPattern.createPattern((IJavaScriptElement)this.fMethod, (int)2, (int)24));
            engine.setStatus(status);
            engine.searchPattern((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            searchResultGroupArray = (SearchResultGroup[])engine.getResults();
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
        return searchResultGroupArray;
    }

    protected IFile[] computeModifiedFiles(IJavaScriptUnit source, IJavaScriptUnit target) {
        Assert.isNotNull((Object)source);
        Assert.isNotNull((Object)target);
        if (source.equals(target)) {
            return ResourceUtil.getFiles(new IJavaScriptUnit[]{source});
        }
        return ResourceUtil.getFiles(new IJavaScriptUnit[]{source, target});
    }

    protected String[] computeReservedIdentifiers() throws JavaScriptModelException {
        ArrayList<String> names = new ArrayList<String>();
        FunctionDeclaration declaration = ASTNodeSearchUtil.getMethodDeclarationNode(this.fMethod, this.fSourceRewrite.getRoot());
        if (declaration != null) {
            List parameters = declaration.parameters();
            VariableDeclaration variable = null;
            int index = 0;
            while (index < parameters.size()) {
                variable = (VariableDeclaration)parameters.get(index);
                names.add(variable.getName().getIdentifier());
                ++index;
            }
            Block body = declaration.getBody();
            if (body != null) {
                IBinding[] bindings = new ScopeAnalyzer(this.fSourceRewrite.getRoot()).getDeclarationsAfter(body.getStartPosition(), 2);
                int index2 = 0;
                while (index2 < bindings.length) {
                    names.add(bindings[index2].getName());
                    ++index2;
                }
            }
        }
        String[] result = new String[names.size()];
        names.toArray(result);
        return result;
    }

    protected IVariableBinding[] computeTargetCategories(FunctionDeclaration declaration) {
        Assert.isNotNull((Object)declaration);
        if (this.fPossibleTargets.length == 0 || this.fCandidateTargets.length == 0) {
            ArrayList<IVariableBinding> possibleTargets = new ArrayList<IVariableBinding>(16);
            ArrayList<IVariableBinding> candidateTargets = new ArrayList<IVariableBinding>(16);
            IFunctionBinding method = declaration.resolveBinding();
            if (method != null) {
                ITypeBinding declaring = method.getDeclaringClass();
                IVariableBinding[] bindings = MoveInstanceMethodProcessor.getArgumentBindings(declaration);
                ITypeBinding binding = null;
                int index = 0;
                while (index < bindings.length) {
                    binding = bindings[index].getType();
                    if (binding.isClass() && binding.isFromSource()) {
                        possibleTargets.add(bindings[index]);
                        candidateTargets.add(bindings[index]);
                    }
                    ++index;
                }
                ReadyOnlyFieldFinder visitor = new ReadyOnlyFieldFinder(declaring);
                declaration.accept((ASTVisitor)visitor);
                bindings = visitor.getReadOnlyFields();
                int index2 = 0;
                while (index2 < bindings.length) {
                    binding = bindings[index2].getType();
                    if (binding.isClass() && binding.isFromSource()) {
                        possibleTargets.add(bindings[index2]);
                    }
                    ++index2;
                }
                bindings = visitor.getDeclaredFields();
                index2 = 0;
                while (index2 < bindings.length) {
                    binding = bindings[index2].getType();
                    if (binding.isClass() && binding.isFromSource()) {
                        candidateTargets.add(bindings[index2]);
                    }
                    ++index2;
                }
            }
            this.fPossibleTargets = new IVariableBinding[possibleTargets.size()];
            possibleTargets.toArray(this.fPossibleTargets);
            this.fCandidateTargets = new IVariableBinding[candidateTargets.size()];
            candidateTargets.toArray(this.fCandidateTargets);
        }
        return this.fPossibleTargets;
    }

    protected Expression createAdjustedTargetExpression(IJavaScriptElement enclosingElement, Expression expression, Map adjustments, ASTRewrite rewrite) throws JavaScriptModelException {
        IField field;
        Assert.isNotNull((Object)enclosingElement);
        Assert.isNotNull((Object)adjustments);
        Assert.isNotNull((Object)rewrite);
        IJavaScriptElement element = this.fTarget.getJavaElement();
        if (element != null && !Modifier.isPublic((int)this.fTarget.getModifiers()) && (field = (IField)this.fTarget.getJavaElement()) != null) {
            FunctionDeclaration method;
            IFunction getter;
            String modifier;
            boolean same = field.getAncestor(4).equals(enclosingElement.getAncestor(4));
            Modifier.ModifierKeyword keyword = same ? null : Modifier.ModifierKeyword.PUBLIC_KEYWORD;
            String string = modifier = same ? RefactoringCoreMessages.MemberVisibilityAdjustor_change_visibility_default : RefactoringCoreMessages.MemberVisibilityAdjustor_change_visibility_public;
            if (this.fUseGetters && (getter = GetterSetterUtil.getGetter(field)) != null && (method = ASTNodeSearchUtil.getMethodDeclarationNode(getter, this.fSourceRewrite.getRoot())) != null) {
                IFunctionBinding binding = method.resolveBinding();
                if (binding != null && MemberVisibilityAdjustor.hasLowerVisibility(getter.getFlags(), same ? 0 : (keyword == null ? 0 : keyword.toFlagValue())) && MemberVisibilityAdjustor.needsVisibilityAdjustments((IMember)getter, keyword, adjustments)) {
                    adjustments.put(getter, new MemberVisibilityAdjustor.OutgoingMemberVisibilityAdjustment((IMember)getter, keyword, RefactoringStatus.createWarningStatus((String)Messages.format(RefactoringCoreMessages.MemberVisibilityAdjustor_change_visibility_method_warning, new String[]{BindingLabelProvider.getBindingLabel((IBinding)binding, JavaScriptElementLabels.ALL_FULLY_QUALIFIED), modifier}), (RefactoringStatusContext)JavaStatusContext.create((IMember)getter))));
                }
                FunctionInvocation invocation = rewrite.getAST().newFunctionInvocation();
                invocation.setExpression(expression);
                invocation.setName(rewrite.getAST().newSimpleName(getter.getElementName()));
                return invocation;
            }
            if (MemberVisibilityAdjustor.hasLowerVisibility(field.getFlags(), keyword == null ? 0 : keyword.toFlagValue()) && MemberVisibilityAdjustor.needsVisibilityAdjustments((IMember)field, keyword, adjustments)) {
                adjustments.put(field, new MemberVisibilityAdjustor.OutgoingMemberVisibilityAdjustment((IMember)field, keyword, RefactoringStatus.createWarningStatus((String)Messages.format(RefactoringCoreMessages.MemberVisibilityAdjustor_change_visibility_field_warning, new String[]{BindingLabelProvider.getBindingLabel((IBinding)this.fTarget, JavaScriptElementLabels.ALL_FULLY_QUALIFIED), modifier}), (RefactoringStatusContext)JavaStatusContext.create((IMember)field))));
            }
        }
        return null;
    }

    protected boolean createArgumentList(FunctionDeclaration declaration, List arguments, IArgumentFactory factory) throws JavaScriptModelException {
        Assert.isNotNull((Object)declaration);
        Assert.isNotNull((Object)arguments);
        Assert.isNotNull((Object)factory);
        ThisReferenceFinder finder = new ThisReferenceFinder();
        declaration.accept((ASTVisitor)finder);
        IVariableBinding binding = null;
        VariableDeclaration variable = null;
        boolean added = false;
        int size = declaration.parameters().size();
        int index = 0;
        while (index < size) {
            variable = (VariableDeclaration)declaration.parameters().get(index);
            binding = variable.resolveBinding();
            if (binding != null) {
                if (!Bindings.equals((IBinding)binding, (IBinding)this.fTarget)) {
                    arguments.add(factory.getArgumentNode(binding, index == size - 1));
                } else if (!finder.getStatus().isOK()) {
                    arguments.add(factory.getTargetNode());
                    added = true;
                }
            } else {
                arguments.add(factory.getArgumentNode(binding, index == size - 1));
            }
            ++index;
        }
        if (!finder.getStatus().isOK() && !added) {
            arguments.add(0, factory.getTargetNode());
            added = true;
        }
        return added;
    }

    public final Change createChange(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        TextChange[] changes;
        block8: {
            TextChange textChange;
            Assert.isNotNull((Object)monitor);
            try {
                monitor.beginTask("", 6);
                monitor.setTaskName(RefactoringCoreMessages.MoveInstanceMethodProcessor_creating);
                changes = this.fChangeManager.getAllChanges();
                if (changes.length != 1) break block8;
                textChange = changes[0];
                Object var13_5 = null;
            }
            catch (Throwable throwable) {
                Object var13_7 = null;
                monitor.done();
                throw throwable;
            }
            monitor.done();
            return textChange;
        }
        ArrayList<TextChange> list = new ArrayList<TextChange>(changes.length);
        list.addAll(Arrays.asList(changes));
        HashMap<String, String> arguments = new HashMap<String, String>();
        String project = null;
        IJavaScriptProject javaProject = this.fMethod.getJavaScriptProject();
        if (javaProject != null) {
            project = javaProject.getElementName();
        }
        int flags = 786438;
        IType declaring = this.fMethod.getDeclaringType();
        try {
            if (declaring.isAnonymous() || declaring.isLocal()) {
                flags |= 0x40000;
            }
        }
        catch (JavaScriptModelException exception) {
            JavaScriptPlugin.log(exception);
        }
        String description = Messages.format(RefactoringCoreMessages.MoveInstanceMethodProcessor_descriptor_description_short, this.fMethod.getElementName());
        String header = Messages.format(RefactoringCoreMessages.MoveInstanceMethodProcessor_descriptor_description, new String[]{JavaScriptElementLabels.getElementLabel((IJavaScriptElement)this.fMethod, JavaScriptElementLabels.ALL_FULLY_QUALIFIED), BindingLabelProvider.getBindingLabel((IBinding)this.fTarget, JavaScriptElementLabels.ALL_FULLY_QUALIFIED)});
        JDTRefactoringDescriptorComment comment = new JDTRefactoringDescriptorComment(project, this, header);
        comment.addSetting(Messages.format(RefactoringCoreMessages.MoveInstanceMethodProcessor_moved_element_pattern, RefactoringCoreMessages.JavaRefactoringDescriptor_not_available));
        comment.addSetting(Messages.format(RefactoringCoreMessages.MoveInstanceMethodProcessor_target_element_pattern, BindingLabelProvider.getBindingLabel((IBinding)this.fTarget, JavaScriptElementLabels.ALL_FULLY_QUALIFIED)));
        comment.addSetting(Messages.format(RefactoringCoreMessages.MoveInstanceMethodProcessor_method_name_pattern, this.getMethodName()));
        if (this.needsTargetNode()) {
            comment.addSetting(Messages.format(RefactoringCoreMessages.MoveInstanceMethodProcessor_parameter_name_pattern, this.getTargetName()));
        }
        JDTRefactoringDescriptor descriptor = new JDTRefactoringDescriptor("org.eclipse.wst.jsdt.ui.move.method", project, description, comment.asString(), arguments, flags);
        arguments.put("input", descriptor.elementToHandle((IJavaScriptElement)this.fMethod));
        arguments.put("name", this.fMethodName);
        arguments.put(ATTRIBUTE_TARGET_NAME, this.fTargetName);
        arguments.put(ATTRIBUTE_DEPRECATE, Boolean.valueOf(this.fDelegateDeprecation).toString());
        arguments.put(ATTRIBUTE_REMOVE, Boolean.valueOf(this.fRemove).toString());
        arguments.put(ATTRIBUTE_INLINE, Boolean.valueOf(this.fInline).toString());
        arguments.put(ATTRIBUTE_USE_GETTER, Boolean.valueOf(this.fUseGetters).toString());
        arguments.put(ATTRIBUTE_USE_SETTER, Boolean.valueOf(this.fUseSetters).toString());
        arguments.put(ATTRIBUTE_TARGET_INDEX, new Integer(this.getTargetIndex()).toString());
        DynamicValidationRefactoringChange dynamicValidationRefactoringChange = new DynamicValidationRefactoringChange(descriptor, RefactoringCoreMessages.MoveInstanceMethodRefactoring_name, list.toArray(new Change[list.size()]));
        Object var13_6 = null;
        monitor.done();
        return dynamicValidationRefactoringChange;
    }

    protected TextChangeManager createChangeManager(RefactoringStatus status, IProgressMonitor monitor) throws JavaScriptModelException, CoreException {
        TextChangeManager textChangeManager;
        Assert.isNotNull((Object)status);
        Assert.isNotNull((Object)monitor);
        try {
            MemberVisibilityAdjustor.IVisibilityAdjustment adjustmentForTarget;
            IJavaScriptElement targetElement;
            monitor.beginTask("", 7);
            monitor.setTaskName(RefactoringCoreMessages.MoveInstanceMethodProcessor_creating);
            this.fSourceRewrite.clearASTAndImportRewrites();
            TextChangeManager manager = new TextChangeManager();
            CompilationUnitRewrite targetRewrite = this.fMethod.getJavaScriptUnit().equals(this.getTargetType().getJavaScriptUnit()) ? this.fSourceRewrite : new CompilationUnitRewrite(this.getTargetType().getJavaScriptUnit());
            FunctionDeclaration declaration = ASTNodeSearchUtil.getMethodDeclarationNode(this.fMethod, this.fSourceRewrite.getRoot());
            SearchResultGroup[] references = this.computeMethodReferences((IProgressMonitor)new SubProgressMonitor(monitor, 1), status);
            HashMap<IJavaScriptUnit, CompilationUnitRewrite> rewrites = new HashMap<IJavaScriptUnit, CompilationUnitRewrite>(2);
            rewrites.put(this.fSourceRewrite.getCu(), this.fSourceRewrite);
            if (!this.fSourceRewrite.getCu().equals(targetRewrite.getCu())) {
                rewrites.put(targetRewrite.getCu(), targetRewrite);
            }
            ASTRewrite sourceRewrite = ASTRewrite.create((AST)this.fSourceRewrite.getRoot().getAST());
            MemberVisibilityAdjustor adjustor = new MemberVisibilityAdjustor((IJavaScriptElement)this.fTargetType, (IMember)this.fMethod);
            adjustor.setStatus(status);
            adjustor.setVisibilitySeverity(2);
            adjustor.setFailureSeverity(2);
            adjustor.setRewrites(rewrites);
            adjustor.setRewrite(sourceRewrite, this.fSourceRewrite.getRoot());
            adjustor.adjustVisibility((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            Document document = new Document(this.fMethod.getJavaScriptUnit().getBuffer().getContents());
            boolean target = this.createMethodCopy((IDocument)document, declaration, sourceRewrite, rewrites, adjustor.getAdjustments(), status, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            this.createMethodJavadocReferences(rewrites, declaration, references, target, status, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (!this.fSourceRewrite.getCu().equals(targetRewrite.getCu())) {
                this.createMethodImports(targetRewrite, declaration, (IProgressMonitor)new SubProgressMonitor(monitor, 1), status);
            }
            boolean removable = false;
            if (this.fInline) {
                removable = this.createMethodDelegator(rewrites, declaration, references, adjustor.getAdjustments(), target, status, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                if (this.fRemove && removable) {
                    this.fSourceRewrite.getASTRewrite().remove((ASTNode)declaration, this.fSourceRewrite.createGroupDescription(RefactoringCoreMessages.MoveInstanceMethodProcessor_remove_original_method));
                    if (!this.fSourceRewrite.getCu().equals(this.fTargetType.getJavaScriptUnit())) {
                        this.fSourceRewrite.getImportRemover().registerRemovedNode((ASTNode)declaration);
                    }
                }
            }
            if (!this.fRemove || !removable) {
                this.createMethodDelegation(declaration, rewrites, adjustor.getAdjustments(), status, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            if ((targetElement = this.fTarget.getJavaElement()) != null && targetElement instanceof IField && (Flags.isPrivate((int)this.fMethod.getFlags()) || !this.fInline) && (adjustmentForTarget = (MemberVisibilityAdjustor.IVisibilityAdjustment)adjustor.getAdjustments().get(targetElement)) != null) {
                adjustor.getAdjustments().remove(targetElement);
            }
            adjustor.rewriteVisibility((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            sourceRewrite.rewriteAST((IDocument)document, this.fMethod.getJavaScriptProject().getOptions(true));
            this.createMethodSignature((IDocument)document, declaration, sourceRewrite, rewrites);
            IJavaScriptUnit unit = null;
            CompilationUnitRewrite rewrite = null;
            Iterator iterator = rewrites.keySet().iterator();
            while (iterator.hasNext()) {
                unit = (IJavaScriptUnit)iterator.next();
                rewrite = (CompilationUnitRewrite)rewrites.get(unit);
                manager.manage(unit, (TextChange)rewrite.createChange());
            }
            textChangeManager = manager;
            Object var17_18 = null;
        }
        catch (Throwable throwable) {
            Object var17_19 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
        return textChangeManager;
    }

    protected boolean createInlinedMethodInvocation(CompilationUnitRewrite rewriter, FunctionDeclaration declaration, SearchMatch match, Map adjustments, boolean target, RefactoringStatus status) throws JavaScriptModelException {
        Assert.isNotNull((Object)rewriter);
        Assert.isNotNull((Object)declaration);
        Assert.isNotNull((Object)match);
        Assert.isNotNull((Object)adjustments);
        Assert.isNotNull((Object)status);
        boolean result = true;
        ASTRewrite rewrite = rewriter.getASTRewrite();
        ASTNode node = ASTNodeSearchUtil.findNode(match, rewriter.getRoot());
        TextEditGroup group = rewriter.createGroupDescription(RefactoringCoreMessages.MoveInstanceMethodProcessor_inline_method_invocation);
        if (node instanceof FunctionInvocation) {
            FunctionInvocation invocation = (FunctionInvocation)node;
            ListRewrite list = rewrite.getListRewrite((ASTNode)invocation, FunctionInvocation.ARGUMENTS_PROPERTY);
            if (this.fTarget.isField()) {
                Expression access = null;
                if (invocation.getExpression() != null) {
                    access = this.createInlinedTargetExpression(rewriter, (IJavaScriptElement)match.getElement(), invocation.getExpression(), adjustments, status);
                    rewrite.set((ASTNode)invocation, (StructuralPropertyDescriptor)FunctionInvocation.EXPRESSION_PROPERTY, (Object)access, group);
                } else {
                    rewrite.set((ASTNode)invocation, (StructuralPropertyDescriptor)FunctionInvocation.EXPRESSION_PROPERTY, (Object)rewrite.getAST().newSimpleName(this.fTarget.getName()), group);
                }
                if (target) {
                    if (access == null || !(access instanceof FieldAccess)) {
                        list.insertFirst((ASTNode)rewrite.getAST().newThisExpression(), null);
                    } else {
                        list.insertLast(rewrite.createCopyTarget((ASTNode)invocation.getExpression()), null);
                    }
                }
            } else {
                IVariableBinding[] bindings = MoveInstanceMethodProcessor.getArgumentBindings(declaration);
                if (bindings.length > 0) {
                    int index = 0;
                    while (index < bindings.length) {
                        if (Bindings.equals((IBinding)bindings[index], (IBinding)this.fTarget)) break;
                        ++index;
                    }
                    if (index < bindings.length && invocation.arguments().size() > index) {
                        Expression argument = (Expression)invocation.arguments().get(index);
                        if (argument instanceof NullLiteral) {
                            status.merge(RefactoringStatus.createErrorStatus((String)Messages.format(RefactoringCoreMessages.MoveInstanceMethodProcessor_no_null_argument, BindingLabelProvider.getBindingLabel((IBinding)declaration.resolveBinding(), JavaScriptElementLabels.ALL_FULLY_QUALIFIED)), (RefactoringStatusContext)JavaStatusContext.create((ITypeRoot)rewriter.getCu(), (ASTNode)invocation)));
                            result = false;
                        } else {
                            if (argument instanceof ThisExpression) {
                                rewrite.remove((ASTNode)invocation.getExpression(), null);
                            } else {
                                rewrite.set((ASTNode)invocation, (StructuralPropertyDescriptor)FunctionInvocation.EXPRESSION_PROPERTY, (Object)rewrite.createCopyTarget((ASTNode)argument), group);
                            }
                            if (target) {
                                if (invocation.getExpression() != null) {
                                    list.replace((ASTNode)argument, rewrite.createCopyTarget((ASTNode)invocation.getExpression()), group);
                                } else {
                                    AbstractTypeDeclaration member;
                                    ThisExpression expression = rewrite.getAST().newThisExpression();
                                    Class<?> clazz = class$0;
                                    if (clazz == null) {
                                        try {
                                            clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration");
                                        }
                                        catch (ClassNotFoundException classNotFoundException) {
                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                        }
                                    }
                                    if ((member = (AbstractTypeDeclaration)ASTNodes.getParent((ASTNode)invocation, clazz)) != null) {
                                        ITypeBinding declaring;
                                        IFunctionBinding method;
                                        ITypeBinding resolved = member.resolveBinding();
                                        Class<?> clazz2 = class$1;
                                        if (clazz2 == null) {
                                            try {
                                                clazz2 = class$1 = Class.forName("org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration");
                                            }
                                            catch (ClassNotFoundException classNotFoundException) {
                                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                            }
                                        }
                                        if ((ASTNodes.getParent((ASTNode)invocation, clazz2) != null || resolved != null && resolved.isMember()) && (method = declaration.resolveBinding()) != null && (declaring = method.getDeclaringClass()) != null) {
                                            expression.setQualifier((Name)rewrite.getAST().newSimpleName(declaring.getName()));
                                        }
                                    }
                                    list.replace((ASTNode)argument, (ASTNode)expression, group);
                                }
                            } else {
                                list.remove((ASTNode)argument, group);
                            }
                        }
                    }
                }
            }
            if (result) {
                rewrite.set((ASTNode)invocation, (StructuralPropertyDescriptor)FunctionInvocation.NAME_PROPERTY, (Object)rewrite.getAST().newSimpleName(this.fMethodName), group);
            }
        }
        return result;
    }

    protected Expression createInlinedTargetExpression(CompilationUnitRewrite rewriter, IJavaScriptElement enclosingElement, Expression original, Map adjustments, RefactoringStatus status) throws JavaScriptModelException {
        Assert.isNotNull((Object)rewriter);
        Assert.isNotNull((Object)enclosingElement);
        Assert.isNotNull((Object)original);
        Assert.isNotNull((Object)adjustments);
        Assert.isNotNull((Object)status);
        Assert.isTrue((boolean)this.fTarget.isField());
        Expression expression = (Expression)ASTNode.copySubtree((AST)this.fSourceRewrite.getASTRewrite().getAST(), (ASTNode)original);
        Expression result = this.createAdjustedTargetExpression(enclosingElement, expression, adjustments, this.fSourceRewrite.getASTRewrite());
        if (result == null) {
            FieldAccess access = this.fSourceRewrite.getASTRewrite().getAST().newFieldAccess();
            access.setExpression(expression);
            access.setName(this.fSourceRewrite.getASTRewrite().getAST().newSimpleName(this.fTarget.getName()));
            return access;
        }
        return result;
    }

    protected boolean createMethodArguments(Map rewrites, ASTRewrite rewrite, final FunctionDeclaration declaration, Map adjustments, RefactoringStatus status) throws JavaScriptModelException {
        Assert.isNotNull((Object)rewrites);
        Assert.isNotNull((Object)declaration);
        Assert.isNotNull((Object)rewrite);
        Assert.isNotNull((Object)adjustments);
        Assert.isNotNull((Object)status);
        final CompilationUnitRewrite rewriter = this.getCompilationUnitRewrite(rewrites, this.getTargetType().getJavaScriptUnit());
        final AST ast = rewriter.getRoot().getAST();
        final AnonymousClassReferenceFinder finder = new AnonymousClassReferenceFinder(declaration);
        declaration.accept((ASTVisitor)finder);
        ArrayList arguments = new ArrayList(declaration.parameters().size() + 1);
        boolean result = this.createArgumentList(declaration, arguments, new VisibilityAdjustingArgumentFactory(ast, rewrites, adjustments){

            public final ASTNode getArgumentNode(IVariableBinding binding, boolean last) throws JavaScriptModelException {
                Assert.isNotNull((Object)binding);
                SingleVariableDeclaration variable = ast.newSingleVariableDeclaration();
                ITypeBinding type = binding.getType();
                this.adjustTypeVisibility(type);
                variable.setName(ast.newSimpleName(binding.getName()));
                variable.modifiers().addAll(ast.newModifiers(binding.getModifiers()));
                IFunctionBinding method = binding.getDeclaringMethod();
                if (last && method != null && method.isVarargs()) {
                    variable.setVarargs(true);
                    String name = null;
                    if (type.isArray()) {
                        name = type.getElementType().getName();
                        if (PrimitiveType.toCode((String)name) != null) {
                            variable.setType((Type)ast.newPrimitiveType(PrimitiveType.toCode((String)name)));
                        } else {
                            variable.setType((Type)ast.newSimpleType((Name)ast.newSimpleName(name)));
                        }
                    } else {
                        name = type.getName();
                        if (PrimitiveType.toCode((String)name) != null) {
                            variable.setType((Type)ast.newPrimitiveType(PrimitiveType.toCode((String)name)));
                        } else {
                            variable.setType((Type)ast.newSimpleType((Name)ast.newSimpleName(name)));
                        }
                    }
                } else {
                    variable.setType(rewriter.getImportRewrite().addImport(type, ast));
                }
                return variable;
            }

            public final ASTNode getTargetNode() throws JavaScriptModelException {
                ITypeBinding declaring;
                SingleVariableDeclaration variable = ast.newSingleVariableDeclaration();
                IFunctionBinding method = declaration.resolveBinding();
                if (method != null && (declaring = method.getDeclaringClass()) != null) {
                    this.adjustTypeVisibility(declaring);
                    variable.setType(rewriter.getImportRewrite().addImport(declaring, ast));
                    variable.setName(ast.newSimpleName(MoveInstanceMethodProcessor.this.fTargetName));
                    if (finder.getResult().size() > 0) {
                        variable.modifiers().add(ast.newModifier(Modifier.ModifierKeyword.FINAL_KEYWORD));
                    }
                }
                return variable;
            }
        });
        ListRewrite list = rewrite.getListRewrite((ASTNode)declaration, FunctionDeclaration.PARAMETERS_PROPERTY);
        ASTNode node = null;
        Iterator iterator = declaration.parameters().iterator();
        while (iterator.hasNext()) {
            node = (ASTNode)iterator.next();
            list.remove(node, null);
        }
        iterator = arguments.iterator();
        while (iterator.hasNext()) {
            node = (ASTNode)iterator.next();
            list.insertLast(node, null);
        }
        return result;
    }

    protected void createMethodBody(CompilationUnitRewrite rewriter, ASTRewrite rewrite, FunctionDeclaration declaration) {
        Assert.isNotNull((Object)declaration);
        declaration.getBody().accept((ASTVisitor)new MethodBodyRewriter(rewriter, rewrite, declaration));
    }

    protected void createMethodComment(final ASTRewrite rewrite, final FunctionDeclaration declaration) throws JavaScriptModelException {
        Assert.isNotNull((Object)rewrite);
        Assert.isNotNull((Object)declaration);
        JSdoc comment = declaration.getJavadoc();
        if (comment != null) {
            LinkedList tags = new LinkedList(comment.tags());
            IVariableBinding[] bindings = MoveInstanceMethodProcessor.getArgumentBindings(declaration);
            final HashMap<String, TagElement> elements = new HashMap<String, TagElement>(bindings.length);
            String name = null;
            List fragments = null;
            TagElement element = null;
            TagElement reference = null;
            IVariableBinding binding = null;
            int index = 0;
            while (index < bindings.length) {
                binding = bindings[index];
                Iterator iterator = comment.tags().iterator();
                while (iterator.hasNext()) {
                    element = (TagElement)iterator.next();
                    name = element.getTagName();
                    fragments = element.fragments();
                    if (name == null) continue;
                    if (name.equals("@param") && !fragments.isEmpty() && fragments.get(0) instanceof SimpleName) {
                        SimpleName simple = (SimpleName)fragments.get(0);
                        if (!binding.getName().equals(simple.getIdentifier())) continue;
                        elements.put(binding.getKey(), element);
                        tags.remove(element);
                        continue;
                    }
                    if (reference != null) continue;
                    reference = element;
                }
                ++index;
            }
            if (bindings.length == 0 && reference == null) {
                Iterator iterator = comment.tags().iterator();
                while (iterator.hasNext()) {
                    element = (TagElement)iterator.next();
                    name = element.getTagName();
                    fragments = element.fragments();
                    if (name == null || name.equals("@param")) continue;
                    reference = element;
                }
            }
            ArrayList arguments = new ArrayList(bindings.length + 1);
            this.createArgumentList(declaration, arguments, new IArgumentFactory(){

                public final ASTNode getArgumentNode(IVariableBinding argument, boolean last) throws JavaScriptModelException {
                    Assert.isNotNull((Object)argument);
                    if (elements.containsKey(argument.getKey())) {
                        return rewrite.createCopyTarget((ASTNode)elements.get(argument.getKey()));
                    }
                    return JavadocUtil.createParamTag(argument.getName(), declaration.getAST(), MoveInstanceMethodProcessor.this.fMethod.getJavaScriptProject());
                }

                public final ASTNode getTargetNode() throws JavaScriptModelException {
                    return JavadocUtil.createParamTag(MoveInstanceMethodProcessor.this.fTargetName, declaration.getAST(), MoveInstanceMethodProcessor.this.fMethod.getJavaScriptProject());
                }
            });
            ListRewrite rewriter = rewrite.getListRewrite((ASTNode)comment, JSdoc.TAGS_PROPERTY);
            ASTNode tag = null;
            Iterator iterator = comment.tags().iterator();
            while (iterator.hasNext()) {
                tag = (ASTNode)iterator.next();
                if (tags.contains(tag)) continue;
                rewriter.remove(tag, null);
            }
            iterator = arguments.iterator();
            while (iterator.hasNext()) {
                tag = (ASTNode)iterator.next();
                if (reference != null) {
                    rewriter.insertBefore(tag, (ASTNode)reference, null);
                    continue;
                }
                rewriter.insertLast(tag, null);
            }
        }
    }

    protected String createMethodContent(IDocument document, FunctionDeclaration declaration, ASTRewrite rewrite) throws BadLocationException {
        Assert.isNotNull((Object)document);
        Assert.isNotNull((Object)declaration);
        Assert.isNotNull((Object)rewrite);
        Region range = new Region(declaration.getStartPosition(), declaration.getLength());
        RangeMarker marker = new RangeMarker(range.getOffset(), range.getLength());
        IJavaScriptProject project = this.fMethod.getJavaScriptProject();
        TextEdit[] edits = rewrite.rewriteAST(document, project.getOptions(true)).removeChildren();
        int index = 0;
        while (index < edits.length) {
            marker.addChild(edits[index]);
            ++index;
        }
        MultiTextEdit result = new MultiTextEdit();
        result.addChild((TextEdit)marker);
        TextEditProcessor processor = new TextEditProcessor(document, (TextEdit)new MultiTextEdit(0, document.getLength()), 2);
        processor.getRoot().addChild((TextEdit)result);
        processor.performEdits();
        IRegion region = document.getLineInformation(document.getLineOfOffset(marker.getOffset()));
        return Strings.changeIndent(document.get(marker.getOffset(), marker.getLength()), Strings.computeIndentUnits(document.get(region.getOffset(), region.getLength()), project), project, "", TextUtilities.getDefaultLineDelimiter((IDocument)document));
    }

    /*
     * Exception decompiling
     */
    protected boolean createMethodCopy(IDocument document, FunctionDeclaration declaration, ASTRewrite rewrite, Map rewrites, Map adjustments, RefactoringStatus status, IProgressMonitor monitor) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 366->369)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected boolean createMethodDelegation(FunctionDeclaration declaration, Map rewrites, Map adjustments, RefactoringStatus status, IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull((Object)declaration);
        Assert.isNotNull((Object)monitor);
        DelegateInstanceMethodCreator creator = new DelegateInstanceMethodCreator(adjustments, rewrites);
        creator.setSourceRewrite(this.fSourceRewrite);
        creator.setCopy(false);
        creator.setDeclareDeprecated(this.fDelegateDeprecation);
        creator.setDeclaration((BodyDeclaration)declaration);
        creator.setNewElementName(this.fMethodName);
        creator.prepareDelegate();
        creator.createEdit();
        return creator.getNeededInsertion();
    }

    /*
     * Loose catch block
     */
    protected boolean createMethodDelegator(Map rewrites, FunctionDeclaration declaration, SearchResultGroup[] groups, Map adjustments, boolean target, RefactoringStatus status, IProgressMonitor monitor) {
        Assert.isNotNull((Object)rewrites);
        Assert.isNotNull((Object)declaration);
        Assert.isNotNull((Object)groups);
        Assert.isNotNull((Object)adjustments);
        Assert.isNotNull((Object)status);
        Assert.isNotNull((Object)monitor);
        monitor.beginTask("", groups.length);
        monitor.setTaskName(RefactoringCoreMessages.MoveInstanceMethodProcessor_creating);
        boolean result = true;
        boolean found = false;
        ITypeHierarchy hierarchy = this.fMethod.getDeclaringType().newTypeHierarchy((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        IType type = null;
        IFunction method = null;
        IType[] types = hierarchy.getAllSubtypes(this.fMethod.getDeclaringType());
        int index = 0;
        while (index < types.length && !found) {
            type = types[index];
            method = JavaModelUtil.findMethod(this.fMethod.getElementName(), this.fMethod.getParameterTypes(), false, type);
            if (method != null) {
                found = true;
            }
            ++index;
        }
        types = hierarchy.getAllSuperclasses(this.fMethod.getDeclaringType());
        index = 0;
        while (index < types.length && !found) {
            type = types[index];
            method = JavaModelUtil.findMethod(this.fMethod.getElementName(), this.fMethod.getParameterTypes(), false, type);
            if (method != null) {
                found = true;
            }
            ++index;
        }
        if (found) {
            status.merge(RefactoringStatus.createWarningStatus((String)Messages.format(RefactoringCoreMessages.MoveInstanceMethodProcessor_inline_overridden, BindingLabelProvider.getBindingLabel((IBinding)declaration.resolveBinding(), JavaScriptElementLabels.ALL_FULLY_QUALIFIED)), (RefactoringStatusContext)JavaStatusContext.create((IMember)this.fMethod)));
            result = false;
        } else {
            monitor.worked(1);
            SearchMatch[] matches = null;
            IJavaScriptElement element = null;
            IJavaScriptUnit unit = null;
            CompilationUnitRewrite rewrite = null;
            SearchResultGroup group = null;
            int index2 = 0;
            while (index2 < groups.length) {
                group = groups[index2];
                element = JavaScriptCore.create((IResource)group.getResource());
                if (element instanceof IJavaScriptUnit) {
                    matches = group.getSearchResults();
                    unit = (IJavaScriptUnit)element;
                    rewrite = this.getCompilationUnitRewrite(rewrites, unit);
                    SearchMatch match = null;
                    int offset = 0;
                    while (offset < matches.length) {
                        match = matches[offset];
                        if (match.getAccuracy() == 1) {
                            status.merge(RefactoringStatus.createWarningStatus((String)Messages.format(RefactoringCoreMessages.MoveInstanceMethodProcessor_inline_inaccurate, unit.getCorrespondingResource().getName()), (RefactoringStatusContext)JavaStatusContext.create((ITypeRoot)unit, new SourceRange(match.getOffset(), match.getLength()))));
                            result = false;
                        } else if (!this.createInlinedMethodInvocation(rewrite, declaration, match, adjustments, target, status)) {
                            result = false;
                        }
                        ++offset;
                    }
                } else if (element != null) {
                    status.merge(RefactoringStatus.createWarningStatus((String)Messages.format(RefactoringCoreMessages.MoveInstanceMethodProcessor_inline_binary_project, element.getJavaScriptProject().getElementName())));
                    result = false;
                } else {
                    status.merge(RefactoringStatus.createWarningStatus((String)Messages.format(RefactoringCoreMessages.MoveInstanceMethodProcessor_inline_binary_resource, group.getResource().getName())));
                    result = false;
                }
                ++index2;
            }
            monitor.worked(1);
        }
        boolean bl = result;
        Object var22_25 = null;
        monitor.done();
        return bl;
        {
            catch (CoreException exception) {
                try {
                    status.merge(RefactoringStatus.create((IStatus)exception.getStatus()));
                    Object var22_26 = null;
                }
                catch (Throwable throwable) {
                    Object var22_27 = null;
                    monitor.done();
                    throw throwable;
                }
                monitor.done();
                return false;
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void createMethodImports(CompilationUnitRewrite rewrite, FunctionDeclaration declaration, IProgressMonitor monitor, RefactoringStatus status) throws CoreException {
        Assert.isNotNull((Object)rewrite);
        Assert.isNotNull((Object)declaration);
        Assert.isNotNull((Object)monitor);
        Assert.isNotNull((Object)status);
        monitor.beginTask("", 1);
        monitor.setTaskName(RefactoringCoreMessages.MoveInstanceMethodProcessor_creating);
        try {
            ImportRewriteUtil.addImports(rewrite, (ASTNode)declaration, new HashMap(), new HashMap(), false);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        monitor.done();
    }

    protected void createMethodJavadocReference(CompilationUnitRewrite rewrite, FunctionDeclaration declaration, SearchMatch match, boolean targetNode, RefactoringStatus status) {
        Assert.isNotNull((Object)rewrite);
        Assert.isNotNull((Object)declaration);
        Assert.isNotNull((Object)match);
        Assert.isNotNull((Object)status);
        ASTNode node = ASTNodeSearchUtil.findNode(match, rewrite.getRoot());
        if (node instanceof FunctionRef) {
            AST ast = node.getAST();
            FunctionRef successor = ast.newFunctionRef();
            rewrite.getASTRewrite().replace(node, (ASTNode)successor, null);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void createMethodJavadocReferences(Map rewrites, FunctionDeclaration declaration, SearchResultGroup[] groups, boolean target, RefactoringStatus status, IProgressMonitor monitor) {
        Assert.isNotNull((Object)rewrites);
        Assert.isNotNull((Object)declaration);
        Assert.isNotNull((Object)status);
        Assert.isNotNull((Object)monitor);
        try {
            monitor.beginTask("", groups.length);
            monitor.setTaskName(RefactoringCoreMessages.MoveInstanceMethodProcessor_creating);
            try {
                SearchMatch[] matches = null;
                IJavaScriptElement element = null;
                IJavaScriptUnit unit = null;
                CompilationUnitRewrite rewrite = null;
                SearchResultGroup group = null;
                int index = 0;
                while (index < groups.length) {
                    group = groups[index];
                    element = JavaScriptCore.create((IResource)group.getResource());
                    unit = group.getCompilationUnit();
                    if (element instanceof IJavaScriptUnit) {
                        matches = group.getSearchResults();
                        unit = (IJavaScriptUnit)element;
                        rewrite = this.getCompilationUnitRewrite(rewrites, unit);
                        SearchMatch match = null;
                        int offset = 0;
                        while (offset < matches.length) {
                            match = matches[offset];
                            if (match.getAccuracy() == 1) {
                                status.merge(RefactoringStatus.createWarningStatus((String)Messages.format(RefactoringCoreMessages.MoveInstanceMethodProcessor_inline_inaccurate, unit.getCorrespondingResource().getName()), (RefactoringStatusContext)JavaStatusContext.create((ITypeRoot)unit, new SourceRange(match.getOffset(), match.getLength()))));
                            } else {
                                this.createMethodJavadocReference(rewrite, declaration, match, target, status);
                            }
                            ++offset;
                        }
                    } else if (element != null) {
                        status.merge(RefactoringStatus.createWarningStatus((String)Messages.format(RefactoringCoreMessages.MoveInstanceMethodProcessor_javadoc_binary_project, element.getJavaScriptProject().getElementName())));
                    } else {
                        status.merge(RefactoringStatus.createWarningStatus((String)Messages.format(RefactoringCoreMessages.MoveInstanceMethodProcessor_javadoc_binary_resource, group.getResource().getName())));
                    }
                    monitor.worked(1);
                    ++index;
                }
            }
            catch (CoreException exception) {
                status.merge(RefactoringStatus.create((IStatus)exception.getStatus()));
            }
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var15_18 = null;
        }
        monitor.done();
    }

    protected ASTNode createMethodReference(final FunctionDeclaration declaration, final AST ast) throws JavaScriptModelException {
        Assert.isNotNull((Object)ast);
        Assert.isNotNull((Object)declaration);
        FunctionRef reference = ast.newFunctionRef();
        reference.setName(ast.newSimpleName(this.fMethodName));
        reference.setQualifier(ASTNodeFactory.newName(ast, JavaModelUtil.getFullyQualifiedName(this.fTargetType)));
        this.createArgumentList(declaration, reference.parameters(), new IArgumentFactory(){

            public final ASTNode getArgumentNode(IVariableBinding binding, boolean last) {
                Assert.isNotNull((Object)binding);
                FunctionRefParameter parameter = ast.newFunctionRefParameter();
                parameter.setType(ASTNodeFactory.newType(ast, binding.getType().getName()));
                return parameter;
            }

            public final ASTNode getTargetNode() {
                ITypeBinding declaring;
                FunctionRefParameter parameter = ast.newFunctionRefParameter();
                IFunctionBinding method = declaration.resolveBinding();
                if (method != null && (declaring = method.getDeclaringClass()) != null) {
                    parameter.setType(ASTNodeFactory.newType(ast, Bindings.getFullyQualifiedName(declaring)));
                }
                return parameter;
            }
        });
        return reference;
    }

    protected void createMethodSignature(IDocument document, FunctionDeclaration declaration, ASTRewrite rewrite, Map rewrites) throws JavaScriptModelException {
        Assert.isNotNull((Object)document);
        Assert.isNotNull((Object)declaration);
        Assert.isNotNull((Object)rewrite);
        Assert.isNotNull((Object)rewrites);
        try {
            CompilationUnitRewrite rewriter = this.getCompilationUnitRewrite(rewrites, this.getTargetType().getJavaScriptUnit());
            FunctionDeclaration stub = (FunctionDeclaration)rewriter.getASTRewrite().createStringPlaceholder(this.createMethodContent(document, declaration, rewrite), 31);
            AbstractTypeDeclaration type = ASTNodeSearchUtil.getAbstractTypeDeclarationNode(this.getTargetType(), rewriter.getRoot());
            rewriter.getASTRewrite().getListRewrite((ASTNode)type, type.getBodyDeclarationsProperty()).insertAt((ASTNode)stub, ASTNodes.getInsertionIndex((BodyDeclaration)stub, type.bodyDeclarations()), rewriter.createGroupDescription(RefactoringCoreMessages.MoveInstanceMethodProcessor_add_moved_method));
        }
        catch (BadLocationException exception) {
            JavaScriptPlugin.log(exception);
        }
    }

    protected Expression createSimpleTargetAccessExpression(FunctionDeclaration declaration) {
        Assert.isNotNull((Object)declaration);
        SimpleName expression = null;
        AST ast = declaration.getAST();
        ITypeBinding type = this.fTarget.getDeclaringClass();
        if (type != null) {
            boolean shadows = false;
            IVariableBinding[] bindings = MoveInstanceMethodProcessor.getArgumentBindings(declaration);
            IVariableBinding variable = null;
            int index = 0;
            while (index < bindings.length) {
                variable = bindings[index];
                if (this.fMethod.getDeclaringType().getField(variable.getName()).exists()) {
                    shadows = true;
                    break;
                }
                ++index;
            }
            if (this.fSettings.useKeywordThis || shadows) {
                FieldAccess access = ast.newFieldAccess();
                access.setName(ast.newSimpleName(this.fTarget.getName()));
                access.setExpression((Expression)ast.newThisExpression());
                expression = access;
            } else {
                expression = ast.newSimpleName(this.fTarget.getName());
            }
        } else {
            expression = ast.newSimpleName(this.fTarget.getName());
        }
        return expression;
    }

    public final IVariableBinding[] getCandidateTargets() {
        Assert.isNotNull((Object)this.fCandidateTargets);
        return this.fCandidateTargets;
    }

    public String getComment() {
        return this.fComment;
    }

    protected CompilationUnitRewrite getCompilationUnitRewrite(Map rewrites, IJavaScriptUnit unit) {
        Assert.isNotNull((Object)rewrites);
        Assert.isNotNull((Object)unit);
        CompilationUnitRewrite rewrite = (CompilationUnitRewrite)rewrites.get(unit);
        if (rewrite == null) {
            rewrite = new CompilationUnitRewrite(unit);
            rewrites.put(unit, rewrite);
        }
        return rewrite;
    }

    public final boolean getDelegateUpdating() {
        return this.fDelegatingUpdating;
    }

    public String getDelegateUpdatingTitle(boolean plural) {
        if (plural) {
            return RefactoringCoreMessages.DelegateMethodCreator_keep_original_moved_plural;
        }
        return RefactoringCoreMessages.DelegateMethodCreator_keep_original_moved_singular;
    }

    public final boolean getDeprecateDelegates() {
        return this.fDelegateDeprecation;
    }

    public final Object[] getElements() {
        return new Object[]{this.fMethod};
    }

    public final String getIdentifier() {
        return IDENTIFIER;
    }

    public final IFunction getMethod() {
        return this.fMethod;
    }

    public final String getMethodName() {
        return this.fMethodName;
    }

    public final IVariableBinding[] getPossibleTargets() {
        Assert.isNotNull((Object)this.fPossibleTargets);
        return this.fPossibleTargets;
    }

    public final String getProcessorName() {
        return RefactoringCoreMessages.MoveInstanceMethodProcessor_name;
    }

    protected final int getTargetIndex() {
        IVariableBinding[] targets = this.getPossibleTargets();
        int result = -1;
        int index = 0;
        while (index < targets.length) {
            if (Bindings.equals((IBinding)this.fTarget, (IBinding)targets[index])) {
                result = index;
                break;
            }
            ++index;
        }
        return result;
    }

    public final String getTargetName() {
        return this.fTargetName;
    }

    protected IType getTargetType() throws JavaScriptModelException {
        Assert.isNotNull((Object)this.fTarget);
        if (this.fTargetType == null) {
            ITypeBinding binding = this.fTarget.getType();
            if (binding != null) {
                this.fTargetType = (IType)binding.getJavaElement();
            } else {
                throw new JavaScriptModelException(new CoreException((IStatus)new Status(4, JavaScriptPlugin.getPluginId(), 0, RefactoringCoreMessages.MoveInstanceMethodProcessor_cannot_be_moved, null)));
            }
        }
        return this.fTargetType;
    }

    protected void initialize(IFunction method) {
        Assert.isNotNull((Object)method);
        this.fSourceRewrite = new CompilationUnitRewrite(this.fMethod.getJavaScriptUnit());
        this.fMethodName = method.getElementName();
        this.fTargetName = this.suggestTargetName();
        if (this.fSettings == null) {
            this.fSettings = JavaPreferencesSettings.getCodeGenerationSettings(this.fMethod.getJavaScriptProject());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RefactoringStatus initialize(RefactoringArguments arguments) {
        if (!(arguments instanceof JavaRefactoringArguments)) return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        JavaRefactoringArguments extended = (JavaRefactoringArguments)arguments;
        String handle = extended.getAttribute("input");
        if (handle == null) return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
        IJavaScriptElement element = JDTRefactoringDescriptor.handleToElement(extended.getProject(), handle, false);
        if (element == null || !element.exists() || element.getElementType() != 9) {
            return ScriptableRefactoring.createInputFatalStatus(element, this.getRefactoring().getName(), "org.eclipse.wst.jsdt.ui.move.method");
        }
        this.fMethod = (IFunction)element;
        this.initialize(this.fMethod);
        String name = extended.getAttribute("name");
        if (name == null) return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "name"));
        RefactoringStatus status = this.setMethodName(name);
        if (status.hasError()) {
            return status;
        }
        String deprecate = extended.getAttribute(ATTRIBUTE_DEPRECATE);
        if (deprecate == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_DEPRECATE));
        }
        this.fDelegateDeprecation = Boolean.valueOf(deprecate);
        String remove = extended.getAttribute(ATTRIBUTE_REMOVE);
        if (remove == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_REMOVE));
        }
        this.fRemove = Boolean.valueOf(remove);
        String inline = extended.getAttribute(ATTRIBUTE_INLINE);
        if (inline == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_INLINE));
        }
        this.fInline = Boolean.valueOf(inline);
        String getter = extended.getAttribute(ATTRIBUTE_USE_GETTER);
        if (getter == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_USE_GETTER));
        }
        this.fUseGetters = Boolean.valueOf(getter);
        String setter = extended.getAttribute(ATTRIBUTE_USE_SETTER);
        if (setter == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_USE_SETTER));
        }
        this.fUseSetters = Boolean.valueOf(setter);
        String target = extended.getAttribute(ATTRIBUTE_TARGET_NAME);
        if (target == null) return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_TARGET_NAME));
        RefactoringStatus status2 = this.setTargetName(target);
        if (status2.hasError()) {
            return status2;
        }
        String value = extended.getAttribute(ATTRIBUTE_TARGET_INDEX);
        if (value == null) return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_TARGET_INDEX));
        try {
            IVariableBinding[] bindings;
            FunctionDeclaration declaration;
            int index = Integer.valueOf(value);
            if (index < 0 || (declaration = ASTNodeSearchUtil.getMethodDeclarationNode(this.fMethod, this.fSourceRewrite.getRoot())) == null || (bindings = this.computeTargetCategories(declaration)) == null || index >= bindings.length) return new RefactoringStatus();
            this.setTarget(bindings[index]);
            return new RefactoringStatus();
        }
        catch (NumberFormatException numberFormatException) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, new String[]{value, ATTRIBUTE_TARGET_INDEX}));
        }
        catch (JavaScriptModelException javaScriptModelException) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, new String[]{value, ATTRIBUTE_TARGET_INDEX}));
        }
    }

    public final boolean isApplicable() throws CoreException {
        return this.fMethod.exists() && !this.fMethod.isConstructor() && !this.fMethod.isBinary() && !this.fMethod.isReadOnly() && this.fMethod.getJavaScriptUnit() != null && !JdtFlags.isStatic((IMember)this.fMethod);
    }

    protected boolean isTargetAccess(Name name) {
        QualifiedName qualified;
        Assert.isNotNull((Object)name);
        IBinding binding = name.resolveBinding();
        if (Bindings.equals((IBinding)this.fTarget, binding)) {
            return true;
        }
        if (name.getParent() instanceof FieldAccess) {
            FieldAccess access = (FieldAccess)name.getParent();
            Expression expression = access.getExpression();
            if (expression instanceof Name) {
                return this.isTargetAccess((Name)expression);
            }
        } else if (name instanceof QualifiedName && (qualified = (QualifiedName)name).getQualifier() != null) {
            return this.isTargetAccess(qualified.getQualifier());
        }
        return false;
    }

    public final RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants participants) throws CoreException {
        return new RefactoringParticipant[0];
    }

    public final boolean needsTargetNode() {
        return this.fTargetNode;
    }

    public void setComment(String comment) {
        this.fComment = comment;
    }

    public final void setDelegateUpdating(boolean updating) {
        this.fDelegatingUpdating = updating;
        this.setInlineDelegator(!updating);
        this.setRemoveDelegator(!updating);
    }

    public final void setDeprecateDelegates(boolean deprecate) {
        this.fDelegateDeprecation = deprecate;
    }

    public final void setInlineDelegator(boolean inline) {
        this.fInline = inline;
    }

    public final RefactoringStatus setMethodName(String name) {
        Assert.isNotNull((Object)name);
        RefactoringStatus status = Checks.checkMethodName(name);
        if (status.hasFatalError()) {
            return status;
        }
        this.fMethodName = name;
        return status;
    }

    public final void setRemoveDelegator(boolean remove) {
        Assert.isTrue((!remove || this.fInline ? 1 : 0) != 0);
        this.fRemove = remove;
    }

    public final void setTarget(IVariableBinding target) {
        Assert.isNotNull((Object)target);
        this.fTarget = target;
        this.fTargetType = null;
        try {
            FunctionDeclaration declaration = ASTNodeSearchUtil.getMethodDeclarationNode(this.fMethod, this.fSourceRewrite.getRoot());
            if (declaration != null) {
                ThisReferenceFinder finder = new ThisReferenceFinder();
                declaration.accept((ASTVisitor)finder);
                this.fTargetNode = !finder.getResult().isEmpty();
                return;
            }
        }
        catch (JavaScriptModelException exception) {
            JavaScriptPlugin.log(exception);
        }
        this.fTargetNode = true;
    }

    public final RefactoringStatus setTargetName(String name) {
        Assert.isNotNull((Object)name);
        RefactoringStatus status = Checks.checkTempName(name);
        if (status.hasFatalError()) {
            return status;
        }
        this.fTargetName = name;
        return status;
    }

    public final void setUseGetters(boolean use) {
        this.fUseGetters = use;
    }

    public final void setUseSetters(boolean use) {
        this.fUseSetters = use;
    }

    public final boolean shouldUseGetters() {
        return this.fUseGetters;
    }

    public final boolean shouldUseSetters() {
        return this.fUseSetters;
    }

    protected String suggestTargetName() {
        try {
            String[] candidates = StubUtility.getArgumentNameSuggestions(this.fMethod.getDeclaringType(), this.fMethod.getJavaScriptUnit(), this.computeReservedIdentifiers());
            if (candidates.length > 0 && candidates[0].indexOf(36) < 0) {
                return candidates[0];
            }
        }
        catch (JavaScriptModelException exception) {
            JavaScriptPlugin.log(exception);
        }
        return "arg";
    }

    public final class AnonymousClassReferenceFinder
    extends AstNodeFinder {
        protected int fAnonymousClass = 0;
        protected final ITypeBinding fDeclaringType;

        public AnonymousClassReferenceFinder(FunctionDeclaration declaration) {
            this.fDeclaringType = declaration.resolveBinding().getDeclaringClass();
        }

        public final void endVisit(AnonymousClassDeclaration node) {
            Assert.isNotNull((Object)node);
            if (this.fAnonymousClass > 0) {
                --this.fAnonymousClass;
            }
            super.endVisit(node);
        }

        public final boolean visit(AnonymousClassDeclaration node) {
            Assert.isNotNull((Object)node);
            ++this.fAnonymousClass;
            return super.visit(node);
        }

        public final boolean visit(FunctionInvocation node) {
            IFunctionBinding binding;
            Assert.isNotNull((Object)node);
            if (this.fAnonymousClass > 0 && (binding = node.resolveMethodBinding()) != null && node.getExpression() == null && !Modifier.isStatic((int)binding.getModifiers())) {
                this.fResult.add(node.getName());
            }
            return true;
        }

        public boolean visit(SimpleName node) {
            IVariableBinding variable;
            ITypeBinding declaring;
            IBinding binding;
            Assert.isNotNull((Object)node);
            if (this.fAnonymousClass > 0 && !(node.getParent() instanceof FieldAccess) && (binding = node.resolveBinding()) instanceof IVariableBinding && (declaring = (variable = (IVariableBinding)binding).getDeclaringClass()) != null && Bindings.equals((IBinding)declaring, (IBinding)this.fDeclaringType)) {
                this.fResult.add(node);
            }
            return false;
        }
    }

    protected static class AstNodeFinder
    extends ASTVisitor {
        protected final Set fResult = new HashSet();
        protected final RefactoringStatus fStatus = new RefactoringStatus();

        protected AstNodeFinder() {
        }

        public final Set getResult() {
            return this.fResult;
        }

        public final RefactoringStatus getStatus() {
            return this.fStatus;
        }
    }

    class DelegateInstanceMethodCreator
    extends DelegateMethodCreator {
        private Map fAdjustments;
        private boolean fNeededInsertion;
        private Map fRewrites;

        public DelegateInstanceMethodCreator(Map adjustments, Map rewrites) {
            this.fAdjustments = adjustments;
            this.fRewrites = rewrites;
        }

        protected ASTNode createBody(BodyDeclaration bd) throws JavaScriptModelException {
            FunctionDeclaration methodDeclaration = (FunctionDeclaration)bd;
            FunctionInvocation invocation = this.getAst().newFunctionInvocation();
            invocation.setName(this.getAst().newSimpleName(this.getNewElementName()));
            invocation.setExpression(MoveInstanceMethodProcessor.this.createSimpleTargetAccessExpression(methodDeclaration));
            this.fNeededInsertion = MoveInstanceMethodProcessor.this.createArgumentList(methodDeclaration, invocation.arguments(), new VisibilityAdjustingArgumentFactory(this.getAst(), this.fRewrites, this.fAdjustments));
            Block block = this.getAst().newBlock();
            block.statements().add(this.createMethodInvocation(methodDeclaration, invocation));
            if (!MoveInstanceMethodProcessor.this.fSourceRewrite.getCu().equals(MoveInstanceMethodProcessor.this.fTargetType.getJavaScriptUnit())) {
                MoveInstanceMethodProcessor.this.fSourceRewrite.getImportRemover().registerRemovedNode((ASTNode)methodDeclaration.getBody());
            }
            return block;
        }

        protected ASTNode createDocReference(BodyDeclaration declaration) throws JavaScriptModelException {
            return MoveInstanceMethodProcessor.this.createMethodReference((FunctionDeclaration)declaration, this.getAst());
        }

        protected boolean getNeededInsertion() {
            return this.fNeededInsertion;
        }
    }

    public final class EnclosingInstanceReferenceFinder
    extends AstNodeFinder {
        private final List fEnclosingTypes = new ArrayList(3);

        public EnclosingInstanceReferenceFinder(ITypeBinding binding) {
            Assert.isNotNull((Object)binding);
            ITypeBinding declaring = binding.getDeclaringClass();
            while (declaring != null) {
                this.fEnclosingTypes.add(declaring);
                declaring = declaring.getDeclaringClass();
            }
        }

        public final boolean visit(SimpleName node) {
            Assert.isNotNull((Object)node);
            IBinding binding = node.resolveBinding();
            ITypeBinding declaring = null;
            if (binding instanceof IVariableBinding) {
                IVariableBinding variable = (IVariableBinding)binding;
                if (Flags.isStatic((int)variable.getModifiers())) {
                    return false;
                }
                declaring = variable.getDeclaringClass();
            } else if (binding instanceof IFunctionBinding) {
                IFunctionBinding method = (IFunctionBinding)binding;
                if (Flags.isStatic((int)method.getModifiers())) {
                    return false;
                }
                declaring = method.getDeclaringClass();
            }
            if (declaring != null) {
                ITypeBinding enclosing = null;
                Iterator iterator = this.fEnclosingTypes.iterator();
                while (iterator.hasNext()) {
                    enclosing = (ITypeBinding)iterator.next();
                    if (!Bindings.equals((IBinding)enclosing, (IBinding)declaring)) continue;
                    this.fStatus.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.MoveInstanceMethodProcessor_refers_enclosing_instances, (RefactoringStatusContext)JavaStatusContext.create((ITypeRoot)MoveInstanceMethodProcessor.this.fMethod.getJavaScriptUnit(), (ASTNode)node)));
                    this.fResult.add(node);
                    break;
                }
            }
            return false;
        }

        public final boolean visit(ThisExpression node) {
            Assert.isNotNull((Object)node);
            if (node.getQualifier() != null) {
                this.fStatus.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.MoveInstanceMethodProcessor_refers_enclosing_instances, (RefactoringStatusContext)JavaStatusContext.create((ITypeRoot)MoveInstanceMethodProcessor.this.fMethod.getJavaScriptUnit(), (ASTNode)node)));
                this.fResult.add(node);
            }
            return false;
        }
    }

    public final class GenericReferenceFinder
    extends AstNodeFinder {
        protected final Set fBindings = new HashSet();

        public GenericReferenceFinder(FunctionDeclaration declaration) {
            Assert.isNotNull((Object)declaration);
        }

        public final boolean visit(SimpleName node) {
            Assert.isNotNull((Object)node);
            node.resolveBinding();
            return true;
        }
    }

    protected static interface IArgumentFactory {
        public ASTNode getArgumentNode(IVariableBinding var1, boolean var2) throws JavaScriptModelException;

        public ASTNode getTargetNode() throws JavaScriptModelException;
    }

    public final class MethodBodyRewriter
    extends ASTVisitor {
        protected int fAnonymousClass = 0;
        protected final FunctionDeclaration fDeclaration;
        protected final Set fMethodDeclarations = new HashSet();
        protected final ASTRewrite fRewrite;
        protected final Set fStaticImports = new HashSet();
        protected final RefactoringStatus fStatus = new RefactoringStatus();
        protected final CompilationUnitRewrite fTargetRewrite;

        public MethodBodyRewriter(CompilationUnitRewrite targetRewrite, ASTRewrite rewrite, FunctionDeclaration sourceDeclaration) {
            Assert.isNotNull((Object)targetRewrite);
            Assert.isNotNull((Object)rewrite);
            Assert.isNotNull((Object)sourceDeclaration);
            this.fTargetRewrite = targetRewrite;
            this.fRewrite = rewrite;
            this.fDeclaration = sourceDeclaration;
            this.fStaticImports.clear();
            ImportRewriteUtil.collectImports(MoveInstanceMethodProcessor.this.fMethod.getJavaScriptProject(), (ASTNode)sourceDeclaration, new HashSet(), this.fStaticImports, false);
        }

        public final void endVisit(AnonymousClassDeclaration node) {
            Assert.isNotNull((Object)node);
            if (this.fAnonymousClass > 0) {
                --this.fAnonymousClass;
            }
            super.endVisit(node);
        }

        public final boolean visit(AnonymousClassDeclaration node) {
            Assert.isNotNull((Object)node);
            ++this.fAnonymousClass;
            return super.visit(node);
        }

        public final boolean visit(ClassInstanceCreation node) {
            Assert.isNotNull((Object)node);
            if (node.getParent() instanceof ClassInstanceCreation) {
                AnonymousClassDeclaration declaration = node.getAnonymousClassDeclaration();
                if (declaration != null) {
                    this.visit(declaration);
                }
                return false;
            }
            return super.visit(node);
        }

        public final boolean visit(FieldAccess node) {
            Assert.isNotNull((Object)node);
            Expression expression = node.getExpression();
            IVariableBinding variable = node.resolveFieldBinding();
            AST ast = this.fRewrite.getAST();
            if (expression instanceof ThisExpression && Bindings.equals((IBinding)MoveInstanceMethodProcessor.this.fTarget, (IBinding)variable)) {
                if (this.fAnonymousClass > 0) {
                    ThisExpression target = ast.newThisExpression();
                    target.setQualifier((Name)ast.newSimpleName(MoveInstanceMethodProcessor.this.fTargetType.getElementName()));
                    this.fRewrite.replace((ASTNode)node, (ASTNode)target, null);
                } else {
                    this.fRewrite.replace((ASTNode)node, (ASTNode)ast.newThisExpression(), null);
                }
                return false;
            }
            if (expression instanceof FieldAccess) {
                FieldAccess access = (FieldAccess)expression;
                IBinding binding = access.getName().resolveBinding();
                if (access.getExpression() instanceof ThisExpression && Bindings.equals((IBinding)MoveInstanceMethodProcessor.this.fTarget, binding)) {
                    this.fRewrite.replace((ASTNode)node, (ASTNode)ast.newSimpleName(node.getName().getIdentifier()), null);
                    return false;
                }
            } else if (expression != null) {
                IFunctionBinding method = this.fDeclaration.resolveBinding();
                if (variable != null && method != null && !JdtFlags.isStatic(variable) && Bindings.equals((IBinding)method.getDeclaringClass(), (IBinding)variable.getDeclaringClass())) {
                    this.fRewrite.replace((ASTNode)expression, (ASTNode)ast.newSimpleName(MoveInstanceMethodProcessor.this.fTargetName), null);
                    return false;
                }
            }
            return true;
        }

        public final void visit(List nodes) {
            Assert.isNotNull((Object)nodes);
            ASTNode node = null;
            Iterator iterator = nodes.iterator();
            while (iterator.hasNext()) {
                node = (ASTNode)iterator.next();
                node.accept((ASTVisitor)this);
            }
        }

        public final boolean visit(FunctionInvocation node) {
            Assert.isNotNull((Object)node);
            Expression expression = node.getExpression();
            IFunctionBinding method = node.resolveMethodBinding();
            if (method != null) {
                Name name;
                ASTRewrite rewrite = this.fRewrite;
                if (expression == null) {
                    AST ast = node.getAST();
                    if (!JdtFlags.isStatic(method)) {
                        rewrite.set((ASTNode)node, (StructuralPropertyDescriptor)FunctionInvocation.EXPRESSION_PROPERTY, (Object)ast.newSimpleName(MoveInstanceMethodProcessor.this.fTargetName), null);
                    } else {
                        rewrite.set((ASTNode)node, (StructuralPropertyDescriptor)FunctionInvocation.EXPRESSION_PROPERTY, (Object)ast.newSimpleType((Name)ast.newSimpleName(MoveInstanceMethodProcessor.this.fMethod.getDeclaringType().getElementName())), null);
                    }
                    return true;
                }
                if (expression instanceof FieldAccess) {
                    FieldAccess access = (FieldAccess)expression;
                    if (Bindings.equals((IBinding)access.resolveFieldBinding(), (IBinding)MoveInstanceMethodProcessor.this.fTarget)) {
                        rewrite.remove((ASTNode)expression, null);
                        this.visit(node.arguments());
                        return false;
                    }
                } else if (expression instanceof Name && Bindings.equals((name = (Name)expression).resolveBinding(), (IBinding)MoveInstanceMethodProcessor.this.fTarget)) {
                    rewrite.remove((ASTNode)expression, null);
                    this.visit(node.arguments());
                    return false;
                }
            }
            return true;
        }

        public final boolean visit(QualifiedName node) {
            String name;
            ITypeBinding type;
            Assert.isNotNull((Object)node);
            IBinding binding = node.resolveBinding();
            if (binding instanceof ITypeBinding && (type = (ITypeBinding)binding).isClass() && type.getDeclaringClass() != null && (name = this.fTargetRewrite.getImportRewrite().addImport(type)) != null && name.length() > 0) {
                this.fRewrite.replace((ASTNode)node, (ASTNode)ASTNodeFactory.newName(node.getAST(), name), null);
                return false;
            }
            binding = node.getQualifier().resolveBinding();
            if (Bindings.equals(binding, (IBinding)MoveInstanceMethodProcessor.this.fTarget)) {
                this.fRewrite.replace((ASTNode)node, this.fRewrite.createCopyTarget((ASTNode)node.getName()), null);
                return false;
            }
            return true;
        }

        public final boolean visit(SimpleName node) {
            String name;
            ITypeBinding type;
            Assert.isNotNull((Object)node);
            AST ast = node.getAST();
            ASTRewrite rewrite = this.fRewrite;
            IBinding binding = node.resolveBinding();
            if (binding instanceof ITypeBinding && (type = (ITypeBinding)binding).isClass() && type.getDeclaringClass() != null && (name = this.fTargetRewrite.getImportRewrite().addImport(type)) != null && name.length() > 0) {
                this.fRewrite.replace((ASTNode)node, (ASTNode)ASTNodeFactory.newName(ast, name), null);
                return false;
            }
            if (Bindings.equals(binding, (IBinding)MoveInstanceMethodProcessor.this.fTarget)) {
                if (this.fAnonymousClass > 0) {
                    ThisExpression target = ast.newThisExpression();
                    target.setQualifier((Name)ast.newSimpleName(MoveInstanceMethodProcessor.this.fTargetType.getElementName()));
                    this.fRewrite.replace((ASTNode)node, (ASTNode)target, null);
                } else {
                    rewrite.replace((ASTNode)node, (ASTNode)ast.newThisExpression(), null);
                }
            } else if (binding instanceof IVariableBinding) {
                IVariableBinding variable = (IVariableBinding)binding;
                IFunctionBinding method = this.fDeclaration.resolveBinding();
                ITypeBinding declaring = variable.getDeclaringClass();
                if (method != null) {
                    if (Bindings.equals((IBinding)method.getDeclaringClass(), (IBinding)declaring)) {
                        if (JdtFlags.isStatic(variable)) {
                            rewrite.replace((ASTNode)node, (ASTNode)ast.newQualifiedName(ASTNodeFactory.newName(ast, this.fTargetRewrite.getImportRewrite().addImport(declaring)), ast.newSimpleName(node.getFullyQualifiedName())), null);
                        } else {
                            FieldAccess access = ast.newFieldAccess();
                            access.setExpression((Expression)ast.newSimpleName(MoveInstanceMethodProcessor.this.fTargetName));
                            access.setName(ast.newSimpleName(node.getFullyQualifiedName()));
                            rewrite.replace((ASTNode)node, (ASTNode)access, null);
                        }
                    } else if (!(node.getParent() instanceof QualifiedName) && JdtFlags.isStatic(variable) && !this.fStaticImports.contains(variable)) {
                        rewrite.replace((ASTNode)node, (ASTNode)ast.newQualifiedName(ASTNodeFactory.newName(ast, this.fTargetRewrite.getImportRewrite().addImport(declaring)), ast.newSimpleName(node.getFullyQualifiedName())), null);
                    }
                }
            }
            return false;
        }

        public final boolean visit(ThisExpression node) {
            Assert.isNotNull((Object)node);
            this.fRewrite.replace((ASTNode)node, (ASTNode)node.getAST().newSimpleName(MoveInstanceMethodProcessor.this.fTargetName), null);
            return false;
        }
    }

    public static class ReadyOnlyFieldFinder
    extends ASTVisitor {
        protected final List fBindings = new LinkedList();
        protected final Set fFound = new HashSet();
        protected final Set fWritten = new HashSet();

        protected static IVariableBinding getFieldBinding(Expression expression) {
            IVariableBinding variable;
            IBinding binding;
            Assert.isNotNull((Object)expression);
            if (expression instanceof FieldAccess) {
                return (IVariableBinding)((FieldAccess)expression).getName().resolveBinding();
            }
            if (expression instanceof Name && (binding = ((Name)expression).resolveBinding()) instanceof IVariableBinding && (variable = (IVariableBinding)binding).isField()) {
                return variable;
            }
            return null;
        }

        protected static boolean isQualifiedEntity(Name name) {
            Assert.isNotNull((Object)name);
            ASTNode parent = name.getParent();
            if (parent instanceof QualifiedName && ((QualifiedName)parent).getName().equals((Object)name) || parent instanceof FieldAccess && ((FieldAccess)parent).getName().equals((Object)name) || parent instanceof SuperFieldAccess) {
                return true;
            }
            if (parent instanceof FunctionInvocation) {
                FunctionInvocation invocation = (FunctionInvocation)parent;
                return invocation.getExpression() != null && invocation.getName().equals((Object)name);
            }
            return false;
        }

        public ReadyOnlyFieldFinder(ITypeBinding binding) {
            Assert.isNotNull((Object)binding);
            IVariableBinding[] bindings = binding.getDeclaredFields();
            IVariableBinding variable = null;
            int index = 0;
            while (index < bindings.length) {
                variable = bindings[index];
                if (!this.fFound.contains(variable.getKey())) {
                    this.fFound.add(variable.getKey());
                    this.fBindings.add(variable);
                }
                ++index;
            }
        }

        public final IVariableBinding[] getDeclaredFields() {
            IVariableBinding[] result = new IVariableBinding[this.fBindings.size()];
            this.fBindings.toArray(result);
            return result;
        }

        public final IVariableBinding[] getReadOnlyFields() {
            IVariableBinding binding = null;
            LinkedList list = new LinkedList(this.fBindings);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                binding = (IVariableBinding)iterator.next();
                if (!this.fWritten.contains(binding.getKey())) continue;
                iterator.remove();
            }
            IVariableBinding[] result = new IVariableBinding[list.size()];
            list.toArray(result);
            return result;
        }

        public final boolean visit(Assignment node) {
            Assert.isNotNull((Object)node);
            IVariableBinding binding = ReadyOnlyFieldFinder.getFieldBinding(node.getLeftHandSide());
            if (binding != null) {
                this.fWritten.add(binding.getKey());
            }
            return true;
        }

        public final boolean visit(FieldAccess node) {
            String key;
            IVariableBinding binding;
            Assert.isNotNull((Object)node);
            if (node.getExpression() instanceof ThisExpression && (binding = (IVariableBinding)node.getName().resolveBinding()) != null && !this.fFound.contains(key = binding.getKey())) {
                this.fFound.add(key);
                this.fBindings.add(binding);
            }
            return true;
        }

        public final boolean visit(PostfixExpression node) {
            IVariableBinding binding = ReadyOnlyFieldFinder.getFieldBinding(node.getOperand());
            if (binding != null) {
                this.fWritten.add(binding.getKey());
            }
            return true;
        }

        public final boolean visit(PrefixExpression node) {
            IVariableBinding binding = ReadyOnlyFieldFinder.getFieldBinding(node.getOperand());
            if (binding != null) {
                this.fWritten.add(binding.getKey());
            }
            return false;
        }

        public final boolean visit(SimpleName node) {
            IVariableBinding variable;
            String key;
            Assert.isNotNull((Object)node);
            IBinding binding = node.resolveBinding();
            if (binding != null && MoveInstanceMethodProcessor.isFieldAccess(node) && !ReadyOnlyFieldFinder.isQualifiedEntity((Name)node) && !this.fFound.contains(key = (variable = (IVariableBinding)binding).getKey())) {
                this.fFound.add(key);
                this.fBindings.add(variable);
            }
            return false;
        }
    }

    public final class RecursiveCallFinder
    extends AstNodeFinder {
        protected final IFunctionBinding fBinding;

        public RecursiveCallFinder(FunctionDeclaration declaration) {
            Assert.isNotNull((Object)declaration);
            this.fBinding = declaration.resolveBinding();
        }

        public final boolean visit(FunctionInvocation node) {
            Assert.isNotNull((Object)node);
            Expression expression = node.getExpression();
            IFunctionBinding binding = node.resolveMethodBinding();
            if (binding == null || !Modifier.isStatic((int)binding.getModifiers()) && Bindings.equals((IBinding)binding, (IBinding)this.fBinding) && (expression == null || expression instanceof ThisExpression)) {
                this.fStatus.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.MoveInstanceMethodProcessor_potentially_recursive, (RefactoringStatusContext)JavaStatusContext.create((ITypeRoot)MoveInstanceMethodProcessor.this.fMethod.getJavaScriptUnit(), (ASTNode)node)));
                this.fResult.add(node);
                return false;
            }
            return true;
        }
    }

    public final class SuperReferenceFinder
    extends AstNodeFinder {
        public final boolean visit(AnonymousClassDeclaration node) {
            return false;
        }

        public final boolean visit(SuperFieldAccess node) {
            Assert.isNotNull((Object)node);
            this.fStatus.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.MoveInstanceMethodProcessor_uses_super, (RefactoringStatusContext)JavaStatusContext.create((ITypeRoot)MoveInstanceMethodProcessor.this.fMethod.getJavaScriptUnit(), (ASTNode)node)));
            this.fResult.add(node);
            return false;
        }

        public final boolean visit(SuperMethodInvocation node) {
            Assert.isNotNull((Object)node);
            this.fStatus.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.MoveInstanceMethodProcessor_uses_super, (RefactoringStatusContext)JavaStatusContext.create((ITypeRoot)MoveInstanceMethodProcessor.this.fMethod.getJavaScriptUnit(), (ASTNode)node)));
            this.fResult.add(node);
            return false;
        }

        public final boolean visit(TypeDeclaration node) {
            return false;
        }
    }

    public final class ThisReferenceFinder
    extends AstNodeFinder {
        public final boolean visit(FunctionInvocation node) {
            Assert.isNotNull((Object)node);
            IFunctionBinding binding = node.resolveMethodBinding();
            if (binding != null && !JdtFlags.isStatic(binding) && node.getExpression() == null) {
                this.fResult.add(node);
                this.fStatus.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.MoveInstanceMethodProcessor_this_reference, (RefactoringStatusContext)JavaStatusContext.create((ITypeRoot)MoveInstanceMethodProcessor.this.fMethod.getJavaScriptUnit(), (ASTNode)node)));
            }
            return true;
        }

        public final boolean visit(SimpleName node) {
            Assert.isNotNull((Object)node);
            if (MoveInstanceMethodProcessor.isFieldAccess(node) && !MoveInstanceMethodProcessor.this.isTargetAccess((Name)node)) {
                this.fResult.add(node);
                this.fStatus.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.MoveInstanceMethodProcessor_this_reference, (RefactoringStatusContext)JavaStatusContext.create((ITypeRoot)MoveInstanceMethodProcessor.this.fMethod.getJavaScriptUnit(), (ASTNode)node)));
            }
            return false;
        }

        public final boolean visit(ThisExpression node) {
            Assert.isNotNull((Object)node);
            this.fResult.add(node);
            this.fStatus.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.MoveInstanceMethodProcessor_this_reference, (RefactoringStatusContext)JavaStatusContext.create((ITypeRoot)MoveInstanceMethodProcessor.this.fMethod.getJavaScriptUnit(), (ASTNode)node)));
            return false;
        }
    }

    public class VisibilityAdjustingArgumentFactory
    implements IArgumentFactory {
        private final Map fAdjustments;
        private final AST fAst;
        private final Map fRewrites;

        public VisibilityAdjustingArgumentFactory(AST ast, Map rewrites, Map adjustments) {
            Assert.isNotNull((Object)ast);
            Assert.isNotNull((Object)rewrites);
            Assert.isNotNull((Object)adjustments);
            this.fAst = ast;
            this.fRewrites = rewrites;
            this.fAdjustments = adjustments;
        }

        protected final void adjustTypeVisibility(ITypeBinding binding) throws JavaScriptModelException {
            IType type;
            Assert.isNotNull((Object)binding);
            IJavaScriptElement element = binding.getJavaElement();
            if (element instanceof IType && !(type = (IType)element).isBinary() && !type.isReadOnly() && !Flags.isPublic((int)type.getFlags())) {
                boolean same = false;
                CompilationUnitRewrite rewrite = MoveInstanceMethodProcessor.this.getCompilationUnitRewrite(this.fRewrites, type.getJavaScriptUnit());
                AbstractTypeDeclaration declaration = ASTNodeSearchUtil.getAbstractTypeDeclarationNode(type, rewrite.getRoot());
                if (declaration != null) {
                    ITypeBinding declaring = declaration.resolveBinding();
                    if (declaring != null && Bindings.equals((IBinding)binding.getPackage(), (IBinding)MoveInstanceMethodProcessor.this.fTarget.getType().getPackage())) {
                        same = true;
                    }
                    Modifier.ModifierKeyword keyword = same ? null : Modifier.ModifierKeyword.PUBLIC_KEYWORD;
                    String modifier = same ? RefactoringCoreMessages.MemberVisibilityAdjustor_change_visibility_default : RefactoringCoreMessages.MemberVisibilityAdjustor_change_visibility_public;
                    if (MemberVisibilityAdjustor.hasLowerVisibility(binding.getModifiers(), same ? 0 : (keyword == null ? 0 : keyword.toFlagValue())) && MemberVisibilityAdjustor.needsVisibilityAdjustments((IMember)type, keyword, this.fAdjustments)) {
                        this.fAdjustments.put(type, new MemberVisibilityAdjustor.OutgoingMemberVisibilityAdjustment((IMember)type, keyword, RefactoringStatus.createWarningStatus((String)Messages.format(RefactoringCoreMessages.MemberVisibilityAdjustor_change_visibility_type_warning, new String[]{BindingLabelProvider.getBindingLabel((IBinding)declaration.resolveBinding(), JavaScriptElementLabels.ALL_FULLY_QUALIFIED), modifier}), (RefactoringStatusContext)JavaStatusContext.create((ITypeRoot)type.getJavaScriptUnit(), (ASTNode)declaration))));
                    }
                }
            }
        }

        public ASTNode getArgumentNode(IVariableBinding binding, boolean last) throws JavaScriptModelException {
            Assert.isNotNull((Object)binding);
            this.adjustTypeVisibility(binding.getType());
            return this.fAst.newSimpleName(binding.getName());
        }

        public ASTNode getTargetNode() throws JavaScriptModelException {
            return this.fAst.newThisExpression();
        }
    }
}

