/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core;

public final class Flags {
    public static final int AccDefault = 0;
    public static final int AccPublic = 1;
    public static final int AccPrivate = 2;
    public static final int AccProtected = 4;
    public static final int AccStatic = 8;
    public static final int AccAbstract = 1024;
    public static final int AccSuper = 32;
    public static final int AccDeprecated = 0x100000;
    public static final int AccVarargs = 128;

    private Flags() {
    }

    public static boolean isAbstract(int flags) {
        return (flags & 0x400) != 0;
    }

    public static boolean isDeprecated(int flags) {
        return (flags & 0x100000) != 0;
    }

    public static boolean isPackageDefault(int flags) {
        return (flags & 7) == 0;
    }

    public static boolean isPrivate(int flags) {
        return (flags & 2) != 0;
    }

    public static boolean isProtected(int flags) {
        return (flags & 4) != 0;
    }

    public static boolean isPublic(int flags) {
        return (flags & 1) != 0;
    }

    public static boolean isStatic(int flags) {
        return (flags & 8) != 0;
    }

    public static boolean isSuper(int flags) {
        return (flags & 0x20) != 0;
    }

    public static boolean isVarargs(int flags) {
        return (flags & 0x80) != 0;
    }

    public static String toString(int flags) {
        int len;
        StringBuffer sb = new StringBuffer();
        if (Flags.isPublic(flags)) {
            sb.append("public ");
        }
        if (Flags.isPrivate(flags)) {
            sb.append("private ");
        }
        if (Flags.isStatic(flags)) {
            sb.append("static ");
        }
        if (Flags.isAbstract(flags)) {
            sb.append("abstract ");
        }
        if ((len = sb.length()) == 0) {
            return "";
        }
        sb.setLength(len - 1);
        return sb.toString();
    }
}

