/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.util;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.wst.jsdt.core.IAccessRule;
import org.eclipse.wst.jsdt.core.IIncludePathAttribute;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.LibrarySuperType;
import org.eclipse.wst.jsdt.internal.core.JavaProject;
import org.eclipse.wst.jsdt.internal.core.util.DefaultSourcePathProvider;
import org.eclipse.wst.jsdt.internal.core.util.Messages;
import org.osgi.framework.Bundle;

public class ConvertUtility {
    private static final String[] NATURE_IDS = new String[]{"org.eclipse.wst.jsdt.core.jsNature"};
    private static final String SYSTEM_LIBRARY = "org.eclipse.wst.jsdt.launching.JRE_CONTAINER";
    private static final String SYSTEM_SUPER_TYPE_NAME = "Global";
    private static final String BROWSER_LIBRARY = "org.eclipse.wst.jsdt.launching.baseBrowserLibrary";
    public static final IPath BROWSER_LIBRARY_PATH = new Path("org.eclipse.wst.jsdt.launching.baseBrowserLibrary");
    private static final String BROWSER_SUPER_TYPE_NAME = "Window";
    public static final String VIRTUAL_CONTAINER = "org.eclipse.wst.jsdt.launching.WebProject";
    public static final IIncludePathEntry VIRTUAL_SCOPE_ENTRY = JavaScriptCore.newContainerEntry((IPath)new Path("org.eclipse.wst.jsdt.launching.WebProject"), new IAccessRule[0], new IIncludePathAttribute[]{IIncludePathAttribute.HIDE}, false);
    private boolean DEBUG = false;
    private IProject fCurrProject;
    private JavaProject fJavaProject;
    private IPath fOutputLocation;

    static void addJsNature(IProject project, IProgressMonitor monitor) throws CoreException {
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (!ConvertUtility.hasNature(project)) {
            IProjectDescription description = project.getDescription();
            String[] prevNatures = description.getNatureIds();
            String[] newNatures = new String[prevNatures.length + NATURE_IDS.length];
            System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
            int i = 0;
            while (i < NATURE_IDS.length) {
                newNatures[prevNatures.length + i] = NATURE_IDS[i];
                ++i;
            }
            description.setNatureIds(newNatures);
            project.setDescription(description, monitor);
        } else if (monitor != null) {
            monitor.worked(1);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasNature(IProject project) {
        try {
            int i = 0;
            while (true) {
                if (i >= NATURE_IDS.length) {
                    return true;
                }
                if (!project.hasNature(NATURE_IDS[i])) {
                    return false;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    static void removeJsNature(IProject project, IProgressMonitor monitor) throws CoreException {
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (ConvertUtility.hasNature(project)) {
            IProjectDescription description = project.getDescription();
            String[] prevNatures = description.getNatureIds();
            String[] newNatures = new String[prevNatures.length - NATURE_IDS.length];
            int k = 0;
            int i = 0;
            while (i < prevNatures.length) {
                block7: {
                    int j = 0;
                    while (j < NATURE_IDS.length) {
                        if (!prevNatures[i].equals(NATURE_IDS[j])) {
                            ++j;
                            continue;
                        }
                        break block7;
                    }
                    newNatures[k++] = prevNatures[i];
                }
                ++i;
            }
            description.setNatureIds(newNatures);
            project.setDescription(description, monitor);
        } else if (monitor != null) {
            monitor.worked(1);
        }
    }

    public ConvertUtility(IProject project) {
        this.fCurrProject = project;
        this.fOutputLocation = this.fCurrProject.getFullPath();
    }

    private IProgressMonitor monitorFor(IProgressMonitor monitor) {
        if (monitor != null) {
            return monitor;
        }
        return new NullProgressMonitor();
    }

    public void addBrowserSupport(boolean changeSuperType, IProgressMonitor monitor) throws CoreException {
        IProgressMonitor progressMonitor = this.monitorFor(monitor);
        progressMonitor.beginTask(Messages.converter_ConfiguringForBrowser, 2);
        this.fJavaProject = (JavaProject)JavaScriptCore.create(this.fCurrProject);
        if (!this.fJavaProject.exists()) {
            this.configure((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
        }
        this.fJavaProject.setProject(this.fCurrProject);
        IIncludePathEntry[] includePath = this.getRawClassPath();
        includePath = this.addEntry(includePath, VIRTUAL_SCOPE_ENTRY, false);
        includePath = this.addEntry(includePath, JavaScriptCore.newContainerEntry(BROWSER_LIBRARY_PATH), false);
        try {
            if (!this.hasProjectClassPathFile()) {
                this.fJavaProject.setRawIncludepath(includePath, this.fOutputLocation, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
            } else {
                this.fJavaProject.setRawIncludepath(includePath, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        if (changeSuperType) {
            LibrarySuperType superType = new LibrarySuperType(BROWSER_LIBRARY_PATH, (IJavaScriptProject)this.getJavaScriptProject(), BROWSER_SUPER_TYPE_NAME);
            this.getJavaScriptProject().setCommonSuperType(superType);
        }
        progressMonitor.done();
    }

    private IIncludePathEntry[] addEntry(IIncludePathEntry[] entries, IIncludePathEntry newEntry, boolean first) {
        int i = 0;
        while (i < entries.length) {
            if (newEntry.getPath().equals((Object)entries[i].getPath())) {
                return entries;
            }
            ++i;
        }
        ArrayList<IIncludePathEntry> entriesList = new ArrayList<IIncludePathEntry>(Arrays.asList(entries));
        if (first && !entriesList.isEmpty()) {
            entriesList.add(0, newEntry);
        } else {
            entriesList.add(newEntry);
        }
        return entriesList.toArray(new IIncludePathEntry[entriesList.size()]);
    }

    private IIncludePathEntry[] addSystemEntry(IIncludePathEntry[] entries) {
        IIncludePathEntry defaultJRELibrary;
        block4: {
            defaultJRELibrary = this.createRuntimeEntry();
            try {
                int i = 0;
                while (i < entries.length) {
                    if (defaultJRELibrary.equals(entries[i])) {
                        return entries;
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                if (!this.DEBUG) break block4;
                System.out.println("Error checking system library in include path:" + e);
            }
        }
        return this.addEntry(entries, defaultJRELibrary, false);
    }

    public void configure(IProgressMonitor monitor) throws CoreException {
        IProgressMonitor progressMonitor = this.monitorFor(monitor);
        progressMonitor.beginTask("", 2);
        ConvertUtility.addJsNature(this.fCurrProject, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
        this.fJavaProject = (JavaProject)JavaScriptCore.create(this.fCurrProject);
        this.fJavaProject.setProject(this.fCurrProject);
        IIncludePathEntry[] includePath = this.getRawClassPath();
        includePath = this.addSystemEntry(includePath);
        try {
            if (!this.hasProjectClassPathFile()) {
                this.fJavaProject.setRawIncludepath(includePath, this.fOutputLocation, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
            } else {
                this.fJavaProject.setRawIncludepath(includePath, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        LibrarySuperType superType = new LibrarySuperType((IPath)new Path(SYSTEM_LIBRARY), (IJavaScriptProject)this.getJavaScriptProject(), SYSTEM_SUPER_TYPE_NAME);
        this.getJavaScriptProject().setCommonSuperType(superType);
        progressMonitor.done();
    }

    private IIncludePathEntry createRuntimeEntry() {
        return JavaScriptCore.newContainerEntry((IPath)new Path(SYSTEM_LIBRARY));
    }

    private JavaProject getJavaScriptProject() {
        if (this.fJavaProject == null) {
            this.fJavaProject = (JavaProject)JavaScriptCore.create(this.fCurrProject);
            this.fJavaProject.setProject(this.fCurrProject);
        }
        return this.fJavaProject;
    }

    public IProject getProject() {
        return this.fCurrProject;
    }

    public IIncludePathEntry[] getDefaultSourcePaths(IProject p) {
        IIncludePathEntry[] defaults;
        block5: {
            defaults = new IIncludePathEntry[]{JavaScriptCore.newSourceEntry(p.getFullPath())};
            try {
                IConfigurationElement[] configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.wst.jsdt.core.sourcePathProvider");
                ArrayList<IIncludePathEntry> provided = new ArrayList<IIncludePathEntry>();
                int i = 0;
                while (i < configurationElements.length) {
                    DefaultSourcePathProvider provider = (DefaultSourcePathProvider)configurationElements[i].createExecutableExtension("class");
                    if (provider != null) {
                        provided.addAll(Arrays.asList(provider.getDefaultSourcePaths(p)));
                    }
                    ++i;
                }
                if (!provided.isEmpty()) {
                    return provided.toArray(new IIncludePathEntry[provided.size()]);
                }
            }
            catch (Exception e) {
                if (!Platform.inDebugMode()) break block5;
                Platform.getLog((Bundle)JavaScriptCore.getPlugin().getBundle()).log((IStatus)new Status(4, "org.eclipse.wst.jsdt.core", "Problem getting source paths", (Throwable)e));
            }
        }
        return defaults;
    }

    private IIncludePathEntry[] getRawClassPath() {
        JavaProject proj = new JavaProject();
        proj.setProject(this.fCurrProject);
        return proj.readRawIncludepath();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasAValidSourcePath() {
        if (!this.hasProjectClassPathFile()) return false;
        try {
            IIncludePathEntry[] entries = this.getRawClassPath();
            int i = 0;
            while (true) {
                if (i >= entries.length) {
                    return false;
                }
                if (entries[i].getEntryKind() == 3) {
                    return true;
                }
                ++i;
            }
        }
        catch (Exception e) {
            if (!this.DEBUG) return false;
            System.out.println("Error checking sourcepath:" + e);
        }
        return false;
    }

    private boolean hasProjectClassPathFile() {
        if (this.fCurrProject == null) {
            return false;
        }
        return this.fCurrProject.getFolder(".settings").getFile(".jsdtscope").exists();
    }
}

