/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets;

import java.util.Iterator;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.ArrayType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.EnumeratedTypeSet;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.SubTypesOfSingleton;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.SuperTypesSet;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.TypeSet;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.TypeSetIntersection;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.TTypes;

public class SubTypesSet
extends TypeSet {
    private TypeSet fUpperBounds;
    private EnumeratedTypeSet fEnumCache = null;

    SubTypesSet(TypeSet superTypes) {
        super(superTypes.getTypeSetEnvironment());
        this.fUpperBounds = superTypes;
    }

    public boolean isUniverse() {
        return this.fUpperBounds.isUniverse() || this.fUpperBounds.contains(this.getJavaLangObject());
    }

    public TypeSet makeClone() {
        return this;
    }

    public boolean equals(Object o) {
        if (o instanceof SubTypesSet) {
            SubTypesSet other = (SubTypesSet)o;
            return other.fUpperBounds.equals(this.fUpperBounds);
        }
        return false;
    }

    protected TypeSet specialCasesIntersectedWith(TypeSet s2) {
        TypeSet myUpperSubTypes;
        TType t2;
        TType t1;
        TypeSet st2;
        if (this.fUpperBounds.equals(s2)) {
            return s2;
        }
        if (s2 instanceof SubTypesSet) {
            st2 = (SubTypesSet)s2;
            if (this.fUpperBounds.isSingleton() && ((SubTypesSet)st2).fUpperBounds.isSingleton()) {
                t1 = this.fUpperBounds.anyMember();
                t2 = ((SubTypesSet)st2).fUpperBounds.anyMember();
                if (TTypes.canAssignTo(t2, t1)) {
                    return new SubTypesSet(((SubTypesSet)st2).fUpperBounds);
                }
            } else if (this.fUpperBounds instanceof SubTypesSet && ((SubTypesSet)(myUpperSubTypes = (SubTypesSet)this.fUpperBounds)).lowerBound().equals(((SubTypesSet)st2).lowerBound())) {
                return st2;
            }
        }
        if (s2 instanceof SubTypesOfSingleton) {
            st2 = (SubTypesOfSingleton)s2;
            if (this.fUpperBounds.isSingleton()) {
                t1 = this.fUpperBounds.anyMember();
                t2 = ((SubTypesOfSingleton)st2).uniqueUpperBound();
                if (TTypes.canAssignTo(t2, t1)) {
                    return this.getTypeSetEnvironment().createSubTypesOfSingleton(t2);
                }
            } else if (this.fUpperBounds instanceof SubTypesOfSingleton && ((SubTypesOfSingleton)(myUpperSubTypes = (SubTypesOfSingleton)this.fUpperBounds)).uniqueLowerBound().equals(((SubTypesOfSingleton)st2).uniqueLowerBound())) {
                return st2;
            }
        }
        if (s2 instanceof SuperTypesSet) {
            st2 = (SuperTypesSet)s2;
            if (this.fUpperBounds.equals(((SuperTypesSet)st2).lowerBound())) {
                return this.fUpperBounds;
            }
            if (this.fUpperBounds instanceof TypeSetIntersection) {
                TypeSetIntersection lbXSect = (TypeSetIntersection)this.fUpperBounds;
                TypeSet xsectLeft = lbXSect.getLHS();
                TypeSet xsectRight = lbXSect.getRHS();
                if (xsectLeft.equals(((SuperTypesSet)st2).lowerBound())) {
                    return new TypeSetIntersection(s2, new SubTypesSet(xsectRight));
                }
            }
        }
        return null;
    }

    public TypeSet subTypes() {
        return this;
    }

    public boolean isEmpty() {
        return this.fUpperBounds.isEmpty();
    }

    public boolean contains(TType t) {
        if (this.fEnumCache != null) {
            return this.fEnumCache.contains(t);
        }
        if (this.fUpperBounds.contains(t)) {
            return true;
        }
        Iterator ubIter = this.fUpperBounds.upperBound().iterator();
        while (ubIter.hasNext()) {
            TType ub = (TType)ubIter.next();
            if (!TTypes.canAssignTo(t, ub)) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(TypeSet s) {
        if (this.fEnumCache != null) {
            return this.fEnumCache.containsAll(s);
        }
        if (this.fUpperBounds.containsAll(s)) {
            return true;
        }
        Iterator sIter = s.iterator();
        while (sIter.hasNext()) {
            TType t = (TType)sIter.next();
            boolean found = false;
            Iterator ubIter = this.fUpperBounds.iterator();
            while (ubIter.hasNext()) {
                TType ub = (TType)ubIter.next();
                if (!TTypes.canAssignTo(t, ub)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private TType getElementTypeOf(TType t) {
        if (t instanceof ArrayType) {
            return ((ArrayType)t).getElementType();
        }
        return t;
    }

    public boolean isSingleton() {
        if (!this.fUpperBounds.isSingleton()) {
            return false;
        }
        TType t = this.fUpperBounds.anyMember();
        return this.getElementTypeOf(t).getSubTypes().length == 0;
    }

    public TType anyMember() {
        return this.fUpperBounds.anyMember();
    }

    public TypeSet upperBound() {
        return this.fUpperBounds;
    }

    public TypeSet lowerBound() {
        return this.enumerate().lowerBound();
    }

    public Iterator iterator() {
        return this.enumerate().iterator();
    }

    public String toString() {
        return "<" + this.fID + ": subTypes(" + this.fUpperBounds + ")>";
    }

    public boolean hasUniqueLowerBound() {
        return false;
    }

    public boolean hasUniqueUpperBound() {
        return this.fUpperBounds.isSingleton();
    }

    public TType uniqueLowerBound() {
        return null;
    }

    public TType uniqueUpperBound() {
        return this.fUpperBounds.isSingleton() ? this.fUpperBounds.anyMember() : null;
    }

    public EnumeratedTypeSet enumerate() {
        if (this.fEnumCache == null) {
            this.fEnumCache = new EnumeratedTypeSet(this.getTypeSetEnvironment());
            Iterator iter = this.fUpperBounds.iterator();
            while (iter.hasNext()) {
                TType ub = (TType)iter.next();
                if (ub instanceof ArrayType) {
                    ArrayType at = (ArrayType)ub;
                    int numDims = at.getDimensions();
                    Iterator elemSubIter = TTypes.getAllSubTypesIterator(at.getElementType());
                    while (elemSubIter.hasNext()) {
                        this.fEnumCache.add(TTypes.createArrayType((TType)elemSubIter.next(), numDims));
                    }
                } else {
                    Iterator iterator = TTypes.getAllSubTypesIterator(ub);
                    while (iterator.hasNext()) {
                        this.fEnumCache.fMembers.add(iterator.next());
                    }
                }
                this.fEnumCache.add(ub);
            }
        }
        return this.fEnumCache;
    }
}

