/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.buildpath;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptModelStatus;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaScriptConventions;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.corext.buildpath.BuildpathDelta;
import org.eclipse.wst.jsdt.internal.corext.buildpath.CPJavaProject;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElement;

public class ClasspathModifier {
    private ClasspathModifier() {
    }

    public static BuildpathDelta removeFromBuildpath(CPListElement[] toRemove, CPJavaProject cpProject) {
        IJavaScriptProject javaScriptProject = cpProject.getJavaProject();
        IPath projectPath = javaScriptProject.getPath();
        IWorkspaceRoot workspaceRoot = javaScriptProject.getProject().getWorkspace().getRoot();
        List existingEntries = cpProject.getCPListElements();
        BuildpathDelta result = new BuildpathDelta(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_RemoveFromCP_tooltip);
        int i = 0;
        while (i < toRemove.length) {
            IResource member;
            CPListElement element = toRemove[i];
            existingEntries.remove(element);
            result.removeEntry(element);
            IPath path = element.getPath();
            ClasspathModifier.removeFilters(path, javaScriptProject, existingEntries);
            if (!path.equals((Object)projectPath) && (member = workspaceRoot.findMember(path)) != null) {
                result.addDeletedResource(member);
            }
            ++i;
        }
        result.setNewEntries(existingEntries.toArray(new CPListElement[existingEntries.size()]));
        return result;
    }

    public static List getExistingEntries(IJavaScriptProject project) throws JavaScriptModelException {
        IIncludePathEntry[] classpathEntries = project.getRawIncludepath();
        ArrayList<CPListElement> newClassPath = new ArrayList<CPListElement>();
        int i = 0;
        while (i < classpathEntries.length) {
            IIncludePathEntry curr = classpathEntries[i];
            newClassPath.add(CPListElement.createFromExisting(curr, project));
            ++i;
        }
        return newClassPath;
    }

    public static CPListElement getClasspathEntry(List elements, IPackageFragmentRoot root) throws JavaScriptModelException {
        IIncludePathEntry entry = root.getRawIncludepathEntry();
        int i = 0;
        while (i < elements.size()) {
            CPListElement element = (CPListElement)elements.get(i);
            if (element.getPath().equals((Object)root.getPath()) && element.getEntryKind() == entry.getEntryKind()) {
                return (CPListElement)elements.get(i);
            }
            ++i;
        }
        CPListElement newElement = CPListElement.createFromExisting(entry, root.getJavaScriptProject());
        elements.add(newElement);
        return newElement;
    }

    public static IPackageFragmentRoot getFragmentRoot(IResource resource, IJavaScriptProject project, IProgressMonitor monitor) throws JavaScriptModelException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        IJavaScriptElement javaElem = null;
        if (resource.getFullPath().equals((Object)project.getPath())) {
            return project.getPackageFragmentRoot(resource);
        }
        IContainer container = resource.getParent();
        do {
            if (container instanceof IFolder) {
                javaElem = JavaScriptCore.create((IFolder)((IFolder)container));
            }
            if (container.getFullPath().equals((Object)project.getPath())) {
                javaElem = project;
                break;
            }
            if ((container = container.getParent()) != null) continue;
            return null;
        } while (javaElem == null || !(javaElem instanceof IPackageFragmentRoot));
        if (javaElem instanceof IJavaScriptProject) {
            if (!ClasspathModifier.isSourceFolder((IJavaScriptProject)javaElem)) {
                return null;
            }
            javaElem = project.getPackageFragmentRoot(project.getResource());
        }
        return (IPackageFragmentRoot)javaElem;
    }

    public static IIncludePathEntry getClasspathEntryFor(IPath path, IJavaScriptProject project, int entryKind) throws JavaScriptModelException {
        IIncludePathEntry[] entries = project.getRawIncludepath();
        int i = 0;
        while (i < entries.length) {
            IIncludePathEntry entry = entries[i];
            if (entry.getPath().equals((Object)path) && ClasspathModifier.equalEntryKind(entry, entryKind)) {
                return entry;
            }
            ++i;
        }
        return null;
    }

    public static boolean isIncluded(IJavaScriptElement selection, IJavaScriptProject project, IProgressMonitor monitor) throws JavaScriptModelException {
        IIncludePathEntry entry;
        IPackageFragmentRoot root;
        block4: {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            try {
                monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_ContainsPath, 4);
                root = (IPackageFragmentRoot)selection.getAncestor(3);
                entry = root.getRawIncludepathEntry();
                if (entry != null) break block4;
                Object var5_5 = null;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                monitor.done();
                throw throwable;
            }
            monitor.done();
            return false;
        }
        boolean bl = ClasspathModifier.contains(selection.getPath().removeFirstSegments(root.getPath().segmentCount()), entry.getInclusionPatterns(), (IProgressMonitor)new SubProgressMonitor(monitor, 2));
        Object var5_6 = null;
        monitor.done();
        return bl;
    }

    public static boolean isExcluded(IResource resource, IJavaScriptProject project) throws JavaScriptModelException {
        IPackageFragmentRoot root = ClasspathModifier.getFragmentRoot(resource, project, null);
        if (root == null) {
            return false;
        }
        String fragmentName = ClasspathModifier.getName(resource.getFullPath(), root.getPath());
        fragmentName = ClasspathModifier.completeName(fragmentName);
        IIncludePathEntry entry = root.getRawIncludepathEntry();
        return entry != null && ClasspathModifier.contains((IPath)new Path(fragmentName), entry.getExclusionPatterns(), null);
    }

    /*
     * Unable to fully structure code
     */
    public static boolean parentExcluded(IResource resource, IJavaScriptProject project) throws JavaScriptModelException {
        if (resource.getFullPath().equals((Object)project.getPath())) {
            return false;
        }
        root = ClasspathModifier.getFragmentRoot(resource, project, null);
        if (root == null) {
            return true;
        }
        path = resource.getFullPath().removeFirstSegments(root.getPath().segmentCount());
        entry = root.getRawIncludepathEntry();
        if (entry != null) ** GOTO lbl13
        return true;
lbl-1000:
        // 1 sources

        {
            if (ClasspathModifier.contains(path, entry.getExclusionPatterns(), null)) {
                return true;
            }
            path = path.removeLastSegments(1);
lbl13:
            // 2 sources

            ** while (path.segmentCount() > 0)
        }
lbl14:
        // 1 sources

        return false;
    }

    public static String escapeSpecialChars(String value) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < value.length()) {
            char c = value.charAt(i);
            switch (c) {
                case '&': {
                    buf.append("&amp;");
                    break;
                }
                case '<': {
                    buf.append("&lt;");
                    break;
                }
                case '>': {
                    buf.append("&gt;");
                    break;
                }
                case '\'': {
                    buf.append("&apos;");
                    break;
                }
                case '\"': {
                    buf.append("&quot;");
                    break;
                }
                case '\u00a0': {
                    buf.append(" ");
                    break;
                }
                default: {
                    buf.append(c);
                }
            }
            ++i;
        }
        return buf.toString();
    }

    public static boolean isSourceFolder(IJavaScriptProject project) throws JavaScriptModelException {
        return ClasspathModifier.getClasspathEntryFor(project.getPath(), project, 3) != null;
    }

    public static boolean isDefaultFragment(IPackageFragment fragment) {
        return fragment.getElementName().length() == 0;
    }

    public static boolean includeFiltersEmpty(IResource resource, IJavaScriptProject project, IProgressMonitor monitor) throws JavaScriptModelException {
        block4: {
            boolean bl;
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            try {
                monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_ExamineInputFilters, 4);
                IPackageFragmentRoot root = ClasspathModifier.getFragmentRoot(resource, project, (IProgressMonitor)new SubProgressMonitor(monitor, 4));
                if (root == null) break block4;
                IIncludePathEntry entry = root.getRawIncludepathEntry();
                bl = entry.getInclusionPatterns().length == 0;
                Object var5_6 = null;
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                monitor.done();
                throw throwable;
            }
            monitor.done();
            return bl;
        }
        Object var5_7 = null;
        monitor.done();
        return true;
    }

    public static boolean filtersSet(IPackageFragmentRoot root) throws JavaScriptModelException {
        if (root == null) {
            return false;
        }
        IIncludePathEntry entry = root.getRawIncludepathEntry();
        IPath[] inclusions = entry.getInclusionPatterns();
        IPath[] exclusions = entry.getExclusionPatterns();
        if (inclusions != null && inclusions.length > 0) {
            return true;
        }
        return exclusions != null && exclusions.length > 0;
    }

    public static CPListElement addToClasspath(IResource resource, List existingEntries, List newEntries, IJavaScriptProject project, IProgressMonitor monitor) throws OperationCanceledException, CoreException {
        CPListElement cPListElement;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            CPListElement entry;
            monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_AddToBuildpath, 2);
            ClasspathModifier.exclude(resource.getFullPath(), existingEntries, newEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            cPListElement = entry = new CPListElement(project, 3, resource.getFullPath(), resource);
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
        return cPListElement;
    }

    public static CPListElement addToClasspath(IJavaScriptElement javaElement, List existingEntries, List newEntries, IJavaScriptProject project, IProgressMonitor monitor) throws OperationCanceledException, CoreException {
        CPListElement cPListElement;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            CPListElement entry;
            monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_AddToBuildpath, 10);
            cPListElement = entry = new CPListElement(project, 3, javaElement.getPath(), javaElement.getResource());
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
        return cPListElement;
    }

    public static IJavaScriptProject removeFromClasspath(IJavaScriptProject project, List existingEntries, IProgressMonitor monitor) {
        CPListElement elem = ClasspathModifier.getListElement(project.getPath(), existingEntries);
        if (elem != null) {
            existingEntries.remove(elem);
        }
        return project;
    }

    public static List removeFilters(IPath path, IJavaScriptProject project, List existingEntries) {
        if (path == null) {
            return Collections.EMPTY_LIST;
        }
        IPath projPath = project.getPath();
        if (projPath.isPrefixOf(path)) {
            path = path.removeFirstSegments(projPath.segmentCount()).addTrailingSeparator();
        }
        ArrayList<CPListElement> result = new ArrayList<CPListElement>();
        Iterator iter = existingEntries.iterator();
        while (iter.hasNext()) {
            IPath[] inclusion;
            CPListElement element = (CPListElement)iter.next();
            boolean hasChange = false;
            IPath[] exlusions = (IPath[])element.getAttribute("exclusion");
            if (exlusions != null) {
                ArrayList<IPath> exlusionList = new ArrayList<IPath>(exlusions.length);
                int i = 0;
                while (i < exlusions.length) {
                    if (!exlusions[i].equals((Object)path)) {
                        exlusionList.add(exlusions[i]);
                    } else {
                        hasChange = true;
                    }
                    ++i;
                }
                element.setAttribute("exclusion", exlusionList.toArray(new IPath[exlusionList.size()]));
            }
            if ((inclusion = (IPath[])element.getAttribute("inclusion")) != null) {
                ArrayList<IPath> inclusionList = new ArrayList<IPath>(inclusion.length);
                int i = 0;
                while (i < inclusion.length) {
                    if (!inclusion[i].equals((Object)path)) {
                        inclusionList.add(inclusion[i]);
                    } else {
                        hasChange = true;
                    }
                    ++i;
                }
                element.setAttribute("inclusion", inclusionList.toArray(new IPath[inclusionList.size()]));
            }
            if (!hasChange) continue;
            result.add(element);
        }
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static IResource exclude(String name, IPath fullPath, CPListElement entry, IJavaScriptProject project, IProgressMonitor monitor) throws JavaScriptModelException {
        IResource result;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_Excluding, 6);
            IPath[] excludedPath = (IPath[])entry.getAttribute("exclusion");
            IPath[] newExcludedPath = new IPath[excludedPath.length + 1];
            name = ClasspathModifier.completeName(name);
            Path path = new Path(name);
            if (!ClasspathModifier.contains((IPath)path, excludedPath, (IProgressMonitor)new SubProgressMonitor(monitor, 2))) {
                System.arraycopy(excludedPath, 0, newExcludedPath, 0, excludedPath.length);
                newExcludedPath[excludedPath.length] = path;
                entry.setAttribute("exclusion", newExcludedPath);
                entry.setAttribute("inclusion", ClasspathModifier.remove((IPath)path, (IPath[])entry.getAttribute("inclusion"), (IProgressMonitor)new SubProgressMonitor(monitor, 4)));
            }
            result = fullPath == null ? null : ClasspathModifier.getResource(fullPath, project);
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var9_11 = null;
        }
        monitor.done();
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void exclude(IPath path, List existingEntries, List newEntries, IJavaScriptProject project, IProgressMonitor monitor) throws JavaScriptModelException {
        block8: {
            block7: {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                try {
                    IPath rootPath;
                    monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_Excluding, 1);
                    CPListElement elem = null;
                    CPListElement existingElem = null;
                    int i = 0;
                    do {
                        if ((rootPath = path.removeLastSegments(++i)).segmentCount() == 0) {
                            Object var9_9 = null;
                            break block7;
                        }
                        elem = ClasspathModifier.getListElement(rootPath, newEntries);
                    } while ((existingElem = ClasspathModifier.getListElement(rootPath, existingEntries)) == null && elem == null);
                    if (elem == null) {
                        elem = existingElem;
                    }
                    ClasspathModifier.exclude(path.removeFirstSegments(path.segmentCount() - i).toString(), null, elem, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    break block8;
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    monitor.done();
                    throw throwable;
                }
            }
            monitor.done();
            return;
        }
        Object var9_11 = null;
        monitor.done();
    }

    public static IResource exclude(IJavaScriptElement javaElement, CPListElement entry, IJavaScriptProject project, IProgressMonitor monitor) throws JavaScriptModelException {
        IResource iResource;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            String name = ClasspathModifier.getName(javaElement.getPath(), entry.getPath());
            iResource = ClasspathModifier.exclude(name, javaElement.getPath(), entry, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
        return iResource;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void unExclude(IResource resource, CPListElement entry, IJavaScriptProject project, IProgressMonitor monitor) throws JavaScriptModelException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_RemoveExclusion, 10);
            String name = ClasspathModifier.getName(resource.getFullPath(), entry.getPath());
            IPath[] excludedPath = (IPath[])entry.getAttribute("exclusion");
            IPath[] newExcludedPath = ClasspathModifier.remove((IPath)new Path(ClasspathModifier.completeName(name)), excludedPath, (IProgressMonitor)new SubProgressMonitor(monitor, 3));
            entry.setAttribute("exclusion", newExcludedPath);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        monitor.done();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void resetFilters(IJavaScriptElement element, CPListElement entry, IJavaScriptProject project, IProgressMonitor monitor) throws JavaScriptModelException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_ResetFilters, 3);
            List exclusionList = ClasspathModifier.getFoldersOnCP(element.getPath(), project, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
            IPath[] exclusions = exclusionList.toArray(new IPath[exclusionList.size()]);
            entry.setAttribute("inclusion", new IPath[0]);
            entry.setAttribute("exclusion", exclusions);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        monitor.done();
    }

    public static CPListElement getClasspathEntry(List elements, CPListElement cpElement) {
        int i = 0;
        while (i < elements.size()) {
            if (((CPListElement)elements.get(i)).getPath().equals((Object)cpElement.getPath())) {
                return (CPListElement)elements.get(i);
            }
            ++i;
        }
        elements.add(cpElement);
        return cpElement;
    }

    public static CPListElement getListElement(IPath path, List elements) {
        int i = 0;
        while (i < elements.size()) {
            CPListElement element = (CPListElement)elements.get(i);
            if (element.getEntryKind() == 3 && element.getPath().equals((Object)path)) {
                return element;
            }
            ++i;
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void commitClassPath(List newEntries, IJavaScriptProject project, IProgressMonitor monitor) throws JavaScriptModelException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("", 2);
        try {
            IIncludePathEntry[] entries = ClasspathModifier.convert(newEntries);
            IJavaScriptModelStatus status = JavaScriptConventions.validateClasspath((IJavaScriptProject)project, (IIncludePathEntry[])entries);
            if (!status.isOK()) {
                throw new JavaScriptModelException(status);
            }
            project.setRawIncludepath(entries, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        monitor.done();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void commitClassPath(CPJavaProject cpProject, IProgressMonitor monitor) throws JavaScriptModelException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("", 2);
        try {
            IIncludePathEntry[] entries = ClasspathModifier.convert(cpProject.getCPListElements());
            IJavaScriptModelStatus status = JavaScriptConventions.validateClasspath((IJavaScriptProject)cpProject.getJavaProject(), (IIncludePathEntry[])entries);
            if (!status.isOK()) {
                throw new JavaScriptModelException(status);
            }
            cpProject.getJavaProject().setRawIncludepath(entries, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        monitor.done();
    }

    public static List getCorrespondingElements(List entries, IJavaScriptProject project) {
        ArrayList<Object> result = new ArrayList<Object>();
        int i = 0;
        while (i < entries.size()) {
            Object element = entries.get(i);
            IPath path = element instanceof IResource ? ((IResource)element).getFullPath() : ((IJavaScriptElement)element).getPath();
            IResource resource = ClasspathModifier.getResource(path, project);
            if (resource != null) {
                IJavaScriptElement elem = JavaScriptCore.create((IResource)resource);
                if (elem != null && project.isOnIncludepath(elem)) {
                    result.add(elem);
                } else {
                    result.add(resource);
                }
            }
            ++i;
        }
        return result;
    }

    private static IResource getResource(IPath path, IJavaScriptProject project) {
        return project.getProject().getWorkspace().getRoot().findMember(path);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean contains(IPath path, IPath[] paths, IProgressMonitor monitor) {
        block9: {
            block8: {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                if (path == null) {
                    return false;
                }
                try {
                    monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_ComparePaths, paths.length);
                    if (path.getFileExtension() == null) {
                        path = new Path(ClasspathModifier.completeName(path.toString()));
                    }
                    int i = 0;
                    while (i < paths.length) {
                        if (paths[i].equals((Object)path)) {
                            Object var4_4 = null;
                            break block8;
                        }
                        monitor.worked(1);
                        ++i;
                    }
                    break block9;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    monitor.done();
                    throw throwable;
                }
            }
            monitor.done();
            return true;
        }
        Object var4_6 = null;
        monitor.done();
        return false;
    }

    private static String completeName(String name) {
        if (!JavaScriptCore.isJavaScriptLikeFileName((String)name)) {
            name = String.valueOf(name) + "/";
            name = name.replace('.', '/');
            return name;
        }
        return name;
    }

    private static IPath[] remove(IPath path, IPath[] paths, IProgressMonitor monitor) {
        IPath[] iPathArray;
        block6: {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_RemovePath, paths.length + 5);
            if (ClasspathModifier.contains(path, paths, (IProgressMonitor)new SubProgressMonitor(monitor, 5))) break block6;
            IPath[] iPathArray2 = paths;
            Object var5_5 = null;
            monitor.done();
            return iPathArray2;
        }
        try {
            ArrayList<IPath> newPaths = new ArrayList<IPath>();
            int i = 0;
            while (i < paths.length) {
                monitor.worked(1);
                if (!paths[i].equals((Object)path)) {
                    newPaths.add(paths[i]);
                }
                ++i;
            }
            iPathArray = newPaths.toArray(new IPath[newPaths.size()]);
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
        return iPathArray;
    }

    private static List getFoldersOnCP(IPath path, IJavaScriptProject project, IProgressMonitor monitor) throws JavaScriptModelException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        ArrayList<Path> srcFolders = new ArrayList<Path>();
        IIncludePathEntry[] cpEntries = project.getRawIncludepath();
        int i = 0;
        while (i < cpEntries.length) {
            IPath cpPath = cpEntries[i].getPath();
            if (path.isPrefixOf(cpPath) && path.segmentCount() + 1 == cpPath.segmentCount()) {
                srcFolders.add(new Path(ClasspathModifier.completeName(cpPath.lastSegment())));
            }
            ++i;
        }
        return srcFolders;
    }

    private static String getName(IPath path, IPath rootPath) {
        return path.removeFirstSegments(rootPath.segmentCount()).toString();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void setNewEntry(List existingEntries, List newEntries, IJavaScriptProject project, IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_SetNewEntry, existingEntries.size());
            int i = 0;
            while (i < newEntries.size()) {
                CPListElement entry = (CPListElement)newEntries.get(i);
                ClasspathModifier.validateAndAddEntry(entry, existingEntries, project);
                monitor.worked(1);
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        monitor.done();
    }

    private static IIncludePathEntry[] convert(List list) {
        IIncludePathEntry[] entries = new IIncludePathEntry[list.size()];
        int i = 0;
        while (i < list.size()) {
            CPListElement element = (CPListElement)list.get(i);
            entries[i] = element.getClasspathEntry();
            ++i;
        }
        return entries;
    }

    private static void validateAndAddEntry(CPListElement entry, List existingEntries, IJavaScriptProject project) throws CoreException {
        IPath path = entry.getPath();
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IStatus validate = workspaceRoot.getWorkspace().validatePath(path.toString(), 2);
        StatusInfo rootStatus = new StatusInfo();
        rootStatus.setOK();
        boolean isExternal = ClasspathModifier.isExternalArchiveOrLibrary(entry, project);
        if (!isExternal && validate.matches(4) && !project.getPath().equals((Object)path)) {
            rootStatus.setError(Messages.format(NewWizardMessages.NewSourceFolderWizardPage_error_InvalidRootName, validate.getMessage()));
            throw new CoreException((IStatus)rootStatus);
        }
        if (!isExternal && !project.getPath().equals((Object)path)) {
            IResource res = workspaceRoot.findMember(path);
            if (res != null) {
                if (res.getType() != 2 && res.getType() != 1) {
                    rootStatus.setError(NewWizardMessages.NewSourceFolderWizardPage_error_NotAFolder);
                    throw new CoreException((IStatus)rootStatus);
                }
            } else {
                IFileStore store;
                URI projLocation = project.getProject().getLocationURI();
                if (projLocation != null && (store = EFS.getStore((URI)projLocation).getChild(path)).fetchInfo().exists()) {
                    rootStatus.setError(NewWizardMessages.NewSourceFolderWizardPage_error_AlreadyExistingDifferentCase);
                    throw new CoreException((IStatus)rootStatus);
                }
            }
        }
        int i = 0;
        while (i < existingEntries.size()) {
            CPListElement curr = (CPListElement)existingEntries.get(i);
            if (curr.getEntryKind() == 3 && path.equals((Object)curr.getPath()) && !project.getPath().equals((Object)path)) {
                rootStatus.setError(NewWizardMessages.NewSourceFolderWizardPage_error_AlreadyExisting);
                throw new CoreException((IStatus)rootStatus);
            }
            ++i;
        }
        if (!isExternal && !entry.getPath().equals((Object)project.getPath())) {
            ClasspathModifier.exclude(entry.getPath(), existingEntries, new ArrayList(), project, null);
        }
        ClasspathModifier.insertAtEndOfCategory(entry, existingEntries);
        IIncludePathEntry[] entries = ClasspathModifier.convert(existingEntries);
        IJavaScriptModelStatus status = JavaScriptConventions.validateClasspath((IJavaScriptProject)project, (IIncludePathEntry[])entries);
        if (!status.isOK()) {
            rootStatus.setError(status.getMessage());
            throw new CoreException((IStatus)rootStatus);
        }
        if (ClasspathModifier.isSourceFolder(project) || project.getPath().equals((Object)path)) {
            rootStatus.setWarning(NewWizardMessages.NewSourceFolderWizardPage_warning_ReplaceSF);
            return;
        }
        rootStatus.setOK();
    }

    private static void insertAtEndOfCategory(CPListElement entry, List existingEntries) {
        int length = existingEntries.size();
        CPListElement[] elements = existingEntries.toArray(new CPListElement[length]);
        int i = 0;
        while (i < length && elements[i].getClasspathEntry().getEntryKind() != entry.getClasspathEntry().getEntryKind()) {
            ++i;
        }
        if (i < length) {
            ++i;
            while (i < length && elements[i].getClasspathEntry().getEntryKind() == entry.getClasspathEntry().getEntryKind()) {
                ++i;
            }
            existingEntries.add(i, entry);
            return;
        }
        switch (entry.getClasspathEntry().getEntryKind()) {
            case 3: {
                existingEntries.add(0, entry);
                break;
            }
            default: {
                existingEntries.add(entry);
            }
        }
    }

    private static boolean isExternalArchiveOrLibrary(CPListElement entry, IJavaScriptProject project) {
        if (entry.getEntryKind() == 1 || entry.getEntryKind() == 5) {
            return !(entry.getResource() instanceof IFolder);
        }
        return false;
    }

    private static boolean equalEntryKind(IIncludePathEntry entry, int kind) {
        return entry.getEntryKind() == kind;
    }
}

