/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.IMemberActionInfo;

class PullPushCheckboxTableViewer
extends CheckboxTableViewer {
    public PullPushCheckboxTableViewer(Table table) {
        super(table);
    }

    protected void doUpdateItem(Widget widget, Object element, boolean fullMap) {
        super.doUpdateItem(widget, element, fullMap);
        if (!(widget instanceof TableItem)) {
            return;
        }
        TableItem item = (TableItem)widget;
        IMemberActionInfo info = (IMemberActionInfo)element;
        item.setChecked(PullPushCheckboxTableViewer.getCheckState(info));
        Assert.isTrue((item.getChecked() == PullPushCheckboxTableViewer.getCheckState(info) ? 1 : 0) != 0);
    }

    protected void inputChanged(Object input, Object oldInput) {
        super.inputChanged(input, oldInput);
        this.setCheckState((IMemberActionInfo[])input);
    }

    private void setCheckState(IMemberActionInfo[] infos) {
        if (infos == null) {
            return;
        }
        int i = 0;
        while (i < infos.length) {
            IMemberActionInfo info = infos[i];
            this.setChecked(info, PullPushCheckboxTableViewer.getCheckState(info));
            ++i;
        }
    }

    private static boolean getCheckState(IMemberActionInfo info) {
        return info.isActive();
    }

    public void refresh() {
        int topIndex = this.getTable().getTopIndex();
        super.refresh();
        this.setCheckState((IMemberActionInfo[])this.getInput());
        if (topIndex < this.getTable().getItemCount()) {
            this.getTable().setTopIndex(topIndex);
        }
    }
}

