/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.reorg;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.ltk.core.refactoring.participants.ValidateEditChecker;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.participants.ResourceModifications;

public abstract class RefactoringModifications {
    private ResourceModifications fResourceModifications = new ResourceModifications();

    public ResourceModifications getResourceModifications() {
        return this.fResourceModifications;
    }

    public abstract RefactoringParticipant[] loadParticipants(RefactoringStatus var1, RefactoringProcessor var2, String[] var3, SharableParticipants var4);

    public abstract void buildDelta(IResourceChangeDescriptionFactory var1);

    public void buildValidateEdits(ValidateEditChecker checker) {
    }

    protected void createIncludingParents(IContainer container) {
        while (container != null && !container.exists() && !this.getResourceModifications().willExist((IResource)container)) {
            this.getResourceModifications().addCreate((IResource)container);
            container = container.getParent();
        }
    }

    protected IResource[] collectResourcesOfInterest(IPackageFragment source) throws CoreException {
        IJavaScriptElement[] children = source.getChildren();
        int childOfInterest = 5;
        if (source.getKind() == 2) {
            childOfInterest = 6;
        }
        ArrayList<Object> result = new ArrayList<Object>(children.length);
        int i = 0;
        while (i < children.length) {
            IJavaScriptElement child = children[i];
            if (child.getElementType() == childOfInterest && child.getResource() != null) {
                result.add(child.getResource());
            }
            ++i;
        }
        Object[] nonJavaResources = source.getNonJavaScriptResources();
        int i2 = 0;
        while (i2 < nonJavaResources.length) {
            Object element = nonJavaResources[i2];
            if (element instanceof IResource) {
                result.add(element);
            }
            ++i2;
        }
        return result.toArray(new IResource[result.size()]);
    }

    protected IFile getClasspathFile(IResource resource) {
        IProject project = resource.getProject();
        if (project == null) {
            return null;
        }
        IFolder rscPath = project.getFolder(".settings");
        IResource result = rscPath.findMember(".jsdtscope");
        if (result instanceof IFile) {
            return (IFile)result;
        }
        return null;
    }
}

