/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.eclipse.wst.server.ui.internal.Trace;

public class ImageResource {
    private static ImageRegistry imageRegistry;
    private static Map<String, ImageDescriptor> imageDescriptors;
    private static URL ICON_BASE_URL;
    private static final String URL_CLCL = "clcl16/";
    private static final String URL_CTOOL = "ctool16/";
    private static final String URL_ELCL = "elcl16/";
    private static final String URL_ETOOL = "etool16/";
    private static final String URL_DLCL = "dlcl16/";
    private static final String URL_DTOOL = "dtool16/";
    private static final String URL_OBJ = "obj16/";
    private static final String URL_OVR = "ovr16/";
    private static final String URL_WIZBAN = "wizban/";
    public static final String IMG_CLCL_START = "IMG_CLCL_START";
    public static final String IMG_CLCL_START_DEBUG = "IMG_CLCL_START_DEBUG";
    public static final String IMG_CLCL_START_PROFILE = "IMG_CLCL_START_PROFILE";
    public static final String IMG_CLCL_STOP = "IMG_CLCL_STOP";
    public static final String IMG_CLCL_PUBLISH = "IMG_CLCL_PUBLISH";
    public static final String IMG_CLCL_DISCONNECT = "IMG_CLCL_DISCONNECT";
    public static final String IMG_ELCL_START = "IMG_ELCL_START";
    public static final String IMG_ELCL_START_DEBUG = "IMG_ELCL_START_DEBUG";
    public static final String IMG_ELCL_START_PROFILE = "IMG_ELCL_START_PROFILE";
    public static final String IMG_ELCL_STOP = "IMG_ELCL_STOP";
    public static final String IMG_ELCL_PUBLISH = "IMG_ELCL_PUBLISH";
    public static final String IMG_ELCL_DISCONNECT = "IMG_ELCL_DISCONNECT";
    public static final String IMG_DLCL_START = "IMG_DLCL_START";
    public static final String IMG_DLCL_START_DEBUG = "IMG_DLCL_START_DEBUG";
    public static final String IMG_DLCL_START_PROFILE = "IMG_DLCL_START_PROFILE";
    public static final String IMG_DLCL_STOP = "IMG_DLCL_STOP";
    public static final String IMG_DLCL_PUBLISH = "IMG_DLCL_PUBLISH";
    public static final String IMG_DLCL_DISCONNECT = "IMG_DLCL_DISCONNECT";
    public static final String IMG_WIZBAN_NEW_RUNTIME = "newServerWiz";
    public static final String IMG_WIZBAN_NEW_SERVER = "newServerWiz";
    public static final String IMG_WIZBAN_SELECT_SERVER_CLIENT = "wizClient";
    public static final String IMG_WIZBAN_SELECT_SERVER = "selectServer";
    public static final String IMG_WIZBAN_IMPORT_SERVER_CONFIGURATION = "importConfigWiz";
    public static final String IMG_SERVER_STATE_STARTED = "stateStarted";
    public static final String IMG_SERVER_STATE_STARTED_DEBUG = "stateStartedDebug";
    public static final String IMG_SERVER_STATE_STARTED_PROFILE = "stateStartedProfile";
    public static final String IMG_SERVER_STATE_STOPPED = "stateStopped";
    public static final String IMG_STATE_STARTED = "stateStarted2";
    public static final String IMG_STATE_STOPPED = "stateStopped2";
    public static final String IMG_SERVER_STATE_STARTING_1 = "stateStarting1";
    public static final String IMG_SERVER_STATE_STARTING_2 = "stateStarting2";
    public static final String IMG_SERVER_STATE_STARTING_3 = "stateStarting3";
    public static final String IMG_SERVER_STATE_STOPPING_1 = "stateStopping1";
    public static final String IMG_SERVER_STATE_STOPPING_2 = "stateStopping2";
    public static final String IMG_SERVER_STATE_STOPPING_3 = "stateStopping3";
    public static final String IMG_SERVER_STATE_STARTED_OVERLAY = "stateStartedOverlay";
    public static final String IMG_SERVER_STATE_STARTED_DEBUG_OVERLAY = "stateStartedDebugOverlay";
    public static final String IMG_SERVER_STATE_STARTED_PROFILE_OVERLAY = "stateStartedProfileOverlay";
    public static final String IMG_SERVER_STATE_STOPPED_OVERLAY = "stateStoppedOverlay";
    public static final String IMG_SERVER_STATE_STARTING_1_OVERLAY = "stateStartingOverlay1";
    public static final String IMG_SERVER_STATE_STARTING_2_OVERLAY = "stateStartingOverlay2";
    public static final String IMG_SERVER_STATE_STARTING_3_OVERLAY = "stateStartingOverlay3";
    public static final String IMG_SERVER_STATE_STOPPING_1_OVERLAY = "stateStoppingOverlay1";
    public static final String IMG_SERVER_STATE_STOPPING_2_OVERLAY = "stateStoppingOverlay2";
    public static final String IMG_SERVER_STATE_STOPPING_3_OVERLAY = "stateStoppingOverlay3";
    public static final String IMG_CTOOL_RUN_ON_SERVER = "IMG_CTOOL_CLIENT";
    public static final String IMG_CTOOL_DEBUG_ON_SERVER = "IMG_CTOOL_CLIENT2";
    public static final String IMG_CTOOL_PROFILE_ON_SERVER = "IMG_CTOOL_CLIENT3";
    public static final String IMG_CTOOL_NEW_SERVER = "IMG_CTOOL_NEW_SERVER";
    public static final String IMG_CTOOL_NEW_SERVER_INSTANCE = "IMG_CTOOL_NEW_SERVER_INSTANCE";
    public static final String IMG_CTOOL_MODIFY_MODULES = "IMG_CTOOL_MODIFY_MODULES";
    public static final String IMG_ETOOL_RUN_ON_SERVER = "IMG_ETOOL_CLIENT";
    public static final String IMG_ETOOL_DEBUG_ON_SERVER = "IMG_ETOOL_CLIENT2";
    public static final String IMG_ETOOL_PROFILE_ON_SERVER = "IMG_ETOOL_CLIENT3";
    public static final String IMG_ETOOL_MODIFY_MODULES = "IMG_ETOOL_MODIFY_MODULES";
    public static final String IMG_ETOOL_RESET_DEFAULT = "IMG_ETOOL_RESET_DEFAULT";
    public static final String IMG_DTOOL_RUN_ON_SERVER = "IMG_DTOOL_CLIENT";
    public static final String IMG_DTOOL_DEBUG_ON_SERVER = "IMG_DTOOL_CLIENT2";
    public static final String IMG_DTOOL_PROFILE_ON_SERVER = "IMG_DTOOL_CLIENT3";
    public static final String IMG_DTOOL_MODIFY_MODULES = "IMG_DTOOL_MODIFY_MODULES";
    public static final String IMG_DTOOL_RESET_DEFAULT = "IMG_DTOOL_RESET_DEFAULT";
    public static final String IMG_SERVER = "server";
    public static final String IMG_SERVER_CONFIGURATION_NONE = "noConfiguration";
    public static final String IMG_SERVER_CONFIGURATION_MISSING = "configurationMissing";
    public static final String IMG_PROJECT_MISSING = "projectMissing";
    public static final String IMG_REPAIR_CONFIGURATION = "repairConfiguration";
    public static final String IMG_PUBLISH_ENABLED = "publishEnabled";
    public static final String IMG_PUBLISH_DISABLED = "publishDisabled";
    public static final String IMG_MONITOR_ON = "monitorOn";
    public static final String IMG_MONITOR_OFF = "monitorOff";
    public static final String IMG_DEFAULT_SERVER_OVERLAY = "defaultServerOverlay";
    public static final String IMG_AUDIO_SOUND = "sound";
    public static final String IMG_AUDIO_CATEGORY = "category";

    static {
        try {
            String pathSuffix = "icons/";
            ICON_BASE_URL = ServerUIPlugin.getInstance().getBundle().getEntry(pathSuffix);
        }
        catch (Exception e) {
            Trace.trace((byte)3, "Could not set icon base URL", e);
        }
    }

    private ImageResource() {
    }

    protected static void dispose() {
    }

    public static Image getImage(String key) {
        Image image;
        if (imageRegistry == null) {
            ImageResource.initializeImageRegistry();
        }
        if ((image = imageRegistry.get(key)) == null) {
            imageRegistry.put(key, ImageDescriptor.getMissingImageDescriptor());
            image = imageRegistry.get(key);
        }
        return image;
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        ImageDescriptor id;
        if (imageRegistry == null) {
            ImageResource.initializeImageRegistry();
        }
        if ((id = imageDescriptors.get(key)) != null) {
            return id;
        }
        return ImageDescriptor.getMissingImageDescriptor();
    }

    protected static void initializeImageRegistry() {
        imageRegistry = new ImageRegistry();
        imageDescriptors = new HashMap<String, ImageDescriptor>();
        ImageResource.registerImage("newServerWiz", "wizban/new_server_wiz.png");
        ImageResource.registerImage(IMG_WIZBAN_IMPORT_SERVER_CONFIGURATION, "wizban/import_configuration_wiz.png");
        ImageResource.registerImage(IMG_WIZBAN_SELECT_SERVER_CLIENT, "wizban/select_client_wiz.png");
        ImageResource.registerImage(IMG_WIZBAN_SELECT_SERVER, "wizban/select_server_wiz.png");
        ImageResource.registerImage(IMG_ETOOL_RUN_ON_SERVER, "etool16/run_on_server.gif");
        ImageResource.registerImage(IMG_ETOOL_DEBUG_ON_SERVER, "etool16/debug_on_server.gif");
        ImageResource.registerImage(IMG_ETOOL_PROFILE_ON_SERVER, "etool16/profile_on_server.gif");
        ImageResource.registerImage(IMG_ETOOL_MODIFY_MODULES, "etool16/wiz_modify_modules.gif");
        ImageResource.registerImage(IMG_ETOOL_RESET_DEFAULT, "etool16/clear.gif");
        ImageResource.registerImage(IMG_CTOOL_RUN_ON_SERVER, "ctool16/run_on_server.gif");
        ImageResource.registerImage(IMG_CTOOL_DEBUG_ON_SERVER, "ctool16/debug_on_server.gif");
        ImageResource.registerImage(IMG_CTOOL_PROFILE_ON_SERVER, "ctool16/profile_on_server.gif");
        ImageResource.registerImage(IMG_CTOOL_NEW_SERVER, "ctool16/wiz_new_server.gif");
        ImageResource.registerImage(IMG_CTOOL_NEW_SERVER_INSTANCE, "ctool16/wiz_new_instance.gif");
        ImageResource.registerImage(IMG_CTOOL_MODIFY_MODULES, "ctool16/wiz_modify_modules.gif");
        ImageResource.registerImage(IMG_DTOOL_RUN_ON_SERVER, "dtool16/run_on_server.gif");
        ImageResource.registerImage(IMG_DTOOL_DEBUG_ON_SERVER, "dtool16/debug_on_server.gif");
        ImageResource.registerImage(IMG_DTOOL_PROFILE_ON_SERVER, "dtool16/profile_on_server.gif");
        ImageResource.registerImage(IMG_DTOOL_MODIFY_MODULES, "dtool16/wiz_modify_modules.gif");
        ImageResource.registerImage(IMG_DTOOL_RESET_DEFAULT, "dtool16/clear.gif");
        ImageResource.registerImage(IMG_SERVER_STATE_STARTED, "obj16/server_started.gif");
        ImageResource.registerImage(IMG_SERVER_STATE_STARTED_DEBUG, "obj16/server_started_debug.gif");
        ImageResource.registerImage(IMG_SERVER_STATE_STARTED_PROFILE, "obj16/server_started_profile.gif");
        ImageResource.registerImage(IMG_SERVER_STATE_STOPPED, "obj16/server_stopped.gif");
        ImageResource.registerImage(IMG_STATE_STARTED, "obj16/state_started.gif");
        ImageResource.registerImage(IMG_STATE_STOPPED, "obj16/state_stopped.gif");
        ImageResource.registerImage(IMG_SERVER_STATE_STARTING_1, "obj16/server_starting1.gif");
        ImageResource.registerImage(IMG_SERVER_STATE_STARTING_2, "obj16/server_starting2.gif");
        ImageResource.registerImage(IMG_SERVER_STATE_STARTING_3, "obj16/server_starting3.gif");
        ImageResource.registerImage(IMG_SERVER_STATE_STOPPING_1, "obj16/server_stopping1.gif");
        ImageResource.registerImage(IMG_SERVER_STATE_STOPPING_2, "obj16/server_stopping2.gif");
        ImageResource.registerImage(IMG_SERVER_STATE_STOPPING_3, "obj16/server_stopping3.gif");
        ImageResource.registerImage(IMG_SERVER_STATE_STARTED_OVERLAY, "ovr16/server_started_ovr.gif");
        ImageResource.registerImage(IMG_SERVER_STATE_STARTED_DEBUG_OVERLAY, "ovr16/server_started_debug_ovr.gif");
        ImageResource.registerImage(IMG_SERVER_STATE_STARTED_PROFILE_OVERLAY, "ovr16/server_started_profile_ovr.gif");
        ImageResource.registerImage(IMG_SERVER_STATE_STOPPED_OVERLAY, "ovr16/server_stopped_ovr.gif");
        ImageResource.registerImage(IMG_SERVER_STATE_STARTING_1_OVERLAY, "ovr16/server_starting1_ovr.gif");
        ImageResource.registerImage(IMG_SERVER_STATE_STARTING_2_OVERLAY, "ovr16/server_starting2_ovr.gif");
        ImageResource.registerImage(IMG_SERVER_STATE_STARTING_3_OVERLAY, "ovr16/server_starting3_ovr.gif");
        ImageResource.registerImage(IMG_SERVER_STATE_STOPPING_1_OVERLAY, "ovr16/server_stopping1_ovr.gif");
        ImageResource.registerImage(IMG_SERVER_STATE_STOPPING_2_OVERLAY, "ovr16/server_stopping2_ovr.gif");
        ImageResource.registerImage(IMG_SERVER_STATE_STOPPING_3_OVERLAY, "ovr16/server_stopping3_ovr.gif");
        ImageResource.registerImage(IMG_ELCL_PUBLISH, "elcl16/launch_publish.gif");
        ImageResource.registerImage(IMG_ELCL_START, "elcl16/launch_run.gif");
        ImageResource.registerImage(IMG_ELCL_START_DEBUG, "elcl16/launch_debug.gif");
        ImageResource.registerImage(IMG_ELCL_START_PROFILE, "elcl16/launch_profile.gif");
        ImageResource.registerImage(IMG_ELCL_STOP, "elcl16/launch_stop.gif");
        ImageResource.registerImage(IMG_ELCL_DISCONNECT, "elcl16/launch_disconnect.gif");
        ImageResource.registerImage(IMG_CLCL_PUBLISH, "clcl16/launch_publish.gif");
        ImageResource.registerImage(IMG_CLCL_START, "clcl16/launch_run.gif");
        ImageResource.registerImage(IMG_CLCL_START_DEBUG, "clcl16/launch_debug.gif");
        ImageResource.registerImage(IMG_CLCL_START_PROFILE, "clcl16/launch_profile.gif");
        ImageResource.registerImage(IMG_CLCL_STOP, "clcl16/launch_stop.gif");
        ImageResource.registerImage(IMG_CLCL_DISCONNECT, "clcl16/launch_disconnect.gif");
        ImageResource.registerImage(IMG_DLCL_PUBLISH, "dlcl16/launch_publish.gif");
        ImageResource.registerImage(IMG_DLCL_START, "dlcl16/launch_run.gif");
        ImageResource.registerImage(IMG_DLCL_START_DEBUG, "dlcl16/launch_debug.gif");
        ImageResource.registerImage(IMG_DLCL_START_PROFILE, "dlcl16/launch_profile.gif");
        ImageResource.registerImage(IMG_DLCL_STOP, "dlcl16/launch_stop.gif");
        ImageResource.registerImage(IMG_DLCL_DISCONNECT, "dlcl16/launch_disconnect.gif");
        ImageResource.registerImage(IMG_SERVER, "obj16/server.gif");
        ImageResource.registerImage(IMG_SERVER_CONFIGURATION_NONE, "obj16/configuration_none.gif");
        ImageResource.registerImage(IMG_SERVER_CONFIGURATION_MISSING, "obj16/configuration_missing.gif");
        ImageResource.registerImage(IMG_PROJECT_MISSING, "obj16/project_missing.gif");
        ImageResource.registerImage(IMG_REPAIR_CONFIGURATION, "obj16/repair_config.gif");
        ImageResource.registerImage(IMG_PUBLISH_ENABLED, "obj16/publish_enabled.gif");
        ImageResource.registerImage(IMG_PUBLISH_DISABLED, "obj16/publish_disabled.gif");
        ImageResource.registerImage(IMG_MONITOR_ON, "obj16/monitorOn.gif");
        ImageResource.registerImage(IMG_MONITOR_OFF, "obj16/monitorOff.gif");
        ImageResource.registerImage(IMG_DEFAULT_SERVER_OVERLAY, "ovr16/default_server_ovr.gif");
        ImageResource.registerImage(IMG_AUDIO_SOUND, "obj16/audio_sound.gif");
        ImageResource.registerImage(IMG_AUDIO_CATEGORY, "obj16/audio_category.gif");
        ImageResource.loadServerImages();
        PlatformUI.getWorkbench().getProgressService().registerIconForFamily(ImageResource.getImageDescriptor(IMG_SERVER), ServerUtil.SERVER_JOB_FAMILY);
    }

    private static void registerImage(String key, String partialURL) {
        try {
            ImageDescriptor id = ImageDescriptor.createFromURL((URL)new URL(ICON_BASE_URL, partialURL));
            imageRegistry.put(key, id);
            imageDescriptors.put(key, id);
        }
        catch (Exception e) {
            Trace.trace((byte)3, "Error registering image " + key + " from " + partialURL, e);
        }
    }

    private static void loadServerImages() {
        Trace.trace((byte)0, "->- Loading .serverImages extension point ->-");
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        ImageResource.loadServerImages(registry.getConfigurationElementsFor("org.eclipse.wst.server.ui", "serverImages"));
        ServerUIPlugin.addRegistryListener();
        Trace.trace((byte)0, "-<- Done loading .serverImages extension point -<-");
    }

    private static void loadServerImages(IConfigurationElement[] cf) {
        int size = cf.length;
        int i = 0;
        while (i < size) {
            try {
                String name = cf[i].getDeclaringExtension().getContributor().getName();
                String iconPath = cf[i].getAttribute("icon");
                ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)name, (String)iconPath);
                if (imageDescriptor == null && iconPath != null && iconPath.length() > 0) {
                    imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
                }
                if (imageDescriptor != null) {
                    String[] typeIds = ServerUIPlugin.tokenize(cf[i].getAttribute("typeIds"), ",");
                    int size2 = typeIds.length;
                    int j = 0;
                    while (j < size2) {
                        imageRegistry.put(typeIds[j], imageDescriptor);
                        imageDescriptors.put(typeIds[j], imageDescriptor);
                        ++j;
                    }
                }
                Trace.trace((byte)0, "  Loaded serverImage: " + cf[i].getAttribute("id"));
            }
            catch (Throwable t) {
                Trace.trace((byte)3, "  Could not load serverImage: " + cf[i].getAttribute("id"), t);
            }
            ++i;
        }
    }

    protected static void handleServerImageDelta(IExtensionDelta delta) {
        if (imageRegistry == null) {
            return;
        }
        IConfigurationElement[] cf = delta.getExtension().getConfigurationElements();
        if (delta.getKind() == 1) {
            ImageResource.loadServerImages(cf);
        } else {
            int size = cf.length;
            int i = 0;
            while (i < size) {
                String typeId = cf[i].getAttribute("typeIds");
                imageRegistry.remove(typeId);
                imageDescriptors.remove(typeId);
                ++i;
            }
        }
    }
}

