/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.util;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IImportDeclaration;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaUIMessages;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectionConverter;
import org.eclipse.wst.jsdt.internal.ui.typehierarchy.TypeHierarchyViewPart;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;

public class OpenTypeHierarchyUtil {
    private OpenTypeHierarchyUtil() {
    }

    public static TypeHierarchyViewPart open(IJavaScriptElement element, IWorkbenchWindow window) {
        IJavaScriptElement[] candidates = OpenTypeHierarchyUtil.getCandidates(element);
        if (candidates != null) {
            return OpenTypeHierarchyUtil.open(candidates, window);
        }
        return null;
    }

    public static TypeHierarchyViewPart open(IJavaScriptElement[] candidates, IWorkbenchWindow window) {
        Assert.isTrue((candidates != null && candidates.length != 0 ? 1 : 0) != 0);
        IJavaScriptElement input = null;
        if (candidates.length > 1) {
            String title = JavaUIMessages.OpenTypeHierarchyUtil_selectionDialog_title;
            String message = JavaUIMessages.OpenTypeHierarchyUtil_selectionDialog_message;
            input = SelectionConverter.selectJavaElement(candidates, window.getShell(), title, message);
        } else {
            input = candidates[0];
        }
        if (input == null) {
            return null;
        }
        return OpenTypeHierarchyUtil.openInViewPart(window, input);
    }

    private static TypeHierarchyViewPart openInViewPart(IWorkbenchWindow window, IJavaScriptElement input) {
        IWorkbenchPage page = window.getActivePage();
        try {
            TypeHierarchyViewPart result = (TypeHierarchyViewPart)page.findView("org.eclipse.wst.jsdt.ui.TypeHierarchy");
            if (result != null) {
                result.clearNeededRefresh();
            }
            result = (TypeHierarchyViewPart)page.showView("org.eclipse.wst.jsdt.ui.TypeHierarchy");
            result.setInputElement(input);
            return result;
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, window.getShell(), JavaUIMessages.OpenTypeHierarchyUtil_error_open_view, e.getMessage());
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IJavaScriptElement[] getCandidates(Object input) {
        if (!(input instanceof IJavaScriptElement)) {
            return null;
        }
        try {
            Object elem = (IJavaScriptElement)input;
            switch (elem.getElementType()) {
                case 2: 
                case 3: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    return new IJavaScriptElement[]{elem};
                }
                case 4: {
                    if (!((IPackageFragment)elem).containsJavaResources()) return null;
                    return new IJavaScriptElement[]{elem};
                }
                case 13: {
                    IImportDeclaration decl = (IImportDeclaration)elem;
                    elem = decl.isOnDemand() ? JavaModelUtil.findTypeContainer(elem.getJavaScriptProject(), Signature.getQualifier((String)elem.getElementName())) : elem.getJavaScriptProject().findType(elem.getElementName());
                    if (elem == null) {
                        return null;
                    }
                    return new IJavaScriptElement[]{elem};
                }
                case 6: {
                    return new IJavaScriptElement[]{((IClassFile)input).getType()};
                }
                case 5: {
                    IJavaScriptUnit cu = (IJavaScriptUnit)elem.getAncestor(5);
                    if (cu == null) return null;
                    IType[] types = cu.getTypes();
                    if (types.length <= 0) return null;
                    return types;
                }
            }
            return null;
        }
        catch (JavaScriptModelException e) {
            JavaScriptPlugin.log(e);
        }
        return null;
    }
}

