/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.internal;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.server.core.internal.ModuleFactory;
import org.eclipse.wst.server.core.internal.ModuleType;
import org.eclipse.wst.server.core.internal.Trace;
import org.eclipse.wst.server.core.model.ModuleDelegate;

public class Module
implements IModule {
    protected String id;
    protected String name;
    protected ModuleFactory factory;
    protected ModuleType moduleType;
    protected IProject project;
    protected ModuleDelegate delegate;
    protected String id2;

    public Module(ModuleFactory factory, String id, String name, String type, String version, IProject project) {
        this.factory = factory;
        this.project = project;
        this.moduleType = ModuleType.getModuleType(type, version);
        this.id = id;
        this.name = name;
        this.id2 = factory != null ? String.valueOf(factory.getId()) + ":" : ":";
        this.id2 = String.valueOf(this.id2) + id;
    }

    public String getId() {
        return this.id2;
    }

    public String getInternalId() {
        return this.id;
    }

    public IModuleType getModuleType() {
        return this.moduleType;
    }

    public IProject getProject() {
        return this.project;
    }

    public String getName() {
        return this.name;
    }

    public ModuleFactory getModuleFactory() {
        return this.factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ModuleDelegate getDelegate(IProgressMonitor monitor) {
        if (this.delegate != null) {
            return this.delegate;
        }
        Module module = this;
        synchronized (module) {
            if (this.delegate == null) {
                try {
                    long time = System.currentTimeMillis();
                    this.delegate = this.factory.getDelegate(monitor).getModuleDelegate(this);
                    this.delegate.initialize(this);
                    Trace.trace(10, "Module.getDelegate(): <" + (System.currentTimeMillis() - time) + " " + this.factory.getId());
                }
                catch (Throwable t) {
                    Trace.trace(2, "Could not create delegate " + this.toString(), t);
                }
            }
        }
        return this.delegate;
    }

    public IModule[] getChildModules(IProgressMonitor monitor) {
        try {
            return this.getDelegate(monitor).getChildModules();
        }
        catch (Exception e) {
            Trace.trace(3, "Error calling delegate getChildModules() " + this.toString(), e);
            return null;
        }
    }

    public IStatus validate(IProgressMonitor monitor) {
        try {
            return this.getDelegate(monitor).validate();
        }
        catch (Exception e) {
            Trace.trace(3, "Error calling delegate validate() " + this.toString(), e);
            return null;
        }
    }

    public Object getAdapter(Class adapter) {
        if (this.delegate != null && adapter.isInstance(this.delegate)) {
            return this.delegate;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public Object loadAdapter(Class adapter, IProgressMonitor monitor) {
        this.getDelegate(monitor);
        if (adapter.isInstance(this.delegate)) {
            return this.delegate;
        }
        return Platform.getAdapterManager().loadAdapter((Object)this, adapter.getName());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof IModule)) {
            return false;
        }
        IModule m = (IModule)obj;
        if (!this.id2.equals(m.getId())) {
            return false;
        }
        return this.project == null || m.getProject() == null || this.project.equals((Object)m.getProject());
    }

    public int hashCode() {
        int result = this.id2.hashCode() + 17;
        if (this.project != null) {
            result += this.project.hashCode() * 37;
        }
        return result;
    }

    public boolean isExternal() {
        return false;
    }

    public boolean exists() {
        return true;
    }

    public String toString() {
        return "Module[" + this.name + "," + this.id2 + "]";
    }
}

