/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.db.internal.vendor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.datatools.modelbase.sql.schema.Catalog;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.jpt.db.internal.vendor.CatalogStrategy;
import org.eclipse.jpt.db.internal.vendor.FoldingStrategy;
import org.eclipse.jpt.db.internal.vendor.Vendor;
import org.eclipse.jpt.utility.internal.ArrayTools;
import org.eclipse.jpt.utility.internal.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractVendor
implements Vendor {
    AbstractVendor() {
    }

    @Override
    public abstract String getDTPVendorName();

    abstract CatalogStrategy getCatalogStrategy();

    @Override
    public boolean supportsCatalogs(Database database) {
        return this.getCatalogStrategy().supportsCatalogs(database);
    }

    @Override
    public List<Catalog> getCatalogs(Database database) {
        return this.getCatalogStrategy().getCatalogs(database);
    }

    @Override
    public List<Schema> getSchemas(Database database) {
        try {
            return this.getCatalogStrategy().getSchemas(database);
        }
        catch (Exception ex) {
            throw new RuntimeException("vendor: " + this, ex);
        }
    }

    @Override
    public final Iterable<String> getDefaultCatalogNames(Database database, String userName) {
        if (!this.supportsCatalogs(database)) {
            return Collections.emptyList();
        }
        ArrayList<String> names = new ArrayList<String>();
        this.addDefaultCatalogNamesTo(database, userName, names);
        return names;
    }

    void addDefaultCatalogNamesTo(Database database, String userName, ArrayList<String> names) {
        names.add(this.convertIdentifierToName(userName));
    }

    @Override
    public final Iterable<String> getDefaultSchemaNames(Database database, String userName) {
        ArrayList<String> names = new ArrayList<String>();
        this.addDefaultSchemaNamesTo(database, userName, names);
        return names;
    }

    void addDefaultSchemaNamesTo(Database database, String userName, ArrayList<String> names) {
        names.add(this.convertIdentifierToName(userName));
    }

    abstract FoldingStrategy getFoldingStrategy();

    @Override
    public String convertNameToIdentifier(String name, String defaultName) {
        return this.nameRequiresDelimiters(name) ? this.delimitName(name) : (this.regularNamesMatch(name, defaultName) ? null : name);
    }

    @Override
    public String convertNameToIdentifier(String name) {
        return this.nameRequiresDelimiters(name) ? this.delimitName(name) : name;
    }

    boolean nameRequiresDelimiters(String name) {
        return name.length() == 0 || this.nameContainsAnySpecialCharacters(name) || this.nameIsNotFolded(name);
    }

    boolean nameContainsAnySpecialCharacters(String name) {
        char[] string = name.toCharArray();
        if (this.characterIsNonRegularNameStart(string[0])) {
            return true;
        }
        int i = string.length;
        while (i-- > 1) {
            if (!this.characterIsNonRegularNamePart(string[i])) continue;
            return true;
        }
        return false;
    }

    boolean characterIsNonRegularNameStart(char c) {
        return !this.characterIsRegularNameStart(c);
    }

    boolean characterIsRegularNameStart(char c) {
        return Character.isLetter(c) || this.characterIsExtendedRegularNameStart(c);
    }

    boolean characterIsExtendedRegularNameStart(char c) {
        return AbstractVendor.arrayContains(this.getExtendedRegularNameStartCharacters(), c);
    }

    char[] getExtendedRegularNameStartCharacters() {
        return null;
    }

    boolean characterIsNonRegularNamePart(char c) {
        return !this.characterIsRegularNamePart(c);
    }

    boolean characterIsRegularNamePart(char c) {
        return Character.isLetterOrDigit(c) || c == '_' || this.characterIsExtendedRegularNameStart(c) || this.characterIsExtendedRegularNamePart(c);
    }

    boolean characterIsExtendedRegularNamePart(char c) {
        return AbstractVendor.arrayContains(this.getExtendedRegularNamePartCharacters(), c);
    }

    char[] getExtendedRegularNamePartCharacters() {
        return null;
    }

    boolean nameIsNotFolded(String name) {
        return !this.getFoldingStrategy().nameIsFolded(name);
    }

    boolean regularNamesMatch(String name1, String name2) {
        return this.regularIdentifiersAreCaseSensitive() ? name1.equals(name2) : name1.equalsIgnoreCase(name2);
    }

    boolean regularIdentifiersAreCaseSensitive() {
        return this.getFoldingStrategy().regularIdentifiersAreCaseSensitive();
    }

    String delimitName(String name) {
        return StringTools.quote((String)name);
    }

    @Override
    public String convertIdentifierToName(String identifier) {
        return identifier == null ? null : (this.identifierIsDelimited(identifier) ? StringTools.undelimit((String)identifier) : this.getFoldingStrategy().fold(identifier));
    }

    boolean identifierIsDelimited(String identifier) {
        return StringTools.stringIsQuoted((String)identifier);
    }

    public String toString() {
        return this.getDTPVendorName();
    }

    static boolean arrayContains(char[] array, char c) {
        return array != null && ArrayTools.contains((char[])array, (char)c);
    }
}

