/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.servlet.ui.internal.wizard;

import java.util.Iterator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jst.j2ee.internal.web.operations.ServletSupertypesValidator;
import org.eclipse.jst.servlet.ui.internal.wizard.NewWebClassOptionsWizardPage;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class NewServletClassOptionsWizardPage
extends NewWebClassOptionsWizardPage
implements ISelectionChangedListener {
    protected Button initButton;
    protected Button destroyButton;
    protected Button getConfigButton;
    protected Button getInfoButton;
    protected Button serviceButton;
    protected Button doGetButton;
    protected Button doPostButton;
    protected Button doPutButton;
    protected Button doDeleteButton;
    protected Button doHeadButton;
    protected Button doOptionsButton;
    protected Button doTraceButton;

    public NewServletClassOptionsWizardPage(IDataModel model, String pageName, String pageDesc, String pageTitle) {
        super(model, pageName, pageDesc, pageTitle);
    }

    protected void enter() {
        super.enter();
        boolean httpServlet = ServletSupertypesValidator.isHttpServletSuperclass((IDataModel)this.model);
        this.doGetButton.setVisible(httpServlet);
        this.doPostButton.setVisible(httpServlet);
        this.doPutButton.setVisible(httpServlet);
        this.doDeleteButton.setVisible(httpServlet);
        this.doHeadButton.setVisible(httpServlet);
        this.doOptionsButton.setVisible(httpServlet);
        this.doTraceButton.setVisible(httpServlet);
    }

    protected void createStubsComposite(Composite parent) {
        super.createStubsComposite(parent);
        this.inheritButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean enable = NewServletClassOptionsWizardPage.this.inheritButton.getSelection();
                this.enableGenericServletButtons(enable);
                this.enableHttpServletButtons(enable);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            private void enableGenericServletButtons(boolean enable) {
                if (ServletSupertypesValidator.isGenericServletSuperclass((IDataModel)NewServletClassOptionsWizardPage.this.model)) {
                    NewServletClassOptionsWizardPage.this.initButton.setEnabled(enable);
                    NewServletClassOptionsWizardPage.this.destroyButton.setEnabled(enable);
                    NewServletClassOptionsWizardPage.this.getConfigButton.setEnabled(enable);
                    NewServletClassOptionsWizardPage.this.getInfoButton.setEnabled(enable);
                    NewServletClassOptionsWizardPage.this.serviceButton.setEnabled(enable);
                }
            }

            private void enableHttpServletButtons(boolean enable) {
                NewServletClassOptionsWizardPage.this.doGetButton.setEnabled(enable);
                NewServletClassOptionsWizardPage.this.doPostButton.setEnabled(enable);
                NewServletClassOptionsWizardPage.this.doPutButton.setEnabled(enable);
                NewServletClassOptionsWizardPage.this.doDeleteButton.setEnabled(enable);
                NewServletClassOptionsWizardPage.this.doHeadButton.setEnabled(enable);
                NewServletClassOptionsWizardPage.this.doOptionsButton.setEnabled(enable);
                NewServletClassOptionsWizardPage.this.doTraceButton.setEnabled(enable);
            }
        });
        Composite comp = new Composite(this.methodStubs, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        layout.makeColumnsEqualWidth = true;
        comp.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        comp.setLayoutData((Object)data);
        this.initButton = new Button(comp, 32);
        this.initButton.setText("init");
        this.synchHelper.synchCheckbox(this.initButton, "NewServletClassDataModel.INIT", null);
        this.destroyButton = new Button(comp, 32);
        this.destroyButton.setText("destroy");
        this.synchHelper.synchCheckbox(this.destroyButton, "NewServletClassDataModel.DESTROY", null);
        this.getConfigButton = new Button(comp, 32);
        this.getConfigButton.setText("getServletConfig");
        this.synchHelper.synchCheckbox(this.getConfigButton, "NewServletClassDataModel.GET_SERVLET_CONFIG", null);
        this.getInfoButton = new Button(comp, 32);
        this.getInfoButton.setText("getServletInfo");
        this.synchHelper.synchCheckbox(this.getInfoButton, "NewServletClassDataModel.GET_SERVLET_INFO", null);
        this.serviceButton = new Button(comp, 32);
        this.serviceButton.setText("service");
        this.synchHelper.synchCheckbox(this.serviceButton, "NewServletClassDataModel.SERVICE", null);
        this.doGetButton = new Button(comp, 32);
        this.doGetButton.setText("do&Get");
        this.synchHelper.synchCheckbox(this.doGetButton, "NewServletClassDataModel.DO_GET", null);
        this.doPostButton = new Button(comp, 32);
        this.doPostButton.setText("do&Post");
        this.synchHelper.synchCheckbox(this.doPostButton, "NewServletClassDataModel.DO_POST", null);
        this.doPutButton = new Button(comp, 32);
        this.doPutButton.setText("doP&ut");
        this.synchHelper.synchCheckbox(this.doPutButton, "NewServletClassDataModel.DO_PUT", null);
        this.doDeleteButton = new Button(comp, 32);
        this.doDeleteButton.setText("do&Delete");
        this.synchHelper.synchCheckbox(this.doDeleteButton, "NewServletClassDataModel.DO_DELETE", null);
        this.doHeadButton = new Button(comp, 32);
        this.doHeadButton.setText("doH&ead");
        this.synchHelper.synchCheckbox(this.doHeadButton, "NewServletClassDataModel.DO_HEAD", null);
        this.doOptionsButton = new Button(comp, 32);
        this.doOptionsButton.setText("do&Options");
        this.synchHelper.synchCheckbox(this.doOptionsButton, "NewServletClassDataModel.DO_OPTIONS", null);
        this.doTraceButton = new Button(comp, 32);
        this.doTraceButton.setText("do&Trace");
        this.synchHelper.synchCheckbox(this.doTraceButton, "NewServletClassDataModel.DO_TRACE", null);
        this.interfaceViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        Dialog.applyDialogFont((Control)parent);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        this.removeButton.setEnabled(this.canRemoveSelectedInterfaces(selection));
    }

    protected KeyListener getInterfaceKeyListener() {
        return new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                IStructuredSelection selection;
                if (e.keyCode == 127 && NewServletClassOptionsWizardPage.this.canRemoveSelectedInterfaces(selection = (IStructuredSelection)NewServletClassOptionsWizardPage.this.interfaceViewer.getSelection())) {
                    NewServletClassOptionsWizardPage.this.handleInterfaceRemoveButtonSelected();
                }
            }
        };
    }

    private boolean canRemoveSelectedInterfaces(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return false;
        }
        if (ServletSupertypesValidator.isGenericServletSuperclass((IDataModel)this.model)) {
            return true;
        }
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            if (!"javax.servlet.Servlet".equals(iter.next())) continue;
            return false;
        }
        return true;
    }
}

