/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.db.internal;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.jpt.db.Catalog;
import org.eclipse.jpt.db.Database;
import org.eclipse.jpt.db.DatabaseObject;
import org.eclipse.jpt.db.internal.DTPCatalogWrapper;
import org.eclipse.jpt.db.internal.DTPColumnWrapper;
import org.eclipse.jpt.db.internal.DTPConnectionProfileWrapper;
import org.eclipse.jpt.db.internal.DTPSchemaContainerWrapper;
import org.eclipse.jpt.db.internal.DTPSchemaWrapper;
import org.eclipse.jpt.db.internal.DTPTableWrapper;
import org.eclipse.jpt.db.internal.vendor.Vendor;
import org.eclipse.jpt.db.internal.vendor.VendorRepository;
import org.eclipse.jpt.utility.internal.ArrayTools;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterables.ArrayIterable;
import org.eclipse.jpt.utility.internal.iterables.TransformationIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DTPDatabaseWrapper
extends DTPSchemaContainerWrapper
implements Database {
    private final org.eclipse.datatools.modelbase.sql.schema.Database dtpDatabase;
    private final Vendor vendor;
    private DTPCatalogWrapper[] catalogs;

    DTPDatabaseWrapper(DTPConnectionProfileWrapper connectionProfile, org.eclipse.datatools.modelbase.sql.schema.Database dtpDatabase) {
        super(connectionProfile, dtpDatabase);
        this.dtpDatabase = dtpDatabase;
        this.vendor = VendorRepository.instance().getVendor(this.getVendorName());
    }

    @Override
    synchronized void catalogObjectChanged() {
        super.catalogObjectChanged();
        this.getConnectionProfile().databaseChanged(this);
    }

    @Override
    public DTPDatabaseWrapper getDatabase() {
        return this;
    }

    @Override
    List<Schema> getDTPSchemata() {
        return this.vendor.getSchemas(this.dtpDatabase);
    }

    @Override
    DTPSchemaWrapper getSchema(Schema dtpSchema) {
        return this.getSchema_(dtpSchema);
    }

    DTPSchemaWrapper getSchemaFromCatalogs(Schema dtpSchema) {
        return this.getCatalog(dtpSchema.getCatalog()).getSchema_(dtpSchema);
    }

    @Override
    DTPTableWrapper getTable(Table dtpTable) {
        return this.getTable_(dtpTable);
    }

    DTPTableWrapper getTableFromCatalogs(Table dtpTable) {
        return this.getCatalog(dtpTable.getSchema().getCatalog()).getTable_(dtpTable);
    }

    @Override
    DTPColumnWrapper getColumn(Column dtpColumn) {
        return this.getColumn_(dtpColumn);
    }

    DTPColumnWrapper getColumnFromCatalogs(Column dtpColumn) {
        return this.getCatalog(dtpColumn.getTable().getSchema().getCatalog()).getColumn_(dtpColumn);
    }

    @Override
    public String getName() {
        return this.dtpDatabase.getName();
    }

    @Override
    public String getVendorName() {
        return this.dtpDatabase.getVendor();
    }

    @Override
    public String getVersion() {
        return this.dtpDatabase.getVersion();
    }

    @Override
    public <T extends DatabaseObject> T selectDatabaseObjectForIdentifier(Iterable<T> databaseObjects, String identifier) {
        return super.selectDatabaseObjectForIdentifier(databaseObjects, identifier);
    }

    @Override
    public boolean supportsCatalogs() {
        return this.vendor.supportsCatalogs(this.dtpDatabase);
    }

    @Override
    public Iterable<Catalog> getCatalogs() {
        return new ArrayIterable((Object[])this.getCatalogArray());
    }

    private Iterable<DTPCatalogWrapper> getCatalogWrappers() {
        return new ArrayIterable((Object[])this.getCatalogArray());
    }

    private synchronized DTPCatalogWrapper[] getCatalogArray() {
        if (this.catalogs == null) {
            this.catalogs = this.buildCatalogArray();
        }
        return this.catalogs;
    }

    private DTPCatalogWrapper[] buildCatalogArray() {
        List<org.eclipse.datatools.modelbase.sql.schema.Catalog> dtpCatalogs = this.getDTPCatalogs();
        Object[] result = new DTPCatalogWrapper[dtpCatalogs.size()];
        int i = result.length;
        while (i-- > 0) {
            result[i] = new DTPCatalogWrapper(this, dtpCatalogs.get(i));
        }
        return (DTPCatalogWrapper[])ArrayTools.sort((Object[])result, (Comparator)DEFAULT_COMPARATOR);
    }

    private List<org.eclipse.datatools.modelbase.sql.schema.Catalog> getDTPCatalogs() {
        return this.vendor.getCatalogs(this.dtpDatabase);
    }

    @Override
    public int getCatalogsSize() {
        return this.getCatalogArray().length;
    }

    DTPCatalogWrapper getCatalog(org.eclipse.datatools.modelbase.sql.schema.Catalog dtpCatalog) {
        DTPCatalogWrapper[] dTPCatalogWrapperArray = this.getCatalogArray();
        int n = dTPCatalogWrapperArray.length;
        int n2 = 0;
        while (n2 < n) {
            DTPCatalogWrapper catalog = dTPCatalogWrapperArray[n2];
            if (catalog.wraps(dtpCatalog)) {
                return catalog;
            }
            ++n2;
        }
        throw new IllegalArgumentException("invalid DTP catalog: " + dtpCatalog);
    }

    @Override
    public Iterable<String> getSortedCatalogNames() {
        return new TransformationIterable(this.getCatalogWrappers(), NAME_TRANSFORMER);
    }

    @Override
    public DTPCatalogWrapper getCatalogNamed(String name) {
        return this.selectDatabaseObjectNamed(this.getCatalogWrappers(), name);
    }

    @Override
    public Iterable<String> getSortedCatalogIdentifiers() {
        return new TransformationIterable(this.getCatalogWrappers(), IDENTIFIER_TRANSFORMER);
    }

    @Override
    public DTPCatalogWrapper getCatalogForIdentifier(String identifier) {
        return this.selectDatabaseObjectForIdentifier(this.getCatalogWrappers(), identifier);
    }

    @Override
    public synchronized DTPCatalogWrapper getDefaultCatalog() {
        return this.getCatalogForNames(this.getDefaultCatalogNames());
    }

    private Iterable<String> getDefaultCatalogNames() {
        return this.vendor.getDefaultCatalogNames(this.dtpDatabase, this.getConnectionProfile().getUserName());
    }

    private DTPCatalogWrapper getCatalogForNames(Iterable<String> names) {
        for (String name : names) {
            DTPCatalogWrapper catalog = this.getCatalogNamed(name);
            if (catalog == null) continue;
            return catalog;
        }
        return null;
    }

    @Override
    public synchronized String getDefaultCatalogIdentifier() {
        Iterable<String> names = this.getDefaultCatalogNames();
        DTPCatalogWrapper catalog = this.getCatalogForNames(names);
        if (catalog != null) {
            return catalog.getIdentifier();
        }
        Iterator<String> stream = names.iterator();
        return stream.hasNext() ? this.convertNameToIdentifier((String)CollectionTools.last(stream)) : null;
    }

    Iterable<String> getDefaultSchemaNames() {
        return this.vendor.getDefaultSchemaNames(this.dtpDatabase, this.getConnectionProfile().getUserName());
    }

    @Override
    public String convertNameToIdentifier(String name) {
        return super.convertNameToIdentifier(name);
    }

    String convertNameToIdentifier_(String name) {
        return this.vendor.convertNameToIdentifier(name);
    }

    String convertIdentifierToName_(String identifier) {
        return this.vendor.convertIdentifierToName(identifier);
    }

    String convertNameToIdentifier(String name, String defaultName) {
        return this.vendor.convertNameToIdentifier(name, defaultName);
    }

    DatabaseDefinition getDTPDefinition() {
        return RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(this.dtpDatabase);
    }

    @Override
    synchronized void startListening() {
        if (this.catalogs != null) {
            this.startCatalogs();
        }
        super.startListening();
    }

    private void startCatalogs() {
        DTPCatalogWrapper[] dTPCatalogWrapperArray = this.catalogs;
        int n = this.catalogs.length;
        int n2 = 0;
        while (n2 < n) {
            DTPCatalogWrapper catalog = dTPCatalogWrapperArray[n2];
            catalog.startListening();
            ++n2;
        }
    }

    @Override
    synchronized void stopListening() {
        if (this.catalogs != null) {
            this.stopCatalogs();
        }
        super.stopListening();
    }

    private void stopCatalogs() {
        DTPCatalogWrapper[] dTPCatalogWrapperArray = this.catalogs;
        int n = this.catalogs.length;
        int n2 = 0;
        while (n2 < n) {
            DTPCatalogWrapper catalog = dTPCatalogWrapperArray[n2];
            catalog.stopListening();
            ++n2;
        }
    }

    @Override
    synchronized void clear() {
        if (this.catalogs != null) {
            this.clearCatalogs();
        }
        super.clear();
    }

    private void clearCatalogs() {
        this.stopCatalogs();
        DTPCatalogWrapper[] dTPCatalogWrapperArray = this.catalogs;
        int n = this.catalogs.length;
        int n2 = 0;
        while (n2 < n) {
            DTPCatalogWrapper catalog = dTPCatalogWrapperArray[n2];
            catalog.clear();
            ++n2;
        }
        this.catalogs = null;
    }
}

