/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.internal;

import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.PreferenceModifyListener;
import org.osgi.service.prefs.Preferences;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ServerPreferenceModifyListener
extends PreferenceModifyListener {
    private static final String LOCKED_ATTRIBUTE_NAME = "locked";
    private static final String RUNTIMES_PREFERENCE_NAME = "runtimes";
    private static final String RUNTIME_NODE_NAME = "runtime";

    public IEclipsePreferences preApply(IEclipsePreferences node) {
        Preferences instance = node.node("instance");
        Preferences runtimes = instance.node("org.eclipse.wst.server.core");
        if (runtimes != null) {
            this.removeLockedServerRuntimePreference(runtimes);
        }
        return super.preApply(node);
    }

    private void removeLockedServerRuntimePreference(Preferences preferences) {
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader(preferences.get(RUNTIMES_PREFERENCE_NAME, ""))));
            NodeList nodeList = doc.getElementsByTagName(RUNTIME_NODE_NAME);
            int s = 0;
            while (s < nodeList.getLength()) {
                NamedNodeMap attributes;
                Node locked;
                Node node = nodeList.item(s);
                if (node.getNodeType() == 1 && (locked = (attributes = node.getAttributes()).getNamedItem(LOCKED_ATTRIBUTE_NAME)) != null && Boolean.parseBoolean(locked.getNodeValue())) {
                    node.getParentNode().removeChild(node);
                }
                ++s;
            }
            StringWriter runtimes = new StringWriter();
            TransformerFactory.newInstance().newTransformer().transform(new DOMSource(doc), new StreamResult(runtimes));
            preferences.remove(RUNTIMES_PREFERENCE_NAME);
            preferences.put(RUNTIMES_PREFERENCE_NAME, runtimes.toString());
        }
        catch (Exception exception) {
            return;
        }
    }
}

