/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.internal;

import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.core.internal.Trace;
import org.eclipse.wst.server.core.model.PublishControllerDelegate;

public class PublishController {
    private IConfigurationElement element;
    private PublishControllerDelegate delegate;

    public PublishController(IConfigurationElement element) {
        this.element = element;
    }

    public String getId() {
        return this.element.getAttribute("id");
    }

    public String getName() {
        return this.element.getAttribute("name");
    }

    public String getDescription() {
        return this.element.getAttribute("description");
    }

    protected String[] getTypeIds() {
        try {
            return ServerPlugin.tokenize(this.element.getAttribute("typeIds"), ",");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean supportsType(String id) {
        return ServerPlugin.contains(this.getTypeIds(), id);
    }

    public PublishControllerDelegate getDelegate() {
        if (this.delegate == null) {
            try {
                long time = System.currentTimeMillis();
                this.delegate = (PublishControllerDelegate)this.element.createExecutableExtension("class");
                Trace.trace(10, "PublishTask.getDelegate(): <" + (System.currentTimeMillis() - time) + "> " + this.getId());
            }
            catch (Throwable t) {
                Trace.trace(3, "Could not create delegate" + this.toString(), t);
            }
        }
        return this.delegate;
    }

    public boolean isPublishRequired(IServer server, IResourceDelta delta) {
        try {
            Trace.trace(5, "Task.init " + this);
            return this.getDelegate().isPublishRequired(server, delta);
        }
        catch (Exception e) {
            Trace.trace(3, "Error calling delegate " + this.toString(), e);
            return true;
        }
    }

    public String toString() {
        return "PublishController[" + this.getId() + "]";
    }
}

