/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal.model;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.sse.core.internal.FileBufferModelManager;
import org.eclipse.wst.sse.core.internal.Logger;
import org.eclipse.wst.sse.core.internal.NullMemento;
import org.eclipse.wst.sse.core.internal.SSECoreMessages;
import org.eclipse.wst.sse.core.internal.SSECorePlugin;
import org.eclipse.wst.sse.core.internal.document.DocumentReader;
import org.eclipse.wst.sse.core.internal.document.IDocumentLoader;
import org.eclipse.wst.sse.core.internal.encoding.CodedIO;
import org.eclipse.wst.sse.core.internal.encoding.CodedStreamCreator;
import org.eclipse.wst.sse.core.internal.encoding.ContentBasedPreferenceGateway;
import org.eclipse.wst.sse.core.internal.encoding.EncodingMemento;
import org.eclipse.wst.sse.core.internal.encoding.EncodingRule;
import org.eclipse.wst.sse.core.internal.exceptions.MalformedOutputExceptionWithDetail;
import org.eclipse.wst.sse.core.internal.ltk.modelhandler.IModelHandler;
import org.eclipse.wst.sse.core.internal.model.AbstractStructuredModel;
import org.eclipse.wst.sse.core.internal.model.FactoryRegistry;
import org.eclipse.wst.sse.core.internal.model.ModelLifecycleEvent;
import org.eclipse.wst.sse.core.internal.model.PrefUtil;
import org.eclipse.wst.sse.core.internal.modelhandler.ModelHandlerRegistry;
import org.eclipse.wst.sse.core.internal.provisional.IModelLoader;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapterFactory;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.document.IEncodedDocument;
import org.eclipse.wst.sse.core.internal.provisional.exceptions.ResourceAlreadyExists;
import org.eclipse.wst.sse.core.internal.provisional.exceptions.ResourceInUse;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.util.Assert;
import org.eclipse.wst.sse.core.internal.util.ProjectResolver;
import org.eclipse.wst.sse.core.internal.util.URIResolver;
import org.eclipse.wst.sse.core.internal.util.Utilities;
import org.osgi.framework.Bundle;

public class ModelManagerImpl
implements IModelManager {
    private Exception debugException = null;
    private static ModelManagerImpl instance;
    private static final int READ_BUFFER_SIZE = 4096;
    private Map fManagedObjects;
    private ModelHandlerRegistry fModelHandlerRegistry;
    private final ReadEditType READ = new ReadEditType("read");
    private final ReadEditType EDIT = new ReadEditType("edit");
    private final ILock SYNC = Job.getJobManager().newLock();
    static /* synthetic */ Class class$0;

    public static synchronized IModelManager getInstance() {
        if (instance == null) {
            instance = new ModelManagerImpl();
        }
        return instance;
    }

    ModelManagerImpl() {
        this.fManagedObjects = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IStructuredModel _commonCreateModel(IFile file, String id, IModelHandler handler, URIResolver resolver, ReadEditType rwType, EncodingRule encodingRule) throws IOException, CoreException {
        SharedObject sharedObject = null;
        this.SYNC.acquire();
        sharedObject = (SharedObject)this.fManagedObjects.get(id);
        this.SYNC.release();
        while (true) {
            if (sharedObject != null) {
                sharedObject.waitForLoadAttempt();
            }
            this.SYNC.acquire();
            SharedObject testObject = (SharedObject)this.fManagedObjects.get(id);
            if (testObject == null) {
                sharedObject = new SharedObject(id);
                this.fManagedObjects.put(id, sharedObject);
                this.SYNC.release();
                this._doCommonCreateModel(file, id, handler, resolver, rwType, encodingRule, sharedObject);
                break;
            }
            if (sharedObject == testObject) {
                SharedObject sharedObject2 = sharedObject;
                synchronized (sharedObject2) {
                    if (sharedObject.theSharedModel != null) {
                        this._incrCount(sharedObject, rwType);
                    }
                }
                this.SYNC.release();
                break;
            }
            this.SYNC.release();
            sharedObject = testObject;
        }
        if (sharedObject == null) {
            this.debugException = new Exception("instance only for stack trace");
            Logger.logException("Program Error: no model recorded for id " + id, this.debugException);
        }
        return sharedObject == null ? null : sharedObject.theSharedModel;
    }

    private void _decrCount(SharedObject sharedObject, ReadEditType type) {
        if (type == this.READ) {
            --sharedObject.referenceCountForRead;
            FileBufferModelManager.getInstance().disconnect(sharedObject.theSharedModel.getStructuredDocument());
        } else if (type == this.EDIT) {
            --sharedObject.referenceCountForEdit;
            FileBufferModelManager.getInstance().disconnect(sharedObject.theSharedModel.getStructuredDocument());
        } else {
            throw new IllegalArgumentException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void _doCommonCreateModel(IFile file, String id, IModelHandler handler, URIResolver resolver, ReadEditType rwType, EncodingRule encodingRule, SharedObject sharedObject) throws CoreException, IOException {
        block17: {
            boolean doRemove = true;
            try {
                SharedObject sharedObject2 = sharedObject;
                synchronized (sharedObject2) {
                    IStructuredModel model;
                    block16: {
                        InputStream inputStream = null;
                        model = null;
                        try {
                            try {
                                model = this._commonCreateModel(id, handler, resolver);
                                IModelLoader loader = handler.getModelLoader();
                                inputStream = Utilities.getMarkSupportedStream(file.getContents(true));
                                loader.load(Utilities.getMarkSupportedStream(inputStream), model, encodingRule);
                            }
                            catch (ResourceInUse e) {
                                this.handleProgramError(e);
                            }
                        }
                        catch (Throwable throwable) {
                            Object var13_15 = null;
                            if (inputStream == null) throw throwable;
                            try {
                                inputStream.close();
                                throw throwable;
                            }
                            catch (IOException iOException) {}
                            throw throwable;
                        }
                        {
                            Object var13_16 = null;
                            if (inputStream == null) break block16;
                        }
                        try {}
                        catch (IOException iOException) {}
                        inputStream.close();
                    }
                    if (model != null) {
                        sharedObject.theSharedModel = model;
                        this._initCount(sharedObject, rwType);
                        doRemove = false;
                    }
                }
            }
            catch (Throwable throwable) {
                Object var15_18 = null;
                if (doRemove) {
                    this.SYNC.acquire();
                    this.fManagedObjects.remove(id);
                    this.SYNC.release();
                }
                sharedObject.setLoaded();
                throw throwable;
            }
            {
                Object var15_19 = null;
                if (!doRemove) break block17;
            }
            this.SYNC.acquire();
            this.fManagedObjects.remove(id);
            this.SYNC.release();
        }
        sharedObject.setLoaded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IStructuredModel _commonCreateModel(InputStream inputStream, String id, IModelHandler handler, URIResolver resolver, ReadEditType rwType, String encoding, String lineDelimiter) throws IOException {
        if (id == null) {
            throw new IllegalArgumentException("Program Error: id may not be null");
        }
        SharedObject sharedObject = null;
        this.SYNC.acquire();
        sharedObject = (SharedObject)this.fManagedObjects.get(id);
        this.SYNC.release();
        while (true) {
            if (sharedObject != null) {
                sharedObject.waitForLoadAttempt();
            }
            this.SYNC.acquire();
            SharedObject testObject = (SharedObject)this.fManagedObjects.get(id);
            if (testObject == null) {
                sharedObject = new SharedObject(id);
                this.fManagedObjects.put(id, sharedObject);
                this.SYNC.release();
                this._doCommonCreateModel(inputStream, id, handler, resolver, rwType, encoding, lineDelimiter, sharedObject);
                break;
            }
            if (sharedObject == testObject) {
                SharedObject sharedObject2 = sharedObject;
                synchronized (sharedObject2) {
                    if (sharedObject.theSharedModel != null) {
                        this._incrCount(sharedObject, rwType);
                    }
                }
                this.SYNC.release();
                break;
            }
            this.SYNC.release();
            sharedObject = testObject;
        }
        Assert.isNotNull(sharedObject, "Program Error: no model recorded for id " + id);
        return sharedObject.theSharedModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void _doCommonCreateModel(InputStream inputStream, String id, IModelHandler handler, URIResolver resolver, ReadEditType rwType, String encoding, String lineDelimiter, SharedObject sharedObject) throws IOException {
        block13: {
            boolean doRemove = true;
            try {
                SharedObject sharedObject2 = sharedObject;
                synchronized (sharedObject2) {
                    IStructuredModel model = null;
                    try {
                        model = this._commonCreateModel(id, handler, resolver);
                        IModelLoader loader = handler.getModelLoader();
                        if (inputStream == null) {
                            Logger.log(2, "model was requested for id " + id + " without a content InputStream");
                        }
                        loader.load(id, Utilities.getMarkSupportedStream(inputStream), model, encoding, lineDelimiter);
                    }
                    catch (ResourceInUse e) {
                        this.handleProgramError(e);
                    }
                    if (model != null) {
                        if (model instanceof AbstractStructuredModel) {
                            DocumentReader reader = new DocumentReader(model.getStructuredDocument());
                            IContentDescription description = Platform.getContentTypeManager().getDescriptionFor((Reader)reader, id, new QualifiedName[0]);
                            reader.close();
                            if (description != null && description.getContentType() != null) {
                                ((AbstractStructuredModel)model).setContentTypeIdentifier(description.getContentType().getId());
                            }
                        }
                        sharedObject.theSharedModel = model;
                        this._initCount(sharedObject, rwType);
                        doRemove = false;
                    }
                }
            }
            catch (Throwable throwable) {
                Object var14_16 = null;
                if (doRemove) {
                    this.SYNC.acquire();
                    this.fManagedObjects.remove(id);
                    this.SYNC.release();
                }
                sharedObject.setLoaded();
                throw throwable;
            }
            {
                Object var14_17 = null;
                if (!doRemove) break block13;
            }
            this.SYNC.acquire();
            this.fManagedObjects.remove(id);
            this.SYNC.release();
        }
        sharedObject.setLoaded();
    }

    private IStructuredModel _commonCreateModel(String id, IModelHandler handler, URIResolver resolver) throws ResourceInUse {
        IModelLoader loader = handler.getModelLoader();
        IStructuredModel result = loader.createModel();
        if (id != null) {
            result.setId(id);
        }
        result.setModelHandler(handler);
        result.setResolver(resolver);
        result.setBaseLocation(id);
        if (resolver != null) {
            resolver.setFileBaseLocation(id);
        }
        this.addFactories(result, handler);
        return result;
    }

    private IStructuredModel _commonGetModel(IFile iFile, ReadEditType rwType, EncodingRule encodingRule) throws UnsupportedEncodingException, IOException, CoreException {
        IStructuredModel model = null;
        if (iFile != null && iFile.exists()) {
            String id = this.calculateId(iFile);
            IModelHandler handler = this.calculateType(iFile);
            URIResolver resolver = this.calculateURIResolver(iFile);
            model = this._commonCreateModel(iFile, id, handler, resolver, rwType, encodingRule);
        }
        return model;
    }

    private IStructuredModel _commonGetModel(IFile iFile, ReadEditType rwType, String encoding, String lineDelimiter) throws UnsupportedEncodingException, IOException, CoreException {
        String id = this.calculateId(iFile);
        IStructuredModel model = this._commonGetModel(iFile, id, rwType, encoding, lineDelimiter);
        return model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IStructuredModel _commonGetModel(IFile file, String id, ReadEditType rwType, String encoding, String lineDelimiter) throws IOException, CoreException {
        if (id == null) {
            throw new IllegalArgumentException("Program Error: id may not be null");
        }
        SharedObject sharedObject = null;
        if (file != null && file.exists()) {
            this.SYNC.acquire();
            sharedObject = (SharedObject)this.fManagedObjects.get(id);
            this.SYNC.release();
            while (true) {
                if (sharedObject != null) {
                    sharedObject.waitForLoadAttempt();
                }
                this.SYNC.acquire();
                SharedObject testObject = (SharedObject)this.fManagedObjects.get(id);
                if (testObject == null) {
                    sharedObject = new SharedObject(id);
                    this.fManagedObjects.put(id, sharedObject);
                    this.SYNC.release();
                    this._doCommonGetModel(file, id, sharedObject, rwType);
                    break;
                }
                if (sharedObject == testObject) {
                    SharedObject sharedObject2 = sharedObject;
                    synchronized (sharedObject2) {
                        if (sharedObject.theSharedModel != null) {
                            this._incrCount(sharedObject, rwType);
                        }
                    }
                    this.SYNC.release();
                    break;
                }
                this.SYNC.release();
                sharedObject = testObject;
            }
        }
        return sharedObject == null ? null : sharedObject.theSharedModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void _doCommonGetModel(IFile file, String id, SharedObject sharedObject, ReadEditType rwType) {
        block11: {
            boolean doRemove = true;
            try {
                SharedObject sharedObject2 = sharedObject;
                synchronized (sharedObject2) {
                    block10: {
                        sharedObject.doWait = false;
                        IStructuredModel model = null;
                        try {
                            model = FileBufferModelManager.getInstance().getModel(file);
                        }
                        catch (Throwable throwable) {
                            Object var8_9 = null;
                            sharedObject.doWait = true;
                            throw throwable;
                        }
                        {
                            Object var8_10 = null;
                            sharedObject.doWait = true;
                            if (model == null) break block10;
                            sharedObject.theSharedModel = model;
                            this._initCount(sharedObject, rwType);
                            doRemove = false;
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                if (doRemove) {
                    this.SYNC.acquire();
                    this.fManagedObjects.remove(id);
                    this.SYNC.release();
                }
                sharedObject.setLoaded();
                throw throwable;
            }
            {
                Object var10_13 = null;
                if (!doRemove) break block11;
            }
            this.SYNC.acquire();
            this.fManagedObjects.remove(id);
            this.SYNC.release();
        }
        sharedObject.setLoaded();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SharedObject _commonNewModel(IFile iFile, boolean force) throws ResourceAlreadyExists, ResourceInUse, IOException, CoreException {
        IStructuredModel aSharedModel = null;
        if (iFile.exists() && !force) {
            throw new ResourceAlreadyExists();
        }
        SharedObject sharedObject = null;
        String id = this.calculateId(iFile);
        try {
            this.SYNC.acquire();
            sharedObject = (SharedObject)this.fManagedObjects.get(id);
            if (sharedObject != null && !force) {
                throw new ResourceInUse();
            }
            sharedObject = new SharedObject(id);
            this.fManagedObjects.put(id, sharedObject);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.SYNC.release();
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        this.SYNC.release();
        aSharedModel = FileBufferModelManager.getInstance().getModel(iFile);
        aSharedModel.setNewState(true);
        sharedObject.theSharedModel = aSharedModel;
        aSharedModel.resetSynchronizationStamp((IResource)iFile);
        return sharedObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStructuredModel _getModelFor(IStructuredDocument document, ReadEditType accessType) {
        String id = FileBufferModelManager.getInstance().calculateId(document);
        if (id == null) {
            if (this.READ == accessType) {
                return this.getExistingModelForRead(document);
            }
            if (this.EDIT == accessType) {
                return this.getExistingModelForEdit(document);
            }
            Assert.isNotNull(id, "unknown IStructuredDocument " + document);
        }
        SharedObject sharedObject = null;
        this.SYNC.acquire();
        sharedObject = (SharedObject)this.fManagedObjects.get(id);
        this.SYNC.release();
        while (true) {
            if (sharedObject != null) {
                sharedObject.waitForLoadAttempt();
            }
            this.SYNC.acquire();
            SharedObject testObject = (SharedObject)this.fManagedObjects.get(id);
            if (testObject == null) {
                sharedObject = new SharedObject(id);
                this.fManagedObjects.put(id, sharedObject);
                this.SYNC.release();
                SharedObject sharedObject2 = sharedObject;
                synchronized (sharedObject2) {
                    sharedObject.theSharedModel = FileBufferModelManager.getInstance().getModel(document);
                    this._initCount(sharedObject, accessType);
                    sharedObject.setLoaded();
                    break;
                }
            }
            if (sharedObject == testObject) {
                SharedObject sharedObject3 = sharedObject;
                synchronized (sharedObject3) {
                    Assert.isTrue(sharedObject.referenceCountForEdit + sharedObject.referenceCountForRead > 0, "reference count was less than zero");
                    if (sharedObject.theSharedModel != null) {
                        this._incrCount(sharedObject, accessType);
                    }
                }
                this.SYNC.release();
                break;
            }
            this.SYNC.release();
            sharedObject = testObject;
        }
        return sharedObject == null ? null : sharedObject.theSharedModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _incrCount(SharedObject sharedObject, ReadEditType type) {
        SharedObject sharedObject2 = sharedObject;
        synchronized (sharedObject2) {
            if (type == this.READ) {
                ++sharedObject.referenceCountForRead;
                FileBufferModelManager.getInstance().connect(sharedObject.theSharedModel.getStructuredDocument());
            } else if (type == this.EDIT) {
                ++sharedObject.referenceCountForEdit;
                FileBufferModelManager.getInstance().connect(sharedObject.theSharedModel.getStructuredDocument());
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _initCount(SharedObject sharedObject, ReadEditType type) {
        SharedObject sharedObject2 = sharedObject;
        synchronized (sharedObject2) {
            if (type == this.READ) {
                FileBufferModelManager.getInstance().connect(sharedObject.theSharedModel.getStructuredDocument());
                sharedObject.referenceCountForRead = 1;
            } else if (type == this.EDIT) {
                FileBufferModelManager.getInstance().connect(sharedObject.theSharedModel.getStructuredDocument());
                sharedObject.referenceCountForEdit = 1;
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    private void addFactories(IStructuredModel model, IModelHandler handler) {
        Assert.isNotNull(model, "model can not be null");
        FactoryRegistry registry = model.getFactoryRegistry();
        Assert.isNotNull(registry, "model's Factory Registry can not be null");
        List factoryList = handler.getAdapterFactories();
        this.addFactories(model, factoryList);
    }

    private void addFactories(IStructuredModel model, List factoryList) {
        Assert.isNotNull(model, "model can not be null");
        FactoryRegistry registry = model.getFactoryRegistry();
        Assert.isNotNull(registry, "model's Factory Registry can not be null");
        if (factoryList != null) {
            Iterator iterator = factoryList.iterator();
            while (iterator.hasNext()) {
                INodeAdapterFactory factory = (INodeAdapterFactory)iterator.next();
                registry.addFactory(factory);
            }
        }
    }

    public String calculateId(IFile file) {
        return FileBufferModelManager.getInstance().calculateId(file);
    }

    private IModelHandler calculateType(IFile iFile) throws CoreException {
        ModelHandlerRegistry cr = this.getModelHandlerRegistry();
        IModelHandler cd = cr.getHandlerFor(iFile);
        return cd;
    }

    private IModelHandler calculateType(String filename, InputStream inputStream) throws IOException {
        ModelHandlerRegistry cr = this.getModelHandlerRegistry();
        IModelHandler cd = cr.getHandlerFor(filename, inputStream);
        return cd;
    }

    private URIResolver calculateURIResolver(IFile file) {
        Object location;
        URIResolver resolver;
        IProject project = file.getProject();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.sse.core.internal.util.URIResolver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((resolver = (URIResolver)project.getAdapter((Class)clazz)) == null) {
            resolver = new ProjectResolver(project);
        }
        if ((location = file.getLocation()) == null) {
            location = file.getLocationURI();
        }
        if (location != null) {
            resolver.setFileBaseLocation(location.toString());
        }
        return resolver;
    }

    private void convertLineDelimiters(IDocument document, IFile iFile) throws CoreException {
        String contentTypeId = this.calculateType(iFile).getAssociatedContentTypeId();
        String endOfLineCode = ContentBasedPreferenceGateway.getPreferencesString(contentTypeId, "endOfLineCode");
        if (endOfLineCode != null && endOfLineCode.length() > 0) {
            String lineDelimiterToUse = System.getProperty("line.separator");
            if (endOfLineCode.equals("EOL_Mac")) {
                lineDelimiterToUse = "\r";
            } else if (endOfLineCode.equals("EOL_Unix")) {
                lineDelimiterToUse = "\n";
            } else if (endOfLineCode.equals("EOL_Windows")) {
                lineDelimiterToUse = "\r\n";
            }
            MultiTextEdit multiTextEdit = new MultiTextEdit();
            int lineCount = document.getNumberOfLines();
            try {
                int i = 0;
                while (i < lineCount) {
                    String currentLineDelimiter;
                    IRegion lineInfo = document.getLineInformation(i);
                    int lineStartOffset = lineInfo.getOffset();
                    int lineLength = lineInfo.getLength();
                    int lineEndOffset = lineStartOffset + lineLength;
                    if (i < lineCount - 1 && (currentLineDelimiter = document.getLineDelimiter(i)) != null && currentLineDelimiter.compareTo(lineDelimiterToUse) != 0) {
                        multiTextEdit.addChild((TextEdit)new ReplaceEdit(lineEndOffset, currentLineDelimiter.length(), lineDelimiterToUse));
                    }
                    ++i;
                }
                if (multiTextEdit.getChildrenSize() > 0) {
                    multiTextEdit.apply(document);
                }
            }
            catch (BadLocationException exception) {
                throw new RuntimeException(exception.getMessage());
            }
        }
    }

    private IStructuredModel copy(IStructuredModel model, String newId) throws ResourceInUse {
        IStructuredModel newModel = null;
        IStructuredModel oldModel = model;
        IModelHandler modelHandler = oldModel.getModelHandler();
        IModelLoader loader = modelHandler.getModelLoader();
        newModel = loader.createModel(oldModel);
        newModel.setModelHandler(modelHandler);
        newModel.setResolver(oldModel.getResolver());
        newModel.setModelManager(oldModel.getModelManager());
        newModel.setId(newId);
        String contents = oldModel.getStructuredDocument().getText();
        newModel.getStructuredDocument().setText(this, contents);
        return newModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStructuredModel copyModelForEdit(String oldId, String newId) throws ResourceInUse {
        SharedObject sharedObject;
        IStructuredModel newModel = null;
        IStructuredModel model = this.getExistingModel(oldId);
        if (model == null) {
            return null;
        }
        SharedObject sharedObject2 = null;
        try {
            this.SYNC.acquire();
            sharedObject2 = (SharedObject)this.fManagedObjects.get(newId);
            if (sharedObject2 != null) {
                throw new ResourceInUse();
            }
            sharedObject2 = new SharedObject(newId);
            this.fManagedObjects.put(newId, sharedObject2);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.SYNC.release();
            throw throwable;
        }
        {
            sharedObject = null;
        }
        this.SYNC.release();
        sharedObject = sharedObject2;
        synchronized (sharedObject) {
            sharedObject2.doWait = false;
            newModel = this.copy(model, newId);
            sharedObject2.doWait = true;
        }
        if (newModel != null) {
            sharedObject = sharedObject2;
            synchronized (sharedObject) {
                sharedObject2.theSharedModel = newModel;
                sharedObject2.referenceCountForEdit = 1;
                this.trace("copied model", newId, sharedObject2.referenceCountForEdit);
            }
        } else {
            this.SYNC.acquire();
            this.fManagedObjects.remove(newId);
            this.SYNC.release();
        }
        sharedObject2.setLoaded();
        return newModel;
    }

    public IStructuredModel createNewInstance(IStructuredModel oldModel) throws IOException {
        IModelHandler handler = oldModel.getModelHandler();
        IModelLoader loader = handler.getModelLoader();
        IStructuredModel newModel = loader.createModel(oldModel);
        newModel.setModelHandler(handler);
        if (newModel instanceof AbstractStructuredModel) {
            ((AbstractStructuredModel)newModel).setContentTypeIdentifier(oldModel.getContentTypeIdentifier());
        }
        URIResolver oldResolver = oldModel.getResolver();
        newModel.setResolver(oldResolver);
        try {
            newModel.setId("org.eclipse.wst.sse.core.IModelManager.DUPLICATED_MODEL");
        }
        catch (ResourceInUse resourceInUse) {}
        newModel.setBaseLocation(null);
        return newModel;
    }

    public IStructuredDocument createNewStructuredDocumentFor(IFile iFile) throws ResourceAlreadyExists, IOException, CoreException {
        if (iFile.exists()) {
            throw new ResourceAlreadyExists(iFile.getFullPath().toOSString());
        }
        IDocumentLoader loader = null;
        IModelHandler handler = this.calculateType(iFile);
        loader = handler.getDocumentLoader();
        IStructuredDocument result = (IStructuredDocument)loader.createNewStructuredDocument();
        return result;
    }

    public IStructuredDocument createStructuredDocumentFor(IFile iFile) throws IOException, CoreException {
        if (!iFile.exists()) {
            throw new FileNotFoundException(iFile.getFullPath().toOSString());
        }
        IDocumentLoader loader = null;
        IModelHandler handler = this.calculateType(iFile);
        loader = handler.getDocumentLoader();
        IStructuredDocument result = (IStructuredDocument)loader.createNewStructuredDocument(iFile);
        return result;
    }

    public IStructuredDocument createStructuredDocumentFor(String contentTypeId) {
        IDocumentLoader loader = null;
        ModelHandlerRegistry cr = this.getModelHandlerRegistry();
        IModelHandler handler = cr.getHandlerForContentTypeId(contentTypeId);
        if (handler == null) {
            Logger.log(4, "Program error: no model handler found for " + contentTypeId);
        }
        loader = handler.getDocumentLoader();
        IStructuredDocument result = (IStructuredDocument)loader.createNewStructuredDocument();
        return result;
    }

    public IStructuredDocument createStructuredDocumentFor(String filename, InputStream inputStream, URIResolver resolver) throws IOException {
        IDocumentLoader loader = null;
        InputStream istream = Utilities.getMarkSupportedStream(inputStream);
        if (istream != null) {
            istream.reset();
        }
        IModelHandler handler = this.calculateType(filename, istream);
        loader = handler.getDocumentLoader();
        IStructuredDocument result = null;
        result = inputStream == null ? (IStructuredDocument)loader.createNewStructuredDocument() : (IStructuredDocument)loader.createNewStructuredDocument(filename, istream);
        return result;
    }

    public IStructuredDocument createStructuredDocumentFor(String filename, InputStream inputStream, URIResolver resolver, String encoding) throws IOException {
        String content = this.readInputStream(inputStream, encoding);
        IStructuredDocument result = this.createStructuredDocumentFor(filename, content, resolver);
        return result;
    }

    public IStructuredDocument createStructuredDocumentFor(String filename, String content, URIResolver resolver) throws IOException {
        StringBuffer contentBuffer = new StringBuffer(content);
        IDocumentLoader loader = null;
        IModelHandler handler = this.calculateType(filename, null);
        loader = handler.getDocumentLoader();
        IStructuredDocument result = (IStructuredDocument)loader.createNewStructuredDocument();
        StringBuffer convertedContent = loader.handleLineDelimiter(contentBuffer, result);
        result.setEncodingMemento(new NullMemento());
        result.setText(this, convertedContent.toString());
        return result;
    }

    private IStructuredModel createUnManagedEmptyModelFor(IFile iFile) throws CoreException {
        IStructuredModel result;
        block2: {
            result = null;
            IModelHandler handler = this.calculateType(iFile);
            String id = this.calculateId(iFile);
            URIResolver resolver = this.calculateURIResolver(iFile);
            try {
                result = this._commonCreateModel(id, handler, resolver);
            }
            catch (ResourceInUse resourceInUse) {
                if (!Logger.DEBUG_MODELMANAGER) break block2;
                Logger.log(1, "ModelMangerImpl::createUnManagedStructuredModelFor. Model unexpectedly in use.");
            }
        }
        return result;
    }

    public IStructuredModel createUnManagedStructuredModelFor(IFile iFile) throws IOException, CoreException {
        IStructuredModel result = null;
        result = this.createUnManagedEmptyModelFor(iFile);
        IDocumentLoader loader = result.getModelHandler().getDocumentLoader();
        IEncodedDocument document = loader.createNewStructuredDocument(iFile);
        result.getStructuredDocument().setText(this, document.get());
        return result;
    }

    public IStructuredModel createUnManagedStructuredModelFor(String contentTypeId) {
        return this.createUnManagedStructuredModelFor(contentTypeId, null);
    }

    public IStructuredModel createUnManagedStructuredModelFor(String contentTypeId, URIResolver resolver) {
        IStructuredModel result;
        block2: {
            result = null;
            ModelHandlerRegistry cr = this.getModelHandlerRegistry();
            IModelHandler handler = cr.getHandlerForContentTypeId(contentTypeId);
            try {
                result = this._commonCreateModel("org.eclipse.wst.sse.core.IModelManager.UNMANAGED_MODEL", handler, resolver);
            }
            catch (ResourceInUse resourceInUse) {
                if (!Logger.DEBUG_MODELMANAGER) break block2;
                Logger.log(1, "ModelMangerImpl::createUnManagedStructuredModelFor. Model unexpectedly in use.");
            }
        }
        return result;
    }

    private IStructuredModel getExistingModel(Object id) {
        IStructuredModel result = null;
        this.SYNC.acquire();
        SharedObject sharedObject = (SharedObject)this.fManagedObjects.get(id);
        if (sharedObject != null) {
            this.SYNC.release();
            sharedObject.waitForLoadAttempt();
            result = sharedObject.theSharedModel;
        } else {
            this.SYNC.release();
        }
        return result;
    }

    public IStructuredModel getExistingModelForEdit(IDocument document) {
        IStructuredModel result = null;
        this.SYNC.acquire();
        HashSet ids = new HashSet(this.fManagedObjects.keySet());
        this.SYNC.release();
        Iterator iterator = ids.iterator();
        while (iterator.hasNext()) {
            Object potentialId = iterator.next();
            this.SYNC.acquire();
            if (this.fManagedObjects.containsKey(potentialId)) {
                this.SYNC.release();
                IStructuredModel tempResult = this.getExistingModel(potentialId);
                if (tempResult == null || document != tempResult.getStructuredDocument()) continue;
                result = this.getExistingModelForEdit(potentialId);
                break;
            }
            this.SYNC.release();
        }
        return result;
    }

    public IStructuredModel getExistingModelForEdit(IFile iFile) {
        Assert.isNotNull(iFile, "IFile parameter can not be null");
        String id = this.calculateId(iFile);
        IStructuredModel result = this.getExistingModelForEdit(id);
        return result;
    }

    /*
     * Exception decompiling
     */
    public IStructuredModel getExistingModelForEdit(Object id) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [3 : 153->156)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public IStructuredModel getExistingModelForRead(IDocument document) {
        IStructuredModel result = null;
        this.SYNC.acquire();
        HashSet ids = new HashSet(this.fManagedObjects.keySet());
        this.SYNC.release();
        Iterator iterator = ids.iterator();
        while (iterator.hasNext()) {
            Object potentialId = iterator.next();
            this.SYNC.acquire();
            if (this.fManagedObjects.containsKey(potentialId)) {
                this.SYNC.release();
                IStructuredModel tempResult = this.getExistingModel(potentialId);
                if (tempResult == null || document != tempResult.getStructuredDocument()) continue;
                result = this.getExistingModelForRead(potentialId);
                break;
            }
            this.SYNC.release();
        }
        return result;
    }

    public IStructuredModel getExistingModelForRead(IFile iFile) {
        Assert.isNotNull(iFile, "IFile parameter can not be null");
        String id = this.calculateId(iFile);
        IStructuredModel result = this.getExistingModelForRead(id);
        return result;
    }

    /*
     * Exception decompiling
     */
    public IStructuredModel getExistingModelForRead(Object id) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [3 : 129->132)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Enumeration getExistingModelIds() {
        Enumeration enumeration;
        try {
            this.SYNC.acquire();
            Vector keys = new Vector(this.fManagedObjects.keySet());
            enumeration = keys.elements();
            Object var2_3 = null;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            this.SYNC.release();
            throw throwable;
        }
        this.SYNC.release();
        return enumeration;
    }

    private IFile getFileFor(IStructuredModel model) {
        if (model == null) {
            return null;
        }
        String path = model.getBaseLocation();
        if (path == null || path.length() == 0) {
            String id = model.getId();
            if (id == null) {
                return null;
            }
            path = id.toString();
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile file = root.getFileForLocation((IPath)new Path(path));
        return file;
    }

    public IStructuredModel getModelForEdit(IFile iFile) throws IOException, CoreException {
        Assert.isNotNull(iFile, "IFile parameter can not be null");
        return this._commonGetModel(iFile, this.EDIT, null, null);
    }

    public IStructuredModel getModelForEdit(IFile iFile, EncodingRule encodingRule) throws UnsupportedEncodingException, IOException, CoreException {
        Assert.isNotNull(iFile, "IFile parameter can not be null");
        return this._commonGetModel(iFile, this.EDIT, encodingRule);
    }

    public IStructuredModel getModelForEdit(IFile iFile, String encoding, String lineDelimiter) throws UnsupportedEncodingException, IOException, CoreException {
        Assert.isNotNull(iFile, "IFile parameter can not be null");
        return this._commonGetModel(iFile, this.EDIT, encoding, lineDelimiter);
    }

    public IStructuredModel getModelForEdit(IStructuredDocument document) {
        return this._getModelFor(document, this.EDIT);
    }

    public IStructuredModel getModelForEdit(Object id, InputStream inputStream, URIResolver resolver) throws UnsupportedEncodingException, IOException {
        Assert.isNotNull(id, "requested model id can not be null");
        String stringId = id.toString();
        return this.getModelForEdit(stringId, Utilities.getMarkSupportedStream(inputStream), resolver);
    }

    public IStructuredModel getModelForEdit(Object id, Object modelType, String encodingName, String lineDelimiter, InputStream inputStream, URIResolver resolver) throws UnsupportedEncodingException, IOException {
        Assert.isNotNull(id, "id parameter can not be null");
        String stringId = id.toString();
        return this.getModelForEdit(stringId, Utilities.getMarkSupportedStream(inputStream), resolver);
    }

    public IStructuredModel getModelForEdit(String id, InputStream inputStream, URIResolver resolver) throws IOException {
        if (id == null) {
            throw new IllegalArgumentException("Program Error: id may not be null");
        }
        IStructuredModel result = null;
        InputStream istream = Utilities.getMarkSupportedStream(inputStream);
        IModelHandler handler = this.calculateType(id, istream);
        if (handler != null) {
            result = this._commonCreateModel(istream, id, handler, resolver, this.EDIT, null, null);
        } else {
            Logger.log(1, "no model handler found for id");
        }
        return result;
    }

    public IStructuredModel getModelForRead(IFile iFile) throws IOException, CoreException {
        Assert.isNotNull(iFile, "IFile parameter can not be null");
        return this._commonGetModel(iFile, this.READ, null, null);
    }

    public IStructuredModel getModelForRead(IFile iFile, EncodingRule encodingRule) throws UnsupportedEncodingException, IOException, CoreException {
        Assert.isNotNull(iFile, "IFile parameter can not be null");
        return this._commonGetModel(iFile, this.READ, encodingRule);
    }

    public IStructuredModel getModelForRead(IFile iFile, String encodingName, String lineDelimiter) throws UnsupportedEncodingException, IOException, CoreException {
        Assert.isNotNull(iFile, "IFile parameter can not be null");
        return this._commonGetModel(iFile, this.READ, encodingName, lineDelimiter);
    }

    public IStructuredModel getModelForRead(IStructuredDocument document) {
        return this._getModelFor(document, this.READ);
    }

    public IStructuredModel getModelForRead(Object id, InputStream inputStream, URIResolver resolver) throws UnsupportedEncodingException, IOException {
        Assert.isNotNull(id, "id parameter can not be null");
        String stringId = id.toString();
        return this.getModelForRead(stringId, Utilities.getMarkSupportedStream(inputStream), resolver);
    }

    public IStructuredModel getModelForRead(Object id, Object modelType, String encodingName, String lineDelimiter, InputStream inputStream, URIResolver resolver) throws UnsupportedEncodingException, IOException {
        Assert.isNotNull(id, "id parameter can not be null");
        String stringId = id.toString();
        return this.getModelForRead(stringId, Utilities.getMarkSupportedStream(inputStream), resolver);
    }

    public IStructuredModel getModelForRead(String id, InputStream inputStream, URIResolver resolver) throws IOException {
        InputStream istream = Utilities.getMarkSupportedStream(inputStream);
        IModelHandler handler = this.calculateType(id, istream);
        IStructuredModel result = null;
        result = this._commonCreateModel(istream, id, handler, resolver, this.READ, null, null);
        return result;
    }

    public ModelHandlerRegistry getModelHandlerRegistry() {
        if (this.fModelHandlerRegistry == null) {
            this.fModelHandlerRegistry = ModelHandlerRegistry.getInstance();
        }
        return this.fModelHandlerRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStructuredModel getNewModelForEdit(IFile iFile, boolean force) throws ResourceAlreadyExists, ResourceInUse, IOException, CoreException {
        SharedObject sharedObject;
        Assert.isNotNull(iFile, "IFile parameter can not be null");
        SharedObject sharedObject2 = sharedObject = this._commonNewModel(iFile, force);
        synchronized (sharedObject2) {
            sharedObject.referenceCountForEdit = 1;
        }
        sharedObject.setLoaded();
        return sharedObject.theSharedModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStructuredModel getNewModelForRead(IFile iFile, boolean force) throws ResourceAlreadyExists, ResourceInUse, IOException, CoreException {
        Assert.isNotNull(iFile, "IFile parameter can not be null");
        SharedObject sharedObject = this._commonNewModel(iFile, force);
        this.SYNC.acquire();
        SharedObject sharedObject2 = sharedObject;
        synchronized (sharedObject2) {
            if (sharedObject.theSharedModel != null) {
                sharedObject.referenceCountForRead = 1;
            }
        }
        this.SYNC.release();
        sharedObject.setLoaded();
        return sharedObject.theSharedModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getReferenceCount(Object id) {
        Assert.isNotNull(id, "id parameter can not be null");
        int count = 0;
        this.SYNC.acquire();
        SharedObject sharedObject = (SharedObject)this.fManagedObjects.get(id);
        if (sharedObject != null) {
            this.SYNC.release();
            sharedObject.waitForLoadAttempt();
            this.SYNC.acquire();
            SharedObject sharedObject2 = sharedObject;
            synchronized (sharedObject2) {
                count = sharedObject.referenceCountForRead + sharedObject.referenceCountForEdit;
            }
        }
        this.SYNC.release();
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getReferenceCountForEdit(Object id) {
        Assert.isNotNull(id, "id parameter can not be null");
        int count = 0;
        this.SYNC.acquire();
        SharedObject sharedObject = (SharedObject)this.fManagedObjects.get(id);
        if (sharedObject != null) {
            this.SYNC.release();
            sharedObject.waitForLoadAttempt();
            SharedObject sharedObject2 = sharedObject;
            synchronized (sharedObject2) {
                count = sharedObject.referenceCountForEdit;
            }
        } else {
            this.SYNC.release();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getReferenceCountForRead(Object id) {
        Assert.isNotNull(id, "id parameter can not be null");
        int count = 0;
        this.SYNC.acquire();
        SharedObject sharedObject = (SharedObject)this.fManagedObjects.get(id);
        if (sharedObject != null) {
            this.SYNC.release();
            sharedObject.waitForLoadAttempt();
            this.SYNC.acquire();
            SharedObject sharedObject2 = sharedObject;
            synchronized (sharedObject2) {
                count = sharedObject.referenceCountForRead;
            }
        }
        this.SYNC.release();
        return count;
    }

    private void handleConvertLineDelimiters(IStructuredDocument structuredDocument, IFile iFile, EncodingRule encodingRule, EncodingMemento encodingMemento) throws CoreException, MalformedOutputExceptionWithDetail, UnsupportedEncodingException {
        if (structuredDocument.getNumberOfLines() > 1) {
            this.convertLineDelimiters(structuredDocument, iFile);
        }
    }

    private void handleProgramError(Throwable t) {
        Logger.logException("Impossible Program Error", t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isShared(Object id) {
        Assert.isNotNull(id, "id parameter can not be null");
        int count = 0;
        boolean result = false;
        this.SYNC.acquire();
        SharedObject sharedObject = (SharedObject)this.fManagedObjects.get(id);
        if (sharedObject != null) {
            this.SYNC.release();
            sharedObject.waitForLoadAttempt();
            this.SYNC.acquire();
            SharedObject sharedObject2 = sharedObject;
            synchronized (sharedObject2) {
                count = sharedObject.referenceCountForRead + sharedObject.referenceCountForEdit;
            }
        }
        this.SYNC.release();
        result = count > 1;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSharedForEdit(Object id) {
        Assert.isNotNull(id, "id parameter can not be null");
        int count = 0;
        boolean result = false;
        this.SYNC.acquire();
        SharedObject sharedObject = (SharedObject)this.fManagedObjects.get(id);
        if (sharedObject != null) {
            this.SYNC.release();
            sharedObject.waitForLoadAttempt();
            SharedObject sharedObject2 = sharedObject;
            synchronized (sharedObject2) {
                count = sharedObject.referenceCountForEdit;
            }
        } else {
            this.SYNC.release();
        }
        result = count > 1;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSharedForRead(Object id) {
        Assert.isNotNull(id, "id parameter can not be null");
        int count = 0;
        boolean result = false;
        this.SYNC.acquire();
        SharedObject sharedObject = (SharedObject)this.fManagedObjects.get(id);
        if (sharedObject != null) {
            this.SYNC.release();
            sharedObject.waitForLoadAttempt();
            this.SYNC.acquire();
            SharedObject sharedObject2 = sharedObject;
            synchronized (sharedObject2) {
                count = sharedObject.referenceCountForRead;
            }
        }
        this.SYNC.release();
        result = count > 1;
        return result;
    }

    public boolean isStateChanging() {
        return false;
    }

    public void moveModel(Object oldId, Object newId) {
        Assert.isNotNull(oldId, "old id parameter can not be null");
        Assert.isNotNull(newId, "new id parameter can not be null");
        this.SYNC.acquire();
        SharedObject sharedObject = (SharedObject)this.fManagedObjects.get(oldId);
        if (sharedObject != null) {
            this.fManagedObjects.remove(oldId);
            this.fManagedObjects.put(newId, sharedObject);
        }
        this.SYNC.release();
    }

    private String readInputStream(InputStream inputStream, String ianaEncodingName) throws UnsupportedEncodingException, IOException {
        String allText = null;
        if (ianaEncodingName != null && ianaEncodingName.length() != 0) {
            String enc = CodedIO.getAppropriateJavaCharset(ianaEncodingName);
            if (enc == null) {
                enc = ianaEncodingName;
            }
            allText = this.readInputStream(new InputStreamReader(inputStream, enc));
        } else {
            allText = this.readInputStream(new InputStreamReader(inputStream));
        }
        return allText;
    }

    private String readInputStream(InputStreamReader inputStream) throws IOException {
        int numRead = 0;
        StringBuffer buffer = new StringBuffer();
        char[] tBuff = new char[4096];
        while ((numRead = inputStream.read(tBuff, 0, tBuff.length)) != -1) {
            buffer.append(tBuff, 0, numRead);
        }
        return buffer.toString();
    }

    public IStructuredModel reinitialize(IStructuredModel model) {
        IModelHandler handler = model.getModelHandler();
        IModelLoader loader = handler.getModelLoader();
        model = loader.reinitialize(model);
        return model;
    }

    void releaseFromEdit(IStructuredModel structuredModel) {
        String id = structuredModel.getId();
        if (id.equals("org.eclipse.wst.sse.core.IModelManager.UNMANAGED_MODEL") || id.equals("org.eclipse.wst.sse.core.IModelManager.DUPLICATED_MODEL")) {
            this.cleanupDiscardedModel(structuredModel);
        } else {
            this.releaseFromEdit(id);
        }
    }

    void releaseFromRead(IStructuredModel structuredModel) {
        String id = structuredModel.getId();
        if (id.equals("org.eclipse.wst.sse.core.IModelManager.UNMANAGED_MODEL") || id.equals("org.eclipse.wst.sse.core.IModelManager.DUPLICATED_MODEL")) {
            this.cleanupDiscardedModel(structuredModel);
        } else {
            this.releaseFromRead(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseFromEdit(Object id) {
        Assert.isNotNull(id, "id parameter can not be null");
        SharedObject sharedObject = null;
        if (id.equals("org.eclipse.wst.sse.core.IModelManager.UNMANAGED_MODEL") || id.equals("org.eclipse.wst.sse.core.IModelManager.DUPLICATED_MODEL")) {
            throw new IllegalArgumentException("Ids of UNMANAGED_MODEL or DUPLICATED_MODEL are illegal here");
        }
        this.SYNC.acquire();
        sharedObject = (SharedObject)this.fManagedObjects.get(id);
        this.SYNC.release();
        Assert.isNotNull(sharedObject, "release was requested on a model that was not being managed");
        sharedObject.waitForLoadAttempt();
        this.SYNC.acquire();
        SharedObject sharedObject2 = sharedObject;
        synchronized (sharedObject2) {
            this._decrCount(sharedObject, this.EDIT);
            if (sharedObject.referenceCountForRead == 0 && sharedObject.referenceCountForEdit == 0) {
                this.discardModel(id, sharedObject);
            }
        }
        this.SYNC.release();
        sharedObject2 = sharedObject;
        synchronized (sharedObject2) {
            if (sharedObject.referenceCountForRead > 0 && sharedObject.referenceCountForEdit == 0 && sharedObject.theSharedModel.isDirty()) {
                this.signalPreLifeCycleListenerRevert(sharedObject.theSharedModel);
                this.revertModel(id, sharedObject);
                if (sharedObject.referenceCountForRead > 0 && sharedObject.referenceCountForEdit == 0) {
                    sharedObject.theSharedModel.setDirtyState(false);
                }
                this.signalPostLifeCycleListenerRevert(sharedObject.theSharedModel);
            }
        }
    }

    private void revertModel(Object id, SharedObject sharedObject) {
        IStructuredDocument structuredDocument = sharedObject.theSharedModel.getStructuredDocument();
        FileBufferModelManager.getInstance().revert(structuredDocument);
    }

    private void signalPreLifeCycleListenerRevert(IStructuredModel structuredModel) {
        int type = 261;
        ModelLifecycleEvent event = new ModelLifecycleEvent(structuredModel, type);
        ((AbstractStructuredModel)structuredModel).signalLifecycleEvent(event);
    }

    private void signalPostLifeCycleListenerRevert(IStructuredModel structuredModel) {
        int type = 517;
        ModelLifecycleEvent event = new ModelLifecycleEvent(structuredModel, type);
        ((AbstractStructuredModel)structuredModel).signalLifecycleEvent(event);
    }

    private void discardModel(Object id, SharedObject sharedObject) {
        this.SYNC.acquire();
        this.fManagedObjects.remove(id);
        this.SYNC.release();
        IStructuredDocument structuredDocument = sharedObject.theSharedModel.getStructuredDocument();
        if (structuredDocument == null) {
            Platform.getLog((Bundle)SSECorePlugin.getDefault().getBundle()).log((IStatus)new Status(4, "org.eclipse.wst.sse.core", 4, "Attempted to discard a structured model but the underlying document has already been set to null: " + sharedObject.theSharedModel.getBaseLocation(), null));
        }
        this.cleanupDiscardedModel(sharedObject.theSharedModel);
    }

    private void cleanupDiscardedModel(IStructuredModel structuredModel) {
        IStructuredDocument structuredDocument = structuredModel.getStructuredDocument();
        structuredModel.getFactoryRegistry().release();
        FileBufferModelManager.getInstance().releaseModel(structuredDocument);
        structuredModel.setStructuredDocument(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseFromRead(Object id) {
        Assert.isNotNull(id, "id parameter can not be null");
        SharedObject sharedObject = null;
        if (id.equals("org.eclipse.wst.sse.core.IModelManager.UNMANAGED_MODEL") || id.equals("org.eclipse.wst.sse.core.IModelManager.DUPLICATED_MODEL")) {
            throw new IllegalArgumentException("Ids of UNMANAGED_MODEL or DUPLICATED_MODEL are illegal here");
        }
        this.SYNC.acquire();
        sharedObject = (SharedObject)this.fManagedObjects.get(id);
        this.SYNC.release();
        Assert.isNotNull(sharedObject, "release was requested on a model that was not being managed");
        sharedObject.waitForLoadAttempt();
        this.SYNC.acquire();
        SharedObject sharedObject2 = sharedObject;
        synchronized (sharedObject2) {
            this._decrCount(sharedObject, this.READ);
            if (sharedObject.referenceCountForRead == 0 && sharedObject.referenceCountForEdit == 0) {
                this.discardModel(id, sharedObject);
            }
        }
        this.SYNC.release();
    }

    public IStructuredModel reloadModel(Object id, InputStream inputStream) throws UnsupportedEncodingException {
        Assert.isNotNull(id, "id parameter can not be null");
        IStructuredModel structuredModel = this.getExistingModel(id);
        if (structuredModel != null) {
            IModelHandler handler = structuredModel.getModelHandler();
            IModelLoader loader = handler.getModelLoader();
            loader.reload(Utilities.getMarkSupportedStream(inputStream), structuredModel);
            this.trace("re-loading model", id);
        }
        return structuredModel;
    }

    public void saveModel(IFile iFile, String id, EncodingRule encodingRule) throws UnsupportedEncodingException, IOException, CoreException {
        Assert.isNotNull(iFile, "file parameter can not be null");
        Assert.isNotNull(id, "id parameter can not be null");
        this.SYNC.acquire();
        SharedObject sharedObject = (SharedObject)this.fManagedObjects.get(id);
        if (sharedObject == null || sharedObject.theSharedModel == null) {
            this.SYNC.release();
            throw new IllegalStateException(SSECoreMessages.Program_Error__ModelManage_EXC_);
        }
        this.SYNC.release();
        sharedObject.waitForLoadAttempt();
        boolean saved = false;
        if (FileBufferModelManager.getInstance().isExistingBuffer(sharedObject.theSharedModel.getStructuredDocument())) {
            ITextFileBuffer buffer = FileBufferModelManager.getInstance().getBuffer(sharedObject.theSharedModel.getStructuredDocument());
            IPath fileLocation = FileBuffers.normalizeLocation((IPath)iFile.getFullPath());
            if (fileLocation.equals((Object)buffer.getLocation())) {
                buffer.commit((IProgressMonitor)new NullProgressMonitor(), true);
                saved = true;
            }
        }
        if (!saved) {
            IStructuredModel model = sharedObject.theSharedModel;
            IStructuredDocument document = model.getStructuredDocument();
            this.saveStructuredDocument(document, iFile, encodingRule);
            this.trace("saving model", id);
        }
        sharedObject.theSharedModel.setDirtyState(false);
        sharedObject.theSharedModel.setNewState(false);
    }

    public void saveModel(String id, EncodingRule encodingRule) throws UnsupportedEncodingException, IOException, CoreException {
        Assert.isNotNull(id, "id parameter can not be null");
        this.SYNC.acquire();
        SharedObject sharedObject = (SharedObject)this.fManagedObjects.get(id);
        if (sharedObject == null) {
            this.SYNC.release();
            throw new IllegalStateException(SSECoreMessages.Program_Error__ModelManage_EXC_);
        }
        this.SYNC.release();
        sharedObject.waitForLoadAttempt();
        if (FileBufferModelManager.getInstance().isExistingBuffer(sharedObject.theSharedModel.getStructuredDocument())) {
            ITextFileBuffer buffer = FileBufferModelManager.getInstance().getBuffer(sharedObject.theSharedModel.getStructuredDocument());
            buffer.commit((IProgressMonitor)new NullProgressMonitor(), true);
        } else {
            IFile iFile = this.getFileFor(sharedObject.theSharedModel);
            IStructuredModel model = sharedObject.theSharedModel;
            IStructuredDocument document = model.getStructuredDocument();
            this.saveStructuredDocument(document, iFile);
            this.trace("saving model", id);
        }
        sharedObject.theSharedModel.setDirtyState(false);
        sharedObject.theSharedModel.setNewState(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveModel(String id, OutputStream outputStream, EncodingRule encodingRule) throws UnsupportedEncodingException, CoreException, IOException {
        Assert.isNotNull(id, "id parameter can not be null");
        this.SYNC.acquire();
        SharedObject sharedObject = (SharedObject)this.fManagedObjects.get(id);
        if (sharedObject == null) {
            this.SYNC.release();
            throw new IllegalStateException(SSECoreMessages.Program_Error__ModelManage_EXC_);
        }
        this.SYNC.release();
        sharedObject.waitForLoadAttempt();
        SharedObject sharedObject2 = sharedObject;
        synchronized (sharedObject2) {
            CodedStreamCreator codedStreamCreator = new CodedStreamCreator();
            codedStreamCreator.set(sharedObject.theSharedModel.getId(), (Reader)new DocumentReader(sharedObject.theSharedModel.getStructuredDocument()));
            codedStreamCreator.setPreviousEncodingMemento(sharedObject.theSharedModel.getStructuredDocument().getEncodingMemento());
            ByteArrayOutputStream byteArrayOutputStream = codedStreamCreator.getCodedByteArrayOutputStream(encodingRule);
            byte[] outputBytes = byteArrayOutputStream.toByteArray();
            outputStream.write(outputBytes);
            this.trace("saving model", id);
            sharedObject.theSharedModel.setDirtyState(false);
            sharedObject.theSharedModel.setNewState(false);
        }
    }

    public void saveStructuredDocument(IStructuredDocument structuredDocument, IFile iFile) throws UnsupportedEncodingException, CoreException, IOException {
        this.saveStructuredDocument(structuredDocument, iFile, EncodingRule.CONTENT_BASED);
    }

    public void saveStructuredDocument(IStructuredDocument structuredDocument, IFile iFile, EncodingRule encodingRule) throws UnsupportedEncodingException, CoreException, IOException {
        Assert.isNotNull(iFile, "file parameter can not be null");
        if (FileBufferModelManager.getInstance().isExistingBuffer(structuredDocument)) {
            ITextFileBuffer buffer = FileBufferModelManager.getInstance().getBuffer(structuredDocument);
            if (buffer.getLocation().equals((Object)iFile.getFullPath()) || buffer.getLocation().equals((Object)iFile.getLocation())) {
                buffer.commit((IProgressMonitor)new NullProgressMonitor(), true);
            }
        } else {
            CodedStreamCreator codedStreamCreator = new CodedStreamCreator();
            DocumentReader reader = new DocumentReader(structuredDocument);
            codedStreamCreator.set(iFile, (Reader)reader);
            codedStreamCreator.setPreviousEncodingMemento(structuredDocument.getEncodingMemento());
            EncodingMemento encodingMemento = codedStreamCreator.getCurrentEncodingMemento();
            structuredDocument.setEncodingMemento(encodingMemento);
            this.handleConvertLineDelimiters(structuredDocument, iFile, encodingRule, encodingMemento);
            ByteArrayOutputStream codedByteStream = codedStreamCreator.getCodedByteArrayOutputStream(encodingRule);
            ByteArrayInputStream codedStream = new ByteArrayInputStream(codedByteStream.toByteArray());
            if (iFile.exists()) {
                iFile.setContents((InputStream)codedStream, true, true, null);
            } else {
                iFile.create((InputStream)codedStream, false, null);
            }
            codedByteStream.close();
            ((InputStream)codedStream).close();
        }
    }

    private void trace(String msg, Object id) {
        if (Logger.DEBUG_MODELMANAGER) {
            Logger.log(1, String.valueOf(msg) + " " + Utilities.makeShortId(id));
        }
    }

    private void trace(String msg, Object id, int value) {
        if (Logger.DEBUG_MODELMANAGER) {
            Logger.log(1, String.valueOf(msg) + Utilities.makeShortId(id) + " (" + value + ")");
        }
    }

    boolean isIdInUse(String newId) {
        boolean inUse = false;
        this.SYNC.acquire();
        SharedObject object = (SharedObject)this.fManagedObjects.get(newId);
        if (object != null) {
            inUse = object.theSharedModel != null;
        }
        this.SYNC.release();
        return inUse;
    }

    static class ReadEditType {
        ReadEditType(String type) {
        }
    }

    class SharedObject {
        int referenceCountForEdit;
        int referenceCountForRead;
        volatile IStructuredModel theSharedModel;
        final ILock LOAD_LOCK = Job.getJobManager().newLock();
        volatile boolean initializing = true;
        volatile boolean doWait = true;
        final String id;

        SharedObject(String id) {
            this.id = id;
            this.LOAD_LOCK.acquire();
        }

        /*
         * Exception decompiling
         */
        public void waitForLoadAttempt() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 173->177)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private void loop() throws InterruptedException {
            if (this.initializing && this.LOAD_LOCK.acquire(PrefUtil.WAIT_INTERVAL_MS)) {
                if (this.initializing) {
                    this.LOAD_LOCK.release();
                    throw new OperationCanceledException("Aborted cyclic load attempt for model with id: " + this.id);
                }
                this.LOAD_LOCK.release();
            }
        }

        public void setLoaded() {
            this.initializing = false;
            this.LOAD_LOCK.release();
        }
    }
}

