/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.javaeditor;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.Position;
import org.eclipse.ui.texteditor.ResourceMarkerAnnotationModel;

public class StorageMarkerAnnotationModel
extends ResourceMarkerAnnotationModel {
    public static final String SECONDARY_ID_KEY = "org.eclipse.wst.sse.ui.extensions.breakpoint.path";
    protected IResource fMarkerResource;
    protected String fSecondaryMarkerAttributeValue;

    public StorageMarkerAnnotationModel(IResource resource) {
        super(resource);
        this.fMarkerResource = resource;
    }

    public StorageMarkerAnnotationModel(IResource resource, String secondaryID) {
        super(resource);
        this.fMarkerResource = resource;
        this.fSecondaryMarkerAttributeValue = secondaryID;
    }

    public Position getMarkerPosition(IMarker marker) {
        Position pos = super.getMarkerPosition(marker);
        if (pos == null || pos.getLength() == 0) {
            pos = this.createPositionFromMarker(marker);
        }
        return pos;
    }

    protected boolean isAcceptable(IMarker marker) {
        if (this.fSecondaryMarkerAttributeValue == null) {
            return super.isAcceptable(marker);
        }
        String markerSecondaryMarkerAttributeValue = marker.getAttribute(SECONDARY_ID_KEY, "");
        boolean isSameFile = this.fSecondaryMarkerAttributeValue.equalsIgnoreCase(markerSecondaryMarkerAttributeValue);
        return super.isAcceptable(marker) && isSameFile;
    }
}

