/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.dom;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.wst.jsdt.core.compiler.CategorizedProblem;
import org.eclipse.wst.jsdt.core.compiler.IProblem;
import org.eclipse.wst.jsdt.core.compiler.InvalidInputException;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTRecoveryPropagator;
import org.eclipse.wst.jsdt.core.dom.ASTSyntaxErrorPropagator;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.ArrayAccess;
import org.eclipse.wst.jsdt.core.dom.ArrayCreation;
import org.eclipse.wst.jsdt.core.dom.ArrayInitializer;
import org.eclipse.wst.jsdt.core.dom.ArrayType;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.BlockComment;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.BooleanLiteral;
import org.eclipse.wst.jsdt.core.dom.BreakStatement;
import org.eclipse.wst.jsdt.core.dom.CatchClause;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.Comment;
import org.eclipse.wst.jsdt.core.dom.ConditionalExpression;
import org.eclipse.wst.jsdt.core.dom.ConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.ContinueStatement;
import org.eclipse.wst.jsdt.core.dom.DefaultCommentMapper;
import org.eclipse.wst.jsdt.core.dom.DoStatement;
import org.eclipse.wst.jsdt.core.dom.DocCommentParser;
import org.eclipse.wst.jsdt.core.dom.EmptyExpression;
import org.eclipse.wst.jsdt.core.dom.EmptyStatement;
import org.eclipse.wst.jsdt.core.dom.EnhancedForStatement;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.ExpressionStatement;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.ForInStatement;
import org.eclipse.wst.jsdt.core.dom.ForStatement;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionExpression;
import org.eclipse.wst.jsdt.core.dom.FunctionInvocation;
import org.eclipse.wst.jsdt.core.dom.FunctionRef;
import org.eclipse.wst.jsdt.core.dom.FunctionRefParameter;
import org.eclipse.wst.jsdt.core.dom.IfStatement;
import org.eclipse.wst.jsdt.core.dom.ImportDeclaration;
import org.eclipse.wst.jsdt.core.dom.InferredType;
import org.eclipse.wst.jsdt.core.dom.InfixExpression;
import org.eclipse.wst.jsdt.core.dom.Initializer;
import org.eclipse.wst.jsdt.core.dom.InstanceofExpression;
import org.eclipse.wst.jsdt.core.dom.JSdoc;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.LabeledStatement;
import org.eclipse.wst.jsdt.core.dom.LineComment;
import org.eclipse.wst.jsdt.core.dom.ListExpression;
import org.eclipse.wst.jsdt.core.dom.MemberRef;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.NullLiteral;
import org.eclipse.wst.jsdt.core.dom.NumberLiteral;
import org.eclipse.wst.jsdt.core.dom.ObjectLiteral;
import org.eclipse.wst.jsdt.core.dom.ObjectLiteralField;
import org.eclipse.wst.jsdt.core.dom.PackageDeclaration;
import org.eclipse.wst.jsdt.core.dom.ParenthesizedExpression;
import org.eclipse.wst.jsdt.core.dom.PostfixExpression;
import org.eclipse.wst.jsdt.core.dom.PrefixExpression;
import org.eclipse.wst.jsdt.core.dom.PrimitiveType;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.RegularExpressionLiteral;
import org.eclipse.wst.jsdt.core.dom.ReturnStatement;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SimpleType;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.Statement;
import org.eclipse.wst.jsdt.core.dom.StringLiteral;
import org.eclipse.wst.jsdt.core.dom.SuperConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.SuperFieldAccess;
import org.eclipse.wst.jsdt.core.dom.SuperMethodInvocation;
import org.eclipse.wst.jsdt.core.dom.SwitchCase;
import org.eclipse.wst.jsdt.core.dom.SwitchStatement;
import org.eclipse.wst.jsdt.core.dom.TagElement;
import org.eclipse.wst.jsdt.core.dom.ThisExpression;
import org.eclipse.wst.jsdt.core.dom.ThrowStatement;
import org.eclipse.wst.jsdt.core.dom.TryStatement;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.TypeDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.TypeLiteral;
import org.eclipse.wst.jsdt.core.dom.UndefinedLiteral;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationExpression;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.WhileStatement;
import org.eclipse.wst.jsdt.core.dom.WithStatement;
import org.eclipse.wst.jsdt.internal.compiler.ast.AND_AND_Expression;
import org.eclipse.wst.jsdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.AbstractVariableDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.Argument;
import org.eclipse.wst.jsdt.internal.compiler.ast.ArrayAllocationExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.ArrayReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.BinaryExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.CaseStatement;
import org.eclipse.wst.jsdt.internal.compiler.ast.ClassLiteralAccess;
import org.eclipse.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.CompoundAssignment;
import org.eclipse.wst.jsdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.DoubleLiteral;
import org.eclipse.wst.jsdt.internal.compiler.ast.EqualExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.ExplicitConstructorCall;
import org.eclipse.wst.jsdt.internal.compiler.ast.ExtendedStringLiteral;
import org.eclipse.wst.jsdt.internal.compiler.ast.FalseLiteral;
import org.eclipse.wst.jsdt.internal.compiler.ast.FieldReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.ForeachStatement;
import org.eclipse.wst.jsdt.internal.compiler.ast.ImportReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.InstanceOfExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.IntLiteral;
import org.eclipse.wst.jsdt.internal.compiler.ast.IntLiteralMinValue;
import org.eclipse.wst.jsdt.internal.compiler.ast.Javadoc;
import org.eclipse.wst.jsdt.internal.compiler.ast.JavadocAllocationExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.JavadocArgumentExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.JavadocFieldReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.JavadocMessageSend;
import org.eclipse.wst.jsdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.MessageSend;
import org.eclipse.wst.jsdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.NameReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.OR_OR_Expression;
import org.eclipse.wst.jsdt.internal.compiler.ast.ProgramElement;
import org.eclipse.wst.jsdt.internal.compiler.ast.QualifiedAllocationExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.QualifiedThisReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.Reference;
import org.eclipse.wst.jsdt.internal.compiler.ast.RegExLiteral;
import org.eclipse.wst.jsdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.StringLiteralConcatenation;
import org.eclipse.wst.jsdt.internal.compiler.ast.ThisReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.TrueLiteral;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.UnaryExpression;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.parser.RecoveryScanner;
import org.eclipse.wst.jsdt.internal.compiler.parser.Scanner;

class ASTConverter {
    protected AST ast;
    protected Comment[] commentsTable;
    char[] compilationUnitSource;
    int compilationUnitSourceLength;
    protected DocCommentParser docParser;
    protected boolean insideComments;
    protected IProgressMonitor monitor;
    protected Set pendingNameScopeResolution;
    protected Set pendingThisExpressionScopeResolution;
    protected boolean resolveBindings;
    Scanner scanner;
    private DefaultCommentMapper commentMapper;

    public ASTConverter(Map options, boolean resolveBindings, IProgressMonitor monitor) {
        this.resolveBindings = resolveBindings;
        Object sourceModeSetting = options.get("org.eclipse.wst.jsdt.core.compiler.source");
        long sourceLevel = 0x2F0000L;
        if ("1.4".equals(sourceModeSetting)) {
            sourceLevel = 0x300000L;
        } else if ("1.5".equals(sourceModeSetting)) {
            sourceLevel = 0x310000L;
        }
        this.scanner = new Scanner(true, false, false, sourceLevel, null, null, true);
        this.monitor = monitor;
        this.insideComments = "enabled".equals(options.get("org.eclipse.wst.jsdt.core.compiler.doc.comment.support"));
    }

    protected void adjustSourcePositionsForParent(org.eclipse.wst.jsdt.internal.compiler.ast.Expression expression) {
        int start = expression.sourceStart;
        int end = expression.sourceEnd;
        int leftParentCount = 1;
        int rightParentCount = 0;
        this.scanner.resetTo(start, end);
        try {
            int token = this.scanner.getNextToken();
            expression.sourceStart = this.scanner.currentPosition;
            boolean stop = false;
            while (!stop && (token = this.scanner.getNextToken()) != 55) {
                switch (token) {
                    case 3: {
                        ++leftParentCount;
                        break;
                    }
                    case 33: {
                        if (++rightParentCount != leftParentCount) break;
                        stop = true;
                    }
                }
            }
            expression.sourceEnd = this.scanner.startPosition - 1;
        }
        catch (InvalidInputException invalidInputException) {}
    }

    protected void buildBodyDeclarations(org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration typeDeclaration, AbstractTypeDeclaration typeDecl) {
        org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration[] members = typeDeclaration.memberTypes;
        org.eclipse.wst.jsdt.internal.compiler.ast.FieldDeclaration[] fields = typeDeclaration.fields;
        AbstractMethodDeclaration[] methods = typeDeclaration.methods;
        int fieldsLength = fields == null ? 0 : fields.length;
        int methodsLength = methods == null ? 0 : methods.length;
        int membersLength = members == null ? 0 : members.length;
        int fieldsIndex = 0;
        int methodsIndex = 0;
        int membersIndex = 0;
        block5: while (fieldsIndex < fieldsLength || membersIndex < membersLength || methodsIndex < methodsLength) {
            org.eclipse.wst.jsdt.internal.compiler.ast.FieldDeclaration nextFieldDeclaration = null;
            AbstractMethodDeclaration nextMethodDeclaration = null;
            org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration nextMemberDeclaration = null;
            int position = Integer.MAX_VALUE;
            int nextDeclarationType = -1;
            if (fieldsIndex < fieldsLength) {
                nextFieldDeclaration = fields[fieldsIndex];
                if (nextFieldDeclaration.declarationSourceStart < position) {
                    position = nextFieldDeclaration.declarationSourceStart;
                    nextDeclarationType = 0;
                }
            }
            if (methodsIndex < methodsLength) {
                nextMethodDeclaration = methods[methodsIndex];
                if (nextMethodDeclaration.declarationSourceStart < position) {
                    position = nextMethodDeclaration.declarationSourceStart;
                    nextDeclarationType = 1;
                }
            }
            if (membersIndex < membersLength) {
                nextMemberDeclaration = members[membersIndex];
                if (nextMemberDeclaration.declarationSourceStart < position) {
                    position = nextMemberDeclaration.declarationSourceStart;
                    nextDeclarationType = 2;
                }
            }
            switch (nextDeclarationType) {
                case 0: {
                    this.checkAndAddMultipleFieldDeclaration(fields, fieldsIndex, typeDecl.bodyDeclarations());
                    ++fieldsIndex;
                    break;
                }
                case 1: {
                    ++methodsIndex;
                    if (nextMethodDeclaration.isDefaultConstructor() || nextMethodDeclaration.isClinit()) continue block5;
                    typeDecl.bodyDeclarations().add(this.convert(nextMethodDeclaration));
                    break;
                }
                case 2: {
                    ++membersIndex;
                    ASTNode node = this.convert(nextMemberDeclaration);
                    if (node == null) {
                        typeDecl.setFlags(typeDecl.getFlags() | 1);
                        break;
                    }
                    typeDecl.bodyDeclarations().add(node);
                }
            }
        }
        this.convert(typeDeclaration.javadoc, typeDecl);
    }

    protected void buildBodyDeclarations(org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration expression, AnonymousClassDeclaration anonymousClassDeclaration) {
        org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration[] members = expression.memberTypes;
        org.eclipse.wst.jsdt.internal.compiler.ast.FieldDeclaration[] fields = expression.fields;
        AbstractMethodDeclaration[] methods = expression.methods;
        int fieldsLength = fields == null ? 0 : fields.length;
        int methodsLength = methods == null ? 0 : methods.length;
        int membersLength = members == null ? 0 : members.length;
        int fieldsIndex = 0;
        int methodsIndex = 0;
        int membersIndex = 0;
        block5: while (fieldsIndex < fieldsLength || membersIndex < membersLength || methodsIndex < methodsLength) {
            org.eclipse.wst.jsdt.internal.compiler.ast.FieldDeclaration nextFieldDeclaration = null;
            AbstractMethodDeclaration nextMethodDeclaration = null;
            org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration nextMemberDeclaration = null;
            int position = Integer.MAX_VALUE;
            int nextDeclarationType = -1;
            if (fieldsIndex < fieldsLength) {
                nextFieldDeclaration = fields[fieldsIndex];
                if (nextFieldDeclaration.declarationSourceStart < position) {
                    position = nextFieldDeclaration.declarationSourceStart;
                    nextDeclarationType = 0;
                }
            }
            if (methodsIndex < methodsLength) {
                nextMethodDeclaration = methods[methodsIndex];
                if (nextMethodDeclaration.declarationSourceStart < position) {
                    position = nextMethodDeclaration.declarationSourceStart;
                    nextDeclarationType = 1;
                }
            }
            if (membersIndex < membersLength) {
                nextMemberDeclaration = members[membersIndex];
                if (nextMemberDeclaration.declarationSourceStart < position) {
                    position = nextMemberDeclaration.declarationSourceStart;
                    nextDeclarationType = 2;
                }
            }
            switch (nextDeclarationType) {
                case 0: {
                    this.checkAndAddMultipleFieldDeclaration(fields, fieldsIndex, anonymousClassDeclaration.bodyDeclarations());
                    ++fieldsIndex;
                    break;
                }
                case 1: {
                    ++methodsIndex;
                    if (nextMethodDeclaration.isDefaultConstructor() || nextMethodDeclaration.isClinit()) continue block5;
                    anonymousClassDeclaration.bodyDeclarations().add(this.convert(nextMethodDeclaration));
                    break;
                }
                case 2: {
                    ++membersIndex;
                    ASTNode node = this.convert(nextMemberDeclaration);
                    if (node == null) {
                        anonymousClassDeclaration.setFlags(anonymousClassDeclaration.getFlags() | 1);
                        break;
                    }
                    anonymousClassDeclaration.bodyDeclarations().add(node);
                }
            }
        }
    }

    void buildCommentsTable(JavaScriptUnit compilationUnit, int[][] comments) {
        this.commentsTable = new Comment[comments.length];
        int nbr = 0;
        int i = 0;
        while (i < comments.length) {
            Comment comment = this.createComment(comments[i]);
            if (comment != null) {
                comment.setAlternateRoot(compilationUnit);
                this.commentsTable[nbr++] = comment;
            }
            ++i;
        }
        if (nbr < comments.length) {
            Comment[] newCommentsTable = new Comment[nbr];
            System.arraycopy(this.commentsTable, 0, newCommentsTable, 0, nbr);
            this.commentsTable = newCommentsTable;
        }
        compilationUnit.setCommentTable(this.commentsTable);
    }

    protected void checkAndAddMultipleFieldDeclaration(org.eclipse.wst.jsdt.internal.compiler.ast.FieldDeclaration[] fields, int index, List bodyDeclarations) {
        if (fields[index] instanceof org.eclipse.wst.jsdt.internal.compiler.ast.Initializer) {
            org.eclipse.wst.jsdt.internal.compiler.ast.Initializer oldInitializer = (org.eclipse.wst.jsdt.internal.compiler.ast.Initializer)fields[index];
            Initializer initializer = new Initializer(this.ast);
            initializer.setBody(this.convert(oldInitializer.block));
            this.setModifiers(initializer, oldInitializer);
            initializer.setSourceRange(oldInitializer.declarationSourceStart, oldInitializer.sourceEnd - oldInitializer.declarationSourceStart + 1);
            this.convert(oldInitializer.javadoc, initializer);
            bodyDeclarations.add(initializer);
            return;
        }
        if (index > 0 && fields[index - 1].declarationSourceStart == fields[index].declarationSourceStart) {
            FieldDeclaration fieldDeclaration = (FieldDeclaration)bodyDeclarations.get(bodyDeclarations.size() - 1);
            fieldDeclaration.fragments().add(this.convertToVariableDeclarationFragment(fields[index]));
        } else {
            bodyDeclarations.add(this.convertToFieldDeclaration(fields[index]));
        }
    }

    protected void checkAndAddMultipleLocalDeclaration(ProgramElement[] stmts, int index, List blockStatements) {
        VariableDeclarationStatement variableDeclarationStatement = this.convertToVariableDeclarationStatement((LocalDeclaration)stmts[index]);
        blockStatements.add(variableDeclarationStatement);
    }

    protected void checkCanceled() {
        if (this.monitor != null && this.monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    protected void completeRecord(ArrayType arrayType, org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode astNode) {
        ArrayType array = arrayType;
        int dimensions = array.getDimensions();
        int i = 0;
        while (i < dimensions) {
            Type componentType = array.getComponentType();
            this.recordNodes(componentType, astNode);
            if (componentType.isArrayType()) {
                array = (ArrayType)componentType;
            }
            ++i;
        }
    }

    public ASTNode convert(AbstractMethodDeclaration methodDeclaration) {
        int end;
        this.checkCanceled();
        FunctionDeclaration methodDecl = new FunctionDeclaration(this.ast);
        this.setModifiers(methodDecl, methodDeclaration);
        boolean isConstructor = methodDeclaration.isConstructor();
        methodDecl.setConstructor(isConstructor);
        int start = methodDeclaration.sourceStart;
        SimpleName methodName = null;
        if (methodDeclaration.selector != null) {
            methodName = new SimpleName(this.ast);
            methodName.internalSetIdentifier(new String(methodDeclaration.selector));
            end = this.retrieveIdentifierEndPosition(start, methodDeclaration.sourceEnd);
            methodName.setSourceRange(start, end - start + 1);
            methodDecl.setName(methodName);
        } else {
            end = methodDeclaration.sourceStart;
        }
        Argument[] parameters = methodDeclaration.arguments;
        if (parameters != null) {
            int parametersLength = parameters.length;
            int i = 0;
            while (i < parametersLength) {
                methodDecl.parameters().add(this.convert(parameters[i]));
                ++i;
            }
        }
        ExplicitConstructorCall explicitConstructorCall = null;
        if (isConstructor) {
            ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)methodDeclaration;
            explicitConstructorCall = constructorDeclaration.constructorCall;
            switch (this.ast.apiLevel) {
                case 2: {
                    PrimitiveType returnType = new PrimitiveType(this.ast);
                    returnType.setPrimitiveTypeCode(PrimitiveType.VOID);
                    returnType.setSourceRange(methodDeclaration.sourceStart, 0);
                    methodDecl.internalSetReturnType(returnType);
                    break;
                }
                case 3: {
                    methodDecl.setReturnType2(null);
                }
            }
        } else if (methodDeclaration instanceof MethodDeclaration) {
            MethodDeclaration method = (MethodDeclaration)methodDeclaration;
            TypeReference typeReference = method.returnType;
            if (typeReference != null) {
                Type returnType = this.convertType(typeReference, method.inferredType);
                int rightParenthesisPosition = this.retrieveEndOfRightParenthesisPosition(end, method.bodyEnd);
                int extraDimensions = this.retrieveExtraDimension(rightParenthesisPosition, method.bodyEnd);
                methodDecl.setExtraDimensions(extraDimensions);
                this.setTypeForMethodDeclaration(methodDecl, returnType, extraDimensions);
            } else {
                switch (this.ast.apiLevel) {
                    case 2: {
                        methodDecl.setFlags(methodDecl.getFlags() | 1);
                        break;
                    }
                    case 3: {
                        methodDecl.setReturnType2(null);
                    }
                }
            }
        }
        int declarationSourceStart = methodDeclaration.declarationSourceStart;
        int declarationSourceEnd = methodDeclaration.bodyEnd;
        methodDecl.setSourceRange(declarationSourceStart, declarationSourceEnd - declarationSourceStart + 1);
        int closingPosition = this.retrieveRightBraceOrSemiColonPosition(methodDeclaration.bodyEnd + 1, methodDeclaration.declarationSourceEnd);
        if (closingPosition != -1) {
            int startPosition = methodDecl.getStartPosition();
            methodDecl.setSourceRange(startPosition, closingPosition - startPosition + 1);
            ProgramElement[] statements = methodDeclaration.statements;
            start = this.retrieveStartBlockPosition(methodDeclaration.sourceStart, declarationSourceEnd);
            end = this.retrieveEndBlockPosition(methodDeclaration.sourceStart, methodDeclaration.declarationSourceEnd);
            Block block = null;
            if (start != -1 && end != -1) {
                block = new Block(this.ast);
                block.setSourceRange(start, end - start + 1);
                methodDecl.setBody(block);
            }
            if (block != null && (statements != null || explicitConstructorCall != null)) {
                if (explicitConstructorCall != null && explicitConstructorCall.accessMode != 1) {
                    block.statements().add(this.convert(explicitConstructorCall));
                }
                int statementsLength = statements == null ? 0 : statements.length;
                int i = 0;
                while (i < statementsLength) {
                    if (statements[i] instanceof LocalDeclaration) {
                        this.checkAndAddMultipleLocalDeclaration(statements, i, block.statements());
                    } else if (statements[i] instanceof MethodDeclaration) {
                        MethodDeclaration method = (MethodDeclaration)statements[i];
                        block.statements().add(this.convert(method));
                    } else {
                        Statement statement = this.convert((org.eclipse.wst.jsdt.internal.compiler.ast.Statement)statements[i]);
                        if (statement != null) {
                            block.statements().add(statement);
                        }
                    }
                    ++i;
                }
            }
            if (block != null && (Modifier.isAbstract(methodDecl.getModifiers()) || Modifier.isNative(methodDecl.getModifiers()))) {
                methodDecl.setFlags(methodDecl.getFlags() | 1);
            }
        } else if (!methodDeclaration.isAbstract()) {
            start = this.retrieveStartBlockPosition(methodDeclaration.sourceStart, declarationSourceEnd);
            end = methodDeclaration.bodyEnd;
            CategorizedProblem[] problems = methodDeclaration.compilationResult().problems;
            if (problems != null) {
                int i = 0;
                int max = methodDeclaration.compilationResult().problemCount;
                while (i < max) {
                    CategorizedProblem currentProblem = problems[i];
                    if (currentProblem.getSourceStart() == start && currentProblem.getID() == 0x600000F0) {
                        end = currentProblem.getSourceEnd();
                        break;
                    }
                    ++i;
                }
            }
            int startPosition = methodDecl.getStartPosition();
            methodDecl.setSourceRange(startPosition, end - startPosition + 1);
            if (start != -1 && end != -1) {
                Block block = new Block(this.ast);
                block.setSourceRange(start, end - start + 1);
                methodDecl.setBody(block);
            }
        }
        this.convert(methodDeclaration.javadoc, methodDecl);
        if (this.resolveBindings) {
            this.recordNodes(methodDecl, methodDeclaration);
            if (methodName != null) {
                this.recordNodes(methodName, methodDeclaration);
            }
            methodDecl.resolveBinding();
        }
        return methodDecl;
    }

    public ClassInstanceCreation convert(AllocationExpression expression) {
        ClassInstanceCreation classInstanceCreation = new ClassInstanceCreation(this.ast);
        if (this.resolveBindings) {
            this.recordNodes(classInstanceCreation, expression);
        }
        if (expression.type != null) {
            switch (this.ast.apiLevel) {
                case 2: {
                    classInstanceCreation.internalSetName(this.convert(expression.type));
                    break;
                }
                case 3: {
                    classInstanceCreation.setType(this.convertType(expression.type));
                }
            }
        }
        classInstanceCreation.setMember(this.convert(expression.member));
        classInstanceCreation.setSourceRange(expression.sourceStart, expression.sourceEnd - expression.sourceStart + 1);
        org.eclipse.wst.jsdt.internal.compiler.ast.Expression[] arguments = expression.arguments;
        if (arguments != null) {
            int length = arguments.length;
            int i = 0;
            while (i < length) {
                classInstanceCreation.arguments().add(this.convert(arguments[i]));
                ++i;
            }
        }
        this.removeTrailingCommentFromExpressionEndingWithAParen(classInstanceCreation);
        return classInstanceCreation;
    }

    public Expression convert(AND_AND_Expression expression) {
        InfixExpression infixExpression = new InfixExpression(this.ast);
        infixExpression.setOperator(InfixExpression.Operator.CONDITIONAL_AND);
        if (this.resolveBindings) {
            this.recordNodes(infixExpression, expression);
        }
        int expressionOperatorID = (expression.bits & 0xFC0) >> 6;
        if (expression.left instanceof BinaryExpression && (expression.left.bits & 0x1FE00000) == 0) {
            infixExpression.extendedOperands().add(this.convert(expression.right));
            org.eclipse.wst.jsdt.internal.compiler.ast.Expression leftOperand = expression.left;
            org.eclipse.wst.jsdt.internal.compiler.ast.Expression rightOperand = null;
            do {
                rightOperand = ((BinaryExpression)leftOperand).right;
                if ((leftOperand.bits & 0xFC0) >> 6 != expressionOperatorID && (leftOperand.bits & 0x1FE00000) == 0 || rightOperand instanceof BinaryExpression && (rightOperand.bits & 0xFC0) >> 6 != expressionOperatorID && (rightOperand.bits & 0x1FE00000) == 0) {
                    List extendedOperands = infixExpression.extendedOperands();
                    InfixExpression temp = new InfixExpression(this.ast);
                    if (this.resolveBindings) {
                        this.recordNodes(temp, expression);
                    }
                    temp.setOperator(this.getOperatorFor(expressionOperatorID));
                    Expression leftSide = this.convert(leftOperand);
                    temp.setLeftOperand(leftSide);
                    temp.setSourceRange(leftSide.getStartPosition(), leftSide.getLength());
                    int size = extendedOperands.size();
                    int i = 0;
                    while (i < size - 1) {
                        InfixExpression expr = temp;
                        temp = new InfixExpression(this.ast);
                        if (this.resolveBindings) {
                            this.recordNodes(temp, expression);
                        }
                        temp.setLeftOperand(expr);
                        temp.setOperator(this.getOperatorFor(expressionOperatorID));
                        temp.setSourceRange(expr.getStartPosition(), expr.getLength());
                        ++i;
                    }
                    infixExpression = temp;
                    i = 0;
                    while (i < size) {
                        Expression extendedOperand = (Expression)extendedOperands.remove(size - 1 - i);
                        temp.setRightOperand(extendedOperand);
                        int startPosition = temp.getLeftOperand().getStartPosition();
                        temp.setSourceRange(startPosition, extendedOperand.getStartPosition() + extendedOperand.getLength() - startPosition);
                        if (temp.getLeftOperand().getNodeType() == 27) {
                            temp = (InfixExpression)temp.getLeftOperand();
                        }
                        ++i;
                    }
                    int startPosition = infixExpression.getLeftOperand().getStartPosition();
                    infixExpression.setSourceRange(startPosition, expression.sourceEnd - startPosition + 1);
                    if (this.resolveBindings) {
                        this.recordNodes(infixExpression, expression);
                    }
                    return infixExpression;
                }
                infixExpression.extendedOperands().add(0, this.convert(rightOperand));
            } while ((leftOperand = ((BinaryExpression)leftOperand).left) instanceof BinaryExpression && (leftOperand.bits & 0x1FE00000) == 0);
            Expression leftExpression = this.convert(leftOperand);
            infixExpression.setLeftOperand(leftExpression);
            infixExpression.setRightOperand((Expression)infixExpression.extendedOperands().remove(0));
            int startPosition = leftExpression.getStartPosition();
            infixExpression.setSourceRange(startPosition, expression.sourceEnd - startPosition + 1);
            return infixExpression;
        }
        Expression leftExpression = this.convert(expression.left);
        infixExpression.setLeftOperand(leftExpression);
        infixExpression.setRightOperand(this.convert(expression.right));
        infixExpression.setOperator(InfixExpression.Operator.CONDITIONAL_AND);
        int startPosition = leftExpression.getStartPosition();
        infixExpression.setSourceRange(startPosition, expression.sourceEnd - startPosition + 1);
        return infixExpression;
    }

    public SingleVariableDeclaration convert(Argument argument) {
        SingleVariableDeclaration variableDecl = new SingleVariableDeclaration(this.ast);
        this.setModifiers(variableDecl, argument);
        SimpleName name = new SimpleName(this.ast);
        name.internalSetIdentifier(new String(argument.name));
        int start = argument.sourceStart;
        int nameEnd = argument.sourceEnd;
        name.setSourceRange(start, nameEnd - start + 1);
        variableDecl.setName(name);
        Type type = this.convertType(argument.type, argument.inferredType);
        int rightEnd = argument.declarationSourceEnd;
        this.setTypeForSingleVariableDeclaration(variableDecl, type, 0);
        variableDecl.setSourceRange(argument.declarationSourceStart, rightEnd - argument.declarationSourceStart + 1);
        if (this.resolveBindings) {
            this.recordNodes(name, argument);
            this.recordNodes(variableDecl, argument);
            variableDecl.resolveBinding();
        }
        return variableDecl;
    }

    public ArrayCreation convert(ArrayAllocationExpression expression) {
        ArrayCreation arrayCreation = new ArrayCreation(this.ast);
        if (this.resolveBindings) {
            this.recordNodes(arrayCreation, expression);
        }
        arrayCreation.setSourceRange(expression.sourceStart, expression.sourceEnd - expression.sourceStart + 1);
        org.eclipse.wst.jsdt.internal.compiler.ast.Expression[] dimensions = expression.dimensions;
        int dimensionsLength = dimensions.length;
        int i = 0;
        while (i < dimensionsLength) {
            if (dimensions[i] != null) {
                Expression dimension = this.convert(dimensions[i]);
                if (this.resolveBindings) {
                    this.recordNodes(dimension, dimensions[i]);
                }
                arrayCreation.dimensions().add(dimension);
            }
            ++i;
        }
        Type type = this.convertType(expression.type);
        if (this.resolveBindings) {
            this.recordNodes(type, expression.type);
        }
        ArrayType arrayType = null;
        if (type.isArrayType()) {
            arrayType = (ArrayType)type;
        } else {
            int end;
            arrayType = this.ast.newArrayType(type, dimensionsLength);
            if (this.resolveBindings) {
                this.completeRecord(arrayType, expression);
            }
            int start = type.getStartPosition();
            int previousSearchStart = end = type.getStartPosition() + type.getLength();
            ArrayType componentType = (ArrayType)type.getParent();
            int i2 = 0;
            while (i2 < dimensionsLength) {
                previousSearchStart = this.retrieveRightBracketPosition(previousSearchStart + 1, this.compilationUnitSourceLength);
                componentType.setSourceRange(start, previousSearchStart - start + 1);
                componentType = (ArrayType)componentType.getParent();
                ++i2;
            }
        }
        arrayCreation.setType(arrayType);
        if (this.resolveBindings) {
            this.recordNodes(arrayType, expression);
        }
        if (expression.initializer != null) {
            arrayCreation.setInitializer(this.convert(expression.initializer));
        }
        return arrayCreation;
    }

    public ArrayInitializer convert(org.eclipse.wst.jsdt.internal.compiler.ast.ArrayInitializer expression) {
        ArrayInitializer arrayInitializer = new ArrayInitializer(this.ast);
        if (this.resolveBindings) {
            this.recordNodes(arrayInitializer, expression);
        }
        arrayInitializer.setSourceRange(expression.sourceStart, expression.sourceEnd - expression.sourceStart + 1);
        org.eclipse.wst.jsdt.internal.compiler.ast.Expression[] expressions = expression.expressions;
        if (expressions != null) {
            int length = expressions.length;
            int i = 0;
            while (i < length) {
                Expression expr = this.convert(expressions[i]);
                if (this.resolveBindings) {
                    this.recordNodes(expr, expressions[i]);
                }
                arrayInitializer.expressions().add(expr);
                ++i;
            }
        }
        return arrayInitializer;
    }

    public ArrayAccess convert(ArrayReference reference) {
        ArrayAccess arrayAccess = new ArrayAccess(this.ast);
        if (this.resolveBindings) {
            this.recordNodes(arrayAccess, reference);
        }
        arrayAccess.setSourceRange(reference.sourceStart, reference.sourceEnd - reference.sourceStart + 1);
        arrayAccess.setArray(this.convert(reference.receiver));
        arrayAccess.setIndex(this.convert(reference.position));
        return arrayAccess;
    }

    public Assignment convert(org.eclipse.wst.jsdt.internal.compiler.ast.Assignment expression) {
        Assignment assignment = new Assignment(this.ast);
        if (this.resolveBindings) {
            this.recordNodes(assignment, expression);
        }
        Expression lhs = this.convert(expression.lhs);
        assignment.setLeftHandSide(lhs);
        assignment.setOperator(Assignment.Operator.ASSIGN);
        assignment.setRightHandSide(this.convert(expression.expression));
        int start = lhs.getStartPosition();
        assignment.setSourceRange(start, expression.sourceEnd - start + 1);
        return assignment;
    }

    public JavaScriptUnit convert(org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode[] nodes, JavaScriptUnit compilationUnit) {
        int nodesLength = nodes.length;
        int i = 0;
        while (i < nodesLength) {
            FieldDeclaration currentFieldDeclaration;
            org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode node = nodes[i];
            if (node instanceof org.eclipse.wst.jsdt.internal.compiler.ast.Initializer) {
                org.eclipse.wst.jsdt.internal.compiler.ast.Initializer oldInitializer = (org.eclipse.wst.jsdt.internal.compiler.ast.Initializer)node;
                Initializer initializer = new Initializer(this.ast);
                initializer.setBody(this.convert(oldInitializer.block));
                this.setModifiers(initializer, oldInitializer);
                initializer.setSourceRange(oldInitializer.declarationSourceStart, oldInitializer.sourceEnd - oldInitializer.declarationSourceStart + 1);
                this.convert(oldInitializer.javadoc, initializer);
                compilationUnit.statements().add(initializer);
            } else if (node instanceof org.eclipse.wst.jsdt.internal.compiler.ast.FieldDeclaration) {
                org.eclipse.wst.jsdt.internal.compiler.ast.FieldDeclaration fieldDeclaration = (org.eclipse.wst.jsdt.internal.compiler.ast.FieldDeclaration)node;
                if (i > 0 && nodes[i - 1] instanceof org.eclipse.wst.jsdt.internal.compiler.ast.FieldDeclaration && ((org.eclipse.wst.jsdt.internal.compiler.ast.FieldDeclaration)nodes[i - 1]).declarationSourceStart == fieldDeclaration.declarationSourceStart) {
                    currentFieldDeclaration = (FieldDeclaration)compilationUnit.statements().get(compilationUnit.statements().size() - 1);
                    currentFieldDeclaration.fragments().add(this.convertToVariableDeclarationFragment(fieldDeclaration));
                } else {
                    compilationUnit.statements().add(this.convertToFieldDeclaration(fieldDeclaration));
                }
            } else if (node instanceof AbstractMethodDeclaration) {
                AbstractMethodDeclaration nextMethodDeclaration = (AbstractMethodDeclaration)node;
                if (!nextMethodDeclaration.isDefaultConstructor() && !nextMethodDeclaration.isClinit()) {
                    compilationUnit.statements().add(this.convert(nextMethodDeclaration));
                }
            } else if (node instanceof LocalDeclaration) {
                LocalDeclaration localDeclaration = (LocalDeclaration)node;
                if (i > 0 && nodes[i - 1] instanceof org.eclipse.wst.jsdt.internal.compiler.ast.FieldDeclaration && ((org.eclipse.wst.jsdt.internal.compiler.ast.FieldDeclaration)nodes[i - 1]).declarationSourceStart == localDeclaration.declarationSourceStart) {
                    currentFieldDeclaration = (FieldDeclaration)compilationUnit.statements().get(compilationUnit.statements().size() - 1);
                    currentFieldDeclaration.fragments().add(this.convertToVariableDeclarationFragment(localDeclaration));
                } else {
                    compilationUnit.statements().add(this.convertToFieldDeclaration(localDeclaration));
                }
            }
            ++i;
        }
        return compilationUnit;
    }

    public Expression convert(BinaryExpression expression) {
        InfixExpression infixExpression = new InfixExpression(this.ast);
        if (this.resolveBindings) {
            this.recordNodes(infixExpression, expression);
        }
        int expressionOperatorID = (expression.bits & 0xFC0) >> 6;
        switch (expressionOperatorID) {
            case 18: {
                infixExpression.setOperator(InfixExpression.Operator.EQUALS);
                break;
            }
            case 5: {
                infixExpression.setOperator(InfixExpression.Operator.LESS_EQUALS);
                break;
            }
            case 7: {
                infixExpression.setOperator(InfixExpression.Operator.GREATER_EQUALS);
                break;
            }
            case 29: {
                infixExpression.setOperator(InfixExpression.Operator.NOT_EQUALS);
                break;
            }
            case 10: {
                infixExpression.setOperator(InfixExpression.Operator.LEFT_SHIFT);
                break;
            }
            case 17: {
                infixExpression.setOperator(InfixExpression.Operator.RIGHT_SHIFT_SIGNED);
                break;
            }
            case 19: {
                infixExpression.setOperator(InfixExpression.Operator.RIGHT_SHIFT_UNSIGNED);
                break;
            }
            case 1: {
                infixExpression.setOperator(InfixExpression.Operator.CONDITIONAL_OR);
                break;
            }
            case 0: {
                infixExpression.setOperator(InfixExpression.Operator.CONDITIONAL_AND);
                break;
            }
            case 14: {
                infixExpression.setOperator(InfixExpression.Operator.PLUS);
                break;
            }
            case 13: {
                infixExpression.setOperator(InfixExpression.Operator.MINUS);
                break;
            }
            case 16: {
                infixExpression.setOperator(InfixExpression.Operator.REMAINDER);
                break;
            }
            case 8: {
                infixExpression.setOperator(InfixExpression.Operator.XOR);
                break;
            }
            case 2: {
                infixExpression.setOperator(InfixExpression.Operator.AND);
                break;
            }
            case 15: {
                infixExpression.setOperator(InfixExpression.Operator.TIMES);
                break;
            }
            case 3: {
                infixExpression.setOperator(InfixExpression.Operator.OR);
                break;
            }
            case 9: {
                infixExpression.setOperator(InfixExpression.Operator.DIVIDE);
                break;
            }
            case 6: {
                infixExpression.setOperator(InfixExpression.Operator.GREATER);
                break;
            }
            case 4: {
                infixExpression.setOperator(InfixExpression.Operator.LESS);
                break;
            }
            case 26: {
                infixExpression.setOperator(InfixExpression.Operator.INSTANCEOF);
                break;
            }
            case 24: {
                infixExpression.setOperator(InfixExpression.Operator.EQUAL_EQUAL_EQUAL);
                break;
            }
            case 25: {
                infixExpression.setOperator(InfixExpression.Operator.NOT_EQUAL_EQUAL);
            }
        }
        if (expression.left instanceof BinaryExpression && (expression.left.bits & 0x1FE00000) == 0) {
            infixExpression.extendedOperands().add(this.convert(expression.right));
            org.eclipse.wst.jsdt.internal.compiler.ast.Expression leftOperand = expression.left;
            org.eclipse.wst.jsdt.internal.compiler.ast.Expression rightOperand = null;
            do {
                rightOperand = ((BinaryExpression)leftOperand).right;
                if ((leftOperand.bits & 0xFC0) >> 6 != expressionOperatorID && (leftOperand.bits & 0x1FE00000) == 0 || rightOperand instanceof BinaryExpression && (rightOperand.bits & 0xFC0) >> 6 != expressionOperatorID && (rightOperand.bits & 0x1FE00000) == 0) {
                    List extendedOperands = infixExpression.extendedOperands();
                    InfixExpression temp = new InfixExpression(this.ast);
                    if (this.resolveBindings) {
                        this.recordNodes(temp, expression);
                    }
                    temp.setOperator(this.getOperatorFor(expressionOperatorID));
                    Expression leftSide = this.convert(leftOperand);
                    temp.setLeftOperand(leftSide);
                    temp.setSourceRange(leftSide.getStartPosition(), leftSide.getLength());
                    int size = extendedOperands.size();
                    int i = 0;
                    while (i < size - 1) {
                        InfixExpression expr = temp;
                        temp = new InfixExpression(this.ast);
                        if (this.resolveBindings) {
                            this.recordNodes(temp, expression);
                        }
                        temp.setLeftOperand(expr);
                        temp.setOperator(this.getOperatorFor(expressionOperatorID));
                        temp.setSourceRange(expr.getStartPosition(), expr.getLength());
                        ++i;
                    }
                    infixExpression = temp;
                    i = 0;
                    while (i < size) {
                        Expression extendedOperand = (Expression)extendedOperands.remove(size - 1 - i);
                        temp.setRightOperand(extendedOperand);
                        int startPosition = temp.getLeftOperand().getStartPosition();
                        temp.setSourceRange(startPosition, extendedOperand.getStartPosition() + extendedOperand.getLength() - startPosition);
                        if (temp.getLeftOperand().getNodeType() == 27) {
                            temp = (InfixExpression)temp.getLeftOperand();
                        }
                        ++i;
                    }
                    int startPosition = infixExpression.getLeftOperand().getStartPosition();
                    infixExpression.setSourceRange(startPosition, expression.sourceEnd - startPosition + 1);
                    if (this.resolveBindings) {
                        this.recordNodes(infixExpression, expression);
                    }
                    return infixExpression;
                }
                infixExpression.extendedOperands().add(0, this.convert(rightOperand));
            } while ((leftOperand = ((BinaryExpression)leftOperand).left) instanceof BinaryExpression && (leftOperand.bits & 0x1FE00000) == 0);
            Expression leftExpression = this.convert(leftOperand);
            infixExpression.setLeftOperand(leftExpression);
            infixExpression.setRightOperand((Expression)infixExpression.extendedOperands().remove(0));
            int startPosition = leftExpression.getStartPosition();
            infixExpression.setSourceRange(startPosition, expression.sourceEnd - startPosition + 1);
            return infixExpression;
        }
        if (expression.left instanceof StringLiteralConcatenation && (expression.left.bits & 0x1FE00000) == 0 && 14 == expressionOperatorID) {
            StringLiteralConcatenation literal = (StringLiteralConcatenation)expression.left;
            org.eclipse.wst.jsdt.internal.compiler.ast.Expression[] stringLiterals = literal.literals;
            infixExpression.setLeftOperand(this.convert(stringLiterals[0]));
            infixExpression.setRightOperand(this.convert(stringLiterals[1]));
            int i = 2;
            while (i < literal.counter) {
                infixExpression.extendedOperands().add(this.convert(stringLiterals[i]));
                ++i;
            }
            infixExpression.extendedOperands().add(this.convert(expression.right));
            int startPosition = literal.sourceStart;
            infixExpression.setSourceRange(startPosition, expression.sourceEnd - startPosition + 1);
            return infixExpression;
        }
        Expression leftExpression = this.convert(expression.left);
        infixExpression.setLeftOperand(leftExpression);
        infixExpression.setRightOperand(this.convert(expression.right));
        int startPosition = leftExpression.getStartPosition();
        infixExpression.setSourceRange(startPosition, expression.sourceEnd - startPosition + 1);
        return infixExpression;
    }

    public Block convert(org.eclipse.wst.jsdt.internal.compiler.ast.Block statement) {
        ProgramElement[] statements;
        Block block = new Block(this.ast);
        if (statement.sourceEnd > 0) {
            block.setSourceRange(statement.sourceStart, statement.sourceEnd - statement.sourceStart + 1);
        }
        if ((statements = statement.statements) != null) {
            int statementsLength = statements.length;
            int i = 0;
            while (i < statementsLength) {
                if (statements[i] instanceof LocalDeclaration) {
                    this.checkAndAddMultipleLocalDeclaration(statements, i, block.statements());
                } else {
                    Statement statement2 = this.convert(statements[i]);
                    if (statement2 != null) {
                        block.statements().add(statement2);
                    }
                }
                ++i;
            }
        }
        return block;
    }

    public BreakStatement convert(org.eclipse.wst.jsdt.internal.compiler.ast.BreakStatement statement) {
        BreakStatement breakStatement = new BreakStatement(this.ast);
        breakStatement.setSourceRange(statement.sourceStart, statement.sourceEnd - statement.sourceStart + 1);
        if (statement.label != null) {
            SimpleName name = new SimpleName(this.ast);
            name.internalSetIdentifier(new String(statement.label));
            this.retrieveIdentifierAndSetPositions(statement.sourceStart, statement.sourceEnd, name);
            breakStatement.setLabel(name);
        }
        return breakStatement;
    }

    public SwitchCase convert(CaseStatement statement) {
        SwitchCase switchCase = new SwitchCase(this.ast);
        org.eclipse.wst.jsdt.internal.compiler.ast.Expression constantExpression = statement.constantExpression;
        if (constantExpression == null) {
            switchCase.setExpression(null);
        } else {
            switchCase.setExpression(this.convert(constantExpression));
        }
        switchCase.setSourceRange(statement.sourceStart, statement.sourceEnd - statement.sourceStart + 1);
        this.retrieveColonPosition(switchCase);
        return switchCase;
    }

    public FunctionExpression convert(org.eclipse.wst.jsdt.internal.compiler.ast.FunctionExpression expression) {
        FunctionExpression functionExpression = new FunctionExpression(this.ast);
        int sourceEnd = expression.sourceEnd;
        if (sourceEnd == 0) {
            sourceEnd = expression.methodDeclaration.bodyEnd;
        }
        functionExpression.setSourceRange(expression.sourceStart, sourceEnd - expression.sourceStart + 1);
        functionExpression.setMethod((FunctionDeclaration)this.convert(expression.methodDeclaration));
        if (this.resolveBindings) {
            this.recordNodes(functionExpression, expression);
        }
        return functionExpression;
    }

    public ObjectLiteral convert(org.eclipse.wst.jsdt.internal.compiler.ast.ObjectLiteral objLiteral) {
        ObjectLiteral objectLiteral = new ObjectLiteral(this.ast);
        objectLiteral.setSourceRange(objLiteral.sourceStart, objLiteral.sourceEnd - objLiteral.sourceStart + 1);
        org.eclipse.wst.jsdt.internal.compiler.ast.ObjectLiteralField[] fields = objLiteral.fields;
        if (fields != null) {
            int fieldsLength = fields.length;
            int i = 0;
            while (i < fieldsLength) {
                ObjectLiteralField objectLiteralField = this.convert(fields[i]);
                objectLiteral.fields().add(objectLiteralField);
                ++i;
            }
        }
        if (this.resolveBindings) {
            this.recordNodes(objectLiteral, objLiteral);
        }
        return objectLiteral;
    }

    public ObjectLiteralField convert(org.eclipse.wst.jsdt.internal.compiler.ast.ObjectLiteralField field) {
        ObjectLiteralField objectLiteralField = new ObjectLiteralField(this.ast);
        objectLiteralField.setSourceRange(field.sourceStart, field.sourceEnd - field.sourceStart + 1);
        objectLiteralField.setFieldName(this.convert(field.fieldName));
        objectLiteralField.setInitializer(this.convert(field.initializer));
        if (this.resolveBindings) {
            this.recordNodes(objectLiteralField, field);
        }
        return objectLiteralField;
    }

    public RegularExpressionLiteral convert(RegExLiteral expression) {
        int length = expression.sourceEnd - expression.sourceStart + 1;
        int sourceStart = expression.sourceStart;
        RegularExpressionLiteral literal = new RegularExpressionLiteral(this.ast);
        if (this.resolveBindings) {
            this.recordNodes(literal, expression);
        }
        literal.internalSetRegularExpression(new String(this.compilationUnitSource, sourceStart, length));
        literal.setSourceRange(sourceStart, length);
        this.removeLeadingAndTrailingCommentsFromLiteral(literal);
        return literal;
    }

    public Expression convert(ClassLiteralAccess expression) {
        TypeLiteral typeLiteral = new TypeLiteral(this.ast);
        if (this.resolveBindings) {
            this.recordNodes(typeLiteral, expression);
        }
        typeLiteral.setSourceRange(expression.sourceStart, expression.sourceEnd - expression.sourceStart + 1);
        typeLiteral.setType(this.convertType(expression.type));
        return typeLiteral;
    }

    public JavaScriptUnit convert(CompilationUnitDeclaration unit, char[] source) {
        ProgramElement[] statements;
        ImportReference[] imports;
        if (unit.compilationResult.recoveryScannerData != null) {
            RecoveryScanner recoveryScanner = new RecoveryScanner(this.scanner, unit.compilationResult.recoveryScannerData.removeUnused());
            this.docParser.scanner = this.scanner = recoveryScanner;
        }
        this.compilationUnitSource = source;
        this.compilationUnitSourceLength = source.length;
        this.scanner.setSource(source, unit.compilationResult);
        JavaScriptUnit compilationUnit = new JavaScriptUnit(this.ast);
        int[][] comments = unit.comments;
        if (comments != null) {
            this.buildCommentsTable(compilationUnit, comments);
        }
        if (this.resolveBindings) {
            this.recordNodes(compilationUnit, unit);
        }
        if (unit.currentPackage != null) {
            PackageDeclaration packageDeclaration = this.convertPackage(unit);
            compilationUnit.setPackage(packageDeclaration);
        }
        if ((imports = unit.imports) != null) {
            int importLength = imports.length;
            int i = 0;
            while (i < importLength) {
                compilationUnit.imports().add(this.convertImport(imports[i]));
                ++i;
            }
        }
        if ((statements = unit.statements) != null) {
            int statementsLength = statements.length;
            int i = 0;
            while (i < statementsLength) {
                ProgramElement programElement = statements[i];
                ASTNode type = null;
                if (programElement instanceof LocalDeclaration) {
                    this.checkAndAddMultipleLocalDeclaration(statements, i, compilationUnit.statements());
                } else if (programElement instanceof AbstractMethodDeclaration) {
                    type = this.convert((AbstractMethodDeclaration)programElement);
                } else if (programElement instanceof org.eclipse.wst.jsdt.internal.compiler.ast.Statement) {
                    type = this.convert((org.eclipse.wst.jsdt.internal.compiler.ast.Statement)programElement);
                } else {
                    throw new RuntimeException("");
                }
                if (type != null) {
                    compilationUnit.statements().add(type);
                }
                ++i;
            }
        }
        compilationUnit.setSourceRange(unit.sourceStart, unit.sourceEnd - unit.sourceStart + 1);
        int problemLength = unit.compilationResult.problemCount;
        if (problemLength != 0) {
            IProblem[] resizedProblems = null;
            CategorizedProblem[] problems = unit.compilationResult.getProblems();
            int realProblemLength = problems.length;
            if (realProblemLength == problemLength) {
                resizedProblems = problems;
            } else {
                resizedProblems = new CategorizedProblem[realProblemLength];
                System.arraycopy(problems, 0, resizedProblems, 0, realProblemLength);
            }
            ASTSyntaxErrorPropagator syntaxErrorPropagator = new ASTSyntaxErrorPropagator((CategorizedProblem[])resizedProblems);
            compilationUnit.accept(syntaxErrorPropagator);
            ASTRecoveryPropagator recoveryPropagator = new ASTRecoveryPropagator((CategorizedProblem[])resizedProblems, unit.compilationResult.recoveryScannerData);
            compilationUnit.accept(recoveryPropagator);
            compilationUnit.setProblems(resizedProblems);
        }
        if (this.resolveBindings) {
            this.lookupForScopes();
        }
        compilationUnit.initCommentMapper(this.scanner);
        return compilationUnit;
    }

    public Assignment convert(CompoundAssignment expression) {
        Assignment assignment = new Assignment(this.ast);
        Expression lhs = this.convert(expression.lhs);
        assignment.setLeftHandSide(lhs);
        int start = lhs.getStartPosition();
        assignment.setSourceRange(start, expression.sourceEnd - start + 1);
        switch (expression.operator) {
            case 14: {
                assignment.setOperator(Assignment.Operator.PLUS_ASSIGN);
                break;
            }
            case 13: {
                assignment.setOperator(Assignment.Operator.MINUS_ASSIGN);
                break;
            }
            case 15: {
                assignment.setOperator(Assignment.Operator.TIMES_ASSIGN);
                break;
            }
            case 9: {
                assignment.setOperator(Assignment.Operator.DIVIDE_ASSIGN);
                break;
            }
            case 2: {
                assignment.setOperator(Assignment.Operator.BIT_AND_ASSIGN);
                break;
            }
            case 3: {
                assignment.setOperator(Assignment.Operator.BIT_OR_ASSIGN);
                break;
            }
            case 8: {
                assignment.setOperator(Assignment.Operator.BIT_XOR_ASSIGN);
                break;
            }
            case 16: {
                assignment.setOperator(Assignment.Operator.REMAINDER_ASSIGN);
                break;
            }
            case 10: {
                assignment.setOperator(Assignment.Operator.LEFT_SHIFT_ASSIGN);
                break;
            }
            case 17: {
                assignment.setOperator(Assignment.Operator.RIGHT_SHIFT_SIGNED_ASSIGN);
                break;
            }
            case 19: {
                assignment.setOperator(Assignment.Operator.RIGHT_SHIFT_UNSIGNED_ASSIGN);
            }
        }
        assignment.setRightHandSide(this.convert(expression.expression));
        if (this.resolveBindings) {
            this.recordNodes(assignment, expression);
        }
        return assignment;
    }

    public ConditionalExpression convert(org.eclipse.wst.jsdt.internal.compiler.ast.ConditionalExpression expression) {
        ConditionalExpression conditionalExpression = new ConditionalExpression(this.ast);
        if (this.resolveBindings) {
            this.recordNodes(conditionalExpression, expression);
        }
        conditionalExpression.setSourceRange(expression.sourceStart, expression.sourceEnd - expression.sourceStart + 1);
        conditionalExpression.setExpression(this.convert(expression.condition));
        conditionalExpression.setThenExpression(this.convert(expression.valueIfTrue));
        conditionalExpression.setElseExpression(this.convert(expression.valueIfFalse));
        return conditionalExpression;
    }

    public ContinueStatement convert(org.eclipse.wst.jsdt.internal.compiler.ast.ContinueStatement statement) {
        ContinueStatement continueStatement = new ContinueStatement(this.ast);
        continueStatement.setSourceRange(statement.sourceStart, statement.sourceEnd - statement.sourceStart + 1);
        if (statement.label != null) {
            SimpleName name = new SimpleName(this.ast);
            name.internalSetIdentifier(new String(statement.label));
            this.retrieveIdentifierAndSetPositions(statement.sourceStart, statement.sourceEnd, name);
            continueStatement.setLabel(name);
        }
        return continueStatement;
    }

    public DoStatement convert(org.eclipse.wst.jsdt.internal.compiler.ast.DoStatement statement) {
        DoStatement doStatement = new DoStatement(this.ast);
        doStatement.setSourceRange(statement.sourceStart, statement.sourceEnd - statement.sourceStart + 1);
        doStatement.setExpression(this.convert(statement.condition));
        Statement action = this.convert(statement.action);
        if (action == null) {
            return null;
        }
        doStatement.setBody(action);
        return doStatement;
    }

    public NumberLiteral convert(DoubleLiteral expression) {
        int length = expression.sourceEnd - expression.sourceStart + 1;
        int sourceStart = expression.sourceStart;
        NumberLiteral literal = new NumberLiteral(this.ast);
        literal.internalSetToken(new String(this.compilationUnitSource, sourceStart, length));
        if (this.resolveBindings) {
            this.recordNodes(literal, expression);
        }
        literal.setSourceRange(sourceStart, length);
        this.removeLeadingAndTrailingCommentsFromLiteral(literal);
        return literal;
    }

    public EmptyStatement convert(org.eclipse.wst.jsdt.internal.compiler.ast.EmptyStatement statement) {
        EmptyStatement emptyStatement = new EmptyStatement(this.ast);
        emptyStatement.setSourceRange(statement.sourceStart, statement.sourceEnd - statement.sourceStart + 1);
        return emptyStatement;
    }

    public EmptyExpression convert(org.eclipse.wst.jsdt.internal.compiler.ast.EmptyExpression expression) {
        EmptyExpression emptyExpression = new EmptyExpression(this.ast);
        emptyExpression.setSourceRange(expression.sourceStart, expression.sourceEnd - expression.sourceStart + 1);
        return emptyExpression;
    }

    public Expression convert(EqualExpression expression) {
        InfixExpression infixExpression = new InfixExpression(this.ast);
        if (this.resolveBindings) {
            this.recordNodes(infixExpression, expression);
        }
        Expression leftExpression = this.convert(expression.left);
        infixExpression.setLeftOperand(leftExpression);
        infixExpression.setRightOperand(this.convert(expression.right));
        int startPosition = leftExpression.getStartPosition();
        infixExpression.setSourceRange(startPosition, expression.sourceEnd - startPosition + 1);
        switch ((expression.bits & 0xFC0) >> 6) {
            case 18: {
                infixExpression.setOperator(InfixExpression.Operator.EQUALS);
                break;
            }
            case 29: {
                infixExpression.setOperator(InfixExpression.Operator.NOT_EQUALS);
            }
        }
        return infixExpression;
    }

    public Statement convert(ExplicitConstructorCall statement) {
        Statement newStatement;
        int sourceStart = statement.sourceStart;
        if (statement.isSuperAccess() || statement.isSuper()) {
            org.eclipse.wst.jsdt.internal.compiler.ast.Expression[] arguments;
            SuperConstructorInvocation superConstructorInvocation = new SuperConstructorInvocation(this.ast);
            if (statement.qualification != null) {
                superConstructorInvocation.setExpression(this.convert(statement.qualification));
            }
            if ((arguments = statement.arguments) != null) {
                int length = arguments.length;
                int i = 0;
                while (i < length) {
                    superConstructorInvocation.arguments().add(this.convert(arguments[i]));
                    ++i;
                }
            }
            if (statement.typeArguments != null) {
                if (sourceStart > statement.typeArgumentsSourceStart) {
                    sourceStart = statement.typeArgumentsSourceStart;
                }
                switch (this.ast.apiLevel) {
                    case 2: {
                        superConstructorInvocation.setFlags(superConstructorInvocation.getFlags() | 1);
                        break;
                    }
                    case 3: {
                        int i = 0;
                        int max = statement.typeArguments.length;
                        while (i < max) {
                            superConstructorInvocation.typeArguments().add(this.convertType(statement.typeArguments[i]));
                            ++i;
                        }
                        break;
                    }
                }
            }
            newStatement = superConstructorInvocation;
        } else {
            ConstructorInvocation constructorInvocation = new ConstructorInvocation(this.ast);
            org.eclipse.wst.jsdt.internal.compiler.ast.Expression[] arguments = statement.arguments;
            if (arguments != null) {
                int length = arguments.length;
                int i = 0;
                while (i < length) {
                    constructorInvocation.arguments().add(this.convert(arguments[i]));
                    ++i;
                }
            }
            if (statement.typeArguments != null) {
                if (sourceStart > statement.typeArgumentsSourceStart) {
                    sourceStart = statement.typeArgumentsSourceStart;
                }
                switch (this.ast.apiLevel) {
                    case 2: {
                        constructorInvocation.setFlags(constructorInvocation.getFlags() | 1);
                        break;
                    }
                    case 3: {
                        int i = 0;
                        int max = statement.typeArguments.length;
                        while (i < max) {
                            constructorInvocation.typeArguments().add(this.convertType(statement.typeArguments[i]));
                            ++i;
                        }
                        break;
                    }
                }
            }
            if (statement.qualification != null) {
                constructorInvocation.setFlags(constructorInvocation.getFlags() | 1);
            }
            newStatement = constructorInvocation;
        }
        newStatement.setSourceRange(sourceStart, statement.sourceEnd - sourceStart + 1);
        if (this.resolveBindings) {
            this.recordNodes(newStatement, statement);
        }
        return newStatement;
    }

    public Expression convert(org.eclipse.wst.jsdt.internal.compiler.ast.Expression expression) {
        if (expression == null) {
            return null;
        }
        if ((expression.bits & 0x1FE00000) != 0) {
            return this.convertToParenthesizedExpression(expression);
        }
        if (expression instanceof ArrayAllocationExpression) {
            return this.convert((ArrayAllocationExpression)expression);
        }
        if (expression instanceof QualifiedAllocationExpression) {
            return this.convert((QualifiedAllocationExpression)expression);
        }
        if (expression instanceof AllocationExpression) {
            return this.convert((AllocationExpression)expression);
        }
        if (expression instanceof org.eclipse.wst.jsdt.internal.compiler.ast.ArrayInitializer) {
            return this.convert((org.eclipse.wst.jsdt.internal.compiler.ast.ArrayInitializer)expression);
        }
        if (expression instanceof org.eclipse.wst.jsdt.internal.compiler.ast.PrefixExpression) {
            return this.convert((org.eclipse.wst.jsdt.internal.compiler.ast.PrefixExpression)expression);
        }
        if (expression instanceof org.eclipse.wst.jsdt.internal.compiler.ast.PostfixExpression) {
            return this.convert((org.eclipse.wst.jsdt.internal.compiler.ast.PostfixExpression)expression);
        }
        if (expression instanceof CompoundAssignment) {
            return this.convert((CompoundAssignment)expression);
        }
        if (expression instanceof org.eclipse.wst.jsdt.internal.compiler.ast.Assignment) {
            return this.convert((org.eclipse.wst.jsdt.internal.compiler.ast.Assignment)expression);
        }
        if (expression instanceof ClassLiteralAccess) {
            return this.convert((ClassLiteralAccess)expression);
        }
        if (expression instanceof FalseLiteral) {
            return this.convert((FalseLiteral)expression);
        }
        if (expression instanceof TrueLiteral) {
            return this.convert((TrueLiteral)expression);
        }
        if (expression instanceof org.eclipse.wst.jsdt.internal.compiler.ast.NullLiteral) {
            return this.convert((org.eclipse.wst.jsdt.internal.compiler.ast.NullLiteral)expression);
        }
        if (expression instanceof DoubleLiteral) {
            return this.convert((DoubleLiteral)expression);
        }
        if (expression instanceof IntLiteralMinValue) {
            return this.convert((IntLiteralMinValue)expression);
        }
        if (expression instanceof IntLiteral) {
            return this.convert((IntLiteral)expression);
        }
        if (expression instanceof StringLiteralConcatenation) {
            return this.convert((StringLiteralConcatenation)expression);
        }
        if (expression instanceof ExtendedStringLiteral) {
            return this.convert((ExtendedStringLiteral)expression);
        }
        if (expression instanceof org.eclipse.wst.jsdt.internal.compiler.ast.StringLiteral) {
            return this.convert((org.eclipse.wst.jsdt.internal.compiler.ast.StringLiteral)expression);
        }
        if (expression instanceof AND_AND_Expression) {
            return this.convert((AND_AND_Expression)expression);
        }
        if (expression instanceof OR_OR_Expression) {
            return this.convert((OR_OR_Expression)expression);
        }
        if (expression instanceof EqualExpression) {
            return this.convert((EqualExpression)expression);
        }
        if (expression instanceof BinaryExpression) {
            return this.convert((BinaryExpression)expression);
        }
        if (expression instanceof InstanceOfExpression) {
            return this.convert((InstanceOfExpression)expression);
        }
        if (expression instanceof UnaryExpression) {
            return this.convert((UnaryExpression)expression);
        }
        if (expression instanceof org.eclipse.wst.jsdt.internal.compiler.ast.ConditionalExpression) {
            return this.convert((org.eclipse.wst.jsdt.internal.compiler.ast.ConditionalExpression)expression);
        }
        if (expression instanceof MessageSend) {
            return this.convert((MessageSend)expression);
        }
        if (expression instanceof Reference) {
            return this.convert((Reference)expression);
        }
        if (expression instanceof TypeReference) {
            return this.convert((TypeReference)expression);
        }
        if (expression instanceof org.eclipse.wst.jsdt.internal.compiler.ast.FunctionExpression) {
            return this.convert((org.eclipse.wst.jsdt.internal.compiler.ast.FunctionExpression)expression);
        }
        if (expression instanceof org.eclipse.wst.jsdt.internal.compiler.ast.ObjectLiteral) {
            return this.convert((org.eclipse.wst.jsdt.internal.compiler.ast.ObjectLiteral)expression);
        }
        if (expression instanceof org.eclipse.wst.jsdt.internal.compiler.ast.ObjectLiteralField) {
            return this.convert((org.eclipse.wst.jsdt.internal.compiler.ast.ObjectLiteralField)expression);
        }
        if (expression instanceof org.eclipse.wst.jsdt.internal.compiler.ast.UndefinedLiteral) {
            return this.convert((org.eclipse.wst.jsdt.internal.compiler.ast.UndefinedLiteral)expression);
        }
        if (expression instanceof RegExLiteral) {
            return this.convert((RegExLiteral)expression);
        }
        if (expression instanceof org.eclipse.wst.jsdt.internal.compiler.ast.ListExpression) {
            return this.convert((org.eclipse.wst.jsdt.internal.compiler.ast.ListExpression)expression);
        }
        if (expression instanceof org.eclipse.wst.jsdt.internal.compiler.ast.EmptyExpression) {
            return this.convert((org.eclipse.wst.jsdt.internal.compiler.ast.EmptyExpression)expression);
        }
        return null;
    }

    public StringLiteral convert(ExtendedStringLiteral expression) {
        expression.computeConstant();
        StringLiteral literal = new StringLiteral(this.ast);
        if (this.resolveBindings) {
            this.recordNodes(literal, expression);
        }
        literal.setLiteralValue(expression.constant.stringValue());
        literal.setSourceRange(expression.sourceStart, expression.sourceEnd - expression.sourceStart + 1);
        return literal;
    }

    public BooleanLiteral convert(FalseLiteral expression) {
        BooleanLiteral literal = new BooleanLiteral(this.ast);
        literal.setBooleanValue(false);
        if (this.resolveBindings) {
            this.recordNodes(literal, expression);
        }
        literal.setSourceRange(expression.sourceStart, expression.sourceEnd - expression.sourceStart + 1);
        return literal;
    }

    public Expression convert(FieldReference reference) {
        if (reference.receiver.isSuper()) {
            SuperFieldAccess superFieldAccess = new SuperFieldAccess(this.ast);
            if (this.resolveBindings) {
                this.recordNodes(superFieldAccess, reference);
            }
            SimpleName simpleName = new SimpleName(this.ast);
            simpleName.internalSetIdentifier(new String(reference.token));
            int sourceStart = (int)(reference.nameSourcePosition >>> 32);
            int length = (int)(reference.nameSourcePosition & 0xFFFFFFFFFFFFFFFFL) - sourceStart + 1;
            simpleName.setSourceRange(sourceStart, length);
            superFieldAccess.setName(simpleName);
            if (this.resolveBindings) {
                this.recordNodes(simpleName, reference);
            }
            superFieldAccess.setSourceRange(reference.receiver.sourceStart, reference.sourceEnd - reference.receiver.sourceStart + 1);
            return superFieldAccess;
        }
        FieldAccess fieldAccess = new FieldAccess(this.ast);
        if (this.resolveBindings) {
            this.recordNodes(fieldAccess, reference);
        }
        Expression receiver = this.convert(reference.receiver);
        fieldAccess.setExpression(receiver);
        SimpleName simpleName = new SimpleName(this.ast);
        simpleName.internalSetIdentifier(new String(reference.token));
        int sourceStart = (int)(reference.nameSourcePosition >>> 32);
        int length = (int)(reference.nameSourcePosition & 0xFFFFFFFFFFFFFFFFL) - sourceStart + 1;
        simpleName.setSourceRange(sourceStart, length);
        fieldAccess.setName(simpleName);
        if (this.resolveBindings) {
            this.recordNodes(simpleName, reference);
        }
        fieldAccess.setSourceRange(receiver.getStartPosition(), reference.sourceEnd - receiver.getStartPosition() + 1);
        return fieldAccess;
    }

    public Statement convert(ForeachStatement statement) {
        switch (this.ast.apiLevel) {
            case 2: {
                return this.createFakeEmptyStatement(statement);
            }
            case 3: {
                EnhancedForStatement enhancedForStatement = new EnhancedForStatement(this.ast);
                enhancedForStatement.setParameter(this.convertToSingleVariableDeclaration(statement.elementVariable));
                org.eclipse.wst.jsdt.internal.compiler.ast.Expression collection = statement.collection;
                if (collection == null) {
                    return null;
                }
                enhancedForStatement.setExpression(this.convert(collection));
                Statement action = this.convert(statement.action);
                if (action == null) {
                    return null;
                }
                enhancedForStatement.setBody(action);
                int start = statement.sourceStart;
                int end = statement.sourceEnd;
                enhancedForStatement.setSourceRange(start, end - start + 1);
                return enhancedForStatement;
            }
        }
        return this.createFakeEmptyStatement(statement);
    }

    public ForStatement convert(org.eclipse.wst.jsdt.internal.compiler.ast.ForStatement statement) {
        Statement action;
        org.eclipse.wst.jsdt.internal.compiler.ast.Statement[] increments;
        ForStatement forStatement = new ForStatement(this.ast);
        forStatement.setSourceRange(statement.sourceStart, statement.sourceEnd - statement.sourceStart + 1);
        org.eclipse.wst.jsdt.internal.compiler.ast.Statement[] initializations = statement.initializations;
        if (initializations != null) {
            if (initializations[0] instanceof LocalDeclaration) {
                VariableDeclarationExpression variableDeclarationExpression = this.convertToVariableDeclarationExpression((LocalDeclaration)initializations[0]);
                int initializationsLength = initializations.length;
                int i = 1;
                while (i < initializationsLength) {
                    variableDeclarationExpression.fragments().add(this.convertToVariableDeclarationFragment((LocalDeclaration)initializations[i]));
                    ++i;
                }
                if (initializationsLength != 1) {
                    int start = variableDeclarationExpression.getStartPosition();
                    int end = ((LocalDeclaration)initializations[initializationsLength - 1]).declarationSourceEnd;
                    variableDeclarationExpression.setSourceRange(start, end - start + 1);
                }
                forStatement.initializers().add(variableDeclarationExpression);
            } else {
                int initializationsLength = initializations.length;
                int i = 0;
                while (i < initializationsLength) {
                    Expression initializer = this.convertToExpression(initializations[i]);
                    if (initializer != null) {
                        forStatement.initializers().add(initializer);
                    } else {
                        forStatement.setFlags(forStatement.getFlags() | 1);
                    }
                    ++i;
                }
            }
        }
        if (statement.condition != null) {
            forStatement.setExpression(this.convert(statement.condition));
        }
        if ((increments = statement.increments) != null) {
            int incrementsLength = increments.length;
            int i = 0;
            while (i < incrementsLength) {
                forStatement.updaters().add(this.convertToExpression(increments[i]));
                ++i;
            }
        }
        if ((action = this.convert(statement.action)) == null) {
            return null;
        }
        forStatement.setBody(action);
        return forStatement;
    }

    public ForInStatement convert(org.eclipse.wst.jsdt.internal.compiler.ast.ForInStatement statement) {
        ForInStatement forInStatement = new ForInStatement(this.ast);
        forInStatement.setSourceRange(statement.sourceStart, statement.sourceEnd - statement.sourceStart + 1);
        Statement iterationVariable = this.convert(statement.iterationVariable);
        forInStatement.setIterationVariable(iterationVariable);
        Expression collection = this.convert(statement.collection);
        forInStatement.setCollection(collection);
        Statement action = this.convert(statement.action);
        if (action == null) {
            return null;
        }
        forInStatement.setBody(action);
        return forInStatement;
    }

    public IfStatement convert(org.eclipse.wst.jsdt.internal.compiler.ast.IfStatement statement) {
        Statement elseStatement;
        IfStatement ifStatement = new IfStatement(this.ast);
        ifStatement.setSourceRange(statement.sourceStart, statement.sourceEnd - statement.sourceStart + 1);
        ifStatement.setExpression(this.convert(statement.condition));
        Statement thenStatement = this.convert(statement.thenStatement);
        if (thenStatement == null) {
            return null;
        }
        ifStatement.setThenStatement(thenStatement);
        org.eclipse.wst.jsdt.internal.compiler.ast.Statement statement2 = statement.elseStatement;
        if (statement2 != null && (elseStatement = this.convert(statement2)) != null) {
            ifStatement.setElseStatement(elseStatement);
        }
        return ifStatement;
    }

    public InstanceofExpression convert(InstanceOfExpression expression) {
        InstanceofExpression instanceOfExpression = new InstanceofExpression(this.ast);
        if (this.resolveBindings) {
            this.recordNodes(instanceOfExpression, expression);
        }
        Expression leftExpression = this.convert(expression.expression);
        instanceOfExpression.setLeftOperand(leftExpression);
        Type convertType = this.convertType(expression.type);
        instanceOfExpression.setRightOperand(convertType);
        int startPosition = leftExpression.getStartPosition();
        int sourceEnd = convertType.getStartPosition() + convertType.getLength() - 1;
        instanceOfExpression.setSourceRange(startPosition, sourceEnd - startPosition + 1);
        return instanceOfExpression;
    }

    public NumberLiteral convert(IntLiteral expression) {
        int length = expression.sourceEnd - expression.sourceStart + 1;
        int sourceStart = expression.sourceStart;
        NumberLiteral literal = new NumberLiteral(this.ast);
        literal.internalSetToken(new String(this.compilationUnitSource, sourceStart, length));
        if (this.resolveBindings) {
            this.recordNodes(literal, expression);
        }
        literal.setSourceRange(sourceStart, length);
        this.removeLeadingAndTrailingCommentsFromLiteral(literal);
        return literal;
    }

    public NumberLiteral convert(IntLiteralMinValue expression) {
        int length = expression.sourceEnd - expression.sourceStart + 1;
        int sourceStart = expression.sourceStart;
        NumberLiteral literal = new NumberLiteral(this.ast);
        literal.internalSetToken(new String(this.compilationUnitSource, sourceStart, length));
        if (this.resolveBindings) {
            this.recordNodes(literal, expression);
        }
        literal.setSourceRange(sourceStart, length);
        this.removeLeadingAndTrailingCommentsFromLiteral(literal);
        return literal;
    }

    public void convert(Javadoc javadoc, BodyDeclaration bodyDeclaration) {
        if (bodyDeclaration.getJavadoc() == null && javadoc != null) {
            Comment comment;
            if (this.commentMapper == null || !this.commentMapper.hasSameTable(this.commentsTable)) {
                this.commentMapper = new DefaultCommentMapper(this.commentsTable);
            }
            if ((comment = this.commentMapper.getComment(javadoc.sourceStart)) != null && comment.isDocComment() && comment.getParent() == null) {
                JSdoc docComment = (JSdoc)comment;
                if (this.resolveBindings) {
                    this.recordNodes(docComment, javadoc);
                    ListIterator tags = docComment.tags().listIterator();
                    while (tags.hasNext()) {
                        this.recordNodes(javadoc, (TagElement)tags.next());
                    }
                }
                bodyDeclaration.setJavadoc(docComment);
            }
        }
    }

    public void convert(Javadoc javadoc, VariableDeclarationStatement variable) {
        if (variable.getJavadoc() == null && javadoc != null) {
            Comment comment;
            if (this.commentMapper == null || !this.commentMapper.hasSameTable(this.commentsTable)) {
                this.commentMapper = new DefaultCommentMapper(this.commentsTable);
            }
            if ((comment = this.commentMapper.getComment(javadoc.sourceStart)) != null && comment.isDocComment() && comment.getParent() == null) {
                JSdoc docComment = (JSdoc)comment;
                if (this.resolveBindings) {
                    this.recordNodes(docComment, javadoc);
                    ListIterator tags = docComment.tags().listIterator();
                    while (tags.hasNext()) {
                        this.recordNodes(javadoc, (TagElement)tags.next());
                    }
                }
                variable.setJavadoc(docComment);
            }
        }
    }

    public void convert(Javadoc javadoc, PackageDeclaration packageDeclaration) {
        if (this.ast.apiLevel == 3 && packageDeclaration.getJavadoc() == null && javadoc != null) {
            Comment comment;
            if (this.commentMapper == null || !this.commentMapper.hasSameTable(this.commentsTable)) {
                this.commentMapper = new DefaultCommentMapper(this.commentsTable);
            }
            if ((comment = this.commentMapper.getComment(javadoc.sourceStart)) != null && comment.isDocComment() && comment.getParent() == null) {
                JSdoc docComment = (JSdoc)comment;
                if (this.resolveBindings) {
                    this.recordNodes(docComment, javadoc);
                    ListIterator tags = docComment.tags().listIterator();
                    while (tags.hasNext()) {
                        this.recordNodes(javadoc, (TagElement)tags.next());
                    }
                }
                packageDeclaration.setJavadoc(docComment);
            }
        }
    }

    public LabeledStatement convert(org.eclipse.wst.jsdt.internal.compiler.ast.LabeledStatement statement) {
        LabeledStatement labeledStatement = new LabeledStatement(this.ast);
        int sourceStart = statement.sourceStart;
        labeledStatement.setSourceRange(sourceStart, statement.sourceEnd - sourceStart + 1);
        Statement body = this.convert(statement.statement);
        if (body == null) {
            return null;
        }
        labeledStatement.setBody(body);
        SimpleName name = new SimpleName(this.ast);
        name.internalSetIdentifier(new String(statement.label));
        name.setSourceRange(sourceStart, statement.labelEnd - sourceStart + 1);
        labeledStatement.setLabel(name);
        return labeledStatement;
    }

    public ListExpression convert(org.eclipse.wst.jsdt.internal.compiler.ast.ListExpression expression) {
        ListExpression listExpression = new ListExpression(this.ast);
        if (this.resolveBindings) {
            this.recordNodes(listExpression, expression);
        }
        listExpression.setSourceRange(expression.sourceStart, expression.sourceEnd - expression.sourceStart + 1);
        org.eclipse.wst.jsdt.internal.compiler.ast.Expression[] expressions = expression.expressions;
        if (expressions != null) {
            int length = expressions.length;
            int i = 0;
            while (i < length) {
                Expression expr = this.convert(expressions[i]);
                if (this.resolveBindings) {
                    this.recordNodes(expr, expressions[i]);
                }
                listExpression.expressions().add(expr);
                ++i;
            }
        }
        return listExpression;
    }

    public Expression convert(MessageSend expression) {
        Expression expr;
        int sourceStart = expression.sourceStart;
        if (expression.isSuperAccess()) {
            SuperMethodInvocation superMethodInvocation = new SuperMethodInvocation(this.ast);
            if (this.resolveBindings) {
                this.recordNodes(superMethodInvocation, expression);
            }
            SimpleName name = new SimpleName(this.ast);
            name.internalSetIdentifier(new String(expression.selector));
            int nameSourceStart = (int)(expression.nameSourcePosition >>> 32);
            int nameSourceLength = (int)expression.nameSourcePosition - nameSourceStart + 1;
            name.setSourceRange(nameSourceStart, nameSourceLength);
            if (this.resolveBindings) {
                this.recordNodes(name, expression);
            }
            superMethodInvocation.setName(name);
            org.eclipse.wst.jsdt.internal.compiler.ast.Expression[] arguments = expression.arguments;
            if (arguments != null) {
                int argumentsLength = arguments.length;
                int i = 0;
                while (i < argumentsLength) {
                    Expression expri = this.convert(arguments[i]);
                    if (this.resolveBindings) {
                        this.recordNodes(expri, arguments[i]);
                    }
                    superMethodInvocation.arguments().add(expri);
                    ++i;
                }
            }
            expr = superMethodInvocation;
        } else {
            org.eclipse.wst.jsdt.internal.compiler.ast.Expression[] arguments;
            FunctionInvocation methodInvocation = new FunctionInvocation(this.ast);
            if (this.resolveBindings) {
                this.recordNodes(methodInvocation, expression);
            }
            if (expression.selector != null) {
                SimpleName name = new SimpleName(this.ast);
                name.internalSetIdentifier(new String(expression.selector));
                int nameSourceStart = (int)(expression.nameSourcePosition >>> 32);
                int nameSourceLength = (int)expression.nameSourcePosition - nameSourceStart + 1;
                name.setSourceRange(nameSourceStart, nameSourceLength);
                methodInvocation.setName(name);
                if (this.resolveBindings) {
                    this.recordNodes(name, expression);
                }
            }
            if ((arguments = expression.arguments) != null) {
                int argumentsLength = arguments.length;
                int i = 0;
                while (i < argumentsLength) {
                    Expression expri = this.convert(arguments[i]);
                    if (this.resolveBindings) {
                        this.recordNodes(expri, arguments[i]);
                    }
                    methodInvocation.arguments().add(expri);
                    ++i;
                }
            }
            Expression qualifier = null;
            org.eclipse.wst.jsdt.internal.compiler.ast.Expression receiver = expression.receiver;
            qualifier = receiver instanceof MessageSend ? ((receiver.bits & 0x1FE00000) != 0 ? this.convertToParenthesizedExpression(receiver) : this.convert((MessageSend)receiver)) : this.convert(receiver);
            if (qualifier instanceof Name && this.resolveBindings) {
                this.recordNodes(qualifier, receiver);
            }
            methodInvocation.setExpression(qualifier);
            if (qualifier != null) {
                sourceStart = qualifier.getStartPosition();
            }
            expr = methodInvocation;
        }
        expr.setSourceRange(sourceStart, expression.sourceEnd - sourceStart + 1);
        this.removeTrailingCommentFromExpressionEndingWithAParen(expr);
        return expr;
    }

    public Name convert(NameReference reference) {
        if (reference instanceof QualifiedNameReference) {
            return this.convert((QualifiedNameReference)reference);
        }
        return this.convert((SingleNameReference)reference);
    }

    public InfixExpression convert(StringLiteralConcatenation expression) {
        expression.computeConstant();
        InfixExpression infixExpression = new InfixExpression(this.ast);
        infixExpression.setOperator(InfixExpression.Operator.PLUS);
        org.eclipse.wst.jsdt.internal.compiler.ast.Expression[] stringLiterals = expression.literals;
        infixExpression.setLeftOperand(this.convert(stringLiterals[0]));
        infixExpression.setRightOperand(this.convert(stringLiterals[1]));
        int i = 2;
        while (i < expression.counter) {
            infixExpression.extendedOperands().add(this.convert(stringLiterals[i]));
            ++i;
        }
        if (this.resolveBindings) {
            this.recordNodes(infixExpression, expression);
        }
        infixExpression.setSourceRange(expression.sourceStart, expression.sourceEnd - expression.sourceStart + 1);
        return infixExpression;
    }

    public NullLiteral convert(org.eclipse.wst.jsdt.internal.compiler.ast.NullLiteral expression) {
        NullLiteral literal = new NullLiteral(this.ast);
        if (this.resolveBindings) {
            this.recordNodes(literal, expression);
        }
        literal.setSourceRange(expression.sourceStart, expression.sourceEnd - expression.sourceStart + 1);
        return literal;
    }

    public UndefinedLiteral convert(org.eclipse.wst.jsdt.internal.compiler.ast.UndefinedLiteral expression) {
        UndefinedLiteral literal = new UndefinedLiteral(this.ast);
        if (this.resolveBindings) {
            this.recordNodes(literal, expression);
        }
        literal.setSourceRange(expression.sourceStart, expression.sourceEnd - expression.sourceStart + 1);
        return literal;
    }

    public Expression convert(OR_OR_Expression expression) {
        InfixExpression infixExpression = new InfixExpression(this.ast);
        infixExpression.setOperator(InfixExpression.Operator.CONDITIONAL_OR);
        if (this.resolveBindings) {
            this.recordNodes(infixExpression, expression);
        }
        int expressionOperatorID = (expression.bits & 0xFC0) >> 6;
        if (expression.left instanceof BinaryExpression && (expression.left.bits & 0x1FE00000) == 0) {
            infixExpression.extendedOperands().add(this.convert(expression.right));
            org.eclipse.wst.jsdt.internal.compiler.ast.Expression leftOperand = expression.left;
            org.eclipse.wst.jsdt.internal.compiler.ast.Expression rightOperand = null;
            do {
                rightOperand = ((BinaryExpression)leftOperand).right;
                if ((leftOperand.bits & 0xFC0) >> 6 != expressionOperatorID && (leftOperand.bits & 0x1FE00000) == 0 || rightOperand instanceof BinaryExpression && (rightOperand.bits & 0xFC0) >> 6 != expressionOperatorID && (rightOperand.bits & 0x1FE00000) == 0) {
                    List extendedOperands = infixExpression.extendedOperands();
                    InfixExpression temp = new InfixExpression(this.ast);
                    if (this.resolveBindings) {
                        this.recordNodes(temp, expression);
                    }
                    temp.setOperator(this.getOperatorFor(expressionOperatorID));
                    Expression leftSide = this.convert(leftOperand);
                    temp.setLeftOperand(leftSide);
                    temp.setSourceRange(leftSide.getStartPosition(), leftSide.getLength());
                    int size = extendedOperands.size();
                    int i = 0;
                    while (i < size - 1) {
                        InfixExpression expr = temp;
                        temp = new InfixExpression(this.ast);
                        if (this.resolveBindings) {
                            this.recordNodes(temp, expression);
                        }
                        temp.setLeftOperand(expr);
                        temp.setOperator(this.getOperatorFor(expressionOperatorID));
                        temp.setSourceRange(expr.getStartPosition(), expr.getLength());
                        ++i;
                    }
                    infixExpression = temp;
                    i = 0;
                    while (i < size) {
                        Expression extendedOperand = (Expression)extendedOperands.remove(size - 1 - i);
                        temp.setRightOperand(extendedOperand);
                        int startPosition = temp.getLeftOperand().getStartPosition();
                        temp.setSourceRange(startPosition, extendedOperand.getStartPosition() + extendedOperand.getLength() - startPosition);
                        if (temp.getLeftOperand().getNodeType() == 27) {
                            temp = (InfixExpression)temp.getLeftOperand();
                        }
                        ++i;
                    }
                    int startPosition = infixExpression.getLeftOperand().getStartPosition();
                    infixExpression.setSourceRange(startPosition, expression.sourceEnd - startPosition + 1);
                    if (this.resolveBindings) {
                        this.recordNodes(infixExpression, expression);
                    }
                    return infixExpression;
                }
                infixExpression.extendedOperands().add(0, this.convert(rightOperand));
            } while ((leftOperand = ((BinaryExpression)leftOperand).left) instanceof BinaryExpression && (leftOperand.bits & 0x1FE00000) == 0);
            Expression leftExpression = this.convert(leftOperand);
            infixExpression.setLeftOperand(leftExpression);
            infixExpression.setRightOperand((Expression)infixExpression.extendedOperands().remove(0));
            int startPosition = leftExpression.getStartPosition();
            infixExpression.setSourceRange(startPosition, expression.sourceEnd - startPosition + 1);
            return infixExpression;
        }
        Expression leftExpression = this.convert(expression.left);
        infixExpression.setLeftOperand(leftExpression);
        infixExpression.setRightOperand(this.convert(expression.right));
        infixExpression.setOperator(InfixExpression.Operator.CONDITIONAL_OR);
        int startPosition = leftExpression.getStartPosition();
        infixExpression.setSourceRange(startPosition, expression.sourceEnd - startPosition + 1);
        return infixExpression;
    }

    public PostfixExpression convert(org.eclipse.wst.jsdt.internal.compiler.ast.PostfixExpression expression) {
        PostfixExpression postfixExpression = new PostfixExpression(this.ast);
        if (this.resolveBindings) {
            this.recordNodes(postfixExpression, expression);
        }
        postfixExpression.setSourceRange(expression.sourceStart, expression.sourceEnd - expression.sourceStart + 1);
        postfixExpression.setOperand(this.convert(expression.lhs));
        switch (expression.operator) {
            case 14: {
                postfixExpression.setOperator(PostfixExpression.Operator.INCREMENT);
                break;
            }
            case 13: {
                postfixExpression.setOperator(PostfixExpression.Operator.DECREMENT);
            }
        }
        return postfixExpression;
    }

    public PrefixExpression convert(org.eclipse.wst.jsdt.internal.compiler.ast.PrefixExpression expression) {
        PrefixExpression prefixExpression = new PrefixExpression(this.ast);
        if (this.resolveBindings) {
            this.recordNodes(prefixExpression, expression);
        }
        prefixExpression.setSourceRange(expression.sourceStart, expression.sourceEnd - expression.sourceStart + 1);
        prefixExpression.setOperand(this.convert(expression.lhs));
        switch (expression.operator) {
            case 14: {
                prefixExpression.setOperator(PrefixExpression.Operator.INCREMENT);
                break;
            }
            case 13: {
                prefixExpression.setOperator(PrefixExpression.Operator.DECREMENT);
            }
        }
        return prefixExpression;
    }

    public Expression convert(QualifiedAllocationExpression allocation) {
        org.eclipse.wst.jsdt.internal.compiler.ast.Expression[] arguments;
        ClassInstanceCreation classInstanceCreation = new ClassInstanceCreation(this.ast);
        if (allocation.enclosingInstance != null) {
            classInstanceCreation.setExpression(this.convert(allocation.enclosingInstance));
        }
        if (allocation.member != null) {
            classInstanceCreation.setMember(this.convert(allocation.member));
        }
        if (allocation.type != null) {
            switch (this.ast.apiLevel) {
                case 2: {
                    classInstanceCreation.internalSetName(this.convert(allocation.type));
                    break;
                }
                case 3: {
                    classInstanceCreation.setType(this.convertType(allocation.type));
                }
            }
        }
        if ((arguments = allocation.arguments) != null) {
            int length = arguments.length;
            int i = 0;
            while (i < length) {
                Expression argument = this.convert(arguments[i]);
                if (this.resolveBindings) {
                    this.recordNodes(argument, arguments[i]);
                }
                classInstanceCreation.arguments().add(argument);
                ++i;
            }
        }
        if (allocation.anonymousType != null) {
            int declarationSourceStart = allocation.sourceStart;
            classInstanceCreation.setSourceRange(declarationSourceStart, allocation.anonymousType.bodyEnd - declarationSourceStart + 1);
            AnonymousClassDeclaration anonymousClassDeclaration = new AnonymousClassDeclaration(this.ast);
            int start = this.retrieveStartBlockPosition(allocation.anonymousType.sourceEnd, allocation.anonymousType.bodyEnd);
            anonymousClassDeclaration.setSourceRange(start, allocation.anonymousType.bodyEnd - start + 1);
            classInstanceCreation.setAnonymousClassDeclaration(anonymousClassDeclaration);
            this.buildBodyDeclarations(allocation.anonymousType, anonymousClassDeclaration);
            if (this.resolveBindings) {
                this.recordNodes(classInstanceCreation, allocation.anonymousType);
                this.recordNodes(anonymousClassDeclaration, allocation.anonymousType);
                anonymousClassDeclaration.resolveBinding();
            }
            return classInstanceCreation;
        }
        int start = allocation.sourceStart;
        classInstanceCreation.setSourceRange(start, allocation.sourceEnd - start + 1);
        if (this.resolveBindings) {
            this.recordNodes(classInstanceCreation, allocation);
        }
        this.removeTrailingCommentFromExpressionEndingWithAParen(classInstanceCreation);
        return classInstanceCreation;
    }

    public Name convert(QualifiedNameReference nameReference) {
        return this.setQualifiedNameNameAndSourceRanges(nameReference.tokens, nameReference.sourcePositions, nameReference);
    }

    public ThisExpression convert(QualifiedThisReference reference) {
        ThisExpression thisExpression = new ThisExpression(this.ast);
        thisExpression.setSourceRange(reference.sourceStart, reference.sourceEnd - reference.sourceStart + 1);
        thisExpression.setQualifier(this.convert(reference.qualification));
        if (this.resolveBindings) {
            this.recordNodes(thisExpression, reference);
            this.recordPendingThisExpressionScopeResolution(thisExpression);
        }
        return thisExpression;
    }

    public Expression convert(Reference reference) {
        if (reference instanceof NameReference) {
            return this.convert((NameReference)reference);
        }
        if (reference instanceof ThisReference) {
            return this.convert((ThisReference)reference);
        }
        if (reference instanceof ArrayReference) {
            return this.convert((ArrayReference)reference);
        }
        if (reference instanceof FieldReference) {
            return this.convert((FieldReference)reference);
        }
        return null;
    }

    public ReturnStatement convert(org.eclipse.wst.jsdt.internal.compiler.ast.ReturnStatement statement) {
        ReturnStatement returnStatement = new ReturnStatement(this.ast);
        returnStatement.setSourceRange(statement.sourceStart, statement.sourceEnd - statement.sourceStart + 1);
        if (statement.expression != null) {
            returnStatement.setExpression(this.convert(statement.expression));
        }
        return returnStatement;
    }

    public SimpleName convert(SingleNameReference nameReference) {
        SimpleName name = new SimpleName(this.ast);
        name.internalSetIdentifier(new String(nameReference.token));
        if (this.resolveBindings) {
            this.recordNodes(name, nameReference);
        }
        name.setSourceRange(nameReference.sourceStart, nameReference.sourceEnd - nameReference.sourceStart + 1);
        return name;
    }

    public Statement convert(org.eclipse.wst.jsdt.internal.compiler.ast.Statement statement) {
        if (statement instanceof ForeachStatement) {
            return this.convert((ForeachStatement)statement);
        }
        if (statement instanceof LocalDeclaration) {
            return this.convertToVariableDeclarationStatement((LocalDeclaration)statement);
        }
        if (statement instanceof org.eclipse.wst.jsdt.internal.compiler.ast.Block) {
            return this.convert((org.eclipse.wst.jsdt.internal.compiler.ast.Block)statement);
        }
        if (statement instanceof org.eclipse.wst.jsdt.internal.compiler.ast.BreakStatement) {
            return this.convert((org.eclipse.wst.jsdt.internal.compiler.ast.BreakStatement)statement);
        }
        if (statement instanceof org.eclipse.wst.jsdt.internal.compiler.ast.ContinueStatement) {
            return this.convert((org.eclipse.wst.jsdt.internal.compiler.ast.ContinueStatement)statement);
        }
        if (statement instanceof CaseStatement) {
            return this.convert((CaseStatement)statement);
        }
        if (statement instanceof org.eclipse.wst.jsdt.internal.compiler.ast.DoStatement) {
            return this.convert((org.eclipse.wst.jsdt.internal.compiler.ast.DoStatement)statement);
        }
        if (statement instanceof org.eclipse.wst.jsdt.internal.compiler.ast.EmptyStatement) {
            return this.convert((org.eclipse.wst.jsdt.internal.compiler.ast.EmptyStatement)statement);
        }
        if (statement instanceof ExplicitConstructorCall) {
            return this.convert((ExplicitConstructorCall)statement);
        }
        if (statement instanceof org.eclipse.wst.jsdt.internal.compiler.ast.ForStatement) {
            return this.convert((org.eclipse.wst.jsdt.internal.compiler.ast.ForStatement)statement);
        }
        if (statement instanceof org.eclipse.wst.jsdt.internal.compiler.ast.ForInStatement) {
            return this.convert((org.eclipse.wst.jsdt.internal.compiler.ast.ForInStatement)statement);
        }
        if (statement instanceof org.eclipse.wst.jsdt.internal.compiler.ast.IfStatement) {
            return this.convert((org.eclipse.wst.jsdt.internal.compiler.ast.IfStatement)statement);
        }
        if (statement instanceof org.eclipse.wst.jsdt.internal.compiler.ast.LabeledStatement) {
            return this.convert((org.eclipse.wst.jsdt.internal.compiler.ast.LabeledStatement)statement);
        }
        if (statement instanceof org.eclipse.wst.jsdt.internal.compiler.ast.ReturnStatement) {
            return this.convert((org.eclipse.wst.jsdt.internal.compiler.ast.ReturnStatement)statement);
        }
        if (statement instanceof org.eclipse.wst.jsdt.internal.compiler.ast.SwitchStatement) {
            return this.convert((org.eclipse.wst.jsdt.internal.compiler.ast.SwitchStatement)statement);
        }
        if (statement instanceof org.eclipse.wst.jsdt.internal.compiler.ast.ThrowStatement) {
            return this.convert((org.eclipse.wst.jsdt.internal.compiler.ast.ThrowStatement)statement);
        }
        if (statement instanceof org.eclipse.wst.jsdt.internal.compiler.ast.TryStatement) {
            return this.convert((org.eclipse.wst.jsdt.internal.compiler.ast.TryStatement)statement);
        }
        if (statement instanceof org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration) {
            ASTNode result = this.convert((org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration)statement);
            if (result == null) {
                return this.createFakeEmptyStatement(statement);
            }
            TypeDeclaration typeDeclaration = (TypeDeclaration)result;
            TypeDeclarationStatement typeDeclarationStatement = new TypeDeclarationStatement(this.ast);
            typeDeclarationStatement.setDeclaration(typeDeclaration);
            switch (this.ast.apiLevel) {
                case 2: {
                    TypeDeclaration typeDecl = typeDeclarationStatement.internalGetTypeDeclaration();
                    typeDeclarationStatement.setSourceRange(typeDecl.getStartPosition(), typeDecl.getLength());
                    break;
                }
                case 3: {
                    AbstractTypeDeclaration typeDeclAST3 = typeDeclarationStatement.getDeclaration();
                    typeDeclarationStatement.setSourceRange(typeDeclAST3.getStartPosition(), typeDeclAST3.getLength());
                }
            }
            return typeDeclarationStatement;
        }
        if (statement instanceof org.eclipse.wst.jsdt.internal.compiler.ast.WhileStatement) {
            return this.convert((org.eclipse.wst.jsdt.internal.compiler.ast.WhileStatement)statement);
        }
        if (statement instanceof org.eclipse.wst.jsdt.internal.compiler.ast.WithStatement) {
            return this.convert((org.eclipse.wst.jsdt.internal.compiler.ast.WithStatement)statement);
        }
        if (statement instanceof org.eclipse.wst.jsdt.internal.compiler.ast.Expression) {
            org.eclipse.wst.jsdt.internal.compiler.ast.Expression statement2 = (org.eclipse.wst.jsdt.internal.compiler.ast.Expression)statement;
            Expression expr = this.convert(statement2);
            ExpressionStatement stmt = new ExpressionStatement(this.ast);
            stmt.setExpression(expr);
            int sourceStart = expr.getStartPosition();
            int sourceEnd = statement2.statementEnd;
            if (sourceEnd == -1) {
                sourceEnd = statement2.sourceEnd;
            }
            stmt.setSourceRange(sourceStart, sourceEnd - sourceStart + 1);
            return stmt;
        }
        return this.createFakeEmptyStatement(statement);
    }

    public Expression convert(org.eclipse.wst.jsdt.internal.compiler.ast.StringLiteral expression) {
        if (expression instanceof StringLiteralConcatenation) {
            return this.convert((StringLiteralConcatenation)expression);
        }
        int length = expression.sourceEnd - expression.sourceStart + 1;
        int sourceStart = expression.sourceStart;
        StringLiteral literal = new StringLiteral(this.ast);
        if (this.resolveBindings) {
            this.recordNodes(literal, expression);
        }
        literal.internalSetEscapedValue(new String(this.compilationUnitSource, sourceStart, length));
        literal.setSourceRange(expression.sourceStart, expression.sourceEnd - expression.sourceStart + 1);
        return literal;
    }

    public SwitchStatement convert(org.eclipse.wst.jsdt.internal.compiler.ast.SwitchStatement statement) {
        SwitchStatement switchStatement = new SwitchStatement(this.ast);
        switchStatement.setSourceRange(statement.sourceStart, statement.sourceEnd - statement.sourceStart + 1);
        switchStatement.setExpression(this.convert(statement.expression));
        ProgramElement[] statements = statement.statements;
        if (statements != null) {
            int statementsLength = statements.length;
            int i = 0;
            while (i < statementsLength) {
                if (statements[i] instanceof LocalDeclaration) {
                    this.checkAndAddMultipleLocalDeclaration(statements, i, switchStatement.statements());
                } else {
                    Statement currentStatement = this.convert(statements[i]);
                    if (currentStatement != null) {
                        switchStatement.statements().add(currentStatement);
                    }
                }
                ++i;
            }
        }
        return switchStatement;
    }

    public Expression convert(ThisReference reference) {
        if (reference.isImplicitThis()) {
            return null;
        }
        if (reference instanceof QualifiedThisReference) {
            return this.convert((QualifiedThisReference)reference);
        }
        ThisExpression thisExpression = new ThisExpression(this.ast);
        thisExpression.setSourceRange(reference.sourceStart, reference.sourceEnd - reference.sourceStart + 1);
        if (this.resolveBindings) {
            this.recordNodes(thisExpression, reference);
            this.recordPendingThisExpressionScopeResolution(thisExpression);
        }
        return thisExpression;
    }

    public ThrowStatement convert(org.eclipse.wst.jsdt.internal.compiler.ast.ThrowStatement statement) {
        ThrowStatement throwStatement = new ThrowStatement(this.ast);
        throwStatement.setSourceRange(statement.sourceStart, statement.sourceEnd - statement.sourceStart + 1);
        throwStatement.setExpression(this.convert(statement.exception));
        return throwStatement;
    }

    public BooleanLiteral convert(TrueLiteral expression) {
        BooleanLiteral literal = new BooleanLiteral(this.ast);
        literal.setBooleanValue(true);
        if (this.resolveBindings) {
            this.recordNodes(literal, expression);
        }
        literal.setSourceRange(expression.sourceStart, expression.sourceEnd - expression.sourceStart + 1);
        return literal;
    }

    public TryStatement convert(org.eclipse.wst.jsdt.internal.compiler.ast.TryStatement statement) {
        TryStatement tryStatement = new TryStatement(this.ast);
        tryStatement.setSourceRange(statement.sourceStart, statement.sourceEnd - statement.sourceStart + 1);
        tryStatement.setBody(this.convert(statement.tryBlock));
        Argument[] catchArguments = statement.catchArguments;
        if (catchArguments != null) {
            int catchArgumentsLength = catchArguments.length;
            org.eclipse.wst.jsdt.internal.compiler.ast.Block[] catchBlocks = statement.catchBlocks;
            int start = statement.tryBlock.sourceEnd;
            int i = 0;
            while (i < catchArgumentsLength) {
                CatchClause catchClause = new CatchClause(this.ast);
                int catchClauseSourceStart = this.retrieveStartingCatchPosition(start, catchArguments[i].sourceStart);
                catchClause.setSourceRange(catchClauseSourceStart, catchBlocks[i].sourceEnd - catchClauseSourceStart + 1);
                catchClause.setBody(this.convert(catchBlocks[i]));
                catchClause.setException(this.convert(catchArguments[i]));
                tryStatement.catchClauses().add(catchClause);
                start = catchBlocks[i].sourceEnd;
                ++i;
            }
        }
        if (statement.finallyBlock != null) {
            tryStatement.setFinally(this.convert(statement.finallyBlock));
        }
        return tryStatement;
    }

    public ASTNode convert(org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration typeDeclaration) {
        this.checkCanceled();
        TypeDeclaration typeDecl = new TypeDeclaration(this.ast);
        if (typeDeclaration.modifiersSourceStart != -1) {
            this.setModifiers(typeDecl, typeDeclaration);
        }
        SimpleName typeName = new SimpleName(this.ast);
        typeName.internalSetIdentifier(new String(typeDeclaration.name));
        typeName.setSourceRange(typeDeclaration.sourceStart, typeDeclaration.sourceEnd - typeDeclaration.sourceStart + 1);
        typeDecl.setName(typeName);
        typeDecl.setSourceRange(typeDeclaration.declarationSourceStart, typeDeclaration.bodyEnd - typeDeclaration.declarationSourceStart + 1);
        if (typeDeclaration.superclass != null) {
            switch (this.ast.apiLevel) {
                case 2: {
                    typeDecl.internalSetSuperclass(this.convert(typeDeclaration.superclass));
                    break;
                }
                case 3: {
                    typeDecl.setSuperclassType(this.convertType(typeDeclaration.superclass));
                }
            }
        }
        this.buildBodyDeclarations(typeDeclaration, typeDecl);
        if (this.resolveBindings) {
            this.recordNodes(typeDecl, typeDeclaration);
            this.recordNodes(typeName, typeDeclaration);
            typeDecl.resolveBinding();
        }
        return typeDecl;
    }

    public Name convert(TypeReference typeReference) {
        char[][] typeName = typeReference.getTypeName();
        int length = typeName.length;
        if (length > 1) {
            QualifiedTypeReference qualifiedTypeReference = (QualifiedTypeReference)typeReference;
            long[] positions = qualifiedTypeReference.sourcePositions;
            return this.setQualifiedNameNameAndSourceRanges(typeName, positions, typeReference);
        }
        SimpleName name = new SimpleName(this.ast);
        name.internalSetIdentifier(new String(typeName[0]));
        name.setSourceRange(typeReference.sourceStart, typeReference.sourceEnd - typeReference.sourceStart + 1);
        name.index = 1;
        if (this.resolveBindings) {
            this.recordNodes(name, typeReference);
        }
        return name;
    }

    public PrefixExpression convert(UnaryExpression expression) {
        PrefixExpression prefixExpression = new PrefixExpression(this.ast);
        if (this.resolveBindings) {
            this.recordNodes(prefixExpression, expression);
        }
        prefixExpression.setSourceRange(expression.sourceStart, expression.sourceEnd - expression.sourceStart + 1);
        prefixExpression.setOperand(this.convert(expression.expression));
        switch ((expression.bits & 0xFC0) >> 6) {
            case 14: {
                prefixExpression.setOperator(PrefixExpression.Operator.PLUS);
                break;
            }
            case 13: {
                prefixExpression.setOperator(PrefixExpression.Operator.MINUS);
                break;
            }
            case 11: {
                prefixExpression.setOperator(PrefixExpression.Operator.NOT);
                break;
            }
            case 12: {
                prefixExpression.setOperator(PrefixExpression.Operator.COMPLEMENT);
            }
        }
        return prefixExpression;
    }

    public WhileStatement convert(org.eclipse.wst.jsdt.internal.compiler.ast.WhileStatement statement) {
        WhileStatement whileStatement = new WhileStatement(this.ast);
        whileStatement.setSourceRange(statement.sourceStart, statement.sourceEnd - statement.sourceStart + 1);
        whileStatement.setExpression(this.convert(statement.condition));
        Statement action = this.convert(statement.action);
        if (action == null) {
            return null;
        }
        whileStatement.setBody(action);
        return whileStatement;
    }

    public WithStatement convert(org.eclipse.wst.jsdt.internal.compiler.ast.WithStatement statement) {
        WithStatement withStatement = new WithStatement(this.ast);
        withStatement.setSourceRange(statement.sourceStart, statement.sourceEnd - statement.sourceStart + 1);
        withStatement.setExpression(this.convert(statement.condition));
        Statement action = this.convert(statement.action);
        if (action == null) {
            return null;
        }
        withStatement.setBody(action);
        return withStatement;
    }

    public ImportDeclaration convertImport(ImportReference importReference) {
        ImportDeclaration importDeclaration = new ImportDeclaration(this.ast);
        boolean onDemand = (importReference.bits & 0x20000) != 0;
        char[][] tokens = importReference.tokens;
        int length = importReference.tokens.length;
        long[] positions = importReference.sourcePositions;
        if (length > 1) {
            importDeclaration.setName(this.setQualifiedNameNameAndSourceRanges(tokens, positions, importReference));
        } else if (length == 1) {
            SimpleName name = new SimpleName(this.ast);
            name.internalSetIdentifier(new String(tokens[0]));
            int start = (int)(positions[0] >>> 32);
            int end = (int)(positions[0] & 0xFFFFFFFFFFFFFFFFL);
            name.setSourceRange(start, end - start + 1);
            name.index = 1;
            importDeclaration.setName(name);
            if (this.resolveBindings) {
                this.recordNodes(name, importReference);
            }
        }
        boolean isFile = (importReference.bits & 0x10) != 0;
        importDeclaration.setSourceRange(importReference.declarationSourceStart, importReference.declarationEnd - importReference.declarationSourceStart + 1);
        importDeclaration.setOnDemand(onDemand && !isFile);
        importDeclaration.setIsFileImport(isFile);
        if (this.resolveBindings) {
            this.recordNodes(importDeclaration, importReference);
        }
        return importDeclaration;
    }

    public PackageDeclaration convertPackage(CompilationUnitDeclaration compilationUnitDeclaration) {
        ImportReference importReference = compilationUnitDeclaration.currentPackage;
        PackageDeclaration packageDeclaration = new PackageDeclaration(this.ast);
        char[][] tokens = importReference.tokens;
        int length = importReference.tokens.length;
        long[] positions = importReference.sourcePositions;
        if (length > 1) {
            packageDeclaration.setName(this.setQualifiedNameNameAndSourceRanges(tokens, positions, importReference));
        } else {
            SimpleName name = new SimpleName(this.ast);
            name.internalSetIdentifier(new String(tokens[0]));
            int start = (int)(positions[0] >>> 32);
            int end = (int)(positions[length - 1] & 0xFFFFFFFFFFFFFFFFL);
            name.setSourceRange(start, end - start + 1);
            name.index = 1;
            packageDeclaration.setName(name);
            if (this.resolveBindings) {
                this.recordNodes(name, compilationUnitDeclaration);
            }
        }
        packageDeclaration.setSourceRange(importReference.declarationSourceStart, importReference.declarationEnd - importReference.declarationSourceStart + 1);
        if (this.resolveBindings) {
            this.recordNodes(packageDeclaration, importReference);
        }
        this.convert(compilationUnitDeclaration.javadoc, packageDeclaration);
        return packageDeclaration;
    }

    public Expression convertToExpression(org.eclipse.wst.jsdt.internal.compiler.ast.Statement statement) {
        if (statement instanceof org.eclipse.wst.jsdt.internal.compiler.ast.Expression) {
            return this.convert((org.eclipse.wst.jsdt.internal.compiler.ast.Expression)statement);
        }
        return null;
    }

    protected FieldDeclaration convertToFieldDeclaration(AbstractVariableDeclaration fieldDecl) {
        VariableDeclarationFragment variableDeclarationFragment = this.convertToVariableDeclarationFragment(fieldDecl);
        FieldDeclaration fieldDeclaration = new FieldDeclaration(this.ast);
        fieldDeclaration.fragments().add(variableDeclarationFragment);
        if (this.resolveBindings) {
            this.recordNodes(variableDeclarationFragment, fieldDecl);
            variableDeclarationFragment.resolveBinding();
        }
        fieldDeclaration.setSourceRange(fieldDecl.declarationSourceStart, fieldDecl.declarationEnd - fieldDecl.declarationSourceStart + 1);
        Type type = this.convertType(fieldDecl.type, fieldDecl.inferredType);
        this.setTypeForField(fieldDeclaration, type, variableDeclarationFragment.getExtraDimensions());
        this.convert(fieldDecl.javadoc, fieldDeclaration);
        return fieldDeclaration;
    }

    public ParenthesizedExpression convertToParenthesizedExpression(org.eclipse.wst.jsdt.internal.compiler.ast.Expression expression) {
        ParenthesizedExpression parenthesizedExpression = new ParenthesizedExpression(this.ast);
        if (this.resolveBindings) {
            this.recordNodes(parenthesizedExpression, expression);
        }
        parenthesizedExpression.setSourceRange(expression.sourceStart, expression.sourceEnd - expression.sourceStart + 1);
        this.adjustSourcePositionsForParent(expression);
        this.trimWhiteSpacesAndComments(expression);
        int numberOfParenthesis = (expression.bits & 0x1FE00000) >> 21;
        expression.bits &= 0xE01FFFFF;
        expression.bits |= numberOfParenthesis - 1 << 21;
        parenthesizedExpression.setExpression(this.convert(expression));
        return parenthesizedExpression;
    }

    public Type convertToType(NameReference reference) {
        Name name = this.convert(reference);
        SimpleType type = new SimpleType(this.ast);
        type.setName(name);
        type.setSourceRange(name.getStartPosition(), name.getLength());
        if (this.resolveBindings) {
            this.recordNodes(type, reference);
        }
        return type;
    }

    protected VariableDeclarationExpression convertToVariableDeclarationExpression(LocalDeclaration localDeclaration) {
        VariableDeclarationFragment variableDeclarationFragment = this.convertToVariableDeclarationFragment(localDeclaration);
        VariableDeclarationExpression variableDeclarationExpression = new VariableDeclarationExpression(this.ast);
        variableDeclarationExpression.fragments().add(variableDeclarationFragment);
        if (this.resolveBindings) {
            this.recordNodes(variableDeclarationFragment, localDeclaration);
        }
        variableDeclarationExpression.setSourceRange(localDeclaration.declarationSourceStart, localDeclaration.declarationSourceEnd - localDeclaration.declarationSourceStart + 1);
        Type type = this.convertType(localDeclaration.type, localDeclaration.inferredType);
        this.setTypeForVariableDeclarationExpression(variableDeclarationExpression, type, variableDeclarationFragment.getExtraDimensions());
        if (localDeclaration.modifiersSourceStart != -1) {
            this.setModifiers(variableDeclarationExpression, localDeclaration);
        }
        return variableDeclarationExpression;
    }

    protected SingleVariableDeclaration convertToSingleVariableDeclaration(LocalDeclaration localDeclaration) {
        SingleVariableDeclaration variableDecl = new SingleVariableDeclaration(this.ast);
        this.setModifiers(variableDecl, localDeclaration);
        SimpleName name = new SimpleName(this.ast);
        name.internalSetIdentifier(new String(localDeclaration.name));
        int start = localDeclaration.sourceStart;
        int nameEnd = localDeclaration.sourceEnd;
        name.setSourceRange(start, nameEnd - start + 1);
        variableDecl.setName(name);
        int extraDimensions = this.retrieveExtraDimension(nameEnd + 1, localDeclaration.type.sourceEnd);
        variableDecl.setExtraDimensions(extraDimensions);
        Type type = this.convertType(localDeclaration.type, localDeclaration.inferredType);
        int typeEnd = type.getStartPosition() + type.getLength() - 1;
        int rightEnd = Math.max(typeEnd, localDeclaration.declarationSourceEnd);
        this.setTypeForSingleVariableDeclaration(variableDecl, type, extraDimensions);
        variableDecl.setSourceRange(localDeclaration.declarationSourceStart, rightEnd - localDeclaration.declarationSourceStart + 1);
        if (this.resolveBindings) {
            this.recordNodes(name, localDeclaration);
            this.recordNodes(variableDecl, localDeclaration);
            variableDecl.resolveBinding();
        }
        return variableDecl;
    }

    protected VariableDeclarationFragment convertToVariableDeclarationFragment(AbstractVariableDeclaration fieldDeclaration) {
        int end;
        VariableDeclarationFragment variableDeclarationFragment = new VariableDeclarationFragment(this.ast);
        SimpleName name = new SimpleName(this.ast);
        name.internalSetIdentifier(new String(fieldDeclaration.name));
        name.setSourceRange(fieldDeclaration.sourceStart, fieldDeclaration.sourceEnd - fieldDeclaration.sourceStart + 1);
        variableDeclarationFragment.setName(name);
        int start = fieldDeclaration.sourceEnd;
        if (fieldDeclaration.initialization != null) {
            Expression expression = this.convert(fieldDeclaration.initialization);
            variableDeclarationFragment.setInitializer(expression);
            start = expression.getStartPosition() + expression.getLength();
        }
        if ((end = this.retrievePositionBeforeNextCommaOrSemiColon(start, fieldDeclaration.declarationSourceEnd)) == -1) {
            variableDeclarationFragment.setSourceRange(fieldDeclaration.sourceStart, fieldDeclaration.declarationSourceEnd - fieldDeclaration.sourceStart + 1);
            variableDeclarationFragment.setFlags(variableDeclarationFragment.getFlags() | 1);
        } else {
            variableDeclarationFragment.setSourceRange(fieldDeclaration.sourceStart, end - fieldDeclaration.sourceStart + 1);
        }
        variableDeclarationFragment.setExtraDimensions(this.retrieveExtraDimension(fieldDeclaration.sourceEnd + 1, fieldDeclaration.declarationSourceEnd));
        if (this.resolveBindings) {
            this.recordNodes(name, fieldDeclaration);
            this.recordNodes(variableDeclarationFragment, fieldDeclaration);
            variableDeclarationFragment.resolveBinding();
        }
        return variableDeclarationFragment;
    }

    protected VariableDeclarationFragment convertToVariableDeclarationFragment(LocalDeclaration localDeclaration) {
        int end;
        boolean hasInitialization;
        VariableDeclarationFragment variableDeclarationFragment = new VariableDeclarationFragment(this.ast);
        SimpleName name = new SimpleName(this.ast);
        name.internalSetIdentifier(new String(localDeclaration.name));
        name.setSourceRange(localDeclaration.sourceStart, localDeclaration.sourceEnd - localDeclaration.sourceStart + 1);
        variableDeclarationFragment.setName(name);
        int start = localDeclaration.sourceEnd;
        org.eclipse.wst.jsdt.internal.compiler.ast.Expression initialization = localDeclaration.initialization;
        boolean bl = hasInitialization = initialization != null;
        if (hasInitialization) {
            Expression expression = this.convert(initialization);
            variableDeclarationFragment.setInitializer(expression);
            start = expression.getStartPosition() + expression.getLength();
        }
        if ((end = this.retrievePositionBeforeNextCommaOrSemiColon(start, localDeclaration.declarationSourceEnd)) == -1) {
            end = hasInitialization ? start - 1 : localDeclaration.sourceEnd;
        }
        variableDeclarationFragment.setSourceRange(localDeclaration.sourceStart, end - localDeclaration.sourceStart + 1);
        variableDeclarationFragment.setExtraDimensions(this.retrieveExtraDimension(localDeclaration.sourceEnd + 1, this.compilationUnitSourceLength));
        if (this.resolveBindings) {
            this.recordNodes(variableDeclarationFragment, localDeclaration);
            this.recordNodes(name, localDeclaration);
            variableDeclarationFragment.resolveBinding();
        }
        return variableDeclarationFragment;
    }

    protected VariableDeclarationStatement convertToVariableDeclarationStatement(LocalDeclaration localDeclaration) {
        VariableDeclarationFragment variableDeclarationFragment = this.convertToVariableDeclarationFragment(localDeclaration);
        VariableDeclarationStatement variableDeclarationStatement = new VariableDeclarationStatement(this.ast);
        variableDeclarationStatement.fragments().add(variableDeclarationFragment);
        if (this.resolveBindings) {
            this.recordNodes(variableDeclarationFragment, localDeclaration);
        }
        variableDeclarationStatement.setSourceRange(localDeclaration.declarationSourceStart, localDeclaration.declarationSourceEnd - localDeclaration.declarationSourceStart + 1);
        if (localDeclaration.type != null) {
            Type type = this.convertType(localDeclaration.type, localDeclaration.inferredType);
            this.setTypeForVariableDeclarationStatement(variableDeclarationStatement, type, variableDeclarationFragment.getExtraDimensions());
        }
        LocalDeclaration local = localDeclaration;
        while (local.nextLocal != null) {
            variableDeclarationStatement.fragments().add(this.convertToVariableDeclarationFragment(local.nextLocal));
            local = (LocalDeclaration)local.nextLocal;
        }
        if (localDeclaration.modifiersSourceStart != -1) {
            this.setModifiers(variableDeclarationStatement, localDeclaration);
        }
        this.convert(localDeclaration.javadoc, variableDeclarationStatement);
        return variableDeclarationStatement;
    }

    public Type convertType(TypeReference typeReference) {
        return this.convertType(typeReference, null);
    }

    public Type convertType(TypeReference typeReference, org.eclipse.wst.jsdt.core.infer.InferredType inferredType) {
        Type type;
        block16: {
            int dimensions;
            int length;
            int sourceStart;
            block15: {
                if (typeReference == null) {
                    InferredType newType = new InferredType(this.ast);
                    newType.setSourceRange(-1, 0);
                    if (inferredType != null) {
                        newType.type = new String(inferredType.getName());
                        if (this.resolveBindings) {
                            this.recordNodes(newType, inferredType);
                        }
                    }
                    return newType;
                }
                type = null;
                sourceStart = -1;
                length = 0;
                dimensions = typeReference.dimensions();
                if (!(typeReference instanceof SingleTypeReference)) break block15;
                char[] name = ((SingleTypeReference)typeReference).getTypeName()[0];
                sourceStart = typeReference.sourceStart;
                length = typeReference.sourceEnd - typeReference.sourceStart + 1;
                if (this.isPrimitiveType(name)) {
                    int end = this.retrieveEndOfElementTypeNamePosition(sourceStart, sourceStart + length);
                    if (end == -1) {
                        end = sourceStart + length - 1;
                    }
                    PrimitiveType primitiveType = new PrimitiveType(this.ast);
                    primitiveType.setPrimitiveTypeCode(this.getPrimitiveTypeCode(name));
                    primitiveType.setSourceRange(sourceStart, end - sourceStart + 1);
                    type = primitiveType;
                } else {
                    SimpleName simpleName = new SimpleName(this.ast);
                    simpleName.internalSetIdentifier(new String(name));
                    int end = this.retrieveEndOfElementTypeNamePosition(sourceStart, sourceStart + length);
                    if (end == -1) {
                        end = sourceStart + length - 1;
                    }
                    simpleName.setSourceRange(sourceStart, end - sourceStart + 1);
                    SimpleType simpleType = new SimpleType(this.ast);
                    simpleType.setName(simpleName);
                    type = simpleType;
                    type.setSourceRange(sourceStart, end - sourceStart + 1);
                    type = simpleType;
                    if (this.resolveBindings) {
                        this.recordNodes(simpleName, typeReference);
                    }
                }
                if (dimensions == 0) break block16;
                type = this.ast.newArrayType(type, dimensions);
                type.setSourceRange(sourceStart, length);
                ArrayType subarrayType = (ArrayType)type;
                int index = dimensions - 1;
                while (index > 0) {
                    subarrayType = (ArrayType)subarrayType.getComponentType();
                    int end = this.retrieveProperRightBracketPosition(index, sourceStart);
                    subarrayType.setSourceRange(sourceStart, end - sourceStart + 1);
                    --index;
                }
                if (!this.resolveBindings) break block16;
                this.completeRecord((ArrayType)type, typeReference);
                break block16;
            }
            char[][] name = ((QualifiedTypeReference)typeReference).getTypeName();
            int nameLength = name.length;
            long[] positions = ((QualifiedTypeReference)typeReference).sourcePositions;
            sourceStart = (int)(positions[0] >>> 32);
            length = (int)(positions[nameLength - 1] & 0xFFFFFFFFFFFFFFFFL) - sourceStart + 1;
            QualifiedName qualifiedName = this.setQualifiedNameNameAndSourceRanges(name, positions, typeReference);
            SimpleType simpleType = new SimpleType(this.ast);
            simpleType.setName(qualifiedName);
            type = simpleType;
            type.setSourceRange(sourceStart, length);
            length = typeReference.sourceEnd - sourceStart + 1;
            if (dimensions != 0) {
                int end;
                type = this.ast.newArrayType(type, dimensions);
                if (this.resolveBindings) {
                    this.completeRecord((ArrayType)type, typeReference);
                }
                if ((end = this.retrieveEndOfDimensionsPosition(sourceStart + length, this.compilationUnitSourceLength)) != -1) {
                    type.setSourceRange(sourceStart, end - sourceStart + 1);
                } else {
                    type.setSourceRange(sourceStart, length);
                }
                ArrayType subarrayType = (ArrayType)type;
                int index = dimensions - 1;
                while (index > 0) {
                    subarrayType = (ArrayType)subarrayType.getComponentType();
                    end = this.retrieveProperRightBracketPosition(index, sourceStart);
                    subarrayType.setSourceRange(sourceStart, end - sourceStart + 1);
                    --index;
                }
            }
        }
        if (this.resolveBindings) {
            this.recordNodes(type, typeReference);
        }
        return type;
    }

    protected Comment createComment(int[] positions) {
        Comment comment = null;
        int start = positions[0];
        int end = positions[1];
        if (positions[1] > 0) {
            JSdoc docComment = this.docParser.parse(positions);
            if (docComment == null) {
                return null;
            }
            comment = docComment;
        } else {
            end = -end;
            if (positions[0] == 0) {
                comment = this.docParser.scanner.source[1] == '/' ? new LineComment(this.ast) : new BlockComment(this.ast);
            } else if (positions[0] > 0) {
                comment = new BlockComment(this.ast);
            } else {
                start = -start;
                comment = new LineComment(this.ast);
            }
            comment.setSourceRange(start, end - start);
        }
        return comment;
    }

    protected Statement createFakeEmptyStatement(org.eclipse.wst.jsdt.internal.compiler.ast.Statement statement) {
        if (statement == null) {
            return null;
        }
        EmptyStatement emptyStatement = new EmptyStatement(this.ast);
        emptyStatement.setFlags(emptyStatement.getFlags() | 1);
        int start = statement.sourceStart;
        int end = statement.sourceEnd;
        emptyStatement.setSourceRange(start, end - start + 1);
        return emptyStatement;
    }

    private Modifier createModifier(Modifier.ModifierKeyword keyword) {
        Modifier modifier = new Modifier(this.ast);
        modifier.setKeyword(keyword);
        int start = this.scanner.getCurrentTokenStartPosition();
        int end = this.scanner.getCurrentTokenEndPosition();
        modifier.setSourceRange(start, end - start + 1);
        return modifier;
    }

    protected InfixExpression.Operator getOperatorFor(int operatorID) {
        switch (operatorID) {
            case 18: {
                return InfixExpression.Operator.EQUALS;
            }
            case 5: {
                return InfixExpression.Operator.LESS_EQUALS;
            }
            case 7: {
                return InfixExpression.Operator.GREATER_EQUALS;
            }
            case 29: {
                return InfixExpression.Operator.NOT_EQUALS;
            }
            case 10: {
                return InfixExpression.Operator.LEFT_SHIFT;
            }
            case 17: {
                return InfixExpression.Operator.RIGHT_SHIFT_SIGNED;
            }
            case 19: {
                return InfixExpression.Operator.RIGHT_SHIFT_UNSIGNED;
            }
            case 1: {
                return InfixExpression.Operator.CONDITIONAL_OR;
            }
            case 0: {
                return InfixExpression.Operator.CONDITIONAL_AND;
            }
            case 14: {
                return InfixExpression.Operator.PLUS;
            }
            case 13: {
                return InfixExpression.Operator.MINUS;
            }
            case 16: {
                return InfixExpression.Operator.REMAINDER;
            }
            case 8: {
                return InfixExpression.Operator.XOR;
            }
            case 2: {
                return InfixExpression.Operator.AND;
            }
            case 15: {
                return InfixExpression.Operator.TIMES;
            }
            case 3: {
                return InfixExpression.Operator.OR;
            }
            case 9: {
                return InfixExpression.Operator.DIVIDE;
            }
            case 6: {
                return InfixExpression.Operator.GREATER;
            }
            case 4: {
                return InfixExpression.Operator.LESS;
            }
            case 26: {
                return InfixExpression.Operator.INSTANCEOF;
            }
            case 24: {
                return InfixExpression.Operator.EQUAL_EQUAL_EQUAL;
            }
            case 25: {
                return InfixExpression.Operator.NOT_EQUAL_EQUAL;
            }
        }
        return null;
    }

    protected PrimitiveType.Code getPrimitiveTypeCode(char[] name) {
        switch (name[0]) {
            case 'i': {
                if (name.length != 3 || name[1] != 'n' || name[2] != 't') break;
                return PrimitiveType.INT;
            }
            case 'l': {
                if (name.length != 4 || name[1] != 'o' || name[2] != 'n' || name[3] != 'g') break;
                return PrimitiveType.LONG;
            }
            case 'd': {
                if (name.length != 6 || name[1] != 'o' || name[2] != 'u' || name[3] != 'b' || name[4] != 'l' || name[5] != 'e') break;
                return PrimitiveType.DOUBLE;
            }
            case 'f': {
                if (name.length != 5 || name[1] != 'l' || name[2] != 'o' || name[3] != 'a' || name[4] != 't') break;
                return PrimitiveType.FLOAT;
            }
            case 'b': {
                if (name.length == 4 && name[1] == 'y' && name[2] == 't' && name[3] == 'e') {
                    return PrimitiveType.BYTE;
                }
                if (name.length != 7 || name[1] != 'o' || name[2] != 'o' || name[3] != 'l' || name[4] != 'e' || name[5] != 'a' || name[6] != 'n') break;
                return PrimitiveType.BOOLEAN;
            }
            case 'c': {
                if (name.length != 4 || name[1] != 'h' || name[2] != 'a' || name[3] != 'r') break;
                return PrimitiveType.CHAR;
            }
            case 's': {
                if (name.length != 5 || name[1] != 'h' || name[2] != 'o' || name[3] != 'r' || name[4] != 't') break;
                return PrimitiveType.SHORT;
            }
            case 'v': {
                if (name.length != 4 || name[1] != 'o' || name[2] != 'i' || name[3] != 'd') break;
                return PrimitiveType.VOID;
            }
        }
        return null;
    }

    protected boolean isPrimitiveType(char[] name) {
        switch (name[0]) {
            case 'i': {
                return name.length == 3 && name[1] == 'n' && name[2] == 't';
            }
            case 'l': {
                return name.length == 4 && name[1] == 'o' && name[2] == 'n' && name[3] == 'g';
            }
            case 'd': {
                return name.length == 6 && name[1] == 'o' && name[2] == 'u' && name[3] == 'b' && name[4] == 'l' && name[5] == 'e';
            }
            case 'f': {
                return name.length == 5 && name[1] == 'l' && name[2] == 'o' && name[3] == 'a' && name[4] == 't';
            }
            case 'b': {
                if (name.length == 4 && name[1] == 'y' && name[2] == 't' && name[3] == 'e') {
                    return true;
                }
                return name.length == 7 && name[1] == 'o' && name[2] == 'o' && name[3] == 'l' && name[4] == 'e' && name[5] == 'a' && name[6] == 'n';
            }
            case 'c': {
                return name.length == 4 && name[1] == 'h' && name[2] == 'a' && name[3] == 'r';
            }
            case 's': {
                return name.length == 5 && name[1] == 'h' && name[2] == 'o' && name[3] == 'r' && name[4] == 't';
            }
            case 'v': {
                return name.length == 4 && name[1] == 'o' && name[2] == 'i' && name[3] == 'd';
            }
        }
        return false;
    }

    private void lookupForScopes() {
        Iterator iterator;
        if (this.pendingNameScopeResolution != null) {
            iterator = this.pendingNameScopeResolution.iterator();
            while (iterator.hasNext()) {
                Name name = (Name)iterator.next();
                this.ast.getBindingResolver().recordScope(name, this.lookupScope(name));
            }
        }
        if (this.pendingThisExpressionScopeResolution != null) {
            iterator = this.pendingThisExpressionScopeResolution.iterator();
            while (iterator.hasNext()) {
                ThisExpression thisExpression = (ThisExpression)iterator.next();
                this.ast.getBindingResolver().recordScope(thisExpression, this.lookupScope(thisExpression));
            }
        }
    }

    private BlockScope lookupScope(ASTNode node) {
        ASTNode currentNode = node;
        while (!(currentNode == null || currentNode instanceof FunctionDeclaration || currentNode instanceof Initializer || currentNode instanceof FieldDeclaration)) {
            currentNode = currentNode.getParent();
        }
        if (currentNode == null) {
            return null;
        }
        if (currentNode instanceof Initializer) {
            Initializer initializer = (Initializer)currentNode;
            while (!(currentNode instanceof AbstractTypeDeclaration)) {
                currentNode = currentNode.getParent();
            }
            if (currentNode instanceof TypeDeclaration) {
                org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration typeDecl = (org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration)this.ast.getBindingResolver().getCorrespondingNode(currentNode);
                if ((initializer.getModifiers() & 8) != 0) {
                    return typeDecl.staticInitializerScope;
                }
                return typeDecl.initializerScope;
            }
        } else if (currentNode instanceof FieldDeclaration) {
            FieldDeclaration fieldDeclaration = (FieldDeclaration)currentNode;
            while (!(currentNode instanceof AbstractTypeDeclaration)) {
                currentNode = currentNode.getParent();
            }
            if (currentNode instanceof TypeDeclaration) {
                org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration typeDecl = (org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration)this.ast.getBindingResolver().getCorrespondingNode(currentNode);
                if ((fieldDeclaration.getModifiers() & 8) != 0) {
                    return typeDecl.staticInitializerScope;
                }
                return typeDecl.initializerScope;
            }
        }
        AbstractMethodDeclaration abstractMethodDeclaration = (AbstractMethodDeclaration)this.ast.getBindingResolver().getCorrespondingNode(currentNode);
        return abstractMethodDeclaration.scope;
    }

    protected void recordName(Name name, org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode compilerNode) {
        if (compilerNode != null) {
            this.recordNodes(name, compilerNode);
            if (compilerNode instanceof TypeReference) {
                TypeReference typeRef = (TypeReference)compilerNode;
                if (name.isQualifiedName()) {
                    SimpleName simpleName = null;
                    while (name.isQualifiedName()) {
                        simpleName = ((QualifiedName)name).getName();
                        this.recordNodes(simpleName, typeRef);
                        name = ((QualifiedName)name).getQualifier();
                        this.recordNodes(name, typeRef);
                    }
                }
            }
        }
    }

    protected void recordNodes(ASTNode node, org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode oldASTNode) {
        this.ast.getBindingResolver().store(node, oldASTNode);
    }

    protected void recordNodes(Javadoc javadoc, TagElement tagElement) {
        ListIterator fragments = tagElement.fragments().listIterator();
        while (fragments.hasNext()) {
            int start;
            SimpleName name;
            ASTNode node = (ASTNode)fragments.next();
            if (node.getNodeType() == 67) {
                org.eclipse.wst.jsdt.internal.compiler.ast.Expression expression;
                MemberRef memberRef = (MemberRef)node;
                name = memberRef.getName();
                start = name.getStartPosition();
                org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode compilerNode = javadoc.getNodeStartingAt(start);
                if (compilerNode != null) {
                    this.recordNodes(name, compilerNode);
                    this.recordNodes(node, compilerNode);
                }
                if (memberRef.getQualifier() == null) continue;
                TypeReference typeRef = null;
                if (compilerNode instanceof JavadocFieldReference) {
                    expression = ((JavadocFieldReference)compilerNode).receiver;
                    if (expression instanceof TypeReference) {
                        typeRef = (TypeReference)expression;
                    }
                } else if (compilerNode instanceof JavadocMessageSend && (expression = ((JavadocMessageSend)compilerNode).receiver) instanceof TypeReference) {
                    typeRef = (TypeReference)expression;
                }
                if (typeRef == null) continue;
                this.recordName(memberRef.getQualifier(), typeRef);
                continue;
            }
            if (node.getNodeType() == 68) {
                FunctionRef methodRef = (FunctionRef)node;
                name = methodRef.getName();
                start = methodRef.getStartPosition();
                this.scanner.resetTo(start, start + name.getStartPosition() + name.getLength());
                try {
                    int token;
                    while ((token = this.scanner.getNextToken()) != 55 && token != 3) {
                        if (token != 121 || this.scanner.currentCharacter != '#') continue;
                        start = this.scanner.getCurrentTokenEndPosition() + 1;
                        break;
                    }
                }
                catch (InvalidInputException invalidInputException) {}
                org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode compilerNode = javadoc.getNodeStartingAt(start);
                if (compilerNode != null) {
                    this.recordNodes(methodRef, compilerNode);
                    TypeReference typeRef = null;
                    if (compilerNode instanceof JavadocAllocationExpression) {
                        typeRef = ((JavadocAllocationExpression)compilerNode).type;
                        if (typeRef != null) {
                            this.recordNodes(name, compilerNode);
                        }
                    } else if (compilerNode instanceof JavadocMessageSend) {
                        org.eclipse.wst.jsdt.internal.compiler.ast.Expression expression = ((JavadocMessageSend)compilerNode).receiver;
                        if (expression instanceof TypeReference) {
                            typeRef = (TypeReference)expression;
                        }
                        this.recordNodes(name, compilerNode);
                    }
                    if (typeRef != null && methodRef.getQualifier() != null) {
                        this.recordName(methodRef.getQualifier(), typeRef);
                    }
                }
                ListIterator parameters = methodRef.parameters().listIterator();
                while (parameters.hasNext()) {
                    FunctionRefParameter param = (FunctionRefParameter)parameters.next();
                    org.eclipse.wst.jsdt.internal.compiler.ast.Expression expression = (org.eclipse.wst.jsdt.internal.compiler.ast.Expression)javadoc.getNodeStartingAt(param.getStartPosition());
                    if (expression == null) continue;
                    this.recordNodes(param, expression);
                    if (!(expression instanceof JavadocArgumentExpression)) continue;
                    JavadocArgumentExpression argExpr = (JavadocArgumentExpression)expression;
                    TypeReference typeRef = argExpr.argument.type;
                    if (this.ast.apiLevel >= 3) {
                        param.setVarargs(argExpr.argument.isVarArgs());
                    }
                    this.recordNodes(param.getType(), typeRef);
                    if (param.getType().isSimpleType()) {
                        this.recordName(((SimpleType)param.getType()).getName(), typeRef);
                        continue;
                    }
                    if (!param.getType().isArrayType()) continue;
                    Type type = ((ArrayType)param.getType()).getElementType();
                    this.recordNodes(type, typeRef);
                    if (!type.isSimpleType()) continue;
                    this.recordName(((SimpleType)type).getName(), typeRef);
                }
                continue;
            }
            if (node.getNodeType() == 42 || node.getNodeType() == 40) {
                org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode compilerNode = javadoc.getNodeStartingAt(node.getStartPosition());
                this.recordName((Name)node, compilerNode);
                continue;
            }
            if (node.getNodeType() != 65) continue;
            this.recordNodes(javadoc, (TagElement)node);
        }
    }

    protected void recordPendingNameScopeResolution(Name name) {
        if (this.pendingNameScopeResolution == null) {
            this.pendingNameScopeResolution = new HashSet();
        }
        this.pendingNameScopeResolution.add(name);
    }

    protected void recordPendingThisExpressionScopeResolution(ThisExpression thisExpression) {
        if (this.pendingThisExpressionScopeResolution == null) {
            this.pendingThisExpressionScopeResolution = new HashSet();
        }
        this.pendingThisExpressionScopeResolution.add(thisExpression);
    }

    private void trimWhiteSpacesAndComments(org.eclipse.wst.jsdt.internal.compiler.ast.Expression expression) {
        int start = expression.sourceStart;
        int end = expression.sourceEnd;
        int trimLeftPosition = expression.sourceStart;
        int trimRightPosition = expression.sourceEnd;
        boolean first = true;
        Scanner removeBlankScanner = this.ast.scanner;
        try {
            removeBlankScanner.setSource(this.compilationUnitSource);
            removeBlankScanner.resetTo(start, end);
            block7: while (true) {
                int token = removeBlankScanner.getNextToken();
                switch (token) {
                    case 1001: 
                    case 1002: 
                    case 1003: {
                        if (!first) continue block7;
                        trimLeftPosition = removeBlankScanner.currentPosition;
                        continue block7;
                    }
                    case 1000: {
                        if (!first) continue block7;
                        trimLeftPosition = removeBlankScanner.currentPosition;
                        continue block7;
                    }
                    case 55: {
                        expression.sourceStart = trimLeftPosition;
                        expression.sourceEnd = trimRightPosition;
                        return;
                    }
                }
                trimRightPosition = removeBlankScanner.currentPosition - 1;
                first = false;
            }
        }
        catch (InvalidInputException invalidInputException) {
            return;
        }
    }

    protected void removeLeadingAndTrailingCommentsFromLiteral(ASTNode node) {
        int start = node.getStartPosition();
        this.scanner.resetTo(start, start + node.getLength());
        int startPosition = -1;
        try {
            int token;
            while ((token = this.scanner.getNextToken()) != 55) {
                switch (token) {
                    case 34: 
                    case 35: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: {
                        if (startPosition == -1) {
                            startPosition = this.scanner.startPosition;
                        }
                        int end = this.scanner.currentPosition;
                        node.setSourceRange(startPosition, end - startPosition);
                        return;
                    }
                    case 2: {
                        startPosition = this.scanner.startPosition;
                    }
                }
            }
        }
        catch (InvalidInputException invalidInputException) {}
    }

    protected void removeTrailingCommentFromExpressionEndingWithAParen(ASTNode node) {
        int start = node.getStartPosition();
        this.scanner.resetTo(start, start + node.getLength());
        int parenCounter = 0;
        try {
            int token;
            while ((token = this.scanner.getNextToken()) != 55) {
                switch (token) {
                    case 3: {
                        ++parenCounter;
                        break;
                    }
                    case 33: {
                        if (--parenCounter != 0) break;
                        int end = this.scanner.currentPosition - 1;
                        node.setSourceRange(start, end - start + 1);
                    }
                }
            }
        }
        catch (InvalidInputException invalidInputException) {}
    }

    protected int retrieveClosingAngleBracketPosition(int start) {
        this.scanner.resetTo(start, this.compilationUnitSourceLength);
        this.scanner.returnOnlyGreater = true;
        try {
            int token = this.scanner.getNextToken();
            if (token != 55) {
                switch (token) {
                    case 14: {
                        return this.scanner.currentPosition - 1;
                    }
                }
                return start;
            }
        }
        catch (InvalidInputException invalidInputException) {}
        this.scanner.returnOnlyGreater = false;
        return start;
    }

    protected void retrieveColonPosition(ASTNode node) {
        int start = node.getStartPosition();
        int length = node.getLength();
        int end = start + length;
        this.scanner.resetTo(end, this.compilationUnitSourceLength);
        try {
            int token;
            while ((token = this.scanner.getNextToken()) != 55) {
                switch (token) {
                    case 52: {
                        node.setSourceRange(start, this.scanner.currentPosition - start);
                        return;
                    }
                }
            }
        }
        catch (InvalidInputException invalidInputException) {}
    }

    protected int retrieveEndBlockPosition(int start, int end) {
        this.scanner.resetTo(start, end);
        int count = 0;
        try {
            int token;
            while ((token = this.scanner.getNextToken()) != 55) {
                switch (token) {
                    case 53: {
                        ++count;
                        break;
                    }
                    case 69: {
                        if (--count != 0) break;
                        return this.scanner.currentPosition - 1;
                    }
                }
            }
        }
        catch (InvalidInputException invalidInputException) {}
        return -1;
    }

    protected int retrieveSemiColonPosition(Expression node) {
        int start = node.getStartPosition();
        int length = node.getLength();
        int end = start + length;
        this.scanner.resetTo(end, this.compilationUnitSourceLength);
        try {
            int token;
            while ((token = this.scanner.getNextToken()) != 55) {
                switch (token) {
                    case 31: {
                        return this.scanner.currentPosition - 1;
                    }
                }
            }
        }
        catch (InvalidInputException invalidInputException) {}
        return -1;
    }

    protected int retrieveEndOfDimensionsPosition(int start, int end) {
        this.scanner.resetTo(start, end);
        int foundPosition = -1;
        try {
            int token;
            while ((token = this.scanner.getNextToken()) != 55) {
                switch (token) {
                    case 10: 
                    case 1001: 
                    case 1002: 
                    case 1003: {
                        break;
                    }
                    case 54: {
                        foundPosition = this.scanner.currentPosition - 1;
                        break;
                    }
                    default: {
                        return foundPosition;
                    }
                }
            }
        }
        catch (InvalidInputException invalidInputException) {}
        return foundPosition;
    }

    protected int retrieveEndOfElementTypeNamePosition(int start, int end) {
        this.scanner.resetTo(start, end);
        try {
            int token;
            while ((token = this.scanner.getNextToken()) != 55) {
                switch (token) {
                    case 32: 
                    case 88: 
                    case 89: 
                    case 90: 
                    case 94: 
                    case 99: 
                    case 104: 
                    case 106: 
                    case 112: {
                        return this.scanner.currentPosition - 1;
                    }
                }
            }
        }
        catch (InvalidInputException invalidInputException) {}
        return -1;
    }

    protected int retrieveEndOfRightParenthesisPosition(int start, int end) {
        this.scanner.resetTo(start, end);
        try {
            int token;
            while ((token = this.scanner.getNextToken()) != 55) {
                switch (token) {
                    case 33: {
                        return this.scanner.currentPosition;
                    }
                }
            }
        }
        catch (InvalidInputException invalidInputException) {}
        return -1;
    }

    protected int retrieveExtraDimension(int start, int end) {
        this.scanner.resetTo(start, end);
        int dimensions = 0;
        try {
            int token;
            while ((token = this.scanner.getNextToken()) != 55) {
                switch (token) {
                    case 10: 
                    case 1001: 
                    case 1002: 
                    case 1003: {
                        break;
                    }
                    case 54: {
                        ++dimensions;
                        break;
                    }
                    default: {
                        return dimensions;
                    }
                }
            }
        }
        catch (InvalidInputException invalidInputException) {}
        return dimensions;
    }

    protected void retrieveIdentifierAndSetPositions(int start, int end, Name name) {
        this.scanner.resetTo(start, end);
        try {
            int token;
            while ((token = this.scanner.getNextToken()) != 55) {
                if (token != 32) continue;
                int startName = this.scanner.startPosition;
                int endName = this.scanner.currentPosition - 1;
                name.setSourceRange(startName, endName - startName + 1);
                return;
            }
        }
        catch (InvalidInputException invalidInputException) {}
    }

    protected int retrieveIdentifierEndPosition(int start, int end) {
        this.scanner.resetTo(start, end);
        try {
            int token;
            while ((token = this.scanner.getNextToken()) != 55) {
                switch (token) {
                    case 32: {
                        return this.scanner.getCurrentTokenEndPosition();
                    }
                }
            }
        }
        catch (InvalidInputException invalidInputException) {}
        return -1;
    }

    protected int retrievePositionBeforeNextCommaOrSemiColon(int start, int end) {
        this.scanner.resetTo(start, end);
        try {
            int token;
            int balance = 0;
            while ((token = this.scanner.getNextToken()) != 55) {
                switch (token) {
                    case 53: {
                        ++balance;
                        break;
                    }
                    case 69: {
                        --balance;
                        break;
                    }
                    case 27: {
                        if (balance != 0) break;
                        return this.scanner.startPosition - 1;
                    }
                    case 31: {
                        return this.scanner.startPosition - 1;
                    }
                }
            }
        }
        catch (InvalidInputException invalidInputException) {}
        return -1;
    }

    protected int retrieveProperRightBracketPosition(int bracketNumber, int start) {
        this.scanner.resetTo(start, this.compilationUnitSourceLength);
        try {
            int token;
            int count = 0;
            while ((token = this.scanner.getNextToken()) != 55) {
                switch (token) {
                    case 54: {
                        if (++count != bracketNumber) break;
                        return this.scanner.currentPosition - 1;
                    }
                }
            }
        }
        catch (InvalidInputException invalidInputException) {}
        return -1;
    }

    protected int retrieveRightBraceOrSemiColonPosition(int start, int end) {
        this.scanner.resetTo(start, end);
        try {
            int token;
            while ((token = this.scanner.getNextToken()) != 55) {
                switch (token) {
                    case 69: {
                        return this.scanner.currentPosition - 1;
                    }
                    case 31: {
                        return this.scanner.currentPosition - 1;
                    }
                }
            }
        }
        catch (InvalidInputException invalidInputException) {}
        return -1;
    }

    protected int retrieveRightBrace(int start, int end) {
        this.scanner.resetTo(start, end);
        try {
            int token;
            while ((token = this.scanner.getNextToken()) != 55) {
                switch (token) {
                    case 69: {
                        return this.scanner.currentPosition - 1;
                    }
                }
            }
        }
        catch (InvalidInputException invalidInputException) {}
        return -1;
    }

    protected int retrieveRightBracketPosition(int start, int end) {
        this.scanner.resetTo(start, end);
        try {
            int token;
            while ((token = this.scanner.getNextToken()) != 55) {
                switch (token) {
                    case 54: {
                        return this.scanner.currentPosition - 1;
                    }
                }
            }
        }
        catch (InvalidInputException invalidInputException) {}
        return -1;
    }

    protected int retrieveStartBlockPosition(int start, int end) {
        this.scanner.resetTo(start, end);
        try {
            int token;
            while ((token = this.scanner.getNextToken()) != 55) {
                switch (token) {
                    case 53: {
                        return this.scanner.startPosition;
                    }
                }
            }
        }
        catch (InvalidInputException invalidInputException) {}
        return -1;
    }

    protected int retrieveStartingCatchPosition(int start, int end) {
        this.scanner.resetTo(start, end);
        try {
            int token;
            while ((token = this.scanner.getNextToken()) != 55) {
                switch (token) {
                    case 85: {
                        return this.scanner.startPosition;
                    }
                }
            }
        }
        catch (InvalidInputException invalidInputException) {}
        return -1;
    }

    public void setAST(AST ast) {
        this.ast = ast;
        this.docParser = new DocCommentParser(this.ast, this.scanner, this.insideComments);
    }

    protected void setModifiers(BodyDeclaration bodyDeclaration) {
        try {
            int token;
            while ((token = this.scanner.getNextToken()) != 55) {
                Modifier modifier = null;
                switch (token) {
                    case 87: {
                        modifier = this.createModifier(Modifier.ModifierKeyword.ABSTRACT_KEYWORD);
                        break;
                    }
                    case 111: {
                        modifier = this.createModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD);
                        break;
                    }
                    case 113: {
                        modifier = this.createModifier(Modifier.ModifierKeyword.STATIC_KEYWORD);
                        break;
                    }
                    case 110: {
                        modifier = this.createModifier(Modifier.ModifierKeyword.PROTECTED_KEYWORD);
                        break;
                    }
                    case 109: {
                        modifier = this.createModifier(Modifier.ModifierKeyword.PRIVATE_KEYWORD);
                        break;
                    }
                    case 98: {
                        modifier = this.createModifier(Modifier.ModifierKeyword.FINAL_KEYWORD);
                        break;
                    }
                    case 107: {
                        modifier = this.createModifier(Modifier.ModifierKeyword.NATIVE_KEYWORD);
                        break;
                    }
                    case 116: {
                        modifier = this.createModifier(Modifier.ModifierKeyword.SYNCHRONIZED_KEYWORD);
                        break;
                    }
                    case 118: {
                        modifier = this.createModifier(Modifier.ModifierKeyword.TRANSIENT_KEYWORD);
                        break;
                    }
                    case 119: {
                        modifier = this.createModifier(Modifier.ModifierKeyword.VOLATILE_KEYWORD);
                        break;
                    }
                    case 114: {
                        modifier = this.createModifier(Modifier.ModifierKeyword.STRICTFP_KEYWORD);
                        break;
                    }
                    case 1001: 
                    case 1002: 
                    case 1003: {
                        break;
                    }
                    default: {
                        return;
                    }
                }
                if (modifier == null) continue;
                bodyDeclaration.modifiers().add(modifier);
            }
        }
        catch (InvalidInputException invalidInputException) {}
    }

    protected void setModifiers(FieldDeclaration fieldDeclaration, org.eclipse.wst.jsdt.internal.compiler.ast.FieldDeclaration fieldDecl) {
        switch (this.ast.apiLevel) {
            case 2: {
                fieldDeclaration.internalSetModifiers(fieldDecl.modifiers & 0xFFFF);
                break;
            }
            case 3: {
                this.scanner.resetTo(fieldDecl.declarationSourceStart, fieldDecl.sourceStart);
                this.setModifiers(fieldDeclaration);
            }
        }
    }

    protected void setModifiers(Initializer initializer, org.eclipse.wst.jsdt.internal.compiler.ast.Initializer oldInitializer) {
        switch (this.ast.apiLevel) {
            case 2: {
                initializer.internalSetModifiers(oldInitializer.modifiers & 0xFFFF);
                break;
            }
            case 3: {
                this.scanner.resetTo(oldInitializer.declarationSourceStart, oldInitializer.bodyStart);
                this.setModifiers(initializer);
            }
        }
    }

    protected void setModifiers(FunctionDeclaration methodDecl, AbstractMethodDeclaration methodDeclaration) {
        switch (this.ast.apiLevel) {
            case 2: {
                methodDecl.internalSetModifiers(methodDeclaration.modifiers & 0xFFFF);
                break;
            }
            case 3: {
                if (methodDeclaration.sourceStart <= methodDeclaration.declarationSourceStart) break;
                this.scanner.resetTo(methodDeclaration.declarationSourceStart, methodDeclaration.sourceStart);
                this.setModifiers(methodDecl);
            }
        }
    }

    protected void setModifiers(SingleVariableDeclaration variableDecl, Argument argument) {
        switch (this.ast.apiLevel) {
            case 2: {
                variableDecl.internalSetModifiers(argument.modifiers & 0xFFFF);
                break;
            }
            case 3: {
                this.scanner.resetTo(argument.declarationSourceStart, argument.sourceStart);
                try {
                    int token;
                    while ((token = this.scanner.getNextToken()) != 55) {
                        Modifier modifier = null;
                        switch (token) {
                            case 87: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.ABSTRACT_KEYWORD);
                                break;
                            }
                            case 111: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD);
                                break;
                            }
                            case 113: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.STATIC_KEYWORD);
                                break;
                            }
                            case 110: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.PROTECTED_KEYWORD);
                                break;
                            }
                            case 109: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.PRIVATE_KEYWORD);
                                break;
                            }
                            case 98: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.FINAL_KEYWORD);
                                break;
                            }
                            case 107: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.NATIVE_KEYWORD);
                                break;
                            }
                            case 116: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.SYNCHRONIZED_KEYWORD);
                                break;
                            }
                            case 118: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.TRANSIENT_KEYWORD);
                                break;
                            }
                            case 119: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.VOLATILE_KEYWORD);
                                break;
                            }
                            case 114: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.STRICTFP_KEYWORD);
                                break;
                            }
                            case 1001: 
                            case 1002: 
                            case 1003: {
                                break;
                            }
                            default: {
                                return;
                            }
                        }
                        if (modifier == null) continue;
                        variableDecl.modifiers().add(modifier);
                    }
                    break;
                }
                catch (InvalidInputException invalidInputException) {}
            }
        }
    }

    protected void setModifiers(SingleVariableDeclaration variableDecl, LocalDeclaration localDeclaration) {
        switch (this.ast.apiLevel) {
            case 2: {
                variableDecl.internalSetModifiers(localDeclaration.modifiers & 0xFFFF);
                break;
            }
            case 3: {
                this.scanner.resetTo(localDeclaration.declarationSourceStart, localDeclaration.sourceStart);
                try {
                    int token;
                    while ((token = this.scanner.getNextToken()) != 55) {
                        Modifier modifier = null;
                        switch (token) {
                            case 87: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.ABSTRACT_KEYWORD);
                                break;
                            }
                            case 111: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD);
                                break;
                            }
                            case 113: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.STATIC_KEYWORD);
                                break;
                            }
                            case 110: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.PROTECTED_KEYWORD);
                                break;
                            }
                            case 109: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.PRIVATE_KEYWORD);
                                break;
                            }
                            case 98: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.FINAL_KEYWORD);
                                break;
                            }
                            case 107: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.NATIVE_KEYWORD);
                                break;
                            }
                            case 116: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.SYNCHRONIZED_KEYWORD);
                                break;
                            }
                            case 118: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.TRANSIENT_KEYWORD);
                                break;
                            }
                            case 119: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.VOLATILE_KEYWORD);
                                break;
                            }
                            case 114: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.STRICTFP_KEYWORD);
                                break;
                            }
                            case 1001: 
                            case 1002: 
                            case 1003: {
                                break;
                            }
                            default: {
                                return;
                            }
                        }
                        if (modifier == null) continue;
                        variableDecl.modifiers().add(modifier);
                    }
                    break;
                }
                catch (InvalidInputException invalidInputException) {}
            }
        }
    }

    protected void setModifiers(TypeDeclaration typeDecl, org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration typeDeclaration) {
        switch (this.ast.apiLevel) {
            case 2: {
                int modifiers = typeDeclaration.modifiers;
                typeDecl.internalSetModifiers(modifiers &= 0xFFFF);
                break;
            }
            case 3: {
                this.scanner.resetTo(typeDeclaration.declarationSourceStart, typeDeclaration.sourceStart);
                this.setModifiers(typeDecl);
            }
        }
    }

    protected void setModifiers(VariableDeclarationExpression variableDeclarationExpression, LocalDeclaration localDeclaration) {
        switch (this.ast.apiLevel) {
            case 2: {
                int modifiers = localDeclaration.modifiers & 0xFFFF;
                variableDeclarationExpression.internalSetModifiers(modifiers &= 0xFBFFFFFF);
                break;
            }
            case 3: {
                this.scanner.resetTo(localDeclaration.declarationSourceStart, localDeclaration.sourceStart);
                try {
                    int token;
                    while ((token = this.scanner.getNextToken()) != 55) {
                        Modifier modifier = null;
                        switch (token) {
                            case 87: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.ABSTRACT_KEYWORD);
                                break;
                            }
                            case 111: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD);
                                break;
                            }
                            case 113: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.STATIC_KEYWORD);
                                break;
                            }
                            case 110: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.PROTECTED_KEYWORD);
                                break;
                            }
                            case 109: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.PRIVATE_KEYWORD);
                                break;
                            }
                            case 98: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.FINAL_KEYWORD);
                                break;
                            }
                            case 107: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.NATIVE_KEYWORD);
                                break;
                            }
                            case 116: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.SYNCHRONIZED_KEYWORD);
                                break;
                            }
                            case 118: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.TRANSIENT_KEYWORD);
                                break;
                            }
                            case 119: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.VOLATILE_KEYWORD);
                                break;
                            }
                            case 114: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.STRICTFP_KEYWORD);
                                break;
                            }
                            case 1001: 
                            case 1002: 
                            case 1003: {
                                break;
                            }
                            default: {
                                return;
                            }
                        }
                        if (modifier == null) continue;
                        variableDeclarationExpression.modifiers().add(modifier);
                    }
                    break;
                }
                catch (InvalidInputException invalidInputException) {}
            }
        }
    }

    protected void setModifiers(VariableDeclarationStatement variableDeclarationStatement, LocalDeclaration localDeclaration) {
        switch (this.ast.apiLevel) {
            case 2: {
                int modifiers = localDeclaration.modifiers & 0xFFFF;
                variableDeclarationStatement.internalSetModifiers(modifiers &= 0xFBFFFFFF);
                break;
            }
            case 3: {
                this.scanner.resetTo(localDeclaration.declarationSourceStart, localDeclaration.sourceStart);
                try {
                    int token;
                    while ((token = this.scanner.getNextToken()) != 55) {
                        Modifier modifier = null;
                        switch (token) {
                            case 87: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.ABSTRACT_KEYWORD);
                                break;
                            }
                            case 111: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD);
                                break;
                            }
                            case 113: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.STATIC_KEYWORD);
                                break;
                            }
                            case 110: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.PROTECTED_KEYWORD);
                                break;
                            }
                            case 109: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.PRIVATE_KEYWORD);
                                break;
                            }
                            case 98: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.FINAL_KEYWORD);
                                break;
                            }
                            case 107: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.NATIVE_KEYWORD);
                                break;
                            }
                            case 116: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.SYNCHRONIZED_KEYWORD);
                                break;
                            }
                            case 118: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.TRANSIENT_KEYWORD);
                                break;
                            }
                            case 119: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.VOLATILE_KEYWORD);
                                break;
                            }
                            case 114: {
                                modifier = this.createModifier(Modifier.ModifierKeyword.STRICTFP_KEYWORD);
                                break;
                            }
                            case 1001: 
                            case 1002: 
                            case 1003: {
                                break;
                            }
                            default: {
                                return;
                            }
                        }
                        if (modifier == null) continue;
                        variableDeclarationStatement.modifiers().add(modifier);
                    }
                    break;
                }
                catch (InvalidInputException invalidInputException) {}
            }
        }
    }

    protected QualifiedName setQualifiedNameNameAndSourceRanges(char[][] typeName, long[] positions, org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode node) {
        int start0;
        int length = typeName.length;
        SimpleName firstToken = new SimpleName(this.ast);
        firstToken.internalSetIdentifier(new String(typeName[0]));
        firstToken.index = 1;
        int start = start0 = (int)(positions[0] >>> 32);
        int end = (int)(positions[0] & 0xFFFFFFFFFFFFFFFFL);
        firstToken.setSourceRange(start, end - start + 1);
        SimpleName secondToken = new SimpleName(this.ast);
        secondToken.internalSetIdentifier(new String(typeName[1]));
        secondToken.index = 2;
        start = (int)(positions[1] >>> 32);
        end = (int)(positions[1] & 0xFFFFFFFFFFFFFFFFL);
        secondToken.setSourceRange(start, end - start + 1);
        QualifiedName qualifiedName = new QualifiedName(this.ast);
        qualifiedName.setQualifier(firstToken);
        qualifiedName.setName(secondToken);
        if (this.resolveBindings) {
            this.recordNodes(qualifiedName, node);
            this.recordPendingNameScopeResolution(qualifiedName);
            this.recordNodes(firstToken, node);
            this.recordNodes(secondToken, node);
            this.recordPendingNameScopeResolution(firstToken);
            this.recordPendingNameScopeResolution(secondToken);
        }
        qualifiedName.index = 2;
        qualifiedName.setSourceRange(start0, end - start0 + 1);
        SimpleName newPart = null;
        int i = 2;
        while (i < length) {
            newPart = new SimpleName(this.ast);
            newPart.internalSetIdentifier(new String(typeName[i]));
            newPart.index = i + 1;
            start = (int)(positions[i] >>> 32);
            end = (int)(positions[i] & 0xFFFFFFFFFFFFFFFFL);
            newPart.setSourceRange(start, end - start + 1);
            QualifiedName qualifiedName2 = new QualifiedName(this.ast);
            qualifiedName2.setQualifier(qualifiedName);
            qualifiedName2.setName(newPart);
            qualifiedName = qualifiedName2;
            qualifiedName.index = newPart.index;
            qualifiedName.setSourceRange(start0, end - start0 + 1);
            if (this.resolveBindings) {
                this.recordNodes(qualifiedName, node);
                this.recordNodes(newPart, node);
                this.recordPendingNameScopeResolution(qualifiedName);
                this.recordPendingNameScopeResolution(newPart);
            }
            ++i;
        }
        QualifiedName name = qualifiedName;
        if (this.resolveBindings) {
            this.recordNodes(name, node);
            this.recordPendingNameScopeResolution(name);
        }
        return name;
    }

    protected QualifiedName setQualifiedNameNameAndSourceRanges(char[][] typeName, long[] positions, int endingIndex, org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode node) {
        int start0;
        int length = endingIndex + 1;
        SimpleName firstToken = new SimpleName(this.ast);
        firstToken.internalSetIdentifier(new String(typeName[0]));
        firstToken.index = 1;
        int start = start0 = (int)(positions[0] >>> 32);
        int end = (int)positions[0];
        firstToken.setSourceRange(start, end - start + 1);
        SimpleName secondToken = new SimpleName(this.ast);
        secondToken.internalSetIdentifier(new String(typeName[1]));
        secondToken.index = 2;
        start = (int)(positions[1] >>> 32);
        end = (int)positions[1];
        secondToken.setSourceRange(start, end - start + 1);
        QualifiedName qualifiedName = new QualifiedName(this.ast);
        qualifiedName.setQualifier(firstToken);
        qualifiedName.setName(secondToken);
        if (this.resolveBindings) {
            this.recordNodes(qualifiedName, node);
            this.recordPendingNameScopeResolution(qualifiedName);
            this.recordNodes(firstToken, node);
            this.recordNodes(secondToken, node);
            this.recordPendingNameScopeResolution(firstToken);
            this.recordPendingNameScopeResolution(secondToken);
        }
        qualifiedName.index = 2;
        qualifiedName.setSourceRange(start0, end - start0 + 1);
        SimpleName newPart = null;
        int i = 2;
        while (i < length) {
            newPart = new SimpleName(this.ast);
            newPart.internalSetIdentifier(new String(typeName[i]));
            newPart.index = i + 1;
            start = (int)(positions[i] >>> 32);
            end = (int)positions[i];
            newPart.setSourceRange(start, end - start + 1);
            QualifiedName qualifiedName2 = new QualifiedName(this.ast);
            qualifiedName2.setQualifier(qualifiedName);
            qualifiedName2.setName(newPart);
            qualifiedName = qualifiedName2;
            qualifiedName.index = newPart.index;
            qualifiedName.setSourceRange(start0, end - start0 + 1);
            if (this.resolveBindings) {
                this.recordNodes(qualifiedName, node);
                this.recordNodes(newPart, node);
                this.recordPendingNameScopeResolution(qualifiedName);
                this.recordPendingNameScopeResolution(newPart);
            }
            ++i;
        }
        if (newPart == null && this.resolveBindings) {
            this.recordNodes(qualifiedName, node);
            this.recordPendingNameScopeResolution(qualifiedName);
        }
        return qualifiedName;
    }

    protected void setTypeForField(FieldDeclaration fieldDeclaration, Type type, int extraDimension) {
        if (extraDimension != 0) {
            if (type.isArrayType()) {
                ArrayType arrayType = (ArrayType)type;
                int remainingDimensions = arrayType.getDimensions() - extraDimension;
                if (remainingDimensions == 0) {
                    Type elementType = arrayType.getElementType();
                    elementType.setParent(null, null);
                    this.ast.getBindingResolver().updateKey(type, elementType);
                    fieldDeclaration.setType(elementType);
                } else {
                    int start = type.getStartPosition();
                    ArrayType subarrayType = arrayType;
                    int index = extraDimension;
                    while (index > 0) {
                        subarrayType = (ArrayType)subarrayType.getComponentType();
                        --index;
                    }
                    int end = this.retrieveProperRightBracketPosition(remainingDimensions, start);
                    subarrayType.setSourceRange(start, end - start + 1);
                    subarrayType.setParent(null, null);
                    fieldDeclaration.setType(subarrayType);
                    this.updateInnerPositions(subarrayType, remainingDimensions);
                    this.ast.getBindingResolver().updateKey(type, subarrayType);
                }
            } else {
                fieldDeclaration.setType(type);
            }
        } else {
            if (type.isArrayType()) {
                int dimensions = ((ArrayType)type).getDimensions();
                this.updateInnerPositions(type, dimensions);
            }
            fieldDeclaration.setType(type);
        }
    }

    protected void setTypeForMethodDeclaration(FunctionDeclaration methodDeclaration, Type type, int extraDimension) {
        if (extraDimension != 0) {
            if (type.isArrayType()) {
                ArrayType arrayType = (ArrayType)type;
                int remainingDimensions = arrayType.getDimensions() - extraDimension;
                if (remainingDimensions == 0) {
                    Type elementType = arrayType.getElementType();
                    elementType.setParent(null, null);
                    this.ast.getBindingResolver().updateKey(type, elementType);
                    switch (this.ast.apiLevel) {
                        case 2: {
                            methodDeclaration.internalSetReturnType(elementType);
                            break;
                        }
                        case 3: {
                            methodDeclaration.setReturnType2(elementType);
                        }
                    }
                } else {
                    int start = type.getStartPosition();
                    ArrayType subarrayType = arrayType;
                    int index = extraDimension;
                    while (index > 0) {
                        subarrayType = (ArrayType)subarrayType.getComponentType();
                        --index;
                    }
                    int end = this.retrieveProperRightBracketPosition(remainingDimensions, start);
                    subarrayType.setSourceRange(start, end - start + 1);
                    subarrayType.setParent(null, null);
                    this.updateInnerPositions(subarrayType, remainingDimensions);
                    switch (this.ast.apiLevel) {
                        case 2: {
                            methodDeclaration.internalSetReturnType(subarrayType);
                            break;
                        }
                        case 3: {
                            methodDeclaration.setReturnType2(subarrayType);
                        }
                    }
                    this.ast.getBindingResolver().updateKey(type, subarrayType);
                }
            } else {
                switch (this.ast.apiLevel) {
                    case 2: {
                        methodDeclaration.internalSetReturnType(type);
                        break;
                    }
                    case 3: {
                        methodDeclaration.setReturnType2(type);
                    }
                }
            }
        } else {
            switch (this.ast.apiLevel) {
                case 2: {
                    methodDeclaration.internalSetReturnType(type);
                    break;
                }
                case 3: {
                    methodDeclaration.setReturnType2(type);
                }
            }
        }
    }

    protected void setTypeForSingleVariableDeclaration(SingleVariableDeclaration singleVariableDeclaration, Type type, int extraDimension) {
        if (extraDimension != 0) {
            if (type.isArrayType()) {
                ArrayType arrayType = (ArrayType)type;
                int remainingDimensions = arrayType.getDimensions() - extraDimension;
                if (remainingDimensions == 0) {
                    Type elementType = arrayType.getElementType();
                    elementType.setParent(null, null);
                    this.ast.getBindingResolver().updateKey(type, elementType);
                    singleVariableDeclaration.setType(elementType);
                } else {
                    int start = type.getStartPosition();
                    ArrayType subarrayType = arrayType;
                    int index = extraDimension;
                    while (index > 0) {
                        subarrayType = (ArrayType)subarrayType.getComponentType();
                        --index;
                    }
                    int end = this.retrieveProperRightBracketPosition(remainingDimensions, start);
                    subarrayType.setSourceRange(start, end - start + 1);
                    subarrayType.setParent(null, null);
                    this.updateInnerPositions(subarrayType, remainingDimensions);
                    singleVariableDeclaration.setType(subarrayType);
                    this.ast.getBindingResolver().updateKey(type, subarrayType);
                }
            } else {
                singleVariableDeclaration.setType(type);
            }
        } else {
            singleVariableDeclaration.setType(type);
        }
    }

    protected void setTypeForVariableDeclarationExpression(VariableDeclarationExpression variableDeclarationExpression, Type type, int extraDimension) {
        if (extraDimension != 0) {
            if (type.isArrayType()) {
                ArrayType arrayType = (ArrayType)type;
                int remainingDimensions = arrayType.getDimensions() - extraDimension;
                if (remainingDimensions == 0) {
                    Type elementType = arrayType.getElementType();
                    elementType.setParent(null, null);
                    this.ast.getBindingResolver().updateKey(type, elementType);
                    variableDeclarationExpression.setType(elementType);
                } else {
                    int start = type.getStartPosition();
                    ArrayType subarrayType = arrayType;
                    int index = extraDimension;
                    while (index > 0) {
                        subarrayType = (ArrayType)subarrayType.getComponentType();
                        --index;
                    }
                    int end = this.retrieveProperRightBracketPosition(remainingDimensions, start);
                    subarrayType.setSourceRange(start, end - start + 1);
                    subarrayType.setParent(null, null);
                    this.updateInnerPositions(subarrayType, remainingDimensions);
                    variableDeclarationExpression.setType(subarrayType);
                    this.ast.getBindingResolver().updateKey(type, subarrayType);
                }
            } else {
                variableDeclarationExpression.setType(type);
            }
        } else {
            variableDeclarationExpression.setType(type);
        }
    }

    protected void setTypeForVariableDeclarationStatement(VariableDeclarationStatement variableDeclarationStatement, Type type, int extraDimension) {
        if (extraDimension != 0) {
            if (type.isArrayType()) {
                ArrayType arrayType = (ArrayType)type;
                int remainingDimensions = arrayType.getDimensions() - extraDimension;
                if (remainingDimensions == 0) {
                    Type elementType = arrayType.getElementType();
                    elementType.setParent(null, null);
                    this.ast.getBindingResolver().updateKey(type, elementType);
                    variableDeclarationStatement.setType(elementType);
                } else {
                    int start = type.getStartPosition();
                    ArrayType subarrayType = arrayType;
                    int index = extraDimension;
                    while (index > 0) {
                        subarrayType = (ArrayType)subarrayType.getComponentType();
                        --index;
                    }
                    int end = this.retrieveProperRightBracketPosition(remainingDimensions, start);
                    subarrayType.setSourceRange(start, end - start + 1);
                    subarrayType.setParent(null, null);
                    this.updateInnerPositions(subarrayType, remainingDimensions);
                    variableDeclarationStatement.setType(subarrayType);
                    this.ast.getBindingResolver().updateKey(type, subarrayType);
                }
            } else {
                variableDeclarationStatement.setType(type);
            }
        } else {
            variableDeclarationStatement.setType(type);
        }
    }

    protected void updateInnerPositions(Type type, int dimensions) {
        if (dimensions > 1) {
            int start = type.getStartPosition();
            Type currentComponentType = ((ArrayType)type).getComponentType();
            int searchedDimension = dimensions - 1;
            int rightBracketEndPosition = start;
            while (currentComponentType.isArrayType()) {
                rightBracketEndPosition = this.retrieveProperRightBracketPosition(searchedDimension, start);
                currentComponentType.setSourceRange(start, rightBracketEndPosition - start + 1);
                currentComponentType = ((ArrayType)currentComponentType).getComponentType();
                --searchedDimension;
            }
        }
    }
}

