/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.correction;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.wst.jsdt.core.IAccessRule;
import org.eclipse.wst.jsdt.core.IIncludePathAttribute;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptConventions;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.ImportDeclaration;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.core.search.TypeNameMatch;
import org.eclipse.wst.jsdt.core.search.TypeNameMatchRequestor;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.fix.UnusedCodeFix;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.AddToClasspathChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.RenameCompilationUnitChange;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.corext.util.TypeNameMatchCollector;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.wst.jsdt.internal.ui.fix.UnusedCodeCleanUp;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.preferences.BuildPathsPropertyPage;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ChangeCorrectionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.correction.CorrectMainTypeNameProposal;
import org.eclipse.wst.jsdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.wst.jsdt.internal.ui.text.correction.FixCorrectionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.correction.UnresolvedElementsSubProcessor;
import org.eclipse.wst.jsdt.internal.ui.util.CoreUtility;
import org.eclipse.wst.jsdt.launching.IVMInstall;
import org.eclipse.wst.jsdt.launching.IVMInstall2;
import org.eclipse.wst.jsdt.launching.IVMInstallType;
import org.eclipse.wst.jsdt.launching.JavaRuntime;
import org.eclipse.wst.jsdt.ui.JavaScriptElementLabels;
import org.eclipse.wst.jsdt.ui.actions.OrganizeImportsAction;
import org.eclipse.wst.jsdt.ui.text.java.IInvocationContext;
import org.eclipse.wst.jsdt.ui.text.java.IProblemLocation;

public class ReorgCorrectionsSubProcessor {
    public static void getWrongTypeNameProposals(IInvocationContext context, IProblemLocation problem, Collection proposals) throws CoreException {
        IJavaScriptUnit cu = context.getCompilationUnit();
        boolean isLinked = cu.getResource().isLinked();
        IJavaScriptProject javaProject = cu.getJavaScriptProject();
        String sourceLevel = javaProject.getOption("org.eclipse.wst.jsdt.core.compiler.source", true);
        String compliance = javaProject.getOption("org.eclipse.wst.jsdt.core.compiler.compliance", true);
        JavaScriptUnit root = context.getASTRoot();
        ASTNode coveredNode = problem.getCoveredNode(root);
        if (!(coveredNode instanceof SimpleName)) {
            return;
        }
        ASTNode parentType = coveredNode.getParent();
        if (!(parentType instanceof AbstractTypeDeclaration)) {
            return;
        }
        String currTypeName = ((SimpleName)coveredNode).getIdentifier();
        String newTypeName = JavaScriptCore.removeJavaScriptLikeExtension((String)cu.getElementName());
        boolean hasOtherPublicTypeBefore = false;
        boolean found = false;
        List types = root.types();
        int i = 0;
        while (i < types.size()) {
            AbstractTypeDeclaration curr = (AbstractTypeDeclaration)types.get(i);
            if (parentType != curr) {
                if (newTypeName.equals(curr.getName().getIdentifier())) {
                    return;
                }
                if (!found && Modifier.isPublic((int)curr.getModifiers())) {
                    hasOtherPublicTypeBefore = true;
                }
            } else {
                found = true;
            }
            ++i;
        }
        if (!JavaScriptConventions.validateJavaScriptTypeName((String)newTypeName, (String)sourceLevel, (String)compliance).matches(4)) {
            proposals.add(new CorrectMainTypeNameProposal(cu, context, currTypeName, newTypeName, 5));
        }
        if (!hasOtherPublicTypeBefore) {
            String newCUName = JavaModelUtil.getRenamedCUName(cu, currTypeName);
            IJavaScriptUnit newCU = ((IPackageFragment)cu.getParent()).getJavaScriptUnit(newCUName);
            if (!(newCU.exists() || isLinked || JavaScriptConventions.validateCompilationUnitName((String)newCUName, (String)sourceLevel, (String)compliance).matches(4))) {
                RenameCompilationUnitChange change = new RenameCompilationUnitChange(cu, newCUName);
                String label = Messages.format(CorrectionMessages.ReorgCorrectionsSubProcessor_renamecu_description, newCUName);
                proposals.add(new ChangeCorrectionProposal(label, change, 6, JavaPluginImages.get("org.eclipse.wst.jsdt.ui.correction_rename.gif")));
            }
        }
    }

    public static void removeImportStatementProposals(IInvocationContext context, IProblemLocation problem, Collection proposals) throws CoreException {
        ChangeCorrectionProposal proposal;
        UnusedCodeFix fix = UnusedCodeFix.createRemoveUnusedImportFix(context.getASTRoot(), problem);
        if (fix != null) {
            Image image = JavaPluginImages.get("org.eclipse.wst.jsdt.ui.correction_delete_import.gif");
            Hashtable<String, String> options = new Hashtable<String, String>();
            options.put("cleanup.remove_unused_imports", "true");
            proposal = new FixCorrectionProposal(fix, new UnusedCodeCleanUp(options), 6, image, context);
            proposals.add(proposal);
        }
        final IJavaScriptUnit cu = context.getCompilationUnit();
        String name = CorrectionMessages.ReorgCorrectionsSubProcessor_organizeimports_description;
        proposal = new ChangeCorrectionProposal(name, null, 5, JavaPluginImages.get("org.eclipse.wst.jsdt.ui.correction_change.gif")){

            public void apply(IDocument document) {
                FileEditorInput input = new FileEditorInput((IFile)cu.getResource());
                IWorkbenchPage p = JavaScriptPlugin.getActivePage();
                if (p == null) {
                    return;
                }
                IEditorPart part = p.findEditor((IEditorInput)input);
                if (part instanceof JavaEditor) {
                    OrganizeImportsAction action = new OrganizeImportsAction((JavaEditor)part);
                    action.run(cu);
                }
            }
        };
        proposals.add(proposal);
    }

    public static void importNotFoundProposals(IInvocationContext context, IProblemLocation problem, Collection proposals) throws CoreException {
        IJavaScriptUnit cu = context.getCompilationUnit();
        IJavaScriptProject project = cu.getJavaScriptProject();
        ASTNode selectedNode = problem.getCoveringNode(context.getASTRoot());
        if (selectedNode != null) {
            char[] packageName;
            ImportDeclaration importDeclaration = (ImportDeclaration)ASTNodes.getParent(selectedNode, 26);
            if (importDeclaration == null) {
                return;
            }
            if (!importDeclaration.isOnDemand()) {
                int kind = JavaModelUtil.is50OrHigher(cu.getJavaScriptProject()) ? 30 : 6;
                UnresolvedElementsSubProcessor.addNewTypeProposals(cu, importDeclaration.getName(), kind, 5, proposals);
            }
            String name = ASTNodes.asString((ASTNode)importDeclaration.getName());
            char[] typeName = null;
            if (importDeclaration.isOnDemand()) {
                packageName = name.toCharArray();
            } else {
                packageName = Signature.getQualifier((String)name).toCharArray();
                typeName = Signature.getSimpleName((String)name).toCharArray();
            }
            IJavaScriptSearchScope scope = SearchEngine.createWorkspaceScope();
            ArrayList res = new ArrayList();
            TypeNameMatchCollector requestor = new TypeNameMatchCollector(res);
            int matchMode = 8;
            new SearchEngine().searchAllTypeNames(packageName, matchMode, typeName, matchMode, 0, scope, (TypeNameMatchRequestor)requestor, 3, null);
            if (res.isEmpty()) {
                return;
            }
            HashSet<Object> addedClaspaths = new HashSet<Object>();
            int i = 0;
            while (i < res.size()) {
                IPackageFragmentRoot root;
                IIncludePathEntry entry;
                TypeNameMatch curr = (TypeNameMatch)res.get(i);
                IType type = curr.getType();
                if (type != null && (entry = (root = (IPackageFragmentRoot)type.getAncestor(3)).getRawIncludepathEntry()) != null) {
                    AddToClasspathChange change;
                    String label;
                    IJavaScriptProject other = root.getJavaScriptProject();
                    int entryKind = entry.getEntryKind();
                    if ((entry.isExported() || entryKind == 3) && addedClaspaths.add(other)) {
                        Object[] args = new String[]{other.getElementName(), project.getElementName()};
                        String label2 = Messages.format(CorrectionMessages.ReorgCorrectionsSubProcessor_addcp_project_description, args);
                        IIncludePathEntry newEntry = JavaScriptCore.newProjectEntry((IPath)other.getPath());
                        AddToClasspathChange change2 = new AddToClasspathChange(project, newEntry);
                        if (change2.validateClasspath()) {
                            ChangeCorrectionProposal proposal = new ChangeCorrectionProposal(label2, change2, 8, JavaPluginImages.get("org.eclipse.wst.jsdt.ui.correction_change.gif"));
                            proposals.add(proposal);
                        }
                    }
                    if ((entryKind == 1 || entryKind == 4 || entryKind == 5) && addedClaspaths.add(entry) && (label = ReorgCorrectionsSubProcessor.getAddClasspathLabel(entry, root, project)) != null && (change = new AddToClasspathChange(project, entry)).validateClasspath()) {
                        ChangeCorrectionProposal proposal = new ChangeCorrectionProposal(label, change, 7, JavaPluginImages.get("org.eclipse.wst.jsdt.ui.correction_change.gif"));
                        proposals.add(proposal);
                    }
                }
                ++i;
            }
        }
    }

    private static String getAddClasspathLabel(IIncludePathEntry entry, IPackageFragmentRoot root, IJavaScriptProject project) {
        switch (entry.getEntryKind()) {
            case 1: {
                if (root.isArchive()) {
                    Object[] args = new String[]{JavaScriptElementLabels.getElementLabel((IJavaScriptElement)root, 0x200000000000L), project.getElementName()};
                    return Messages.format(CorrectionMessages.ReorgCorrectionsSubProcessor_addcp_archive_description, args);
                }
                Object[] args = new String[]{JavaScriptElementLabels.getElementLabel((IJavaScriptElement)root, 0x200000000000L), project.getElementName()};
                return Messages.format(CorrectionMessages.ReorgCorrectionsSubProcessor_addcp_classfolder_description, args);
            }
            case 4: {
                Object[] args = new String[]{JavaScriptElementLabels.getElementLabel((IJavaScriptElement)root, 0L), project.getElementName()};
                return Messages.format(CorrectionMessages.ReorgCorrectionsSubProcessor_addcp_variable_description, args);
            }
            case 5: {
                try {
                    Object[] args = new String[]{JavaScriptElementLabels.getContainerEntryLabel(entry.getPath(), root.getJavaScriptProject()), project.getElementName()};
                    return Messages.format(CorrectionMessages.ReorgCorrectionsSubProcessor_addcp_library_description, args);
                }
                catch (JavaScriptModelException javaScriptModelException) {}
            }
        }
        return null;
    }

    public static void getNeed50ComplianceProposals(IInvocationContext context, IProblemLocation problem, Collection proposals) {
        IJavaScriptProject project = context.getCompilationUnit().getJavaScriptProject();
        String label1 = CorrectionMessages.ReorgCorrectionsSubProcessor_50_project_compliance_description;
        proposals.add(new ChangeTo50Compliance(label1, project, false, 5));
        if (project.getOption("org.eclipse.wst.jsdt.core.compiler.compliance", false) == null) {
            String label2 = CorrectionMessages.ReorgCorrectionsSubProcessor_50_workspace_compliance_description;
            proposals.add(new ChangeTo50Compliance(label2, project, true, 6));
        }
    }

    public static void getIncorrectBuildPathProposals(IInvocationContext context, IProblemLocation problem, Collection proposals) {
        IProject project = context.getCompilationUnit().getJavaScriptProject().getProject();
        String label = CorrectionMessages.ReorgCorrectionsSubProcessor_configure_buildpath_label;
        OpenBuildPathCorrectionProposal proposal = new OpenBuildPathCorrectionProposal(project, label, 5, null);
        proposals.add(proposal);
    }

    public static void getAccessRulesProposals(IInvocationContext context, IProblemLocation problem, Collection proposals) {
        ITypeBinding referencedElement = null;
        ASTNode node = problem.getCoveredNode(context.getASTRoot());
        if (node instanceof Type) {
            referencedElement = ((Type)node).resolveBinding();
        } else if (node instanceof Name) {
            referencedElement = ((Name)node).resolveBinding();
        }
        IProject project = context.getCompilationUnit().getJavaScriptProject().getProject();
        String label = CorrectionMessages.ReorgCorrectionsSubProcessor_accessrules_description;
        OpenBuildPathCorrectionProposal proposal = new OpenBuildPathCorrectionProposal(project, label, 5, (IBinding)referencedElement);
        proposals.add(proposal);
    }

    private static final class ChangeTo50Compliance
    extends ChangeCorrectionProposal
    implements IWorkspaceRunnable {
        private final IJavaScriptProject fProject;
        private final boolean fChangeOnWorkspace;
        private Job fUpdateJob;
        private boolean f50JREFound;

        public ChangeTo50Compliance(String name, IJavaScriptProject project, boolean changeOnWorkspace, int relevance) {
            super(name, null, relevance, JavaPluginImages.get("org.eclipse.wst.jsdt.ui.correction_change.gif"));
            this.fProject = project;
            this.fChangeOnWorkspace = changeOnWorkspace;
            this.fUpdateJob = null;
            this.f50JREFound = false;
        }

        private boolean is50orGreaterVMInstall(IVMInstall install) {
            if (install instanceof IVMInstall2) {
                String compliance = JavaModelUtil.getCompilerCompliance((IVMInstall2)install, "1.3");
                return JavaModelUtil.is50OrHigher(compliance);
            }
            return false;
        }

        private IVMInstall find50OrGreaterVMInstall() {
            IVMInstallType[] installTypes = JavaRuntime.getVMInstallTypes();
            int i = 0;
            while (i < installTypes.length) {
                IVMInstall[] installs = installTypes[i].getVMInstalls();
                int k = 0;
                while (k < installs.length) {
                    if (this.is50orGreaterVMInstall(installs[k])) {
                        return installs[k];
                    }
                    ++k;
                }
                ++i;
            }
            return null;
        }

        public void run(IProgressMonitor monitor) throws CoreException {
            boolean needsBuild = this.updateJRE(monitor);
            if (needsBuild) {
                this.fUpdateJob = CoreUtility.getBuildJob(this.fChangeOnWorkspace ? null : this.fProject.getProject());
            }
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean updateJRE(IProgressMonitor monitor) throws CoreException, JavaScriptModelException {
            block8: {
                block9: {
                    block10: {
                        try {
                            vm50Install = this.find50OrGreaterVMInstall();
                            v0 = this.f50JREFound = vm50Install != null;
                            if (vm50Install == null) break block8;
                            install = JavaRuntime.getVMInstall((IJavaScriptProject)this.fProject);
                            if (this.fChangeOnWorkspace) {
                                monitor.beginTask(CorrectionMessages.ReorgCorrectionsSubProcessor_50_compliance_operation, 4);
                                defaultVM = JavaRuntime.getDefaultVMInstall();
                                if (defaultVM != null && !defaultVM.equals(install)) {
                                    newPath = new Path("org.eclipse.wst.jsdt.launching.JRE_CONTAINER");
                                    this.updateClasspath((IPath)newPath, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                } else {
                                    monitor.worked(1);
                                }
                                if (defaultVM != null && this.is50orGreaterVMInstall(defaultVM)) break block9;
                                JavaRuntime.setDefaultVMInstall((IVMInstall)vm50Install, (IProgressMonitor)new SubProgressMonitor(monitor, 3), (boolean)true);
lbl17:
                                // 2 sources

                                while (true) {
                                    var6_7 = null;
                                    break block10;
                                    break;
                                }
                            }
                            if (install == null || !this.is50orGreaterVMInstall(install)) {
                                newPath = new Path("org.eclipse.wst.jsdt.launching.JRE_CONTAINER").append(vm50Install.getVMInstallType().getId()).append(vm50Install.getName());
                                this.updateClasspath(newPath, monitor);
                                ** continue;
                            }
                            break block8;
                        }
                        catch (Throwable var7_11) {
                            var6_9 = null;
                            monitor.done();
                            throw var7_11;
                        }
                    }
                    monitor.done();
                    return false;
                }
                var6_8 = null;
                monitor.done();
                return true;
            }
            var6_10 = null;
            monitor.done();
            return true;
        }

        private void updateClasspath(IPath newPath, IProgressMonitor monitor) throws JavaScriptModelException {
            IIncludePathEntry[] classpath = this.fProject.getRawIncludepath();
            Path jreContainerPath = new Path("org.eclipse.wst.jsdt.launching.JRE_CONTAINER");
            int i = 0;
            while (i < classpath.length) {
                IIncludePathEntry curr = classpath[i];
                if (curr.getEntryKind() == 5 && curr.getPath().matchingFirstSegments((IPath)jreContainerPath) > 0) {
                    classpath[i] = JavaScriptCore.newContainerEntry((IPath)newPath, (IAccessRule[])curr.getAccessRules(), (IIncludePathAttribute[])curr.getExtraAttributes(), (boolean)curr.isExported());
                }
                ++i;
            }
            this.fProject.setRawIncludepath(classpath, monitor);
        }

        public String getAdditionalProposalInfo() {
            StringBuffer message = new StringBuffer();
            if (this.fChangeOnWorkspace) {
                message.append(CorrectionMessages.ReorgCorrectionsSubProcessor_50_compliance_changeworkspace_description);
            } else {
                message.append(CorrectionMessages.ReorgCorrectionsSubProcessor_50_compliance_changeproject_description);
            }
            IVMInstall vm50Install = this.find50OrGreaterVMInstall();
            if (vm50Install != null) {
                try {
                    IVMInstall install = JavaRuntime.getVMInstall((IJavaScriptProject)this.fProject);
                    if (this.fChangeOnWorkspace) {
                        IVMInstall defaultVM = JavaRuntime.getDefaultVMInstall();
                        if (defaultVM != null && !defaultVM.equals(install)) {
                            message.append(CorrectionMessages.ReorgCorrectionsSubProcessor_50_compliance_changeProjectJREToDefault_description);
                        }
                        if (defaultVM == null || !this.is50orGreaterVMInstall(defaultVM)) {
                            message.append(Messages.format(CorrectionMessages.ReorgCorrectionsSubProcessor_50_compliance_changeWorkspaceJRE_description, vm50Install.getName()));
                        }
                    } else if (install == null || !this.is50orGreaterVMInstall(install)) {
                        message.append(Messages.format(CorrectionMessages.ReorgCorrectionsSubProcessor_50_compliance_changeProjectJRE_description, vm50Install.getName()));
                    }
                }
                catch (CoreException coreException) {}
            }
            return message.toString();
        }

        public void apply(IDocument document) {
            Map map;
            if (this.fChangeOnWorkspace) {
                map = JavaScriptCore.getOptions();
                JavaModelUtil.set50CompilanceOptions(map);
                JavaScriptCore.setOptions((Hashtable)map);
            } else {
                map = this.fProject.getOptions(false);
                int optionsCount = map.size();
                JavaModelUtil.set50CompilanceOptions(map);
                if (map.size() > optionsCount) {
                    JavaModelUtil.setDefaultClassfileOptions(map, "1.5");
                }
                this.fProject.setOptions(map);
            }
            try {
                IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
                progressService.run(true, true, (IRunnableWithProgress)new WorkbenchRunnableAdapter(this));
            }
            catch (InvocationTargetException e) {
                JavaScriptPlugin.log(e);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            if (this.fUpdateJob != null) {
                this.fUpdateJob.schedule();
            }
            if (!this.f50JREFound) {
                MessageDialog.openInformation((Shell)JavaScriptPlugin.getActiveWorkbenchShell(), (String)CorrectionMessages.ReorgCorrectionsSubProcessor_no_50jre_title, (String)CorrectionMessages.ReorgCorrectionsSubProcessor_no_50jre_message);
            }
        }
    }

    private static final class OpenBuildPathCorrectionProposal
    extends ChangeCorrectionProposal {
        private final IProject fProject;
        private final IBinding fReferencedType;

        private OpenBuildPathCorrectionProposal(IProject project, String label, int relevance, IBinding referencedType) {
            super(label, null, relevance, null);
            this.fProject = project;
            this.fReferencedType = referencedType;
            this.setImage(JavaPluginImages.get("org.eclipse.wst.jsdt.ui.access_restriction_attrib.gif"));
        }

        public void apply(IDocument document) {
            IPackageFragmentRoot root;
            IJavaScriptElement elem;
            HashMap<Object, Object> data = null;
            if (this.fReferencedType != null && (elem = this.fReferencedType.getJavaElement()) != null && (root = (IPackageFragmentRoot)elem.getAncestor(3)) != null) {
                try {
                    IIncludePathEntry entry = root.getRawIncludepathEntry();
                    if (entry != null) {
                        data = new HashMap<Object, Object>(1);
                        data.put(BuildPathsPropertyPage.DATA_REVEAL_ENTRY, entry);
                        if (entry.getEntryKind() != 5) {
                            data.put(BuildPathsPropertyPage.DATA_REVEAL_ATTRIBUTE_KEY, "accessrules");
                        }
                    }
                }
                catch (JavaScriptModelException javaScriptModelException) {}
            }
            PreferencesUtil.createPropertyDialogOn((Shell)JavaScriptPlugin.getActiveWorkbenchShell(), (IAdaptable)this.fProject, (String)"org.eclipse.wst.jsdt.ui.propertyPages.BuildPathsPropertyPage", null, data).open();
        }

        public String getAdditionalProposalInfo() {
            return Messages.format(CorrectionMessages.ReorgCorrectionsSubProcessor_configure_buildpath_description, this.fProject.getName());
        }
    }
}

