/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets;

import java.util.Iterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.EnumeratedTypeSet;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.TypeSet;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.TypeSetEnvironment;

public class SingletonTypeSet
extends TypeSet {
    private final TType fType;

    public SingletonTypeSet(TType t, TypeSetEnvironment typeSetEnvironment) {
        super(typeSetEnvironment);
        Assert.isNotNull((Object)t);
        this.fType = t;
    }

    public boolean isUniverse() {
        return false;
    }

    public TypeSet makeClone() {
        return this;
    }

    protected TypeSet specialCasesIntersectedWith(TypeSet s2) {
        if (s2.contains(this.fType)) {
            return this;
        }
        return this.getTypeSetEnvironment().getEmptyTypeSet();
    }

    public boolean isEmpty() {
        return false;
    }

    public TypeSet upperBound() {
        return this;
    }

    public TypeSet lowerBound() {
        return this;
    }

    public boolean hasUniqueLowerBound() {
        return true;
    }

    public boolean hasUniqueUpperBound() {
        return true;
    }

    public TType uniqueLowerBound() {
        return this.fType;
    }

    public TType uniqueUpperBound() {
        return this.fType;
    }

    public boolean contains(TType t) {
        return this.fType.equals(t);
    }

    public boolean containsAll(TypeSet s) {
        if (s.isEmpty()) {
            return true;
        }
        if (s.isSingleton()) {
            return s.anyMember().equals(this.fType);
        }
        return false;
    }

    public Iterator iterator() {
        return new Iterator(){
            private boolean done = false;

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public boolean hasNext() {
                return !this.done;
            }

            public Object next() {
                this.done = true;
                return SingletonTypeSet.this.fType;
            }
        };
    }

    public boolean isSingleton() {
        return true;
    }

    public TType anyMember() {
        return this.fType;
    }

    public EnumeratedTypeSet enumerate() {
        EnumeratedTypeSet enumeratedTypeSet = new EnumeratedTypeSet(this.fType, this.getTypeSetEnvironment());
        enumeratedTypeSet.initComplete();
        return enumeratedTypeSet;
    }

    public boolean equals(Object o) {
        if (o instanceof SingletonTypeSet) {
            SingletonTypeSet other = (SingletonTypeSet)o;
            return this.fType.equals(other.fType);
        }
        if (o instanceof TypeSet) {
            TypeSet other = (TypeSet)o;
            return other.isSingleton() && other.anyMember().equals(this.fType);
        }
        return false;
    }

    public String toString() {
        return "{" + this.fID + ": " + this.fType.getPrettySignature() + "}";
    }
}

