/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.viewsupport;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.jsdt.core.BindingKey;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IInitializer;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IJsGlobalScopeContainer;
import org.eclipse.wst.jsdt.core.ILocalVariable;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.JsGlobalScopeContainerInitializer;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaUIMessages;
import org.eclipse.wst.jsdt.internal.ui.packageview.JsGlobalScopeContainer;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ColoredString;
import org.eclipse.wst.jsdt.ui.JavaScriptElementLabels;

public class ColoredJavaElementLabels {
    public static final ColoredString.Style QUALIFIER_STYLE = new ColoredString.Style("org.eclipse.wst.jsdt.ui.ColoredLabels.qualifier");
    public static final ColoredString.Style COUNTER_STYLE = new ColoredString.Style("org.eclipse.wst.jsdt.ui.ColoredLabels.counter");
    public static final ColoredString.Style DECORATIONS_STYLE;
    private static final ColoredString.Style APPENDED_TYPE_STYLE;
    public static final long COLORIZE = 0x80000000000000L;
    private static final long QUALIFIER_FLAGS = 0x1002000000000L;

    static {
        APPENDED_TYPE_STYLE = DECORATIONS_STYLE = new ColoredString.Style("org.eclipse.wst.jsdt.ui.ColoredLabels.decorations");
    }

    private static final boolean getFlag(long flags, long flag) {
        return (flags & flag) != 0L;
    }

    public static ColoredString getTextLabel(Object obj, long flags) {
        if (obj instanceof IJavaScriptElement) {
            return ColoredJavaElementLabels.getElementLabel((IJavaScriptElement)obj, flags);
        }
        if (obj instanceof IResource) {
            return new ColoredString(((IResource)obj).getName());
        }
        if (obj instanceof JsGlobalScopeContainer) {
            JsGlobalScopeContainer container = (JsGlobalScopeContainer)obj;
            return ColoredJavaElementLabels.getContainerEntryLabel(container.getClasspathEntry().getPath(), container.getJavaProject());
        }
        return new ColoredString(JavaScriptElementLabels.getTextLabel(obj, flags));
    }

    public static ColoredString getElementLabel(IJavaScriptElement element, long flags) {
        ColoredString result = new ColoredString();
        ColoredJavaElementLabels.getElementLabel(element, flags, result);
        return result;
    }

    public static void getElementLabel(IJavaScriptElement element, long flags, ColoredString result) {
        int type = element.getElementType();
        IPackageFragmentRoot root = null;
        if (type != 1 && type != 2 && type != 3) {
            root = JavaModelUtil.getPackageFragmentRoot(element);
        }
        if (root != null && ColoredJavaElementLabels.getFlag(flags, 0x100000000000L)) {
            ColoredJavaElementLabels.getPackageFragmentRootLabel(root, 0x20000000000L, result);
            result.append(JavaScriptElementLabels.CONCAT_STRING);
        }
        switch (type) {
            case 9: {
                ColoredJavaElementLabels.getMethodLabel((IFunction)element, flags, result);
                break;
            }
            case 8: {
                ColoredJavaElementLabels.getFieldLabel((IField)element, flags, result);
                break;
            }
            case 14: {
                ColoredJavaElementLabels.getLocalVariableLabel((ILocalVariable)element, flags, result);
                break;
            }
            case 10: {
                ColoredJavaElementLabels.getInitializerLabel((IInitializer)element, flags, result);
                break;
            }
            case 7: {
                ColoredJavaElementLabels.getTypeLabel((IType)element, flags, result);
                break;
            }
            case 6: {
                ColoredJavaElementLabels.getClassFileLabel((IClassFile)element, flags, result);
                break;
            }
            case 5: {
                ColoredJavaElementLabels.getCompilationUnitLabel((IJavaScriptUnit)element, flags, result);
                break;
            }
            case 4: {
                ColoredJavaElementLabels.getPackageFragmentLabel((IPackageFragment)element, flags, result);
                break;
            }
            case 3: {
                ColoredJavaElementLabels.getPackageFragmentRootLabel((IPackageFragmentRoot)element, flags, result);
                break;
            }
            case 12: 
            case 13: {
                ColoredJavaElementLabels.getDeclarationLabel(element, flags, result);
                break;
            }
            case 1: 
            case 2: {
                result.append(element.getElementName());
                break;
            }
            default: {
                result.append(element.getElementName());
            }
        }
        if (root != null && ColoredJavaElementLabels.getFlag(flags, 0x80000000000L)) {
            int offset = result.length();
            result.append(JavaScriptElementLabels.CONCAT_STRING);
            ColoredJavaElementLabels.getPackageFragmentRootLabel(root, 0x20000000000L, result);
            if (ColoredJavaElementLabels.getFlag(flags, 0x80000000000000L)) {
                result.colorize(offset, result.length() - offset, QUALIFIER_STYLE);
            }
        }
    }

    public static void getMethodLabel(IFunction method, long flags, ColoredString result) {
        try {
            String[] types;
            String resolvedSig;
            BindingKey resolvedKey = ColoredJavaElementLabels.getFlag(flags, 0x1000000000000L) && method.isResolved() ? new BindingKey(method.getKey()) : null;
            String string = resolvedSig = resolvedKey != null ? resolvedKey.toSignature() : null;
            if (ColoredJavaElementLabels.getFlag(flags, 64L) && method.exists() && !method.isConstructor()) {
                String returnTypeSig = resolvedSig != null ? Signature.getReturnType((String)resolvedSig) : method.getReturnType();
                ColoredJavaElementLabels.getTypeSignatureLabel(returnTypeSig, flags, result);
                result.append(' ');
            }
            if (ColoredJavaElementLabels.getFlag(flags, 128L)) {
                ColoredJavaElementLabels.getTypeLabel(method.getDeclaringType(), 0x40000L | flags & 0x1002000000000L, result);
                result.append('.');
            }
            result.append(method.getElementName());
            result.append('(');
            if (ColoredJavaElementLabels.getFlag(flags, 3L)) {
                types = null;
                int nParams = 0;
                boolean renderVarargs = false;
                if (ColoredJavaElementLabels.getFlag(flags, 1L)) {
                    types = resolvedSig != null ? Signature.getParameterTypes((String)resolvedSig) : method.getParameterTypes();
                    nParams = types.length;
                    renderVarargs = method.exists() && Flags.isVarargs((int)method.getFlags());
                }
                String[] names = null;
                if (ColoredJavaElementLabels.getFlag(flags, 2L) && method.exists()) {
                    names = method.getParameterNames();
                    if (types == null) {
                        nParams = names.length;
                    } else if (nParams != names.length) {
                        if (resolvedSig != null && types.length > names.length) {
                            nParams = names.length;
                            String[] typesWithoutSyntheticParams = new String[nParams];
                            System.arraycopy(types, types.length - nParams, typesWithoutSyntheticParams, 0, nParams);
                            types = typesWithoutSyntheticParams;
                        } else {
                            names = null;
                        }
                    }
                }
                int i = 0;
                while (i < nParams) {
                    if (i > 0) {
                        result.append(JavaScriptElementLabels.COMMA_STRING);
                    }
                    if (types != null) {
                        String paramSig = types[i];
                        if (renderVarargs && i == nParams - 1) {
                            int newDim = Signature.getArrayCount((String)paramSig) - 1;
                            ColoredJavaElementLabels.getTypeSignatureLabel(Signature.getElementType((String)paramSig), flags, result);
                            int k = 0;
                            while (k < newDim) {
                                result.append('[').append(']');
                                ++k;
                            }
                            result.append("...");
                        } else {
                            ColoredJavaElementLabels.getTypeSignatureLabel(paramSig, flags, result);
                        }
                    }
                    if (names != null) {
                        if (types != null) {
                            result.append(' ');
                        }
                        result.append(names[i]);
                    }
                    ++i;
                }
            } else if (method.getParameterTypes().length > 0) {
                result.append("...");
            }
            result.append(')');
            if (ColoredJavaElementLabels.getFlag(flags, 16L) && (types = resolvedKey != null ? new String[]{} : new String[]{}).length > 0) {
                result.append(" throws ");
                int i = 0;
                while (i < types.length) {
                    if (i > 0) {
                        result.append(JavaScriptElementLabels.COMMA_STRING);
                    }
                    ColoredJavaElementLabels.getTypeSignatureLabel(types[i], flags, result);
                    ++i;
                }
            }
            if (ColoredJavaElementLabels.getFlag(flags, 8L)) {
                int offset = result.length();
                if (ColoredJavaElementLabels.getFlag(flags, 0x80000000000000L)) {
                    result.colorize(offset, result.length() - offset, APPENDED_TYPE_STYLE);
                }
            }
            if (ColoredJavaElementLabels.getFlag(flags, 32L) && method.exists() && !method.isConstructor()) {
                int offset = result.length();
                result.append(JavaScriptElementLabels.DECL_STRING);
                String returnTypeSig = resolvedSig != null ? Signature.getReturnType((String)resolvedSig) : method.getReturnType();
                ColoredJavaElementLabels.getTypeSignatureLabel(returnTypeSig, flags, result);
                if (ColoredJavaElementLabels.getFlag(flags, 0x80000000000000L)) {
                    result.colorize(offset, result.length() - offset, APPENDED_TYPE_STYLE);
                }
            }
            if (ColoredJavaElementLabels.getFlag(flags, 0x4000000000000L) && method.exists()) {
                ColoredJavaElementLabels.getCategoryLabel((IMember)method, result);
            }
            if (ColoredJavaElementLabels.getFlag(flags, 256L)) {
                int offset = result.length();
                result.append(JavaScriptElementLabels.CONCAT_STRING);
                if (method.getDeclaringType() != null) {
                    ColoredJavaElementLabels.getTypeLabel(method.getDeclaringType(), 0x40000L | flags & 0x1002000000000L, result);
                }
                if (ColoredJavaElementLabels.getFlag(flags, 0x80000000000000L)) {
                    result.colorize(offset, result.length() - offset, QUALIFIER_STYLE);
                }
            }
        }
        catch (JavaScriptModelException e) {
            JavaScriptPlugin.log(e);
        }
    }

    private static void getCategoryLabel(IMember member, ColoredString result) throws JavaScriptModelException {
        String[] categories = member.getCategories();
        if (categories.length > 0) {
            ColoredString categoriesBuf = new ColoredString();
            int i = 0;
            while (i < categories.length) {
                if (i > 0) {
                    categoriesBuf.append(JavaUIMessages.JavaElementLabels_category_separator_string);
                }
                categoriesBuf.append(categories[i]);
                ++i;
            }
            result.append(JavaScriptElementLabels.CONCAT_STRING);
            result.append(Messages.format(JavaUIMessages.JavaElementLabels_category, categoriesBuf.toString()));
        }
    }

    public static void getFieldLabel(IField field, long flags, ColoredString result) {
        try {
            int offset;
            if (ColoredJavaElementLabels.getFlag(flags, 32768L) && field.exists()) {
                if (ColoredJavaElementLabels.getFlag(flags, 0x1000000000000L) && field.isResolved()) {
                    ColoredJavaElementLabels.getTypeSignatureLabel(new BindingKey(field.getKey()).toSignature(), flags, result);
                } else {
                    ColoredJavaElementLabels.getTypeSignatureLabel(field.getTypeSignature(), flags, result);
                }
                result.append(' ');
            }
            if (ColoredJavaElementLabels.getFlag(flags, 65536L)) {
                ColoredJavaElementLabels.getTypeLabel(field.getDeclaringType(), 0x40000L | flags & 0x1002000000000L, result);
                result.append('.');
            }
            result.append(field.getElementName());
            if (ColoredJavaElementLabels.getFlag(flags, 16384L) && field.exists()) {
                offset = result.length();
                result.append(JavaScriptElementLabels.DECL_STRING);
                if (ColoredJavaElementLabels.getFlag(flags, 0x1000000000000L) && field.isResolved()) {
                    ColoredJavaElementLabels.getTypeSignatureLabel(new BindingKey(field.getKey()).toSignature(), flags, result);
                } else {
                    ColoredJavaElementLabels.getTypeSignatureLabel(field.getTypeSignature(), flags, result);
                }
                if (ColoredJavaElementLabels.getFlag(flags, 0x80000000000000L)) {
                    result.colorize(offset, result.length() - offset, APPENDED_TYPE_STYLE);
                }
            }
            if (ColoredJavaElementLabels.getFlag(flags, 0x2000000000000L) && field.exists()) {
                ColoredJavaElementLabels.getCategoryLabel((IMember)field, result);
            }
            if (ColoredJavaElementLabels.getFlag(flags, 131072L)) {
                offset = result.length();
                result.append(JavaScriptElementLabels.CONCAT_STRING);
                ColoredJavaElementLabels.getTypeLabel(field.getDeclaringType(), 0x40000L | flags & 0x1002000000000L, result);
                if (ColoredJavaElementLabels.getFlag(flags, 0x80000000000000L)) {
                    result.colorize(offset, result.length() - offset, QUALIFIER_STYLE);
                }
            }
        }
        catch (JavaScriptModelException e) {
            JavaScriptPlugin.log(e);
        }
    }

    public static void getLocalVariableLabel(ILocalVariable localVariable, long flags, ColoredString result) {
        if (ColoredJavaElementLabels.getFlag(flags, 32768L)) {
            ColoredJavaElementLabels.getTypeSignatureLabel(localVariable.getTypeSignature(), flags, result);
            result.append(' ');
        }
        if (ColoredJavaElementLabels.getFlag(flags, 65536L)) {
            ColoredJavaElementLabels.getElementLabel(localVariable.getParent(), 0x40081L | flags & 0x1002000000000L, result);
            result.append('.');
        }
        result.append(localVariable.getElementName());
        if (ColoredJavaElementLabels.getFlag(flags, 16384L)) {
            int offset = result.length();
            result.append(JavaScriptElementLabels.DECL_STRING);
            ColoredJavaElementLabels.getTypeSignatureLabel(localVariable.getTypeSignature(), flags, result);
            if (ColoredJavaElementLabels.getFlag(flags, 0x80000000000000L)) {
                result.colorize(offset, result.length() - offset, APPENDED_TYPE_STYLE);
            }
        }
        if (ColoredJavaElementLabels.getFlag(flags, 131072L)) {
            result.append(JavaScriptElementLabels.CONCAT_STRING);
            ColoredJavaElementLabels.getElementLabel(localVariable.getParent(), 0x40081L | flags & 0x1002000000000L, result);
        }
    }

    public static void getInitializerLabel(IInitializer initializer, long flags, ColoredString result) {
        if (ColoredJavaElementLabels.getFlag(flags, 1024L)) {
            ColoredJavaElementLabels.getTypeLabel(initializer.getDeclaringType(), 0x40000L | flags & 0x1002000000000L, result);
            result.append('.');
        }
        result.append(JavaUIMessages.JavaElementLabels_initializer);
        if (ColoredJavaElementLabels.getFlag(flags, 2048L)) {
            int offset = result.length();
            result.append(JavaScriptElementLabels.CONCAT_STRING);
            ColoredJavaElementLabels.getTypeLabel(initializer.getDeclaringType(), 0x40000L | flags & 0x1002000000000L, result);
            if (ColoredJavaElementLabels.getFlag(flags, 0x80000000000000L)) {
                result.colorize(offset, result.length() - offset, QUALIFIER_STYLE);
            }
        }
    }

    private static void getTypeSignatureLabel(String typeSig, long flags, ColoredString result) {
        int sigKind = Signature.getTypeSignatureKind((String)typeSig);
        switch (sigKind) {
            case 2: {
                result.append(Signature.toString((String)typeSig));
                break;
            }
            case 4: {
                ColoredJavaElementLabels.getTypeSignatureLabel(Signature.getElementType((String)typeSig), flags, result);
                int dim = Signature.getArrayCount((String)typeSig);
                while (dim > 0) {
                    result.append('[').append(']');
                    --dim;
                }
                break;
            }
            case 1: {
                String baseType = Signature.toString((String)typeSig);
                result.append(Signature.getSimpleName((String)baseType));
                ColoredJavaElementLabels.getTypeArgumentSignaturesLabel(new String[0], flags, result);
            }
        }
    }

    private static void getTypeArgumentSignaturesLabel(String[] typeArgsSig, long flags, ColoredString result) {
        if (typeArgsSig.length > 0) {
            result.append('<');
            int i = 0;
            while (i < typeArgsSig.length) {
                if (i > 0) {
                    result.append(JavaScriptElementLabels.COMMA_STRING);
                }
                ColoredJavaElementLabels.getTypeSignatureLabel(typeArgsSig[i], flags, result);
                ++i;
            }
            result.append('>');
        }
    }

    private static void getTypeParameterSignaturesLabel(String[] typeParamSigs, long flags, ColoredString result) {
        if (typeParamSigs.length > 0) {
            result.append('<');
            int i = 0;
            while (i < typeParamSigs.length) {
                if (i > 0) {
                    result.append(JavaScriptElementLabels.COMMA_STRING);
                }
                result.append(Signature.getTypeVariable((String)typeParamSigs[i]));
                ++i;
            }
            result.append('>');
        }
    }

    public static void getTypeLabel(IType type, long flags, ColoredString result) {
        String typeName;
        IPackageFragment pack;
        if (ColoredJavaElementLabels.getFlag(flags, 262144L) && !(pack = type.getPackageFragment()).isDefaultPackage()) {
            ColoredJavaElementLabels.getPackageFragmentLabel(pack, flags & 0x1002000000000L, result);
            result.append('.');
        }
        if (ColoredJavaElementLabels.getFlag(flags, 786432L)) {
            int parentType;
            IType declaringType = type.getDeclaringType();
            if (declaringType != null) {
                ColoredJavaElementLabels.getTypeLabel(declaringType, 0x80000L | flags & 0x1002000000000L, result);
                result.append('.');
            }
            if ((parentType = type.getParent().getElementType()) == 9 || parentType == 8 || parentType == 10) {
                ColoredJavaElementLabels.getElementLabel(type.getParent(), 0L, result);
                result.append('.');
            }
        }
        if ((typeName = type.getElementName()).length() == 0) {
            try {
                String supertypeName = Signature.getSimpleName((String)type.getSuperclassName());
                typeName = Messages.format(JavaUIMessages.JavaElementLabels_anonym_type, supertypeName);
            }
            catch (JavaScriptModelException javaScriptModelException) {
                typeName = JavaUIMessages.JavaElementLabels_anonym;
            }
        }
        result.append(typeName);
        if (ColoredJavaElementLabels.getFlag(flags, 0x200000L) && ColoredJavaElementLabels.getFlag(flags, 0x1000000000000L) && type.isResolved()) {
            new BindingKey(type.getKey());
            ColoredJavaElementLabels.getTypeParameterSignaturesLabel(new String[0], flags, result);
        }
        if (ColoredJavaElementLabels.getFlag(flags, 0x8000000000000L) && type.exists()) {
            try {
                ColoredJavaElementLabels.getCategoryLabel((IMember)type, result);
            }
            catch (JavaScriptModelException javaScriptModelException) {}
        }
        if (ColoredJavaElementLabels.getFlag(flags, 0x100000L)) {
            int offset = result.length();
            result.append(JavaScriptElementLabels.CONCAT_STRING);
            IType declaringType = type.getDeclaringType();
            if (declaringType != null) {
                ColoredJavaElementLabels.getTypeLabel(declaringType, 0x40000L | flags & 0x1002000000000L, result);
                int parentType = type.getParent().getElementType();
                if (parentType == 9 || parentType == 8 || parentType == 10) {
                    result.append('.');
                    ColoredJavaElementLabels.getElementLabel(type.getParent(), 0L, result);
                }
            } else {
                ColoredJavaElementLabels.getPackageFragmentLabel(type.getPackageFragment(), flags & 0x1002000000000L, result);
            }
            if (ColoredJavaElementLabels.getFlag(flags, 0x80000000000000L)) {
                result.colorize(offset, result.length() - offset, QUALIFIER_STYLE);
            }
        }
    }

    public static void getDeclarationLabel(IJavaScriptElement declaration, long flags, ColoredString result) {
        IJavaScriptElement openable;
        if (ColoredJavaElementLabels.getFlag(flags, 0x1000000L) && (openable = (IJavaScriptElement)declaration.getOpenable()) != null) {
            result.append(ColoredJavaElementLabels.getElementLabel(openable, 0x88000000L | flags & 0x1002000000000L));
            result.append('/');
        }
        if (declaration.getElementType() == 12) {
            result.append(JavaUIMessages.JavaElementLabels_import_container);
        } else {
            result.append(declaration.getElementName());
        }
        if (ColoredJavaElementLabels.getFlag(flags, 0x2000000L)) {
            int offset = result.length();
            IJavaScriptElement openable2 = (IJavaScriptElement)declaration.getOpenable();
            if (openable2 != null) {
                result.append(JavaScriptElementLabels.CONCAT_STRING);
                result.append(ColoredJavaElementLabels.getElementLabel(openable2, 0x88000000L | flags & 0x1002000000000L));
            }
            if (ColoredJavaElementLabels.getFlag(flags, 0x80000000000000L)) {
                result.colorize(offset, result.length() - offset, QUALIFIER_STYLE);
            }
        }
    }

    public static void getClassFileLabel(IClassFile classFile, long flags, ColoredString result) {
        IPackageFragment pack;
        if (ColoredJavaElementLabels.getFlag(flags, 0x8000000L) && !(pack = (IPackageFragment)classFile.getParent()).isDefaultPackage()) {
            ColoredJavaElementLabels.getPackageFragmentLabel(pack, flags & 0x1002000000000L, result);
            result.append('.');
        }
        result.append(classFile.getElementName());
        if (ColoredJavaElementLabels.getFlag(flags, 0x10000000L)) {
            int offset = result.length();
            result.append(JavaScriptElementLabels.CONCAT_STRING);
            ColoredJavaElementLabels.getPackageFragmentLabel((IPackageFragment)classFile.getParent(), flags & 0x1002000000000L, result);
            if (ColoredJavaElementLabels.getFlag(flags, 0x80000000000000L)) {
                result.colorize(offset, result.length() - offset, QUALIFIER_STYLE);
            }
        }
    }

    public static void getCompilationUnitLabel(IJavaScriptUnit cu, long flags, ColoredString result) {
        IPackageFragment pack;
        if (ColoredJavaElementLabels.getFlag(flags, 0x80000000L) && !(pack = (IPackageFragment)cu.getParent()).isDefaultPackage()) {
            ColoredJavaElementLabels.getPackageFragmentLabel(pack, flags & 0x1002000000000L, result);
            result.append('.');
        }
        result.append(cu.getElementName());
        if (ColoredJavaElementLabels.getFlag(flags, 0x100000000L)) {
            int offset = result.length();
            result.append(JavaScriptElementLabels.CONCAT_STRING);
            ColoredJavaElementLabels.getPackageFragmentLabel((IPackageFragment)cu.getParent(), flags & 0x1002000000000L, result);
            if (ColoredJavaElementLabels.getFlag(flags, 0x80000000000000L)) {
                result.colorize(offset, result.length() - offset, QUALIFIER_STYLE);
            }
        }
    }

    public static void getPackageFragmentLabel(IPackageFragment pack, long flags, ColoredString result) {
        if (ColoredJavaElementLabels.getFlag(flags, 0x800000000L)) {
            ColoredJavaElementLabels.getPackageFragmentRootLabel((IPackageFragmentRoot)pack.getParent(), 0x20000000000L, result);
            result.append('/');
        }
        if (pack.isDefaultPackage()) {
            result.append(JavaScriptElementLabels.DEFAULT_PACKAGE);
        } else if (ColoredJavaElementLabels.getFlag(flags, 0x2000000000L)) {
            StringBuffer buf = new StringBuffer();
            JavaScriptElementLabels.getPackageFragmentLabel(pack, 0x2000000000L, buf);
            result.append(buf.toString());
        } else {
            result.append(pack.getElementName());
        }
        if (ColoredJavaElementLabels.getFlag(flags, 0x1000000000L)) {
            int offset = result.length();
            result.append(JavaScriptElementLabels.CONCAT_STRING);
            ColoredJavaElementLabels.getPackageFragmentRootLabel((IPackageFragmentRoot)pack.getParent(), 0x20000000000L, result);
            if (ColoredJavaElementLabels.getFlag(flags, 0x80000000000000L)) {
                result.colorize(offset, result.length() - offset, QUALIFIER_STYLE);
            }
        }
    }

    public static void getPackageFragmentRootLabel(IPackageFragmentRoot root, long flags, ColoredString result) {
        if (root.isArchive()) {
            ColoredJavaElementLabels.getArchiveLabel(root, flags, result);
        } else {
            ColoredJavaElementLabels.getFolderLabel(root, flags, result);
        }
    }

    private static void getArchiveLabel(IPackageFragmentRoot root, long flags, ColoredString result) {
        if (ColoredJavaElementLabels.getFlag(flags, 0x10000000000L) && ColoredJavaElementLabels.getVariableLabel(root, flags, result)) {
            return;
        }
        boolean external = root.isExternal();
        if (external) {
            ColoredJavaElementLabels.getExternalArchiveLabel(root, flags, result);
        } else {
            ColoredJavaElementLabels.getInternalArchiveLabel(root, flags, result);
        }
    }

    private static boolean getVariableLabel(IPackageFragmentRoot root, long flags, ColoredString result) {
        try {
            IIncludePathEntry rawEntry = root.getRawIncludepathEntry();
            if (rawEntry != null && rawEntry.getEntryKind() == 4) {
                IPath path = rawEntry.getPath().makeRelative();
                int offset = result.length();
                if (ColoredJavaElementLabels.getFlag(flags, 0x200000000000L)) {
                    int segements = path.segmentCount();
                    if (segements > 0) {
                        result.append(path.segment(segements - 1));
                        if (segements > 1) {
                            result.append(JavaScriptElementLabels.CONCAT_STRING);
                            result.append(path.removeLastSegments(1).toOSString());
                        }
                    } else {
                        result.append(path.toString());
                    }
                } else {
                    result.append(path.toString());
                }
                result.append(JavaScriptElementLabels.CONCAT_STRING);
                if (root.isExternal()) {
                    result.append(root.getPath().toOSString());
                } else {
                    result.append(root.getPath().makeRelative().toString());
                }
                if (ColoredJavaElementLabels.getFlag(flags, 0x80000000000000L)) {
                    result.colorize(offset, result.length() - offset, QUALIFIER_STYLE);
                }
                return true;
            }
        }
        catch (JavaScriptModelException e) {
            JavaScriptPlugin.log(e);
        }
        return false;
    }

    private static void getExternalArchiveLabel(IPackageFragmentRoot root, long flags, ColoredString result) {
        IPath path = root.getPath();
        if (ColoredJavaElementLabels.getFlag(flags, 0x200000000000L)) {
            int segements = path.segmentCount();
            if (segements > 0) {
                result.append(path.segment(segements - 1));
                int offset = result.length();
                if (segements > 1 || path.getDevice() != null) {
                    result.append(JavaScriptElementLabels.CONCAT_STRING);
                    result.append(path.removeLastSegments(1).toOSString());
                }
                if (ColoredJavaElementLabels.getFlag(flags, 0x80000000000000L)) {
                    result.colorize(offset, result.length() - offset, QUALIFIER_STYLE);
                }
            } else {
                result.append(path.toOSString());
            }
        } else {
            result.append(path.toOSString());
        }
    }

    private static void getInternalArchiveLabel(IPackageFragmentRoot root, long flags, ColoredString result) {
        boolean referencedQualified;
        IResource resource = root.getResource();
        boolean rootQualified = ColoredJavaElementLabels.getFlag(flags, 0x20000000000L);
        boolean bl = referencedQualified = ColoredJavaElementLabels.getFlag(flags, 0x200000000000L) && ColoredJavaElementLabels.isReferenced(root);
        if (rootQualified) {
            result.append(root.getPath().makeRelative().toString());
        } else {
            result.append(root.getElementName());
            int offset = result.length();
            if (referencedQualified) {
                result.append(JavaScriptElementLabels.CONCAT_STRING);
                result.append(resource.getParent().getFullPath().makeRelative().toString());
            } else if (ColoredJavaElementLabels.getFlag(flags, 0x40000000000L)) {
                result.append(JavaScriptElementLabels.CONCAT_STRING);
                result.append(root.getParent().getPath().makeRelative().toString());
            } else {
                return;
            }
            if (ColoredJavaElementLabels.getFlag(flags, 0x80000000000000L)) {
                result.colorize(offset, result.length() - offset, QUALIFIER_STYLE);
            }
        }
    }

    private static void getFolderLabel(IPackageFragmentRoot root, long flags, ColoredString result) {
        boolean referencedQualified;
        IResource resource = root.getResource();
        boolean rootQualified = ColoredJavaElementLabels.getFlag(flags, 0x20000000000L);
        boolean bl = referencedQualified = ColoredJavaElementLabels.getFlag(flags, 0x200000000000L) && ColoredJavaElementLabels.isReferenced(root);
        if (rootQualified) {
            result.append(root.getPath().makeRelative().toString());
        } else {
            if (resource != null) {
                IPath projectRelativePath = resource.getProjectRelativePath();
                if (projectRelativePath.segmentCount() == 0) {
                    result.append(resource.getName());
                    referencedQualified = false;
                } else {
                    result.append(projectRelativePath.toString());
                }
            } else {
                result.append(root.getElementName());
            }
            int offset = result.length();
            if (referencedQualified) {
                result.append(JavaScriptElementLabels.CONCAT_STRING);
                result.append(resource.getProject().getName());
            } else if (ColoredJavaElementLabels.getFlag(flags, 0x40000000000L)) {
                result.append(JavaScriptElementLabels.CONCAT_STRING);
                result.append(root.getParent().getElementName());
            } else {
                return;
            }
            if (ColoredJavaElementLabels.getFlag(flags, 0x80000000000000L)) {
                result.colorize(offset, result.length() - offset, QUALIFIER_STYLE);
            }
        }
    }

    private static boolean isReferenced(IPackageFragmentRoot root) {
        IResource resource = root.getResource();
        if (resource != null) {
            IProject jarProject = resource.getProject();
            IProject container = root.getJavaScriptProject().getProject();
            return !container.equals((Object)jarProject);
        }
        return false;
    }

    public static ColoredString getContainerEntryLabel(IPath containerPath, IJavaScriptProject project) {
        try {
            JsGlobalScopeContainerInitializer initializer;
            IJsGlobalScopeContainer container = JavaScriptCore.getJsGlobalScopeContainer((IPath)containerPath, (IJavaScriptProject)project);
            String description = null;
            if (container != null) {
                description = container.getDescription();
            }
            if (description == null && (initializer = JavaScriptCore.getJsGlobalScopeContainerInitializer((String)containerPath.segment(0))) != null) {
                description = initializer.getDescription(containerPath, project);
            }
            if (description != null) {
                int index;
                ColoredString str = new ColoredString(description);
                if (containerPath.segmentCount() > 0 && "org.eclipse.wst.jsdt.launching.JRE_CONTAINER".equals(containerPath.segment(0)) && (index = description.indexOf(91)) != -1) {
                    str.colorize(index, description.length() - index, DECORATIONS_STYLE);
                }
                return str;
            }
        }
        catch (JavaScriptModelException javaScriptModelException) {}
        return new ColoredString(containerPath.toString());
    }

    public static ColoredString decorateColoredString(ColoredString string, String decorated, ColoredString.Style color) {
        String label = string.getString();
        int originalStart = decorated.indexOf(label);
        if (originalStart == -1) {
            return new ColoredString(decorated);
        }
        if (originalStart > 0) {
            ColoredString newString = new ColoredString(decorated.substring(0, originalStart), color);
            newString.append(string);
            string = newString;
        }
        if (decorated.length() > originalStart + label.length()) {
            return string.append(decorated.substring(originalStart + label.length()), color);
        }
        return string;
    }
}

