/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.tests.util;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.j2ee.classpathdep.ClasspathDependencyUtil;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFLibrary;
import org.eclipse.jst.jsf.core.internal.project.facet.JSFFacetInstallDataModelProvider;
import org.eclipse.jst.jsf.core.tests.util.JSFCoreUtilHelper;
import org.eclipse.jst.jsf.test.util.JDTTestEnvironment;
import org.eclipse.jst.jsf.test.util.ProjectTestEnvironment;
import org.eclipse.jst.jsf.test.util.WebProjectTestEnvironment;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSFFacetedTestEnvironment {
    private final WebProjectTestEnvironment _projectTestEnvironment;
    private JSFFacetInstallDataModelProvider _modelProvider;
    private IDataModel _model;

    public JSFFacetedTestEnvironment(WebProjectTestEnvironment projectTestEnvironment) {
        this._projectTestEnvironment = projectTestEnvironment;
    }

    public void initialize(String version) throws CoreException, ExecutionException {
        IProject project = this._projectTestEnvironment.getTestProject();
        this._modelProvider = new JSFFacetInstallDataModelProvider();
        this._model = DataModelFactory.createDataModel((IDataModelProvider)this._modelProvider);
        this._model.setStringProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", project.getName());
        Set<IFacetedProject.Action> actions = this.getAddFacetActions(version);
        IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
        facetedProject.modify(actions, null);
    }

    private Set<IFacetedProject.Action> getAddFacetActions(String jsfVersion) {
        HashSet<IFacetedProject.Action> actions = new HashSet<IFacetedProject.Action>();
        IProjectFacetVersion jsfFacet = this.getJSFFacet(jsfVersion);
        actions.add(new IFacetedProject.Action((IFacetedProject.Action.Type)this._model.getProperty("IFacetDataModelProperties.FACET_TYPE"), jsfFacet, (Object)this._model));
        return actions;
    }

    private IProjectFacetVersion getJSFFacet(String version) {
        IProjectFacet facet = ProjectFacetsManager.getProjectFacet((String)"jst.jsf");
        return facet.getVersion(version);
    }

    public void generateJSFLibraryRegistry() {
        JSFCoreUtilHelper.createJSFLibraryRegistry();
    }

    public void addJSFLibraryReference(JSFLibrary lib, boolean isDeployed) throws CoreException {
        JDTTestEnvironment jdtTestEnv = new JDTTestEnvironment((ProjectTestEnvironment)this._projectTestEnvironment);
        IPath path = new Path("org.eclipse.jst.jsf.core.internal.jsflibrarycontainer").append(lib.getID());
        IClasspathEntry cpEntry = null;
        if (isDeployed) {
            IClasspathAttribute depAttrib = JavaCore.newClasspathAttribute((String)"org.eclipse.jst.component.dependency", (String)ClasspathDependencyUtil.getDefaultRuntimePath((boolean)true).toString());
            cpEntry = JavaCore.newContainerEntry((IPath)path, null, (IClasspathAttribute[])new IClasspathAttribute[]{depAttrib}, (boolean)true);
        } else {
            cpEntry = JavaCore.newContainerEntry((IPath)path);
        }
        jdtTestEnv.addClasspathEntry(cpEntry);
    }

    public void dispose() {
        if (this._model != null) {
            this._model.dispose();
        }
    }
}

