/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.tests.types;

import junit.framework.TestCase;
import org.eclipse.jst.jsf.common.internal.types.CompositeType;
import org.eclipse.jst.jsf.common.internal.types.TypeTransformer;

public class TypeTransformerTests
extends TestCase {
    private static final CompositeType primitiveLong = new CompositeType("J", 2);
    private static final CompositeType primitiveInteger = new CompositeType("I", 2);
    private static final CompositeType primitiveLongArray = new CompositeType("[J", 2);
    private static final CompositeType primitiveIntegerArrayArray = new CompositeType("[[I", 2);
    private static final CompositeType boxedLong = new CompositeType("Ljava.lang.Long;", 2);
    private static final CompositeType boxedInteger = new CompositeType("Ljava.lang.Integer;", 2);
    private static final CompositeType boxedLongArray = new CompositeType("[Ljava.lang.Long;", 2);
    private static final CompositeType boxedIntegerArrayArray = new CompositeType("[[Ljava.lang.Integer;", 2);

    public void testBoxPrimitives() {
        CompositeType newType = TypeTransformer.transformBoxPrimitives((CompositeType)primitiveLong);
        TypeTransformerTests.assertTrue((boolean)TypeTransformerTests.exactMatch(newType, boxedLong));
        newType = TypeTransformer.transformBoxPrimitives((CompositeType)primitiveInteger);
        TypeTransformerTests.assertTrue((boolean)TypeTransformerTests.exactMatch(newType, boxedInteger));
        newType = TypeTransformer.transformBoxPrimitives((CompositeType)primitiveLongArray);
        TypeTransformerTests.assertTrue((boolean)TypeTransformerTests.exactMatch(newType, boxedLongArray));
        newType = TypeTransformer.transformBoxPrimitives((CompositeType)primitiveIntegerArrayArray);
        TypeTransformerTests.assertTrue((boolean)TypeTransformerTests.exactMatch(newType, boxedIntegerArrayArray));
    }

    public void testUnboxPrimitives() {
        CompositeType newType = TypeTransformer.transformUnboxPrimitives((CompositeType)boxedLong);
        TypeTransformerTests.assertTrue((boolean)TypeTransformerTests.exactMatch(newType, primitiveLong));
        newType = TypeTransformer.transformUnboxPrimitives((CompositeType)boxedInteger);
        TypeTransformerTests.assertTrue((boolean)TypeTransformerTests.exactMatch(newType, primitiveInteger));
        newType = TypeTransformer.transformUnboxPrimitives((CompositeType)boxedLongArray);
        TypeTransformerTests.assertTrue((boolean)TypeTransformerTests.exactMatch(newType, primitiveLongArray));
        newType = TypeTransformer.transformUnboxPrimitives((CompositeType)boxedIntegerArrayArray);
        TypeTransformerTests.assertTrue((boolean)TypeTransformerTests.exactMatch(newType, primitiveIntegerArrayArray));
    }

    private static boolean exactMatch(CompositeType t1, CompositeType t2) {
        String[] s2;
        String[] s1 = t1.getSignatures();
        if (s1.length != (s2 = t2.getSignatures()).length) {
            return false;
        }
        int i = 0;
        while (i < s1.length) {
            if (!s1[i].equals(s2[i])) {
                return false;
            }
            ++i;
        }
        return t1.getAssignmentTypeMask() == t2.getAssignmentTypeMask();
    }
}

