/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.tests.project.facet;

import java.util.Set;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.jst.jsf.core.internal.jsflibraryconfig.JSFLibraryRegistryUtil;
import org.eclipse.jst.jsf.core.internal.project.facet.JSFFacetInstallDataModelProvider;
import org.eclipse.jst.jsf.core.tests.util.JSFCoreUtilHelper;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;

public class JSFFacetInstallDataModelProviderTestCases
extends TestCase {
    private static final String PROJ_2_3_NAME = "_TEST_2_3_PROJECT";
    private JSFFacetInstallDataModelProvider dm;

    protected void setUp() throws Exception {
        JSFCoreUtilHelper.createJSFLibraryRegistry();
        IProject project = JSFCoreUtilHelper.createWebProject(PROJ_2_3_NAME);
        JSFLibraryRegistryUtil.getInstance().getJSFLibraryRegistry().getDefaultImplementation();
        this.dm = new JSFFacetInstallDataModelProvider();
        IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)this.dm);
        model.setStringProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", project.getName());
    }

    public void testGetPropertyNames() {
        Set names = this.dm.getPropertyNames();
        Assert.assertNotNull((Object)names);
        Assert.assertTrue((boolean)names.contains("IJSFFacetInstallDataModelProperties.CONFIG_PATH"));
        Assert.assertTrue((boolean)names.contains("IJSFFacetInstallDataModelProperties.SERVLET_NAME"));
        Assert.assertTrue((boolean)names.contains("IJSFFacetInstallDataModelProperties.SERVLET_URL_PATTERNS"));
        Assert.assertTrue((boolean)names.contains("IJSFFacetInstallDataModelProperties.WEBCONTENT_DIR"));
        Assert.assertTrue((boolean)names.contains("IJSFFacetInstallDataModelProperties.LIBRARY_PROVIDER_DELEGATE"));
    }

    public void testGetDefaultPropertyString() {
        Assert.assertTrue((this.dm.getDefaultProperty("IJSFFacetInstallDataModelProperties.CONFIG_PATH") != null ? 1 : 0) != 0);
        Assert.assertTrue((this.dm.getDefaultProperty("IJSFFacetInstallDataModelProperties.SERVLET_NAME") != null ? 1 : 0) != 0);
        Assert.assertTrue((this.dm.getDefaultProperty("IJSFFacetInstallDataModelProperties.SERVLET_URL_PATTERNS") != null ? 1 : 0) != 0);
        Assert.assertTrue((this.dm.getDefaultProperty("IJSFFacetInstallDataModelProperties.WEBCONTENT_DIR") != null ? 1 : 0) != 0);
    }

    public void testConfigFileNameValidation() {
        JSFFacetInstallDataModelProviderTestCases.assertTrue((boolean)JSFFacetInstallDataModelProvider.isValidConfigFileName((String)"faces-config.xml"));
        JSFFacetInstallDataModelProviderTestCases.assertTrue((boolean)JSFFacetInstallDataModelProvider.isValidConfigFileName((String)"/WEB-INF/config/faces-config.xml"));
        JSFFacetInstallDataModelProviderTestCases.assertFalse((boolean)JSFFacetInstallDataModelProvider.isValidConfigFileName((String)"/WEB-INF/config/faces config.xml"));
        JSFFacetInstallDataModelProviderTestCases.assertFalse((boolean)JSFFacetInstallDataModelProvider.isValidConfigFileName((String)"/WEB-INF/config//faces-config.xml"));
        JSFFacetInstallDataModelProviderTestCases.assertFalse((boolean)JSFFacetInstallDataModelProvider.isValidConfigFileName((String)"/WEB-INF/config///faces-config.xml"));
        JSFFacetInstallDataModelProviderTestCases.assertFalse((boolean)JSFFacetInstallDataModelProvider.isValidConfigFileName((String)"/WEB-INF/config/faces-config.xml,/WEB-INF/config/faces-config2.xml"));
        JSFFacetInstallDataModelProviderTestCases.assertFalse((boolean)JSFFacetInstallDataModelProvider.isValidConfigFileName((String)"/WEB-INF/config/faces-config.xml, /WEB-INF/config/faces-config2.xml"));
        JSFFacetInstallDataModelProviderTestCases.assertFalse((boolean)JSFFacetInstallDataModelProvider.isValidConfigFileName((String)"/WEB-INF/config/faces-config.xml, "));
        JSFFacetInstallDataModelProviderTestCases.assertFalse((boolean)JSFFacetInstallDataModelProvider.isValidConfigFileName((String)"/WEB-INF/config/faces-config.xml. "));
        JSFFacetInstallDataModelProviderTestCases.assertFalse((boolean)JSFFacetInstallDataModelProvider.isValidConfigFileName((String)"/WEB-INF/config/faces-config.xml%"));
        JSFFacetInstallDataModelProviderTestCases.assertFalse((boolean)JSFFacetInstallDataModelProvider.isValidConfigFileName((String)"/WEB-INF/config/faces-config.xml.&65"));
        JSFFacetInstallDataModelProviderTestCases.assertFalse((boolean)JSFFacetInstallDataModelProvider.isValidConfigFileName((String)"/WEB-INF/config/faces-config.xml*"));
        JSFFacetInstallDataModelProviderTestCases.assertFalse((boolean)JSFFacetInstallDataModelProvider.isValidConfigFileName((String)"/WEB-INF/config/face*s-config.xml*"));
    }
}

