/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.tests.jsflibraryconfiguration;

import java.util.Collection;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jst.jsf.core.internal.jsflibraryconfig.JSFLibraryRegistryUtil;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFLibrary;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFLibraryRegistry;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFVersion;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.PluginProvidedJSFLibrary;
import org.eclipse.jst.jsf.core.jsflibraryconfiguration.JSFLibraryConfigurationHelper;
import org.eclipse.jst.jsf.core.jsflibraryconfiguration.JSFLibraryReference;
import org.eclipse.jst.jsf.core.jsflibraryconfiguration.JSFLibraryReferenceServerSupplied;
import org.eclipse.jst.jsf.core.tests.util.JSFCoreUtilHelper;
import org.eclipse.jst.jsf.core.tests.util.JSFFacetedTestEnvironment;
import org.eclipse.jst.jsf.test.util.JDTTestEnvironment;
import org.eclipse.jst.jsf.test.util.JSFTestUtil;
import org.eclipse.jst.jsf.test.util.WebProjectTestEnvironment;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class JSFLibraryServerSuppliedReferenceTestCases
extends TestCase {
    WebProjectTestEnvironment projectTestEnvironment;
    JDTTestEnvironment jdtTestEnv;

    protected void setUp() throws Exception {
        super.setUp();
        JSFTestUtil.setValidationEnabled((boolean)false);
        JSFTestUtil.setInternetProxyPreferences((boolean)true, (String)"www-proxy.us.oracle.com", (String)"80");
        this.projectTestEnvironment = new WebProjectTestEnvironment("JSFLibraryServerSuppliedReferenceTestCases", ProjectFacetsManager.getProjectFacet((String)"jst.java").getVersion("5.0"), ProjectFacetsManager.getProjectFacet((String)"jst.web").getVersion("2.5"));
        boolean created = this.projectTestEnvironment.createProject(true);
        JSFLibraryServerSuppliedReferenceTestCases.assertNotNull((Object)this.projectTestEnvironment);
        JSFLibraryServerSuppliedReferenceTestCases.assertNotNull((Object)this.projectTestEnvironment.getTestProject());
        JSFLibraryServerSuppliedReferenceTestCases.assertTrue((boolean)this.projectTestEnvironment.getTestProject().isAccessible());
        if (created) {
            JSFFacetedTestEnvironment jsfFacedEnv = new JSFFacetedTestEnvironment(this.projectTestEnvironment);
            jsfFacedEnv.initialize("1.2");
            this.createRegistryAndAddreferences(this.projectTestEnvironment, jsfFacedEnv);
        }
    }

    private void createRegistryAndAddreferences(WebProjectTestEnvironment projectTestEnvironment, JSFFacetedTestEnvironment jsfFacedEnv) throws CoreException {
        JSFLibraryRegistry jsfLibRegistry = JSFLibraryRegistryUtil.getInstance().getJSFLibraryRegistry();
        String[] archivefiles1 = new String[]{"faces-all-bogu.jar", "faces-api-bogus.jar", "faces-impl-bogus.jar", "tomahawk-bogus.jar"};
        String[] archivefiles2 = new String[]{"faces-all-bogu2.jar", "faces-api-bogus2.jar", "faces-impl-bogus2.jar", "tomahawk-bogus2.jar"};
        JSFLibrary implJSFLib = JSFCoreUtilHelper.constructJSFLib("JSFLIBIMPL_NAME", "JSFLIBIMPL_NAME", archivefiles1, true);
        implJSFLib.setJSFVersion(JSFVersion.V1_1_LITERAL);
        JSFLibrary nonimplJSFLib = JSFCoreUtilHelper.constructJSFLib("JSFLIBNONIMPL_NAME", "JSFLIBNONIMPL_NAME", archivefiles2, false);
        nonimplJSFLib.setJSFVersion(JSFVersion.V1_2_LITERAL);
        PluginProvidedJSFLibrary ppJSFLib = (PluginProvidedJSFLibrary)JSFCoreUtilHelper.constructJSFLib("PP-JSFLIBNONIMPL_NAME", "testfiles/JSFLib", false, true);
        ppJSFLib.setPluginID("PluginProvidedLib");
        ppJSFLib.setLabel("PluginProvidedLib");
        ppJSFLib.setJSFVersion(JSFVersion.V1_1_LITERAL);
        jsfLibRegistry.addJSFLibrary(implJSFLib);
        jsfLibRegistry.addJSFLibrary(nonimplJSFLib);
        jsfLibRegistry.addJSFLibrary((JSFLibrary)ppJSFLib);
    }

    public void testGetJSFLibraryReferencesAndServerSuppliedRef() throws CoreException {
        Collection libs = JSFLibraryConfigurationHelper.getJSFLibraryReferences((IProject)this.projectTestEnvironment.getTestProject());
        Assert.assertNotNull((Object)libs);
        Assert.assertEquals((int)1, (int)libs.size());
        JSFLibraryReference ref = (JSFLibraryReference)libs.iterator().next();
        Assert.assertTrue((boolean)(ref instanceof JSFLibraryReferenceServerSupplied));
        this.doAsserts(ref, "JSFLibraryReferenceServerSuppliedImpl", "_ServerSupplied_", "_ServerSupplied_", "Server Supplied", false, true, org.eclipse.jst.jsf.core.jsflibraryconfiguration.JSFVersion.UNKNOWN, 0);
    }

    private void doAsserts(JSFLibraryReference ref, String instanceName, String id, String name, String label, boolean isDeployed, boolean isImpl, org.eclipse.jst.jsf.core.jsflibraryconfiguration.JSFVersion version, int jarCount) {
        Assert.assertTrue((String)(String.valueOf(id) + ":instanceName"), (boolean)ref.getClass().getSimpleName().equals(instanceName));
        Assert.assertEquals((String)(String.valueOf(id) + ": id"), (String)id, (String)ref.getId());
        Assert.assertEquals((String)(String.valueOf(id) + ": name"), (String)name, (String)ref.getName());
        Assert.assertEquals((String)(String.valueOf(id) + ": label"), (String)label, (String)ref.getLabel());
        Assert.assertEquals((String)(String.valueOf(id) + ": isDeployed"), (boolean)isDeployed, (boolean)ref.isDeployed());
        Assert.assertEquals((String)(String.valueOf(id) + ": isImpl"), (boolean)isImpl, (boolean)ref.isJSFImplementation());
        Assert.assertEquals((String)(String.valueOf(id) + ": version"), (Object)version, (Object)ref.getMaxSupportedVersion());
        Assert.assertEquals((String)(String.valueOf(id) + ": jarCount"), (int)jarCount, (int)ref.getJars().size());
        Assert.assertNotNull((Object)ref.toString());
    }
}

