/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.tests.appconfig.validation;

import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.jst.jsf.core.tests.TestsPlugin;
import org.eclipse.jst.jsf.test.util.JDTTestEnvironment;
import org.eclipse.jst.jsf.test.util.JSFTestUtil;
import org.eclipse.jst.jsf.test.util.ProjectTestEnvironment;
import org.eclipse.jst.jsf.test.util.TestFileResource;
import org.eclipse.jst.jsf.test.util.WebProjectTestEnvironment;
import org.eclipse.jst.jsf.validation.internal.appconfig.AppConfigValidationUtil;
import org.eclipse.jst.jsf.validation.internal.appconfig.ILocalizedMessage;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

public class AppConfigValidationUtilTestCase
extends TestCase {
    private ProjectTestEnvironment _testEnvironment;
    private JDTTestEnvironment _jdtTestEnvironment;

    protected void setUp() throws Exception {
        super.setUp();
        JSFTestUtil.setValidationEnabled((boolean)false);
        JSFTestUtil.setInternetProxyPreferences((boolean)true, (String)"www-proxy.uk.oracle.com", (String)"80");
        this._testEnvironment = new WebProjectTestEnvironment("AppConfigValidationUtilTestCase_" + this.getName());
        this._testEnvironment.createProject(true);
        this._jdtTestEnvironment = new JDTTestEnvironment(this._testEnvironment);
        TestFileResource resource = new TestFileResource();
        resource.load(TestsPlugin.getDefault().getBundle(), "/testfiles/TestEnum1.java.data");
        this._jdtTestEnvironment.addSourceFile("src", "org.eclipse.jst.jsf.core.tests.util", "TestEnum1", resource.toString());
        resource = new TestFileResource();
        resource.load(TestsPlugin.getDefault().getBundle(), "/testfiles/TestBean1.java.data");
        this._jdtTestEnvironment.addSourceFile("src", "com.test", "TestBean1", resource.toString());
        resource = new TestFileResource();
        resource.load(TestsPlugin.getDefault().getBundle(), "/testfiles/TestBean1Subclass.java.data");
        this._jdtTestEnvironment.addSourceFile("src", "com.test", "TestBean1Subclass", resource.toString());
    }

    public void testValidateELExpression() {
        AppConfigValidationUtilTestCase.assertNull((Object)AppConfigValidationUtil.validateELExpression((String)"#{x.y}"));
        AppConfigValidationUtilTestCase.assertNull((Object)AppConfigValidationUtil.validateELExpression((String)"#{a.b.c}"));
        IMessage message = AppConfigValidationUtil.validateELExpression((String)"#{}");
        AppConfigValidationUtilTestCase.assertNotNull((Object)message);
        AppConfigValidationUtilTestCase.assertEquals((int)1, (int)((ILocalizedMessage)message).getErrorCode());
        message = AppConfigValidationUtil.validateELExpression((String)"x.y");
        AppConfigValidationUtilTestCase.assertNotNull((Object)message);
        AppConfigValidationUtilTestCase.assertEquals((int)0, (int)((ILocalizedMessage)message).getErrorCode());
        message = AppConfigValidationUtil.validateELExpression((String)"#{x.[}");
        AppConfigValidationUtilTestCase.assertNotNull((Object)message);
        AppConfigValidationUtilTestCase.assertEquals((int)1, (int)((ILocalizedMessage)message).getErrorCode());
    }

    public void testValidateClassName_NoError() throws Exception {
        IProject project = this._testEnvironment.getTestProject();
        AppConfigValidationUtilTestCase.assertNull((Object)AppConfigValidationUtil.validateClassName((String)"com.test.TestBean1", null, (boolean)true, (IProject)project));
        AppConfigValidationUtilTestCase.assertNull((Object)AppConfigValidationUtil.validateClassName((String)"com.test.TestBean1", null, (boolean)false, (IProject)project));
        AppConfigValidationUtilTestCase.assertNull((Object)AppConfigValidationUtil.validateClassName((String)"com.test.TestBean1Subclass", null, (boolean)true, (IProject)project));
        AppConfigValidationUtilTestCase.assertNull((Object)AppConfigValidationUtil.validateClassName((String)"com.test.TestBean1Subclass", null, (boolean)false, (IProject)project));
        AppConfigValidationUtilTestCase.assertNull((Object)AppConfigValidationUtil.validateClassName((String)"com.test.TestBean1Subclass", (String)"com.test.TestBean1", (boolean)true, (IProject)project));
        AppConfigValidationUtilTestCase.assertNull((Object)AppConfigValidationUtil.validateClassName((String)"com.test.TestBean1Subclass", (String)"com.test.TestBean1", (boolean)false, (IProject)project));
        AppConfigValidationUtilTestCase.assertNull((Object)AppConfigValidationUtil.validateClassName((String)"org.eclipse.jst.jsf.core.tests.util.TestEnum1", null, (boolean)false, (IProject)project));
        AppConfigValidationUtilTestCase.assertNull((Object)AppConfigValidationUtil.validateClassName((String)"org.eclipse.jst.jsf.core.tests.util.TestEnum1", (String)"java.lang.Enum", (boolean)false, (IProject)project));
    }

    public void testValidateClassName_Errors() throws Exception {
        IProject project = this._testEnvironment.getTestProject();
        IMessage error = AppConfigValidationUtil.validateClassName((String)"com.test.NoTaVAliDClAss", null, (boolean)false, (IProject)project);
        AppConfigValidationUtilTestCase.assertNotNull((Object)error);
        AppConfigValidationUtilTestCase.assertEquals((int)2, (int)((ILocalizedMessage)error).getErrorCode());
        error = AppConfigValidationUtil.validateClassName((String)"org.eclipse.jst.jsf.core.tests.util.TestEnum1", null, (boolean)true, (IProject)project);
        AppConfigValidationUtilTestCase.assertNotNull((Object)error);
        AppConfigValidationUtilTestCase.assertEquals((int)3, (int)((ILocalizedMessage)error).getErrorCode());
        error = AppConfigValidationUtil.validateClassName((String)"com.test.TestBean1", (String)"javax.faces.Converter", (boolean)true, (IProject)project);
        AppConfigValidationUtilTestCase.assertNotNull((Object)error);
        AppConfigValidationUtilTestCase.assertEquals((int)4, (int)((ILocalizedMessage)error).getErrorCode());
    }
}

