/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.model.ejb.tests;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IProject;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.IModelProviderEvent;
import org.eclipse.jst.j2ee.model.IModelProviderListener;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.jee.model.tests.AbstractTest;
import org.eclipse.jst.jee.model.tests.SynchronousModelChangedListener;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;

public class NotifyCloseProjectTest
extends TestCase {
    public static Test suite() {
        TestSuite suite = new TestSuite(NotifyCloseProjectTest.class);
        return suite;
    }

    public void testCloseEjbProject() throws Exception {
        IFacetedProject facetedProject = AbstractTest.createEjbProject(String.valueOf(NotifyCloseProjectTest.class.getSimpleName()) + "testCloseEjbProject");
        IModelProvider provider = ModelProviderManager.getModelProvider((IProject)facetedProject.getProject());
        provider.getModelObject();
        SynchronousModelChangedListener listener = new SynchronousModelChangedListener(1);
        provider.addListener((IModelProviderListener)listener);
        AbstractTest.closeProject(facetedProject.getProject().getName());
        NotifyCloseProjectTest.assertTrue((boolean)listener.waitForEvents());
        provider.removeListener((IModelProviderListener)listener);
        NotifyCloseProjectTest.assertEquals((Object)new Integer(1), (Object)new Integer(listener.getReceivedEvents().size()));
        IModelProviderEvent event = listener.getReceivedEvents().iterator().next();
        NotifyCloseProjectTest.assertTrue((event.getEventCode() == 64 ? 1 : 0) != 0);
    }

    public void testCloseWebProject() throws Exception {
        IFacetedProject facetedProject = AbstractTest.createWebProject(String.valueOf(NotifyCloseProjectTest.class.getSimpleName()) + "testCloseWebProject");
        IModelProvider provider = ModelProviderManager.getModelProvider((IProject)facetedProject.getProject());
        provider.getModelObject();
        SynchronousModelChangedListener listener = new SynchronousModelChangedListener(1);
        provider.addListener((IModelProviderListener)listener);
        AbstractTest.closeProject(facetedProject.getProject().getName());
        NotifyCloseProjectTest.assertTrue((boolean)listener.waitForEvents());
        provider.removeListener((IModelProviderListener)listener);
        NotifyCloseProjectTest.assertEquals((Object)new Integer(1), (Object)new Integer(listener.getReceivedEvents().size()));
        IModelProviderEvent event = listener.getReceivedEvents().iterator().next();
        NotifyCloseProjectTest.assertTrue((event.getEventCode() == 64 ? 1 : 0) != 0);
    }
}

